/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import com.google.common.jimfs.Configuration;
import com.google.common.jimfs.Jimfs;
import java.io.BufferedReader;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Stack;
import java.util.stream.Stream;
import org.apache.commons.io.input.ReversedLinesFileReader;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class ReversedLinesFileReaderTestParamFile {
    public static Stream<Arguments> testDataIntegrityWithBufferedReader() {
        return Stream.of(Arguments.of((Object[])new Object[]{"test-file-20byteslength.bin", "ISO_8859_1", null, false}), Arguments.of((Object[])new Object[]{"test-file-iso8859-1-shortlines-win-linebr.bin", "ISO_8859_1", null, false}), Arguments.of((Object[])new Object[]{"test-file-iso8859-1.bin", "ISO_8859_1", null, false}), Arguments.of((Object[])new Object[]{"test-file-shiftjis.bin", "Shift_JIS", null, false}), Arguments.of((Object[])new Object[]{"test-file-utf16be.bin", "UTF-16BE", null, false}), Arguments.of((Object[])new Object[]{"test-file-utf16le.bin", "UTF-16LE", null, false}), Arguments.of((Object[])new Object[]{"test-file-utf8-cr-only.bin", "UTF-8", null, false}), Arguments.of((Object[])new Object[]{"test-file-utf8-win-linebr.bin", "UTF-8", null, false}), Arguments.of((Object[])new Object[]{"test-file-utf8-win-linebr.bin", "UTF-8", 1, false}), Arguments.of((Object[])new Object[]{"test-file-utf8-win-linebr.bin", "UTF-8", 2, false}), Arguments.of((Object[])new Object[]{"test-file-utf8-win-linebr.bin", "UTF-8", 3, false}), Arguments.of((Object[])new Object[]{"test-file-utf8-win-linebr.bin", "UTF-8", 4, false}), Arguments.of((Object[])new Object[]{"test-file-utf8.bin", "UTF-8", null, false}), Arguments.of((Object[])new Object[]{"test-file-utf8.bin", "UTF-8", null, true}), Arguments.of((Object[])new Object[]{"test-file-windows-31j.bin", "windows-31j", null, false}), Arguments.of((Object[])new Object[]{"test-file-gbk.bin", "gbk", null, false}), Arguments.of((Object[])new Object[]{"test-file-x-windows-949.bin", "x-windows-949", null, false}), Arguments.of((Object[])new Object[]{"test-file-x-windows-950.bin", "x-windows-950", null, false}));
    }

    @ParameterizedTest(name="{0}, encoding={1}, blockSize={2}, useNonDefaultFileSystem={3}")
    @MethodSource
    public void testDataIntegrityWithBufferedReader(String fileName, String encodingName, Integer blockSize, boolean useNonDefaultFileSystem) throws IOException, URISyntaxException {
        Path file = Paths.get(this.getClass().getResource("/" + fileName).toURI());
        FileSystem fileSystem = null;
        if (useNonDefaultFileSystem) {
            fileSystem = Jimfs.newFileSystem((Configuration)Configuration.unix());
            file = Files.copy(file, fileSystem.getPath("/" + fileName, new String[0]), new CopyOption[0]);
        }
        Charset encoding = Charset.forName(encodingName);
        try (ReversedLinesFileReader reversedLinesFileReader = blockSize == null ? new ReversedLinesFileReader(file, encoding) : new ReversedLinesFileReader(file, blockSize.intValue(), encoding);){
            String line;
            Stack<String> lineStack = new Stack<String>();
            try (BufferedReader bufferedReader = Files.newBufferedReader(file, encoding);){
                while ((line = bufferedReader.readLine()) != null) {
                    lineStack.push(line);
                }
            }
            while ((line = reversedLinesFileReader.readLine()) != null) {
                String lineFromBufferedReader = (String)lineStack.pop();
                Assertions.assertEquals((Object)lineFromBufferedReader, (Object)line);
            }
            if (fileSystem != null) {
                fileSystem.close();
            }
        }
    }
}

