/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.monitor;

import java.io.File;
import java.io.FileFilter;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.HiddenFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.monitor.CollectionFileListener;
import org.apache.commons.io.monitor.FileAlterationListener;
import org.apache.commons.io.monitor.FileAlterationListenerAdaptor;
import org.apache.commons.io.monitor.FileAlterationObserver;
import org.apache.commons.io.testtools.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.io.TempDir;

public abstract class AbstractMonitorTestCase {
    protected FileAlterationObserver observer;
    protected CollectionFileListener listener;
    @TempDir
    protected File testDir;
    protected long pauseTime = 100L;

    @BeforeEach
    public void setUp() throws Exception {
        IOFileFilter files = FileFilterUtils.fileFileFilter();
        IOFileFilter javaSuffix = FileFilterUtils.suffixFileFilter((String)".java");
        IOFileFilter fileFilter = FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{files, javaSuffix});
        IOFileFilter directories = FileFilterUtils.directoryFileFilter();
        IOFileFilter visible = HiddenFileFilter.VISIBLE;
        IOFileFilter dirFilter = FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{directories, visible});
        IOFileFilter filter = FileFilterUtils.or((IOFileFilter[])new IOFileFilter[]{dirFilter, fileFilter});
        this.createObserver(this.testDir, (FileFilter)filter);
    }

    protected void createObserver(File file, FileFilter fileFilter) {
        this.observer = new FileAlterationObserver(file, fileFilter);
        this.observer.addListener((FileAlterationListener)this.listener);
        this.observer.addListener((FileAlterationListener)new FileAlterationListenerAdaptor());
        try {
            this.observer.initialize();
        }
        catch (Exception e) {
            Assertions.fail((String)("Observer init() threw " + e));
        }
    }

    protected void checkCollectionsEmpty(String label) {
        this.checkCollectionSizes("EMPTY-" + label, 0, 0, 0, 0, 0, 0);
    }

    protected void checkCollectionSizes(String label, int dirCreate, int dirChange, int dirDelete, int fileCreate, int fileChange, int fileDelete) {
        label = label + "[" + this.listener.getCreatedDirectories().size() + " " + this.listener.getChangedDirectories().size() + " " + this.listener.getDeletedDirectories().size() + " " + this.listener.getCreatedFiles().size() + " " + this.listener.getChangedFiles().size() + " " + this.listener.getDeletedFiles().size() + "]";
        Assertions.assertEquals((int)dirCreate, (int)this.listener.getCreatedDirectories().size(), (String)(label + ": No. of directories created"));
        Assertions.assertEquals((int)dirChange, (int)this.listener.getChangedDirectories().size(), (String)(label + ": No. of directories changed"));
        Assertions.assertEquals((int)dirDelete, (int)this.listener.getDeletedDirectories().size(), (String)(label + ": No. of directories deleted"));
        Assertions.assertEquals((int)fileCreate, (int)this.listener.getCreatedFiles().size(), (String)(label + ": No. of files created"));
        Assertions.assertEquals((int)fileChange, (int)this.listener.getChangedFiles().size(), (String)(label + ": No. of files changed"));
        Assertions.assertEquals((int)fileDelete, (int)this.listener.getDeletedFiles().size(), (String)(label + ": No. of files deleted"));
    }

    protected File touch(File file) {
        long lastModified = file.exists() ? file.lastModified() : 0L;
        try {
            FileUtils.touch((File)file);
            file = new File(file.getParent(), file.getName());
            while (lastModified == file.lastModified()) {
                TestUtils.sleepQuietly(this.pauseTime);
                FileUtils.touch((File)file);
                file = new File(file.getParent(), file.getName());
            }
        }
        catch (Exception e) {
            Assertions.fail((String)("Touching " + file + ": " + e));
        }
        TestUtils.sleepQuietly(this.pauseTime);
        return file;
    }
}

