/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.output.BrokenOutputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class BrokenOutputStreamTest {
    private IOException exception;
    private OutputStream stream;

    @BeforeEach
    public void setUp() {
        this.exception = new IOException("test exception");
        this.stream = new BrokenOutputStream(this.exception);
    }

    @Test
    public void testWrite() {
        try {
            this.stream.write(1);
            Assertions.fail((String)"Expected exception not thrown.");
        }
        catch (IOException e) {
            Assertions.assertEquals((Object)this.exception, (Object)e);
        }
        try {
            this.stream.write(new byte[1]);
            Assertions.fail((String)"Expected exception not thrown.");
        }
        catch (IOException e) {
            Assertions.assertEquals((Object)this.exception, (Object)e);
        }
        try {
            this.stream.write(new byte[1], 0, 1);
            Assertions.fail((String)"Expected exception not thrown.");
        }
        catch (IOException e) {
            Assertions.assertEquals((Object)this.exception, (Object)e);
        }
    }

    @Test
    public void testFlush() {
        try {
            this.stream.flush();
            Assertions.fail((String)"Expected exception not thrown.");
        }
        catch (IOException e) {
            Assertions.assertEquals((Object)this.exception, (Object)e);
        }
    }

    @Test
    public void testClose() {
        try {
            this.stream.close();
            Assertions.fail((String)"Expected exception not thrown.");
        }
        catch (IOException e) {
            Assertions.assertEquals((Object)this.exception, (Object)e);
        }
    }
}

