/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.io.IOExceptionList;
import org.apache.commons.io.IOIndexedException;
import org.apache.commons.io.output.BrokenWriter;
import org.apache.commons.io.output.ProxyCollectionWriter;
import org.apache.commons.io.output.StringBuilderWriter;
import org.apache.commons.io.output.TeeWriter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TeeWriterTest {
    @Test
    public void testArrayIOExceptionOnAppendChar1() throws IOException {
        BrokenWriter badW = new BrokenWriter();
        StringWriter goodW = (StringWriter)Mockito.mock(StringWriter.class);
        ProxyCollectionWriter tw = new ProxyCollectionWriter(new Writer[]{badW, goodW, null});
        int data = 65;
        try {
            tw.append('A');
            Assertions.fail((String)("Expected " + IOException.class.getName()));
        }
        catch (IOExceptionList e) {
            ((StringWriter)Mockito.verify((Object)goodW)).append('A');
            Assertions.assertEquals((int)1, (int)e.getCauseList().size());
            Assertions.assertEquals((int)0, (int)((IOIndexedException)e.getCause(0, IOIndexedException.class)).getIndex());
        }
    }

    @Test
    public void testArrayIOExceptionOnAppendChar2() throws IOException {
        BrokenWriter badW = new BrokenWriter();
        StringWriter goodW = (StringWriter)Mockito.mock(StringWriter.class);
        ProxyCollectionWriter tw = new ProxyCollectionWriter(new Writer[]{goodW, badW, null});
        int data = 65;
        try {
            tw.append('A');
            Assertions.fail((String)("Expected " + IOException.class.getName()));
        }
        catch (IOExceptionList e) {
            ((StringWriter)Mockito.verify((Object)goodW)).append('A');
            Assertions.assertEquals((int)1, (int)e.getCauseList().size());
            Assertions.assertEquals((int)1, (int)((IOIndexedException)e.getCause(0, IOIndexedException.class)).getIndex());
        }
    }

    @Test
    public void testArrayIOExceptionOnAppendCharSequence1() throws IOException {
        BrokenWriter badW = new BrokenWriter();
        StringWriter goodW = (StringWriter)Mockito.mock(StringWriter.class);
        TeeWriter tw = new TeeWriter(new Writer[]{badW, goodW, null});
        String data = "A";
        try {
            tw.append((CharSequence)"A");
            Assertions.fail((String)("Expected " + IOException.class.getName()));
        }
        catch (IOExceptionList e) {
            ((StringWriter)Mockito.verify((Object)goodW)).append("A");
            Assertions.assertEquals((int)1, (int)e.getCauseList().size());
            Assertions.assertEquals((int)0, (int)((IOIndexedException)e.getCause(0, IOIndexedException.class)).getIndex());
        }
    }

    @Test
    public void testArrayIOExceptionOnAppendCharSequence2() throws IOException {
        BrokenWriter badW = new BrokenWriter();
        StringWriter goodW = (StringWriter)Mockito.mock(StringWriter.class);
        TeeWriter tw = new TeeWriter(new Writer[]{goodW, badW, null});
        String data = "A";
        try {
            tw.append((CharSequence)"A");
            Assertions.fail((String)("Expected " + IOException.class.getName()));
        }
        catch (IOExceptionList e) {
            ((StringWriter)Mockito.verify((Object)goodW)).append("A");
            Assertions.assertEquals((int)1, (int)e.getCauseList().size());
            Assertions.assertEquals((int)1, (int)((IOIndexedException)e.getCause(0, IOIndexedException.class)).getIndex());
        }
    }

    @Test
    public void testArrayIOExceptionOnAppendCharSequenceIntInt1() throws IOException {
        BrokenWriter badW = new BrokenWriter();
        StringWriter goodW = (StringWriter)Mockito.mock(StringWriter.class);
        TeeWriter tw = new TeeWriter(new Writer[]{badW, goodW, null});
        String data = "A";
        try {
            tw.append((CharSequence)"A", 0, 0);
            Assertions.fail((String)("Expected " + IOException.class.getName()));
        }
        catch (IOExceptionList e) {
            ((StringWriter)Mockito.verify((Object)goodW)).append("A", 0, 0);
            Assertions.assertEquals((int)1, (int)e.getCauseList().size());
            Assertions.assertEquals((int)0, (int)((IOIndexedException)e.getCause(0, IOIndexedException.class)).getIndex());
        }
    }

    @Test
    public void testArrayIOExceptionOnAppendCharSequenceIntInt2() throws IOException {
        BrokenWriter badW = new BrokenWriter();
        StringWriter goodW = (StringWriter)Mockito.mock(StringWriter.class);
        TeeWriter tw = new TeeWriter(new Writer[]{goodW, badW, null});
        String data = "A";
        try {
            tw.append((CharSequence)"A", 0, 0);
            Assertions.fail((String)("Expected " + IOException.class.getName()));
        }
        catch (IOExceptionList e) {
            ((StringWriter)Mockito.verify((Object)goodW)).append("A", 0, 0);
            Assertions.assertEquals((int)1, (int)e.getCauseList().size());
            Assertions.assertEquals((int)1, (int)((IOIndexedException)e.getCause(0, IOIndexedException.class)).getIndex());
        }
    }

    @Test
    public void testArrayIOExceptionOnClose1() throws IOException {
        BrokenWriter badW = new BrokenWriter();
        StringWriter goodW = (StringWriter)Mockito.mock(StringWriter.class);
        TeeWriter tw = new TeeWriter(new Writer[]{badW, goodW, null});
        try {
            tw.close();
            Assertions.fail((String)("Expected " + IOException.class.getName()));
        }
        catch (IOExceptionList e) {
            ((StringWriter)Mockito.verify((Object)goodW)).close();
            Assertions.assertEquals((int)1, (int)e.getCauseList().size());
            Assertions.assertEquals((int)0, (int)((IOIndexedException)e.getCause(0, IOIndexedException.class)).getIndex());
        }
    }

    @Test
    public void testArrayIOExceptionOnClose2() throws IOException {
        BrokenWriter badW = new BrokenWriter();
        StringWriter goodW = (StringWriter)Mockito.mock(StringWriter.class);
        TeeWriter tw = new TeeWriter(new Writer[]{goodW, badW, null});
        try {
            tw.close();
            Assertions.fail((String)("Expected " + IOException.class.getName()));
        }
        catch (IOExceptionList e) {
            ((StringWriter)Mockito.verify((Object)goodW)).close();
            Assertions.assertEquals((int)1, (int)e.getCauseList().size());
            Assertions.assertEquals((int)1, (int)((IOIndexedException)e.getCause(0, IOIndexedException.class)).getIndex());
        }
    }

    @Test
    public void testArrayIOExceptionOnFlush1() throws IOException {
        BrokenWriter badW = new BrokenWriter();
        StringWriter goodW = (StringWriter)Mockito.mock(StringWriter.class);
        TeeWriter tw = new TeeWriter(new Writer[]{badW, goodW, null});
        try {
            tw.flush();
            Assertions.fail((String)("Expected " + IOException.class.getName()));
        }
        catch (IOExceptionList e) {
            ((StringWriter)Mockito.verify((Object)goodW)).flush();
            Assertions.assertEquals((int)1, (int)e.getCauseList().size());
            Assertions.assertEquals((int)0, (int)((IOIndexedException)e.getCause(0, IOIndexedException.class)).getIndex());
        }
    }

    @Test
    public void testArrayIOExceptionOnFlush2() throws IOException {
        BrokenWriter badW = new BrokenWriter();
        StringWriter goodW = (StringWriter)Mockito.mock(StringWriter.class);
        TeeWriter tw = new TeeWriter(new Writer[]{goodW, badW, null});
        try {
            tw.flush();
            Assertions.fail((String)("Expected " + IOException.class.getName()));
        }
        catch (IOExceptionList e) {
            ((StringWriter)Mockito.verify((Object)goodW)).flush();
            Assertions.assertEquals((int)1, (int)e.getCauseList().size());
            Assertions.assertEquals((int)1, (int)((IOIndexedException)e.getCause(0, IOIndexedException.class)).getIndex());
        }
    }

    @Test
    public void testArrayIOExceptionOnWriteCharArray1() throws IOException {
        BrokenWriter badW = new BrokenWriter();
        StringWriter goodW = (StringWriter)Mockito.mock(StringWriter.class);
        TeeWriter tw = new TeeWriter(new Writer[]{badW, goodW, null});
        char[] data = new char[]{'a'};
        try {
            tw.write(data);
            Assertions.fail((String)("Expected " + IOException.class.getName()));
        }
        catch (IOExceptionList e) {
            ((StringWriter)Mockito.verify((Object)goodW)).write(data);
            Assertions.assertEquals((int)1, (int)e.getCauseList().size());
            Assertions.assertEquals((int)0, (int)((IOIndexedException)e.getCause(0, IOIndexedException.class)).getIndex());
        }
    }

    @Test
    public void testArrayIOExceptionOnWriteCharArray2() throws IOException {
        BrokenWriter badW = new BrokenWriter();
        StringWriter goodW = (StringWriter)Mockito.mock(StringWriter.class);
        TeeWriter tw = new TeeWriter(new Writer[]{goodW, badW, null});
        char[] data = new char[]{'a'};
        try {
            tw.write(data);
            Assertions.fail((String)("Expected " + IOException.class.getName()));
        }
        catch (IOExceptionList e) {
            ((StringWriter)Mockito.verify((Object)goodW)).write(data);
            Assertions.assertEquals((int)1, (int)e.getCauseList().size());
            Assertions.assertEquals((int)1, (int)((IOIndexedException)e.getCause(0, IOIndexedException.class)).getIndex());
        }
    }

    @Test
    public void testArrayIOExceptionOnWriteCharArrayIntInt1() throws IOException {
        BrokenWriter badW = new BrokenWriter();
        StringWriter goodW = (StringWriter)Mockito.mock(StringWriter.class);
        TeeWriter tw = new TeeWriter(new Writer[]{badW, goodW, null});
        char[] data = new char[]{'a'};
        try {
            tw.write(data, 0, 0);
            Assertions.fail((String)("Expected " + IOException.class.getName()));
        }
        catch (IOExceptionList e) {
            ((StringWriter)Mockito.verify((Object)goodW)).write(data, 0, 0);
            Assertions.assertEquals((int)1, (int)e.getCauseList().size());
            Assertions.assertEquals((int)0, (int)((IOIndexedException)e.getCause(0, IOIndexedException.class)).getIndex());
        }
    }

    @Test
    public void testArrayIOExceptionOnWriteCharArrayIntInt2() throws IOException {
        BrokenWriter badW = new BrokenWriter();
        StringWriter goodW = (StringWriter)Mockito.mock(StringWriter.class);
        TeeWriter tw = new TeeWriter(new Writer[]{goodW, badW, null});
        char[] data = new char[]{'a'};
        try {
            tw.write(data, 0, 0);
            Assertions.fail((String)("Expected " + IOException.class.getName()));
        }
        catch (IOExceptionList e) {
            ((StringWriter)Mockito.verify((Object)goodW)).write(data, 0, 0);
            Assertions.assertEquals((int)1, (int)e.getCauseList().size());
            Assertions.assertEquals((int)1, (int)((IOIndexedException)e.getCause(0, IOIndexedException.class)).getIndex());
        }
    }

    @Test
    public void testArrayIOExceptionOnWriteInt1() throws IOException {
        BrokenWriter badW = new BrokenWriter();
        StringWriter goodW = (StringWriter)Mockito.mock(StringWriter.class);
        TeeWriter tw = new TeeWriter(new Writer[]{badW, goodW, null});
        int data = 32;
        try {
            tw.write(32);
            Assertions.fail((String)("Expected " + IOException.class.getName()));
        }
        catch (IOExceptionList e) {
            ((StringWriter)Mockito.verify((Object)goodW)).write(32);
            Assertions.assertEquals((int)1, (int)e.getCauseList().size());
            Assertions.assertEquals((int)0, (int)((IOIndexedException)e.getCause(0, IOIndexedException.class)).getIndex());
        }
    }

    @Test
    public void testArrayIOExceptionOnWriteInt2() throws IOException {
        BrokenWriter badW = new BrokenWriter();
        StringWriter goodW = (StringWriter)Mockito.mock(StringWriter.class);
        TeeWriter tw = new TeeWriter(new Writer[]{goodW, badW, null});
        try {
            tw.write(32);
            Assertions.fail((String)("Expected " + IOException.class.getName()));
        }
        catch (IOExceptionList e) {
            ((StringWriter)Mockito.verify((Object)goodW)).write(32);
            Assertions.assertEquals((int)1, (int)e.getCauseList().size());
            Assertions.assertEquals((int)1, (int)((IOIndexedException)e.getCause(0, IOIndexedException.class)).getIndex());
        }
    }

    @Test
    public void testArrayIOExceptionOnWriteString1() throws IOException {
        BrokenWriter badW = new BrokenWriter();
        StringWriter goodW = (StringWriter)Mockito.mock(StringWriter.class);
        TeeWriter tw = new TeeWriter(new Writer[]{badW, goodW, null});
        String data = "A";
        try {
            tw.write("A");
            Assertions.fail((String)("Expected " + IOException.class.getName()));
        }
        catch (IOExceptionList e) {
            ((StringWriter)Mockito.verify((Object)goodW)).write("A");
            Assertions.assertEquals((int)1, (int)e.getCauseList().size());
            Assertions.assertEquals((int)0, (int)((IOIndexedException)e.getCause(0, IOIndexedException.class)).getIndex());
        }
    }

    @Test
    public void testArrayIOExceptionOnWriteString2() throws IOException {
        BrokenWriter badW = new BrokenWriter();
        StringWriter goodW = (StringWriter)Mockito.mock(StringWriter.class);
        TeeWriter tw = new TeeWriter(new Writer[]{goodW, badW, null});
        String data = "A";
        try {
            tw.write("A");
            Assertions.fail((String)("Expected " + IOException.class.getName()));
        }
        catch (IOExceptionList e) {
            ((StringWriter)Mockito.verify((Object)goodW)).write("A");
            Assertions.assertEquals((int)1, (int)e.getCauseList().size());
            Assertions.assertEquals((int)1, (int)((IOIndexedException)e.getCause(0, IOIndexedException.class)).getIndex());
        }
    }

    @Test
    public void testArrayIOExceptionOnWriteStringIntInt1() throws IOException {
        BrokenWriter badW = new BrokenWriter();
        StringWriter goodW = (StringWriter)Mockito.mock(StringWriter.class);
        TeeWriter tw = new TeeWriter(new Writer[]{badW, goodW, null});
        String data = "A";
        try {
            tw.write("A", 0, 0);
            Assertions.fail((String)("Expected " + IOException.class.getName()));
        }
        catch (IOExceptionList e) {
            ((StringWriter)Mockito.verify((Object)goodW)).write("A", 0, 0);
            Assertions.assertEquals((int)1, (int)e.getCauseList().size());
            Assertions.assertEquals((int)0, (int)((IOIndexedException)e.getCause(0, IOIndexedException.class)).getIndex());
        }
    }

    @Test
    public void testArrayIOExceptionOnWriteStringIntInt2() throws IOException {
        BrokenWriter badW = new BrokenWriter();
        StringWriter goodW = (StringWriter)Mockito.mock(StringWriter.class);
        TeeWriter tw = new TeeWriter(new Writer[]{goodW, badW, null});
        String data = "A";
        try {
            tw.write("A", 0, 0);
            Assertions.fail((String)("Expected " + IOException.class.getName()));
        }
        catch (IOExceptionList e) {
            ((StringWriter)Mockito.verify((Object)goodW)).write("A", 0, 0);
            Assertions.assertEquals((int)1, (int)e.getCauseList().size());
            Assertions.assertEquals((int)1, (int)((IOIndexedException)e.getCause(0, IOIndexedException.class)).getIndex());
        }
    }

    @Test
    public void testCollectionCloseBranchIOException() throws IOException {
        BrokenWriter badW = new BrokenWriter();
        StringWriter goodW = (StringWriter)Mockito.mock(StringWriter.class);
        TeeWriter tw = new TeeWriter(Arrays.asList(goodW, badW, null));
        try {
            tw.close();
            Assertions.fail((String)("Expected " + IOException.class.getName()));
        }
        catch (IOExceptionList e) {
            ((StringWriter)Mockito.verify((Object)goodW)).close();
            Assertions.assertEquals((int)1, (int)e.getCauseList().size());
            Assertions.assertEquals((int)1, (int)((IOIndexedException)e.getCause(0, IOIndexedException.class)).getIndex());
        }
    }

    @Test
    public void testConstructorsNull() throws IOException {
        try (TeeWriter teeWriter = new TeeWriter((Writer[])null);){
            teeWriter.append('a');
            teeWriter.flush();
        }
        teeWriter = new TeeWriter((Collection)null);
        var2_2 = null;
        try {
            teeWriter.append('a');
            teeWriter.flush();
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (teeWriter != null) {
                if (var2_2 != null) {
                    try {
                        teeWriter.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    teeWriter.close();
                }
            }
        }
    }

    @Test
    public void testTee() throws IOException {
        StringBuilderWriter sbw1 = new StringBuilderWriter();
        StringBuilderWriter sbw2 = new StringBuilderWriter();
        StringBuilderWriter expected = new StringBuilderWriter();
        try (TeeWriter tw = new TeeWriter(new Writer[]{sbw1, sbw2, null});){
            int i;
            for (int i2 = 0; i2 < 20; ++i2) {
                tw.write(i2);
                expected.write(i2);
            }
            Assertions.assertEquals((Object)expected.toString(), (Object)sbw1.toString(), (String)"TeeWriter.write(int)");
            Assertions.assertEquals((Object)expected.toString(), (Object)sbw2.toString(), (String)"TeeWriter.write(int)");
            char[] array = new char[10];
            for (i = 20; i < 30; ++i) {
                array[i - 20] = (char)i;
            }
            tw.write(array);
            expected.write(array);
            Assertions.assertEquals((Object)expected.toString(), (Object)sbw1.toString(), (String)"TeeWriter.write(char[])");
            Assertions.assertEquals((Object)expected.toString(), (Object)sbw2.toString(), (String)"TeeWriter.write(char[])");
            for (i = 25; i < 35; ++i) {
                array[i - 25] = (char)i;
            }
            tw.write(array, 5, 5);
            expected.write(array, 5, 5);
            Assertions.assertEquals((Object)expected.toString(), (Object)sbw1.toString(), (String)"TeeOutputStream.write(byte[], int, int)");
            Assertions.assertEquals((Object)expected.toString(), (Object)sbw2.toString(), (String)"TeeOutputStream.write(byte[], int, int)");
            for (i = 0; i < 20; ++i) {
                tw.append((char)i);
                expected.append((char)i);
            }
            Assertions.assertEquals((Object)expected.toString(), (Object)sbw1.toString(), (String)"TeeWriter.append(char)");
            Assertions.assertEquals((Object)expected.toString(), (Object)sbw2.toString(), (String)"TeeWriter.append(char)");
            for (i = 20; i < 30; ++i) {
                array[i - 20] = (char)i;
            }
            tw.append((CharSequence)new String(array));
            expected.append((CharSequence)new String(array));
            Assertions.assertEquals((Object)expected.toString(), (Object)sbw1.toString(), (String)"TeeWriter.append(CharSequence)");
            Assertions.assertEquals((Object)expected.toString(), (Object)sbw2.toString(), (String)"TeeWriter.append(CharSequence)");
            for (i = 25; i < 35; ++i) {
                array[i - 25] = (char)i;
            }
            tw.append((CharSequence)new String(array), 5, 5);
            expected.append((CharSequence)new String(array), 5, 5);
            Assertions.assertEquals((Object)expected.toString(), (Object)sbw1.toString(), (String)"TeeWriter.append(CharSequence, int, int)");
            Assertions.assertEquals((Object)expected.toString(), (Object)sbw2.toString(), (String)"TeeWriter.append(CharSequence, int, int)");
            expected.flush();
            expected.close();
            tw.flush();
        }
    }
}

