/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.io.output.ThresholdingOutputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ThresholdingOutputStreamTest {
    @Test
    public void testSetByteCount() throws Exception {
        final AtomicBoolean reached = new AtomicBoolean(false);
        try (ThresholdingOutputStream tos = new ThresholdingOutputStream(3){
            {
                super(x0);
                this.setByteCount(2L);
            }

            protected OutputStream getStream() throws IOException {
                return new ByteArrayOutputStream(4);
            }

            protected void thresholdReached() throws IOException {
                reached.set(true);
            }
        };){
            tos.write(12);
            Assertions.assertFalse((boolean)reached.get());
            tos.write(12);
            Assertions.assertTrue((boolean)reached.get());
        }
    }
}

