/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Random;
import org.apache.commons.io.output.WriterOutputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class WriterOutputStreamTest {
    private static final String TEST_STRING = "\u00e0 peine arriv\u00e9s nous entr\u00e2mes dans sa chambre";
    private static final String LARGE_TEST_STRING;
    private final Random random = new Random();

    private void testWithSingleByteWrite(String testString, String charsetName) throws IOException {
        byte[] bytes = testString.getBytes(charsetName);
        StringWriter writer = new StringWriter();
        try (WriterOutputStream out = new WriterOutputStream((Writer)writer, charsetName);){
            for (byte b : bytes) {
                out.write((int)b);
            }
        }
        Assertions.assertEquals((Object)testString, (Object)writer.toString());
    }

    private void testWithBufferedWrite(String testString, String charsetName) throws IOException {
        byte[] expected = testString.getBytes(charsetName);
        StringWriter writer = new StringWriter();
        try (WriterOutputStream out = new WriterOutputStream((Writer)writer, charsetName);){
            int length;
            for (int offset = 0; offset < expected.length; offset += length) {
                length = Math.min(this.random.nextInt(128), expected.length - offset);
                out.write(expected, offset, length);
            }
        }
        Assertions.assertEquals((Object)testString, (Object)writer.toString());
    }

    @Test
    public void testUTF8WithSingleByteWrite() throws IOException {
        this.testWithSingleByteWrite(TEST_STRING, "UTF-8");
    }

    @Test
    public void testLargeUTF8WithSingleByteWrite() throws IOException {
        this.testWithSingleByteWrite(LARGE_TEST_STRING, "UTF-8");
    }

    @Test
    public void testUTF8WithBufferedWrite() throws IOException {
        this.testWithBufferedWrite(TEST_STRING, "UTF-8");
    }

    @Test
    public void testLargeUTF8WithBufferedWrite() throws IOException {
        this.testWithBufferedWrite(LARGE_TEST_STRING, "UTF-8");
    }

    @Test
    public void testUTF16WithSingleByteWrite() throws IOException {
        block2: {
            try {
                this.testWithSingleByteWrite(TEST_STRING, "UTF-16");
            }
            catch (UnsupportedOperationException e) {
                if (System.getProperty("java.vendor").contains("IBM")) break block2;
                Assertions.fail((String)"This test should only throw UOE on IBM JDKs with broken UTF-16");
            }
        }
    }

    @Test
    public void testUTF16WithBufferedWrite() throws IOException {
        block2: {
            try {
                this.testWithBufferedWrite(TEST_STRING, "UTF-16");
            }
            catch (UnsupportedOperationException e) {
                if (System.getProperty("java.vendor").contains("IBM")) break block2;
                Assertions.fail((String)"This test should only throw UOE on IBM JDKs with broken UTF-16");
            }
        }
    }

    @Test
    public void testUTF16BEWithSingleByteWrite() throws IOException {
        this.testWithSingleByteWrite(TEST_STRING, "UTF-16BE");
    }

    @Test
    public void testUTF16BEWithBufferedWrite() throws IOException {
        this.testWithBufferedWrite(TEST_STRING, "UTF-16BE");
    }

    @Test
    public void testUTF16LEWithSingleByteWrite() throws IOException {
        this.testWithSingleByteWrite(TEST_STRING, "UTF-16LE");
    }

    @Test
    public void testUTF16LEWithBufferedWrite() throws IOException {
        this.testWithBufferedWrite(TEST_STRING, "UTF-16LE");
    }

    @Test
    public void testFlush() throws IOException {
        StringWriter writer = new StringWriter();
        try (WriterOutputStream out = new WriterOutputStream((Writer)writer, "us-ascii", 1024, false);){
            out.write("abc".getBytes("us-ascii"));
            Assertions.assertEquals((int)0, (int)writer.getBuffer().length());
            out.flush();
            Assertions.assertEquals((Object)"abc", (Object)writer.toString());
        }
    }

    @Test
    public void testWriteImmediately() throws IOException {
        StringWriter writer = new StringWriter();
        try (WriterOutputStream out = new WriterOutputStream((Writer)writer, "us-ascii", 1024, true);){
            out.write("abc".getBytes("us-ascii"));
            Assertions.assertEquals((Object)"abc", (Object)writer.toString());
        }
    }

    static {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < 100; ++i) {
            buffer.append(TEST_STRING);
        }
        LARGE_TEST_STRING = buffer.toString();
    }
}

