/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.testtools;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.junit.jupiter.api.Assertions;

public abstract class TestUtils {
    private TestUtils() {
    }

    public static void createFile(File file, long size) throws IOException {
        if (!file.getParentFile().exists()) {
            throw new IOException("Cannot create file " + file + " as the parent directory does not exist");
        }
        try (BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(file));){
            TestUtils.generateTestData(output, size);
        }
    }

    public static byte[] generateTestData(long size) {
        try {
            ByteArrayOutputStream baout = new ByteArrayOutputStream();
            TestUtils.generateTestData((OutputStream)baout, size);
            return baout.toByteArray();
        }
        catch (IOException ioe) {
            throw new RuntimeException("This should never happen: " + ioe.getMessage());
        }
    }

    public static void generateTestData(OutputStream out, long size) throws IOException {
        int i = 0;
        while ((long)i < size) {
            out.write((byte)(i % 127 + 1));
            ++i;
        }
    }

    public static void createLineBasedFile(File file, String[] data) throws IOException {
        if (file.getParentFile() != null && !file.getParentFile().exists()) {
            throw new IOException("Cannot create file " + file + " as the parent directory does not exist");
        }
        try (PrintWriter output = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));){
            for (String element : data) {
                output.println(element);
            }
        }
    }

    public static File newFile(File testDirectory, String filename) throws IOException {
        File destination = new File(testDirectory, filename);
        if (destination.exists()) {
            FileUtils.forceDelete((File)destination);
        }
        return destination;
    }

    public static void checkFile(File file, File referenceFile) throws Exception {
        Assertions.assertTrue((boolean)file.exists(), (String)"Check existence of output file");
        TestUtils.assertEqualContent(referenceFile, file);
    }

    private static void assertEqualContent(File f0, File f1) throws IOException {
        try (FileInputStream is0 = new FileInputStream(f0);
             FileInputStream is1 = new FileInputStream(f1);){
            byte[] buf0 = new byte[1024];
            byte[] buf1 = new byte[1024];
            int n0 = 0;
            while (-1 != n0) {
                int n1;
                n0 = ((InputStream)is0).read(buf0);
                Assertions.assertTrue((n0 == (n1 = ((InputStream)is1).read(buf1)) ? 1 : 0) != 0, (String)("The files " + f0 + " and " + f1 + " have differing number of bytes available (" + n0 + " vs " + n1 + ")"));
                Assertions.assertTrue((boolean)Arrays.equals(buf0, buf1), (String)("The files " + f0 + " and " + f1 + " have different content"));
            }
        }
    }

    public static void assertEqualContent(byte[] b0, File file) throws IOException {
        int numRead = 0;
        byte[] b1 = new byte[b0.length];
        try (FileInputStream is = new FileInputStream(file);){
            int count;
            for (count = 0; count < b0.length && numRead >= 0; count += numRead) {
                numRead = ((InputStream)is).read(b1, count, b0.length);
            }
            Assertions.assertEquals((int)b0.length, (int)count, (String)"Different number of bytes: ");
            for (int i = 0; i < count; ++i) {
                Assertions.assertEquals((byte)b0[i], (byte)b1[i], (String)("byte " + i + " differs"));
            }
        }
    }

    public static void assertEqualContent(char[] c0, File file) throws IOException {
        int numRead = 0;
        char[] c1 = new char[c0.length];
        try (FileReader ir = new FileReader(file);){
            int count;
            for (count = 0; count < c0.length && numRead >= 0; count += numRead) {
                numRead = ((Reader)ir).read(c1, count, c0.length);
            }
            Assertions.assertEquals((int)c0.length, (int)count, (String)"Different number of chars: ");
            for (int i = 0; i < count; ++i) {
                Assertions.assertEquals((char)c0[i], (char)c1[i], (String)("char " + i + " differs"));
            }
        }
    }

    public static void checkWrite(OutputStream output) throws Exception {
        try {
            new PrintStream(output).write(0);
        }
        catch (Throwable t) {
            Assertions.fail((String)("The copy() method closed the stream when it shouldn't have. " + t.getMessage()));
        }
    }

    public static void checkWrite(Writer output) throws Exception {
        try {
            new PrintWriter(output).write(97);
        }
        catch (Throwable t) {
            Assertions.fail((String)("The copy() method closed the stream when it shouldn't have. " + t.getMessage()));
        }
    }

    public static void deleteFile(File file) throws Exception {
        if (file.exists()) {
            Assertions.assertTrue((boolean)file.delete(), (String)("Couldn't delete file: " + file));
        }
    }

    public static void sleep(long ms) throws InterruptedException {
        long finishAt = System.currentTimeMillis() + ms;
        long remaining = ms;
        do {
            Thread.sleep(remaining);
        } while ((remaining = finishAt - System.currentTimeMillis()) > 0L);
    }

    public static void sleepQuietly(long ms) {
        try {
            TestUtils.sleep(ms);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

