/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class FilenameUtilsTestCase {
    @TempDir
    public File temporaryFolder;
    private static final String SEP = "" + File.separatorChar;
    private static final boolean WINDOWS = File.separatorChar == '\\';
    private File testFile1;
    private File testFile2;
    private int testFile1Size;
    private int testFile2Size;

    @BeforeEach
    public void setUp() throws Exception {
        this.testFile1 = File.createTempFile("test", "1", this.temporaryFolder);
        this.testFile2 = File.createTempFile("test", "2", this.temporaryFolder);
        this.testFile1Size = (int)this.testFile1.length();
        this.testFile2Size = (int)this.testFile2.length();
        if (!this.testFile1.getParentFile().exists()) {
            throw new IOException("Cannot create file " + this.testFile1 + " as the parent directory does not exist");
        }
        try (BufferedOutputStream output3 = new BufferedOutputStream(new FileOutputStream(this.testFile1));){
            TestUtils.generateTestData(output3, this.testFile1Size);
        }
        if (!this.testFile2.getParentFile().exists()) {
            throw new IOException("Cannot create file " + this.testFile2 + " as the parent directory does not exist");
        }
        var2_2 = null;
        try (BufferedOutputStream output2 = new BufferedOutputStream(new FileOutputStream(this.testFile2));){
            TestUtils.generateTestData(output2, this.testFile2Size);
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        if (!this.testFile1.getParentFile().exists()) {
            throw new IOException("Cannot create file " + this.testFile1 + " as the parent directory does not exist");
        }
        var2_2 = null;
        try (BufferedOutputStream output1 = new BufferedOutputStream(new FileOutputStream(this.testFile1));){
            TestUtils.generateTestData(output1, this.testFile1Size);
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        if (!this.testFile2.getParentFile().exists()) {
            throw new IOException("Cannot create file " + this.testFile2 + " as the parent directory does not exist");
        }
        var2_2 = null;
        try (BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(this.testFile2));){
            TestUtils.generateTestData(output, this.testFile2Size);
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
    }

    @Test
    public void testNormalize() throws Exception {
        Assertions.assertEquals(null, (Object)FilenameUtils.normalize(null));
        Assertions.assertEquals(null, (Object)FilenameUtils.normalize((String)":"));
        Assertions.assertEquals(null, (Object)FilenameUtils.normalize((String)"1:\\a\\b\\c.txt"));
        Assertions.assertEquals(null, (Object)FilenameUtils.normalize((String)"1:"));
        Assertions.assertEquals(null, (Object)FilenameUtils.normalize((String)"1:a"));
        Assertions.assertEquals(null, (Object)FilenameUtils.normalize((String)"\\\\\\a\\b\\c.txt"));
        Assertions.assertEquals(null, (Object)FilenameUtils.normalize((String)"\\\\a"));
        Assertions.assertEquals((Object)("a" + SEP + "b" + SEP + "c.txt"), (Object)FilenameUtils.normalize((String)"a\\b/c.txt"));
        Assertions.assertEquals((Object)("" + SEP + "a" + SEP + "b" + SEP + "c.txt"), (Object)FilenameUtils.normalize((String)"\\a\\b/c.txt"));
        Assertions.assertEquals((Object)("C:" + SEP + "a" + SEP + "b" + SEP + "c.txt"), (Object)FilenameUtils.normalize((String)"C:\\a\\b/c.txt"));
        Assertions.assertEquals((Object)("" + SEP + "" + SEP + "server" + SEP + "a" + SEP + "b" + SEP + "c.txt"), (Object)FilenameUtils.normalize((String)"\\\\server\\a\\b/c.txt"));
        Assertions.assertEquals((Object)("~" + SEP + "a" + SEP + "b" + SEP + "c.txt"), (Object)FilenameUtils.normalize((String)"~\\a\\b/c.txt"));
        Assertions.assertEquals((Object)("~user" + SEP + "a" + SEP + "b" + SEP + "c.txt"), (Object)FilenameUtils.normalize((String)"~user\\a\\b/c.txt"));
        Assertions.assertEquals((Object)("a" + SEP + "c"), (Object)FilenameUtils.normalize((String)"a/b/../c"));
        Assertions.assertEquals((Object)"c", (Object)FilenameUtils.normalize((String)"a/b/../../c"));
        Assertions.assertEquals((Object)("c" + SEP), (Object)FilenameUtils.normalize((String)"a/b/../../c/"));
        Assertions.assertEquals(null, (Object)FilenameUtils.normalize((String)"a/b/../../../c"));
        Assertions.assertEquals((Object)("a" + SEP), (Object)FilenameUtils.normalize((String)"a/b/.."));
        Assertions.assertEquals((Object)("a" + SEP), (Object)FilenameUtils.normalize((String)"a/b/../"));
        Assertions.assertEquals((Object)"", (Object)FilenameUtils.normalize((String)"a/b/../.."));
        Assertions.assertEquals((Object)"", (Object)FilenameUtils.normalize((String)"a/b/../../"));
        Assertions.assertEquals(null, (Object)FilenameUtils.normalize((String)"a/b/../../.."));
        Assertions.assertEquals((Object)("a" + SEP + "d"), (Object)FilenameUtils.normalize((String)"a/b/../c/../d"));
        Assertions.assertEquals((Object)("a" + SEP + "d" + SEP), (Object)FilenameUtils.normalize((String)"a/b/../c/../d/"));
        Assertions.assertEquals((Object)("a" + SEP + "b" + SEP + "d"), (Object)FilenameUtils.normalize((String)"a/b//d"));
        Assertions.assertEquals((Object)("a" + SEP + "b" + SEP), (Object)FilenameUtils.normalize((String)"a/b/././."));
        Assertions.assertEquals((Object)("a" + SEP + "b" + SEP), (Object)FilenameUtils.normalize((String)"a/b/./././"));
        Assertions.assertEquals((Object)("a" + SEP), (Object)FilenameUtils.normalize((String)"./a/"));
        Assertions.assertEquals((Object)"a", (Object)FilenameUtils.normalize((String)"./a"));
        Assertions.assertEquals((Object)"", (Object)FilenameUtils.normalize((String)"./"));
        Assertions.assertEquals((Object)"", (Object)FilenameUtils.normalize((String)"."));
        Assertions.assertEquals(null, (Object)FilenameUtils.normalize((String)"../a"));
        Assertions.assertEquals(null, (Object)FilenameUtils.normalize((String)".."));
        Assertions.assertEquals((Object)"", (Object)FilenameUtils.normalize((String)""));
        Assertions.assertEquals((Object)(SEP + "a"), (Object)FilenameUtils.normalize((String)"/a"));
        Assertions.assertEquals((Object)(SEP + "a" + SEP), (Object)FilenameUtils.normalize((String)"/a/"));
        Assertions.assertEquals((Object)(SEP + "a" + SEP + "c"), (Object)FilenameUtils.normalize((String)"/a/b/../c"));
        Assertions.assertEquals((Object)(SEP + "c"), (Object)FilenameUtils.normalize((String)"/a/b/../../c"));
        Assertions.assertEquals(null, (Object)FilenameUtils.normalize((String)"/a/b/../../../c"));
        Assertions.assertEquals((Object)(SEP + "a" + SEP), (Object)FilenameUtils.normalize((String)"/a/b/.."));
        Assertions.assertEquals((Object)(SEP + ""), (Object)FilenameUtils.normalize((String)"/a/b/../.."));
        Assertions.assertEquals(null, (Object)FilenameUtils.normalize((String)"/a/b/../../.."));
        Assertions.assertEquals((Object)(SEP + "a" + SEP + "d"), (Object)FilenameUtils.normalize((String)"/a/b/../c/../d"));
        Assertions.assertEquals((Object)(SEP + "a" + SEP + "b" + SEP + "d"), (Object)FilenameUtils.normalize((String)"/a/b//d"));
        Assertions.assertEquals((Object)(SEP + "a" + SEP + "b" + SEP), (Object)FilenameUtils.normalize((String)"/a/b/././."));
        Assertions.assertEquals((Object)(SEP + "a"), (Object)FilenameUtils.normalize((String)"/./a"));
        Assertions.assertEquals((Object)(SEP + ""), (Object)FilenameUtils.normalize((String)"/./"));
        Assertions.assertEquals((Object)(SEP + ""), (Object)FilenameUtils.normalize((String)"/."));
        Assertions.assertEquals(null, (Object)FilenameUtils.normalize((String)"/../a"));
        Assertions.assertEquals(null, (Object)FilenameUtils.normalize((String)"/.."));
        Assertions.assertEquals((Object)(SEP + ""), (Object)FilenameUtils.normalize((String)"/"));
        Assertions.assertEquals((Object)("~" + SEP + "a"), (Object)FilenameUtils.normalize((String)"~/a"));
        Assertions.assertEquals((Object)("~" + SEP + "a" + SEP), (Object)FilenameUtils.normalize((String)"~/a/"));
        Assertions.assertEquals((Object)("~" + SEP + "a" + SEP + "c"), (Object)FilenameUtils.normalize((String)"~/a/b/../c"));
        Assertions.assertEquals((Object)("~" + SEP + "c"), (Object)FilenameUtils.normalize((String)"~/a/b/../../c"));
        Assertions.assertEquals(null, (Object)FilenameUtils.normalize((String)"~/a/b/../../../c"));
        Assertions.assertEquals((Object)("~" + SEP + "a" + SEP), (Object)FilenameUtils.normalize((String)"~/a/b/.."));
        Assertions.assertEquals((Object)("~" + SEP + ""), (Object)FilenameUtils.normalize((String)"~/a/b/../.."));
        Assertions.assertEquals(null, (Object)FilenameUtils.normalize((String)"~/a/b/../../.."));
        Assertions.assertEquals((Object)("~" + SEP + "a" + SEP + "d"), (Object)FilenameUtils.normalize((String)"~/a/b/../c/../d"));
        Assertions.assertEquals((Object)("~" + SEP + "a" + SEP + "b" + SEP + "d"), (Object)FilenameUtils.normalize((String)"~/a/b//d"));
        Assertions.assertEquals((Object)("~" + SEP + "a" + SEP + "b" + SEP), (Object)FilenameUtils.normalize((String)"~/a/b/././."));
        Assertions.assertEquals((Object)("~" + SEP + "a"), (Object)FilenameUtils.normalize((String)"~/./a"));
        Assertions.assertEquals((Object)("~" + SEP), (Object)FilenameUtils.normalize((String)"~/./"));
        Assertions.assertEquals((Object)("~" + SEP), (Object)FilenameUtils.normalize((String)"~/."));
        Assertions.assertEquals(null, (Object)FilenameUtils.normalize((String)"~/../a"));
        Assertions.assertEquals(null, (Object)FilenameUtils.normalize((String)"~/.."));
        Assertions.assertEquals((Object)("~" + SEP), (Object)FilenameUtils.normalize((String)"~/"));
        Assertions.assertEquals((Object)("~" + SEP), (Object)FilenameUtils.normalize((String)"~"));
        Assertions.assertEquals((Object)("~user" + SEP + "a"), (Object)FilenameUtils.normalize((String)"~user/a"));
        Assertions.assertEquals((Object)("~user" + SEP + "a" + SEP), (Object)FilenameUtils.normalize((String)"~user/a/"));
        Assertions.assertEquals((Object)("~user" + SEP + "a" + SEP + "c"), (Object)FilenameUtils.normalize((String)"~user/a/b/../c"));
        Assertions.assertEquals((Object)("~user" + SEP + "c"), (Object)FilenameUtils.normalize((String)"~user/a/b/../../c"));
        Assertions.assertEquals(null, (Object)FilenameUtils.normalize((String)"~user/a/b/../../../c"));
        Assertions.assertEquals((Object)("~user" + SEP + "a" + SEP), (Object)FilenameUtils.normalize((String)"~user/a/b/.."));
        Assertions.assertEquals((Object)("~user" + SEP + ""), (Object)FilenameUtils.normalize((String)"~user/a/b/../.."));
        Assertions.assertEquals(null, (Object)FilenameUtils.normalize((String)"~user/a/b/../../.."));
        Assertions.assertEquals((Object)("~user" + SEP + "a" + SEP + "d"), (Object)FilenameUtils.normalize((String)"~user/a/b/../c/../d"));
        Assertions.assertEquals((Object)("~user" + SEP + "a" + SEP + "b" + SEP + "d"), (Object)FilenameUtils.normalize((String)"~user/a/b//d"));
        Assertions.assertEquals((Object)("~user" + SEP + "a" + SEP + "b" + SEP), (Object)FilenameUtils.normalize((String)"~user/a/b/././."));
        Assertions.assertEquals((Object)("~user" + SEP + "a"), (Object)FilenameUtils.normalize((String)"~user/./a"));
        Assertions.assertEquals((Object)("~user" + SEP + ""), (Object)FilenameUtils.normalize((String)"~user/./"));
        Assertions.assertEquals((Object)("~user" + SEP + ""), (Object)FilenameUtils.normalize((String)"~user/."));
        Assertions.assertEquals(null, (Object)FilenameUtils.normalize((String)"~user/../a"));
        Assertions.assertEquals(null, (Object)FilenameUtils.normalize((String)"~user/.."));
        Assertions.assertEquals((Object)("~user" + SEP), (Object)FilenameUtils.normalize((String)"~user/"));
        Assertions.assertEquals((Object)("~user" + SEP), (Object)FilenameUtils.normalize((String)"~user"));
        Assertions.assertEquals((Object)("C:" + SEP + "a"), (Object)FilenameUtils.normalize((String)"C:/a"));
        Assertions.assertEquals((Object)("C:" + SEP + "a" + SEP), (Object)FilenameUtils.normalize((String)"C:/a/"));
        Assertions.assertEquals((Object)("C:" + SEP + "a" + SEP + "c"), (Object)FilenameUtils.normalize((String)"C:/a/b/../c"));
        Assertions.assertEquals((Object)("C:" + SEP + "c"), (Object)FilenameUtils.normalize((String)"C:/a/b/../../c"));
        Assertions.assertEquals(null, (Object)FilenameUtils.normalize((String)"C:/a/b/../../../c"));
        Assertions.assertEquals((Object)("C:" + SEP + "a" + SEP), (Object)FilenameUtils.normalize((String)"C:/a/b/.."));
        Assertions.assertEquals((Object)("C:" + SEP + ""), (Object)FilenameUtils.normalize((String)"C:/a/b/../.."));
        Assertions.assertEquals(null, (Object)FilenameUtils.normalize((String)"C:/a/b/../../.."));
        Assertions.assertEquals((Object)("C:" + SEP + "a" + SEP + "d"), (Object)FilenameUtils.normalize((String)"C:/a/b/../c/../d"));
        Assertions.assertEquals((Object)("C:" + SEP + "a" + SEP + "b" + SEP + "d"), (Object)FilenameUtils.normalize((String)"C:/a/b//d"));
        Assertions.assertEquals((Object)("C:" + SEP + "a" + SEP + "b" + SEP), (Object)FilenameUtils.normalize((String)"C:/a/b/././."));
        Assertions.assertEquals((Object)("C:" + SEP + "a"), (Object)FilenameUtils.normalize((String)"C:/./a"));
        Assertions.assertEquals((Object)("C:" + SEP + ""), (Object)FilenameUtils.normalize((String)"C:/./"));
        Assertions.assertEquals((Object)("C:" + SEP + ""), (Object)FilenameUtils.normalize((String)"C:/."));
        Assertions.assertEquals(null, (Object)FilenameUtils.normalize((String)"C:/../a"));
        Assertions.assertEquals(null, (Object)FilenameUtils.normalize((String)"C:/.."));
        Assertions.assertEquals((Object)("C:" + SEP + ""), (Object)FilenameUtils.normalize((String)"C:/"));
        Assertions.assertEquals((Object)"C:a", (Object)FilenameUtils.normalize((String)"C:a"));
        Assertions.assertEquals((Object)("C:a" + SEP), (Object)FilenameUtils.normalize((String)"C:a/"));
        Assertions.assertEquals((Object)("C:a" + SEP + "c"), (Object)FilenameUtils.normalize((String)"C:a/b/../c"));
        Assertions.assertEquals((Object)"C:c", (Object)FilenameUtils.normalize((String)"C:a/b/../../c"));
        Assertions.assertEquals(null, (Object)FilenameUtils.normalize((String)"C:a/b/../../../c"));
        Assertions.assertEquals((Object)("C:a" + SEP), (Object)FilenameUtils.normalize((String)"C:a/b/.."));
        Assertions.assertEquals((Object)"C:", (Object)FilenameUtils.normalize((String)"C:a/b/../.."));
        Assertions.assertEquals(null, (Object)FilenameUtils.normalize((String)"C:a/b/../../.."));
        Assertions.assertEquals((Object)("C:a" + SEP + "d"), (Object)FilenameUtils.normalize((String)"C:a/b/../c/../d"));
        Assertions.assertEquals((Object)("C:a" + SEP + "b" + SEP + "d"), (Object)FilenameUtils.normalize((String)"C:a/b//d"));
        Assertions.assertEquals((Object)("C:a" + SEP + "b" + SEP), (Object)FilenameUtils.normalize((String)"C:a/b/././."));
        Assertions.assertEquals((Object)"C:a", (Object)FilenameUtils.normalize((String)"C:./a"));
        Assertions.assertEquals((Object)"C:", (Object)FilenameUtils.normalize((String)"C:./"));
        Assertions.assertEquals((Object)"C:", (Object)FilenameUtils.normalize((String)"C:."));
        Assertions.assertEquals(null, (Object)FilenameUtils.normalize((String)"C:../a"));
        Assertions.assertEquals(null, (Object)FilenameUtils.normalize((String)"C:.."));
        Assertions.assertEquals((Object)"C:", (Object)FilenameUtils.normalize((String)"C:"));
        Assertions.assertEquals((Object)(SEP + SEP + "server" + SEP + "a"), (Object)FilenameUtils.normalize((String)"//server/a"));
        Assertions.assertEquals((Object)(SEP + SEP + "server" + SEP + "a" + SEP), (Object)FilenameUtils.normalize((String)"//server/a/"));
        Assertions.assertEquals((Object)(SEP + SEP + "server" + SEP + "a" + SEP + "c"), (Object)FilenameUtils.normalize((String)"//server/a/b/../c"));
        Assertions.assertEquals((Object)(SEP + SEP + "server" + SEP + "c"), (Object)FilenameUtils.normalize((String)"//server/a/b/../../c"));
        Assertions.assertEquals(null, (Object)FilenameUtils.normalize((String)"//server/a/b/../../../c"));
        Assertions.assertEquals((Object)(SEP + SEP + "server" + SEP + "a" + SEP), (Object)FilenameUtils.normalize((String)"//server/a/b/.."));
        Assertions.assertEquals((Object)(SEP + SEP + "server" + SEP + ""), (Object)FilenameUtils.normalize((String)"//server/a/b/../.."));
        Assertions.assertEquals(null, (Object)FilenameUtils.normalize((String)"//server/a/b/../../.."));
        Assertions.assertEquals((Object)(SEP + SEP + "server" + SEP + "a" + SEP + "d"), (Object)FilenameUtils.normalize((String)"//server/a/b/../c/../d"));
        Assertions.assertEquals((Object)(SEP + SEP + "server" + SEP + "a" + SEP + "b" + SEP + "d"), (Object)FilenameUtils.normalize((String)"//server/a/b//d"));
        Assertions.assertEquals((Object)(SEP + SEP + "server" + SEP + "a" + SEP + "b" + SEP), (Object)FilenameUtils.normalize((String)"//server/a/b/././."));
        Assertions.assertEquals((Object)(SEP + SEP + "server" + SEP + "a"), (Object)FilenameUtils.normalize((String)"//server/./a"));
        Assertions.assertEquals((Object)(SEP + SEP + "server" + SEP + ""), (Object)FilenameUtils.normalize((String)"//server/./"));
        Assertions.assertEquals((Object)(SEP + SEP + "server" + SEP + ""), (Object)FilenameUtils.normalize((String)"//server/."));
        Assertions.assertEquals(null, (Object)FilenameUtils.normalize((String)"//server/../a"));
        Assertions.assertEquals(null, (Object)FilenameUtils.normalize((String)"//server/.."));
        Assertions.assertEquals((Object)(SEP + SEP + "server" + SEP + ""), (Object)FilenameUtils.normalize((String)"//server/"));
        Assertions.assertEquals((Object)(SEP + SEP + "127.0.0.1" + SEP + "a" + SEP + "b" + SEP + "c.txt"), (Object)FilenameUtils.normalize((String)"\\\\127.0.0.1\\a\\b\\c.txt"));
        Assertions.assertEquals((Object)(SEP + SEP + "::1" + SEP + "a" + SEP + "b" + SEP + "c.txt"), (Object)FilenameUtils.normalize((String)"\\\\::1\\a\\b\\c.txt"));
        Assertions.assertEquals((Object)(SEP + SEP + "1::" + SEP + "a" + SEP + "b" + SEP + "c.txt"), (Object)FilenameUtils.normalize((String)"\\\\1::\\a\\b\\c.txt"));
        Assertions.assertEquals((Object)(SEP + SEP + "server.example.org" + SEP + "a" + SEP + "b" + SEP + "c.txt"), (Object)FilenameUtils.normalize((String)"\\\\server.example.org\\a\\b\\c.txt"));
        Assertions.assertEquals((Object)(SEP + SEP + "server.sub.example.org" + SEP + "a" + SEP + "b" + SEP + "c.txt"), (Object)FilenameUtils.normalize((String)"\\\\server.sub.example.org\\a\\b\\c.txt"));
        Assertions.assertEquals((Object)(SEP + SEP + "server." + SEP + "a" + SEP + "b" + SEP + "c.txt"), (Object)FilenameUtils.normalize((String)"\\\\server.\\a\\b\\c.txt"));
        Assertions.assertEquals((Object)(SEP + SEP + "1::127.0.0.1" + SEP + "a" + SEP + "b" + SEP + "c.txt"), (Object)FilenameUtils.normalize((String)"\\\\1::127.0.0.1\\a\\b\\c.txt"));
        Assertions.assertEquals((Object)(SEP + SEP + "127.0.0.256" + SEP + "a" + SEP + "b" + SEP + "c.txt"), (Object)FilenameUtils.normalize((String)"\\\\127.0.0.256\\a\\b\\c.txt"));
        Assertions.assertEquals((Object)(SEP + SEP + "127.0.0.01" + SEP + "a" + SEP + "b" + SEP + "c.txt"), (Object)FilenameUtils.normalize((String)"\\\\127.0.0.01\\a\\b\\c.txt"));
        Assertions.assertEquals(null, (Object)FilenameUtils.normalize((String)"\\\\-server\\a\\b\\c.txt"));
        Assertions.assertEquals(null, (Object)FilenameUtils.normalize((String)"\\\\.\\a\\b\\c.txt"));
        Assertions.assertEquals(null, (Object)FilenameUtils.normalize((String)"\\\\..\\a\\b\\c.txt"));
        Assertions.assertEquals(null, (Object)FilenameUtils.normalize((String)"\\\\127.0..1\\a\\b\\c.txt"));
        Assertions.assertEquals(null, (Object)FilenameUtils.normalize((String)"\\\\::1::2\\a\\b\\c.txt"));
        Assertions.assertEquals(null, (Object)FilenameUtils.normalize((String)"\\\\:1\\a\\b\\c.txt"));
        Assertions.assertEquals(null, (Object)FilenameUtils.normalize((String)"\\\\1:\\a\\b\\c.txt"));
        Assertions.assertEquals(null, (Object)FilenameUtils.normalize((String)"\\\\1:2:3:4:5:6:7:8:9\\a\\b\\c.txt"));
        Assertions.assertEquals(null, (Object)FilenameUtils.normalize((String)"\\\\g:2:3:4:5:6:7:8\\a\\b\\c.txt"));
        Assertions.assertEquals(null, (Object)FilenameUtils.normalize((String)"\\\\1ffff:2:3:4:5:6:7:8\\a\\b\\c.txt"));
        Assertions.assertEquals(null, (Object)FilenameUtils.normalize((String)"\\\\1:2\\a\\b\\c.txt"));
    }

    @Test
    public void testNormalize_with_nullbytes() throws Exception {
        try {
            Assertions.assertEquals((Object)("a" + SEP + "b" + SEP + "c.txt"), (Object)FilenameUtils.normalize((String)"a\\b/c\u0000.txt"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            Assertions.assertEquals((Object)("a" + SEP + "b" + SEP + "c.txt"), (Object)FilenameUtils.normalize((String)"\u0000a\\b/c.txt"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testNormalizeUnixWin() throws Exception {
        Assertions.assertEquals((Object)"/a/c/", (Object)FilenameUtils.normalize((String)"/a/b/../c/", (boolean)true));
        Assertions.assertEquals((Object)"/a/c/", (Object)FilenameUtils.normalize((String)"\\a\\b\\..\\c\\", (boolean)true));
        Assertions.assertEquals((Object)"\\a\\c\\", (Object)FilenameUtils.normalize((String)"/a/b/../c/", (boolean)false));
        Assertions.assertEquals((Object)"\\a\\c\\", (Object)FilenameUtils.normalize((String)"\\a\\b\\..\\c\\", (boolean)false));
    }

    @Test
    public void testNormalizeNoEndSeparator() throws Exception {
        Assertions.assertEquals(null, (Object)FilenameUtils.normalizeNoEndSeparator(null));
        Assertions.assertEquals(null, (Object)FilenameUtils.normalizeNoEndSeparator((String)":"));
        Assertions.assertEquals(null, (Object)FilenameUtils.normalizeNoEndSeparator((String)"1:\\a\\b\\c.txt"));
        Assertions.assertEquals(null, (Object)FilenameUtils.normalizeNoEndSeparator((String)"1:"));
        Assertions.assertEquals(null, (Object)FilenameUtils.normalizeNoEndSeparator((String)"1:a"));
        Assertions.assertEquals(null, (Object)FilenameUtils.normalizeNoEndSeparator((String)"\\\\\\a\\b\\c.txt"));
        Assertions.assertEquals(null, (Object)FilenameUtils.normalizeNoEndSeparator((String)"\\\\a"));
        Assertions.assertEquals((Object)("a" + SEP + "b" + SEP + "c.txt"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"a\\b/c.txt"));
        Assertions.assertEquals((Object)("" + SEP + "a" + SEP + "b" + SEP + "c.txt"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"\\a\\b/c.txt"));
        Assertions.assertEquals((Object)("C:" + SEP + "a" + SEP + "b" + SEP + "c.txt"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"C:\\a\\b/c.txt"));
        Assertions.assertEquals((Object)("" + SEP + "" + SEP + "server" + SEP + "a" + SEP + "b" + SEP + "c.txt"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"\\\\server\\a\\b/c.txt"));
        Assertions.assertEquals((Object)("~" + SEP + "a" + SEP + "b" + SEP + "c.txt"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"~\\a\\b/c.txt"));
        Assertions.assertEquals((Object)("~user" + SEP + "a" + SEP + "b" + SEP + "c.txt"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"~user\\a\\b/c.txt"));
        Assertions.assertEquals((Object)("a" + SEP + "c"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"a/b/../c"));
        Assertions.assertEquals((Object)"c", (Object)FilenameUtils.normalizeNoEndSeparator((String)"a/b/../../c"));
        Assertions.assertEquals((Object)"c", (Object)FilenameUtils.normalizeNoEndSeparator((String)"a/b/../../c/"));
        Assertions.assertEquals(null, (Object)FilenameUtils.normalizeNoEndSeparator((String)"a/b/../../../c"));
        Assertions.assertEquals((Object)"a", (Object)FilenameUtils.normalizeNoEndSeparator((String)"a/b/.."));
        Assertions.assertEquals((Object)"a", (Object)FilenameUtils.normalizeNoEndSeparator((String)"a/b/../"));
        Assertions.assertEquals((Object)"", (Object)FilenameUtils.normalizeNoEndSeparator((String)"a/b/../.."));
        Assertions.assertEquals((Object)"", (Object)FilenameUtils.normalizeNoEndSeparator((String)"a/b/../../"));
        Assertions.assertEquals(null, (Object)FilenameUtils.normalizeNoEndSeparator((String)"a/b/../../.."));
        Assertions.assertEquals((Object)("a" + SEP + "d"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"a/b/../c/../d"));
        Assertions.assertEquals((Object)("a" + SEP + "d"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"a/b/../c/../d/"));
        Assertions.assertEquals((Object)("a" + SEP + "b" + SEP + "d"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"a/b//d"));
        Assertions.assertEquals((Object)("a" + SEP + "b"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"a/b/././."));
        Assertions.assertEquals((Object)("a" + SEP + "b"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"a/b/./././"));
        Assertions.assertEquals((Object)"a", (Object)FilenameUtils.normalizeNoEndSeparator((String)"./a/"));
        Assertions.assertEquals((Object)"a", (Object)FilenameUtils.normalizeNoEndSeparator((String)"./a"));
        Assertions.assertEquals((Object)"", (Object)FilenameUtils.normalizeNoEndSeparator((String)"./"));
        Assertions.assertEquals((Object)"", (Object)FilenameUtils.normalizeNoEndSeparator((String)"."));
        Assertions.assertEquals(null, (Object)FilenameUtils.normalizeNoEndSeparator((String)"../a"));
        Assertions.assertEquals(null, (Object)FilenameUtils.normalizeNoEndSeparator((String)".."));
        Assertions.assertEquals((Object)"", (Object)FilenameUtils.normalizeNoEndSeparator((String)""));
        Assertions.assertEquals((Object)(SEP + "a"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"/a"));
        Assertions.assertEquals((Object)(SEP + "a"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"/a/"));
        Assertions.assertEquals((Object)(SEP + "a" + SEP + "c"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"/a/b/../c"));
        Assertions.assertEquals((Object)(SEP + "c"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"/a/b/../../c"));
        Assertions.assertEquals(null, (Object)FilenameUtils.normalizeNoEndSeparator((String)"/a/b/../../../c"));
        Assertions.assertEquals((Object)(SEP + "a"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"/a/b/.."));
        Assertions.assertEquals((Object)(SEP + ""), (Object)FilenameUtils.normalizeNoEndSeparator((String)"/a/b/../.."));
        Assertions.assertEquals(null, (Object)FilenameUtils.normalizeNoEndSeparator((String)"/a/b/../../.."));
        Assertions.assertEquals((Object)(SEP + "a" + SEP + "d"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"/a/b/../c/../d"));
        Assertions.assertEquals((Object)(SEP + "a" + SEP + "b" + SEP + "d"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"/a/b//d"));
        Assertions.assertEquals((Object)(SEP + "a" + SEP + "b"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"/a/b/././."));
        Assertions.assertEquals((Object)(SEP + "a"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"/./a"));
        Assertions.assertEquals((Object)(SEP + ""), (Object)FilenameUtils.normalizeNoEndSeparator((String)"/./"));
        Assertions.assertEquals((Object)(SEP + ""), (Object)FilenameUtils.normalizeNoEndSeparator((String)"/."));
        Assertions.assertEquals(null, (Object)FilenameUtils.normalizeNoEndSeparator((String)"/../a"));
        Assertions.assertEquals(null, (Object)FilenameUtils.normalizeNoEndSeparator((String)"/.."));
        Assertions.assertEquals((Object)(SEP + ""), (Object)FilenameUtils.normalizeNoEndSeparator((String)"/"));
        Assertions.assertEquals((Object)("~" + SEP + "a"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"~/a"));
        Assertions.assertEquals((Object)("~" + SEP + "a"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"~/a/"));
        Assertions.assertEquals((Object)("~" + SEP + "a" + SEP + "c"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"~/a/b/../c"));
        Assertions.assertEquals((Object)("~" + SEP + "c"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"~/a/b/../../c"));
        Assertions.assertEquals(null, (Object)FilenameUtils.normalizeNoEndSeparator((String)"~/a/b/../../../c"));
        Assertions.assertEquals((Object)("~" + SEP + "a"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"~/a/b/.."));
        Assertions.assertEquals((Object)("~" + SEP + ""), (Object)FilenameUtils.normalizeNoEndSeparator((String)"~/a/b/../.."));
        Assertions.assertEquals(null, (Object)FilenameUtils.normalizeNoEndSeparator((String)"~/a/b/../../.."));
        Assertions.assertEquals((Object)("~" + SEP + "a" + SEP + "d"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"~/a/b/../c/../d"));
        Assertions.assertEquals((Object)("~" + SEP + "a" + SEP + "b" + SEP + "d"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"~/a/b//d"));
        Assertions.assertEquals((Object)("~" + SEP + "a" + SEP + "b"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"~/a/b/././."));
        Assertions.assertEquals((Object)("~" + SEP + "a"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"~/./a"));
        Assertions.assertEquals((Object)("~" + SEP), (Object)FilenameUtils.normalizeNoEndSeparator((String)"~/./"));
        Assertions.assertEquals((Object)("~" + SEP), (Object)FilenameUtils.normalizeNoEndSeparator((String)"~/."));
        Assertions.assertEquals(null, (Object)FilenameUtils.normalizeNoEndSeparator((String)"~/../a"));
        Assertions.assertEquals(null, (Object)FilenameUtils.normalizeNoEndSeparator((String)"~/.."));
        Assertions.assertEquals((Object)("~" + SEP), (Object)FilenameUtils.normalizeNoEndSeparator((String)"~/"));
        Assertions.assertEquals((Object)("~" + SEP), (Object)FilenameUtils.normalizeNoEndSeparator((String)"~"));
        Assertions.assertEquals((Object)("~user" + SEP + "a"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"~user/a"));
        Assertions.assertEquals((Object)("~user" + SEP + "a"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"~user/a/"));
        Assertions.assertEquals((Object)("~user" + SEP + "a" + SEP + "c"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"~user/a/b/../c"));
        Assertions.assertEquals((Object)("~user" + SEP + "c"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"~user/a/b/../../c"));
        Assertions.assertEquals(null, (Object)FilenameUtils.normalizeNoEndSeparator((String)"~user/a/b/../../../c"));
        Assertions.assertEquals((Object)("~user" + SEP + "a"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"~user/a/b/.."));
        Assertions.assertEquals((Object)("~user" + SEP + ""), (Object)FilenameUtils.normalizeNoEndSeparator((String)"~user/a/b/../.."));
        Assertions.assertEquals(null, (Object)FilenameUtils.normalizeNoEndSeparator((String)"~user/a/b/../../.."));
        Assertions.assertEquals((Object)("~user" + SEP + "a" + SEP + "d"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"~user/a/b/../c/../d"));
        Assertions.assertEquals((Object)("~user" + SEP + "a" + SEP + "b" + SEP + "d"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"~user/a/b//d"));
        Assertions.assertEquals((Object)("~user" + SEP + "a" + SEP + "b"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"~user/a/b/././."));
        Assertions.assertEquals((Object)("~user" + SEP + "a"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"~user/./a"));
        Assertions.assertEquals((Object)("~user" + SEP + ""), (Object)FilenameUtils.normalizeNoEndSeparator((String)"~user/./"));
        Assertions.assertEquals((Object)("~user" + SEP + ""), (Object)FilenameUtils.normalizeNoEndSeparator((String)"~user/."));
        Assertions.assertEquals(null, (Object)FilenameUtils.normalizeNoEndSeparator((String)"~user/../a"));
        Assertions.assertEquals(null, (Object)FilenameUtils.normalizeNoEndSeparator((String)"~user/.."));
        Assertions.assertEquals((Object)("~user" + SEP), (Object)FilenameUtils.normalizeNoEndSeparator((String)"~user/"));
        Assertions.assertEquals((Object)("~user" + SEP), (Object)FilenameUtils.normalizeNoEndSeparator((String)"~user"));
        Assertions.assertEquals((Object)("C:" + SEP + "a"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"C:/a"));
        Assertions.assertEquals((Object)("C:" + SEP + "a"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"C:/a/"));
        Assertions.assertEquals((Object)("C:" + SEP + "a" + SEP + "c"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"C:/a/b/../c"));
        Assertions.assertEquals((Object)("C:" + SEP + "c"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"C:/a/b/../../c"));
        Assertions.assertEquals(null, (Object)FilenameUtils.normalizeNoEndSeparator((String)"C:/a/b/../../../c"));
        Assertions.assertEquals((Object)("C:" + SEP + "a"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"C:/a/b/.."));
        Assertions.assertEquals((Object)("C:" + SEP + ""), (Object)FilenameUtils.normalizeNoEndSeparator((String)"C:/a/b/../.."));
        Assertions.assertEquals(null, (Object)FilenameUtils.normalizeNoEndSeparator((String)"C:/a/b/../../.."));
        Assertions.assertEquals((Object)("C:" + SEP + "a" + SEP + "d"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"C:/a/b/../c/../d"));
        Assertions.assertEquals((Object)("C:" + SEP + "a" + SEP + "b" + SEP + "d"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"C:/a/b//d"));
        Assertions.assertEquals((Object)("C:" + SEP + "a" + SEP + "b"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"C:/a/b/././."));
        Assertions.assertEquals((Object)("C:" + SEP + "a"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"C:/./a"));
        Assertions.assertEquals((Object)("C:" + SEP + ""), (Object)FilenameUtils.normalizeNoEndSeparator((String)"C:/./"));
        Assertions.assertEquals((Object)("C:" + SEP + ""), (Object)FilenameUtils.normalizeNoEndSeparator((String)"C:/."));
        Assertions.assertEquals(null, (Object)FilenameUtils.normalizeNoEndSeparator((String)"C:/../a"));
        Assertions.assertEquals(null, (Object)FilenameUtils.normalizeNoEndSeparator((String)"C:/.."));
        Assertions.assertEquals((Object)("C:" + SEP + ""), (Object)FilenameUtils.normalizeNoEndSeparator((String)"C:/"));
        Assertions.assertEquals((Object)"C:a", (Object)FilenameUtils.normalizeNoEndSeparator((String)"C:a"));
        Assertions.assertEquals((Object)"C:a", (Object)FilenameUtils.normalizeNoEndSeparator((String)"C:a/"));
        Assertions.assertEquals((Object)("C:a" + SEP + "c"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"C:a/b/../c"));
        Assertions.assertEquals((Object)"C:c", (Object)FilenameUtils.normalizeNoEndSeparator((String)"C:a/b/../../c"));
        Assertions.assertEquals(null, (Object)FilenameUtils.normalizeNoEndSeparator((String)"C:a/b/../../../c"));
        Assertions.assertEquals((Object)"C:a", (Object)FilenameUtils.normalizeNoEndSeparator((String)"C:a/b/.."));
        Assertions.assertEquals((Object)"C:", (Object)FilenameUtils.normalizeNoEndSeparator((String)"C:a/b/../.."));
        Assertions.assertEquals(null, (Object)FilenameUtils.normalizeNoEndSeparator((String)"C:a/b/../../.."));
        Assertions.assertEquals((Object)("C:a" + SEP + "d"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"C:a/b/../c/../d"));
        Assertions.assertEquals((Object)("C:a" + SEP + "b" + SEP + "d"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"C:a/b//d"));
        Assertions.assertEquals((Object)("C:a" + SEP + "b"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"C:a/b/././."));
        Assertions.assertEquals((Object)"C:a", (Object)FilenameUtils.normalizeNoEndSeparator((String)"C:./a"));
        Assertions.assertEquals((Object)"C:", (Object)FilenameUtils.normalizeNoEndSeparator((String)"C:./"));
        Assertions.assertEquals((Object)"C:", (Object)FilenameUtils.normalizeNoEndSeparator((String)"C:."));
        Assertions.assertEquals(null, (Object)FilenameUtils.normalizeNoEndSeparator((String)"C:../a"));
        Assertions.assertEquals(null, (Object)FilenameUtils.normalizeNoEndSeparator((String)"C:.."));
        Assertions.assertEquals((Object)"C:", (Object)FilenameUtils.normalizeNoEndSeparator((String)"C:"));
        Assertions.assertEquals((Object)(SEP + SEP + "server" + SEP + "a"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"//server/a"));
        Assertions.assertEquals((Object)(SEP + SEP + "server" + SEP + "a"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"//server/a/"));
        Assertions.assertEquals((Object)(SEP + SEP + "server" + SEP + "a" + SEP + "c"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"//server/a/b/../c"));
        Assertions.assertEquals((Object)(SEP + SEP + "server" + SEP + "c"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"//server/a/b/../../c"));
        Assertions.assertEquals(null, (Object)FilenameUtils.normalizeNoEndSeparator((String)"//server/a/b/../../../c"));
        Assertions.assertEquals((Object)(SEP + SEP + "server" + SEP + "a"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"//server/a/b/.."));
        Assertions.assertEquals((Object)(SEP + SEP + "server" + SEP + ""), (Object)FilenameUtils.normalizeNoEndSeparator((String)"//server/a/b/../.."));
        Assertions.assertEquals(null, (Object)FilenameUtils.normalizeNoEndSeparator((String)"//server/a/b/../../.."));
        Assertions.assertEquals((Object)(SEP + SEP + "server" + SEP + "a" + SEP + "d"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"//server/a/b/../c/../d"));
        Assertions.assertEquals((Object)(SEP + SEP + "server" + SEP + "a" + SEP + "b" + SEP + "d"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"//server/a/b//d"));
        Assertions.assertEquals((Object)(SEP + SEP + "server" + SEP + "a" + SEP + "b"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"//server/a/b/././."));
        Assertions.assertEquals((Object)(SEP + SEP + "server" + SEP + "a"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"//server/./a"));
        Assertions.assertEquals((Object)(SEP + SEP + "server" + SEP + ""), (Object)FilenameUtils.normalizeNoEndSeparator((String)"//server/./"));
        Assertions.assertEquals((Object)(SEP + SEP + "server" + SEP + ""), (Object)FilenameUtils.normalizeNoEndSeparator((String)"//server/."));
        Assertions.assertEquals(null, (Object)FilenameUtils.normalizeNoEndSeparator((String)"//server/../a"));
        Assertions.assertEquals(null, (Object)FilenameUtils.normalizeNoEndSeparator((String)"//server/.."));
        Assertions.assertEquals((Object)(SEP + SEP + "server" + SEP + ""), (Object)FilenameUtils.normalizeNoEndSeparator((String)"//server/"));
    }

    @Test
    public void testNormalizeNoEndSeparatorUnixWin() throws Exception {
        Assertions.assertEquals((Object)"/a/c", (Object)FilenameUtils.normalizeNoEndSeparator((String)"/a/b/../c/", (boolean)true));
        Assertions.assertEquals((Object)"/a/c", (Object)FilenameUtils.normalizeNoEndSeparator((String)"\\a\\b\\..\\c\\", (boolean)true));
        Assertions.assertEquals((Object)"\\a\\c", (Object)FilenameUtils.normalizeNoEndSeparator((String)"/a/b/../c/", (boolean)false));
        Assertions.assertEquals((Object)"\\a\\c", (Object)FilenameUtils.normalizeNoEndSeparator((String)"\\a\\b\\..\\c\\", (boolean)false));
    }

    @Test
    public void testConcat() {
        Assertions.assertEquals(null, (Object)FilenameUtils.concat((String)"", null));
        Assertions.assertEquals(null, (Object)FilenameUtils.concat(null, null));
        Assertions.assertEquals(null, (Object)FilenameUtils.concat(null, (String)""));
        Assertions.assertEquals(null, (Object)FilenameUtils.concat(null, (String)"a"));
        Assertions.assertEquals((Object)(SEP + "a"), (Object)FilenameUtils.concat(null, (String)"/a"));
        Assertions.assertEquals(null, (Object)FilenameUtils.concat((String)"", (String)":"));
        Assertions.assertEquals(null, (Object)FilenameUtils.concat((String)":", (String)""));
        Assertions.assertEquals((Object)("f" + SEP), (Object)FilenameUtils.concat((String)"", (String)"f/"));
        Assertions.assertEquals((Object)"f", (Object)FilenameUtils.concat((String)"", (String)"f"));
        Assertions.assertEquals((Object)("a" + SEP + "f" + SEP), (Object)FilenameUtils.concat((String)"a/", (String)"f/"));
        Assertions.assertEquals((Object)("a" + SEP + "f"), (Object)FilenameUtils.concat((String)"a", (String)"f"));
        Assertions.assertEquals((Object)("a" + SEP + "b" + SEP + "f" + SEP), (Object)FilenameUtils.concat((String)"a/b/", (String)"f/"));
        Assertions.assertEquals((Object)("a" + SEP + "b" + SEP + "f"), (Object)FilenameUtils.concat((String)"a/b", (String)"f"));
        Assertions.assertEquals((Object)("a" + SEP + "f" + SEP), (Object)FilenameUtils.concat((String)"a/b/", (String)"../f/"));
        Assertions.assertEquals((Object)("a" + SEP + "f"), (Object)FilenameUtils.concat((String)"a/b", (String)"../f"));
        Assertions.assertEquals((Object)("a" + SEP + "c" + SEP + "g" + SEP), (Object)FilenameUtils.concat((String)"a/b/../c/", (String)"f/../g/"));
        Assertions.assertEquals((Object)("a" + SEP + "c" + SEP + "g"), (Object)FilenameUtils.concat((String)"a/b/../c", (String)"f/../g"));
        Assertions.assertEquals((Object)("a" + SEP + "c.txt" + SEP + "f"), (Object)FilenameUtils.concat((String)"a/c.txt", (String)"f"));
        Assertions.assertEquals((Object)(SEP + "f" + SEP), (Object)FilenameUtils.concat((String)"", (String)"/f/"));
        Assertions.assertEquals((Object)(SEP + "f"), (Object)FilenameUtils.concat((String)"", (String)"/f"));
        Assertions.assertEquals((Object)(SEP + "f" + SEP), (Object)FilenameUtils.concat((String)"a/", (String)"/f/"));
        Assertions.assertEquals((Object)(SEP + "f"), (Object)FilenameUtils.concat((String)"a", (String)"/f"));
        Assertions.assertEquals((Object)(SEP + "c" + SEP + "d"), (Object)FilenameUtils.concat((String)"a/b/", (String)"/c/d"));
        Assertions.assertEquals((Object)("C:c" + SEP + "d"), (Object)FilenameUtils.concat((String)"a/b/", (String)"C:c/d"));
        Assertions.assertEquals((Object)("C:" + SEP + "c" + SEP + "d"), (Object)FilenameUtils.concat((String)"a/b/", (String)"C:/c/d"));
        Assertions.assertEquals((Object)("~" + SEP + "c" + SEP + "d"), (Object)FilenameUtils.concat((String)"a/b/", (String)"~/c/d"));
        Assertions.assertEquals((Object)("~user" + SEP + "c" + SEP + "d"), (Object)FilenameUtils.concat((String)"a/b/", (String)"~user/c/d"));
        Assertions.assertEquals((Object)("~" + SEP), (Object)FilenameUtils.concat((String)"a/b/", (String)"~"));
        Assertions.assertEquals((Object)("~user" + SEP), (Object)FilenameUtils.concat((String)"a/b/", (String)"~user"));
    }

    @Test
    public void testSeparatorsToUnix() {
        Assertions.assertEquals(null, (Object)FilenameUtils.separatorsToUnix(null));
        Assertions.assertEquals((Object)"/a/b/c", (Object)FilenameUtils.separatorsToUnix((String)"/a/b/c"));
        Assertions.assertEquals((Object)"/a/b/c.txt", (Object)FilenameUtils.separatorsToUnix((String)"/a/b/c.txt"));
        Assertions.assertEquals((Object)"/a/b/c", (Object)FilenameUtils.separatorsToUnix((String)"/a/b\\c"));
        Assertions.assertEquals((Object)"/a/b/c", (Object)FilenameUtils.separatorsToUnix((String)"\\a\\b\\c"));
        Assertions.assertEquals((Object)"D:/a/b/c", (Object)FilenameUtils.separatorsToUnix((String)"D:\\a\\b\\c"));
    }

    @Test
    public void testSeparatorsToWindows() {
        Assertions.assertEquals(null, (Object)FilenameUtils.separatorsToWindows(null));
        Assertions.assertEquals((Object)"\\a\\b\\c", (Object)FilenameUtils.separatorsToWindows((String)"\\a\\b\\c"));
        Assertions.assertEquals((Object)"\\a\\b\\c.txt", (Object)FilenameUtils.separatorsToWindows((String)"\\a\\b\\c.txt"));
        Assertions.assertEquals((Object)"\\a\\b\\c", (Object)FilenameUtils.separatorsToWindows((String)"\\a\\b/c"));
        Assertions.assertEquals((Object)"\\a\\b\\c", (Object)FilenameUtils.separatorsToWindows((String)"/a/b/c"));
        Assertions.assertEquals((Object)"D:\\a\\b\\c", (Object)FilenameUtils.separatorsToWindows((String)"D:/a/b/c"));
    }

    @Test
    public void testSeparatorsToSystem() {
        if (WINDOWS) {
            Assertions.assertEquals(null, (Object)FilenameUtils.separatorsToSystem(null));
            Assertions.assertEquals((Object)"\\a\\b\\c", (Object)FilenameUtils.separatorsToSystem((String)"\\a\\b\\c"));
            Assertions.assertEquals((Object)"\\a\\b\\c.txt", (Object)FilenameUtils.separatorsToSystem((String)"\\a\\b\\c.txt"));
            Assertions.assertEquals((Object)"\\a\\b\\c", (Object)FilenameUtils.separatorsToSystem((String)"\\a\\b/c"));
            Assertions.assertEquals((Object)"\\a\\b\\c", (Object)FilenameUtils.separatorsToSystem((String)"/a/b/c"));
            Assertions.assertEquals((Object)"D:\\a\\b\\c", (Object)FilenameUtils.separatorsToSystem((String)"D:/a/b/c"));
        } else {
            Assertions.assertEquals(null, (Object)FilenameUtils.separatorsToSystem(null));
            Assertions.assertEquals((Object)"/a/b/c", (Object)FilenameUtils.separatorsToSystem((String)"/a/b/c"));
            Assertions.assertEquals((Object)"/a/b/c.txt", (Object)FilenameUtils.separatorsToSystem((String)"/a/b/c.txt"));
            Assertions.assertEquals((Object)"/a/b/c", (Object)FilenameUtils.separatorsToSystem((String)"/a/b\\c"));
            Assertions.assertEquals((Object)"/a/b/c", (Object)FilenameUtils.separatorsToSystem((String)"\\a\\b\\c"));
            Assertions.assertEquals((Object)"D:/a/b/c", (Object)FilenameUtils.separatorsToSystem((String)"D:\\a\\b\\c"));
        }
    }

    @Test
    public void testGetPrefixLength() {
        Assertions.assertEquals((int)-1, (int)FilenameUtils.getPrefixLength(null));
        Assertions.assertEquals((int)-1, (int)FilenameUtils.getPrefixLength((String)":"));
        Assertions.assertEquals((int)-1, (int)FilenameUtils.getPrefixLength((String)"1:\\a\\b\\c.txt"));
        Assertions.assertEquals((int)-1, (int)FilenameUtils.getPrefixLength((String)"1:"));
        Assertions.assertEquals((int)-1, (int)FilenameUtils.getPrefixLength((String)"1:a"));
        Assertions.assertEquals((int)-1, (int)FilenameUtils.getPrefixLength((String)"\\\\\\a\\b\\c.txt"));
        Assertions.assertEquals((int)-1, (int)FilenameUtils.getPrefixLength((String)"\\\\a"));
        Assertions.assertEquals((int)0, (int)FilenameUtils.getPrefixLength((String)""));
        Assertions.assertEquals((int)1, (int)FilenameUtils.getPrefixLength((String)"\\"));
        Assertions.assertEquals((int)2, (int)FilenameUtils.getPrefixLength((String)"C:"));
        Assertions.assertEquals((int)3, (int)FilenameUtils.getPrefixLength((String)"C:\\"));
        Assertions.assertEquals((int)9, (int)FilenameUtils.getPrefixLength((String)"//server/"));
        Assertions.assertEquals((int)2, (int)FilenameUtils.getPrefixLength((String)"~"));
        Assertions.assertEquals((int)2, (int)FilenameUtils.getPrefixLength((String)"~/"));
        Assertions.assertEquals((int)6, (int)FilenameUtils.getPrefixLength((String)"~user"));
        Assertions.assertEquals((int)6, (int)FilenameUtils.getPrefixLength((String)"~user/"));
        Assertions.assertEquals((int)0, (int)FilenameUtils.getPrefixLength((String)"a\\b\\c.txt"));
        Assertions.assertEquals((int)1, (int)FilenameUtils.getPrefixLength((String)"\\a\\b\\c.txt"));
        Assertions.assertEquals((int)2, (int)FilenameUtils.getPrefixLength((String)"C:a\\b\\c.txt"));
        Assertions.assertEquals((int)3, (int)FilenameUtils.getPrefixLength((String)"C:\\a\\b\\c.txt"));
        Assertions.assertEquals((int)9, (int)FilenameUtils.getPrefixLength((String)"\\\\server\\a\\b\\c.txt"));
        Assertions.assertEquals((int)0, (int)FilenameUtils.getPrefixLength((String)"a/b/c.txt"));
        Assertions.assertEquals((int)1, (int)FilenameUtils.getPrefixLength((String)"/a/b/c.txt"));
        Assertions.assertEquals((int)3, (int)FilenameUtils.getPrefixLength((String)"C:/a/b/c.txt"));
        Assertions.assertEquals((int)9, (int)FilenameUtils.getPrefixLength((String)"//server/a/b/c.txt"));
        Assertions.assertEquals((int)2, (int)FilenameUtils.getPrefixLength((String)"~/a/b/c.txt"));
        Assertions.assertEquals((int)6, (int)FilenameUtils.getPrefixLength((String)"~user/a/b/c.txt"));
        Assertions.assertEquals((int)0, (int)FilenameUtils.getPrefixLength((String)"a\\b\\c.txt"));
        Assertions.assertEquals((int)1, (int)FilenameUtils.getPrefixLength((String)"\\a\\b\\c.txt"));
        Assertions.assertEquals((int)2, (int)FilenameUtils.getPrefixLength((String)"~\\a\\b\\c.txt"));
        Assertions.assertEquals((int)6, (int)FilenameUtils.getPrefixLength((String)"~user\\a\\b\\c.txt"));
        Assertions.assertEquals((int)9, (int)FilenameUtils.getPrefixLength((String)"//server/a/b/c.txt"));
        Assertions.assertEquals((int)-1, (int)FilenameUtils.getPrefixLength((String)"\\\\\\a\\b\\c.txt"));
        Assertions.assertEquals((int)-1, (int)FilenameUtils.getPrefixLength((String)"///a/b/c.txt"));
        Assertions.assertEquals((int)1, (int)FilenameUtils.getPrefixLength((String)"/:foo"));
        Assertions.assertEquals((int)1, (int)FilenameUtils.getPrefixLength((String)"/:/"));
        Assertions.assertEquals((int)1, (int)FilenameUtils.getPrefixLength((String)"/:::::::.txt"));
        Assertions.assertEquals((int)12, (int)FilenameUtils.getPrefixLength((String)"\\\\127.0.0.1\\a\\b\\c.txt"));
        Assertions.assertEquals((int)6, (int)FilenameUtils.getPrefixLength((String)"\\\\::1\\a\\b\\c.txt"));
        Assertions.assertEquals((int)21, (int)FilenameUtils.getPrefixLength((String)"\\\\server.example.org\\a\\b\\c.txt"));
        Assertions.assertEquals((int)10, (int)FilenameUtils.getPrefixLength((String)"\\\\server.\\a\\b\\c.txt"));
        Assertions.assertEquals((int)-1, (int)FilenameUtils.getPrefixLength((String)"\\\\-server\\a\\b\\c.txt"));
        Assertions.assertEquals((int)-1, (int)FilenameUtils.getPrefixLength((String)"\\\\.\\a\\b\\c.txt"));
        Assertions.assertEquals((int)-1, (int)FilenameUtils.getPrefixLength((String)"\\\\..\\a\\b\\c.txt"));
    }

    @Test
    public void testIndexOfLastSeparator() {
        Assertions.assertEquals((int)-1, (int)FilenameUtils.indexOfLastSeparator(null));
        Assertions.assertEquals((int)-1, (int)FilenameUtils.indexOfLastSeparator((String)"noseperator.inthispath"));
        Assertions.assertEquals((int)3, (int)FilenameUtils.indexOfLastSeparator((String)"a/b/c"));
        Assertions.assertEquals((int)3, (int)FilenameUtils.indexOfLastSeparator((String)"a\\b\\c"));
    }

    @Test
    public void testIndexOfExtension() {
        Assertions.assertEquals((int)-1, (int)FilenameUtils.indexOfExtension(null));
        Assertions.assertEquals((int)-1, (int)FilenameUtils.indexOfExtension((String)"file"));
        Assertions.assertEquals((int)4, (int)FilenameUtils.indexOfExtension((String)"file.txt"));
        Assertions.assertEquals((int)13, (int)FilenameUtils.indexOfExtension((String)"a.txt/b.txt/c.txt"));
        Assertions.assertEquals((int)-1, (int)FilenameUtils.indexOfExtension((String)"a/b/c"));
        Assertions.assertEquals((int)-1, (int)FilenameUtils.indexOfExtension((String)"a\\b\\c"));
        Assertions.assertEquals((int)-1, (int)FilenameUtils.indexOfExtension((String)"a/b.notextension/c"));
        Assertions.assertEquals((int)-1, (int)FilenameUtils.indexOfExtension((String)"a\\b.notextension\\c"));
        if (FilenameUtils.isSystemWindows()) {
            try {
                FilenameUtils.indexOfExtension((String)"foo.exe:bar.txt");
                throw new AssertionError((Object)"Expected Exception");
            }
            catch (IllegalArgumentException e) {
                Assertions.assertEquals((Object)"NTFS ADS separator (':') in file name is forbidden.", (Object)e.getMessage());
            }
        } else {
            Assertions.assertEquals((int)11, (int)FilenameUtils.indexOfExtension((String)"foo.exe:bar.txt"));
        }
    }

    @Test
    public void testGetPrefix() {
        Assertions.assertEquals(null, (Object)FilenameUtils.getPrefix(null));
        Assertions.assertEquals(null, (Object)FilenameUtils.getPrefix((String)":"));
        Assertions.assertEquals(null, (Object)FilenameUtils.getPrefix((String)"1:\\a\\b\\c.txt"));
        Assertions.assertEquals(null, (Object)FilenameUtils.getPrefix((String)"1:"));
        Assertions.assertEquals(null, (Object)FilenameUtils.getPrefix((String)"1:a"));
        Assertions.assertEquals(null, (Object)FilenameUtils.getPrefix((String)"\\\\\\a\\b\\c.txt"));
        Assertions.assertEquals(null, (Object)FilenameUtils.getPrefix((String)"\\\\a"));
        Assertions.assertEquals((Object)"", (Object)FilenameUtils.getPrefix((String)""));
        Assertions.assertEquals((Object)"\\", (Object)FilenameUtils.getPrefix((String)"\\"));
        Assertions.assertEquals((Object)"C:", (Object)FilenameUtils.getPrefix((String)"C:"));
        Assertions.assertEquals((Object)"C:\\", (Object)FilenameUtils.getPrefix((String)"C:\\"));
        Assertions.assertEquals((Object)"//server/", (Object)FilenameUtils.getPrefix((String)"//server/"));
        Assertions.assertEquals((Object)"~/", (Object)FilenameUtils.getPrefix((String)"~"));
        Assertions.assertEquals((Object)"~/", (Object)FilenameUtils.getPrefix((String)"~/"));
        Assertions.assertEquals((Object)"~user/", (Object)FilenameUtils.getPrefix((String)"~user"));
        Assertions.assertEquals((Object)"~user/", (Object)FilenameUtils.getPrefix((String)"~user/"));
        Assertions.assertEquals((Object)"", (Object)FilenameUtils.getPrefix((String)"a\\b\\c.txt"));
        Assertions.assertEquals((Object)"\\", (Object)FilenameUtils.getPrefix((String)"\\a\\b\\c.txt"));
        Assertions.assertEquals((Object)"C:\\", (Object)FilenameUtils.getPrefix((String)"C:\\a\\b\\c.txt"));
        Assertions.assertEquals((Object)"\\\\server\\", (Object)FilenameUtils.getPrefix((String)"\\\\server\\a\\b\\c.txt"));
        Assertions.assertEquals((Object)"", (Object)FilenameUtils.getPrefix((String)"a/b/c.txt"));
        Assertions.assertEquals((Object)"/", (Object)FilenameUtils.getPrefix((String)"/a/b/c.txt"));
        Assertions.assertEquals((Object)"C:/", (Object)FilenameUtils.getPrefix((String)"C:/a/b/c.txt"));
        Assertions.assertEquals((Object)"//server/", (Object)FilenameUtils.getPrefix((String)"//server/a/b/c.txt"));
        Assertions.assertEquals((Object)"~/", (Object)FilenameUtils.getPrefix((String)"~/a/b/c.txt"));
        Assertions.assertEquals((Object)"~user/", (Object)FilenameUtils.getPrefix((String)"~user/a/b/c.txt"));
        Assertions.assertEquals((Object)"", (Object)FilenameUtils.getPrefix((String)"a\\b\\c.txt"));
        Assertions.assertEquals((Object)"\\", (Object)FilenameUtils.getPrefix((String)"\\a\\b\\c.txt"));
        Assertions.assertEquals((Object)"~\\", (Object)FilenameUtils.getPrefix((String)"~\\a\\b\\c.txt"));
        Assertions.assertEquals((Object)"~user\\", (Object)FilenameUtils.getPrefix((String)"~user\\a\\b\\c.txt"));
    }

    @Test
    public void testGetPrefix_with_nullbyte() {
        try {
            Assertions.assertEquals((Object)"~user\\", (Object)FilenameUtils.getPrefix((String)"~u\u0000ser\\a\\b\\c.txt"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testGetPath() {
        Assertions.assertEquals(null, (Object)FilenameUtils.getPath(null));
        Assertions.assertEquals((Object)"", (Object)FilenameUtils.getPath((String)"noseperator.inthispath"));
        Assertions.assertEquals((Object)"", (Object)FilenameUtils.getPath((String)"/noseperator.inthispath"));
        Assertions.assertEquals((Object)"", (Object)FilenameUtils.getPath((String)"\\noseperator.inthispath"));
        Assertions.assertEquals((Object)"a/b/", (Object)FilenameUtils.getPath((String)"a/b/c.txt"));
        Assertions.assertEquals((Object)"a/b/", (Object)FilenameUtils.getPath((String)"a/b/c"));
        Assertions.assertEquals((Object)"a/b/c/", (Object)FilenameUtils.getPath((String)"a/b/c/"));
        Assertions.assertEquals((Object)"a\\b\\", (Object)FilenameUtils.getPath((String)"a\\b\\c"));
        Assertions.assertEquals(null, (Object)FilenameUtils.getPath((String)":"));
        Assertions.assertEquals(null, (Object)FilenameUtils.getPath((String)"1:/a/b/c.txt"));
        Assertions.assertEquals(null, (Object)FilenameUtils.getPath((String)"1:"));
        Assertions.assertEquals(null, (Object)FilenameUtils.getPath((String)"1:a"));
        Assertions.assertEquals(null, (Object)FilenameUtils.getPath((String)"///a/b/c.txt"));
        Assertions.assertEquals(null, (Object)FilenameUtils.getPath((String)"//a"));
        Assertions.assertEquals((Object)"", (Object)FilenameUtils.getPath((String)""));
        Assertions.assertEquals((Object)"", (Object)FilenameUtils.getPath((String)"C:"));
        Assertions.assertEquals((Object)"", (Object)FilenameUtils.getPath((String)"C:/"));
        Assertions.assertEquals((Object)"", (Object)FilenameUtils.getPath((String)"//server/"));
        Assertions.assertEquals((Object)"", (Object)FilenameUtils.getPath((String)"~"));
        Assertions.assertEquals((Object)"", (Object)FilenameUtils.getPath((String)"~/"));
        Assertions.assertEquals((Object)"", (Object)FilenameUtils.getPath((String)"~user"));
        Assertions.assertEquals((Object)"", (Object)FilenameUtils.getPath((String)"~user/"));
        Assertions.assertEquals((Object)"a/b/", (Object)FilenameUtils.getPath((String)"a/b/c.txt"));
        Assertions.assertEquals((Object)"a/b/", (Object)FilenameUtils.getPath((String)"/a/b/c.txt"));
        Assertions.assertEquals((Object)"", (Object)FilenameUtils.getPath((String)"C:a"));
        Assertions.assertEquals((Object)"a/b/", (Object)FilenameUtils.getPath((String)"C:a/b/c.txt"));
        Assertions.assertEquals((Object)"a/b/", (Object)FilenameUtils.getPath((String)"C:/a/b/c.txt"));
        Assertions.assertEquals((Object)"a/b/", (Object)FilenameUtils.getPath((String)"//server/a/b/c.txt"));
        Assertions.assertEquals((Object)"a/b/", (Object)FilenameUtils.getPath((String)"~/a/b/c.txt"));
        Assertions.assertEquals((Object)"a/b/", (Object)FilenameUtils.getPath((String)"~user/a/b/c.txt"));
    }

    @Test
    public void testGetPath_with_nullbyte() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> FilenameUtils.getPath((String)"~user/a/\u0000b/c.txt"));
    }

    @Test
    public void testGetPathNoEndSeparator() {
        Assertions.assertEquals(null, (Object)FilenameUtils.getPath(null));
        Assertions.assertEquals((Object)"", (Object)FilenameUtils.getPath((String)"noseperator.inthispath"));
        Assertions.assertEquals((Object)"", (Object)FilenameUtils.getPathNoEndSeparator((String)"/noseperator.inthispath"));
        Assertions.assertEquals((Object)"", (Object)FilenameUtils.getPathNoEndSeparator((String)"\\noseperator.inthispath"));
        Assertions.assertEquals((Object)"a/b", (Object)FilenameUtils.getPathNoEndSeparator((String)"a/b/c.txt"));
        Assertions.assertEquals((Object)"a/b", (Object)FilenameUtils.getPathNoEndSeparator((String)"a/b/c"));
        Assertions.assertEquals((Object)"a/b/c", (Object)FilenameUtils.getPathNoEndSeparator((String)"a/b/c/"));
        Assertions.assertEquals((Object)"a\\b", (Object)FilenameUtils.getPathNoEndSeparator((String)"a\\b\\c"));
        Assertions.assertEquals(null, (Object)FilenameUtils.getPathNoEndSeparator((String)":"));
        Assertions.assertEquals(null, (Object)FilenameUtils.getPathNoEndSeparator((String)"1:/a/b/c.txt"));
        Assertions.assertEquals(null, (Object)FilenameUtils.getPathNoEndSeparator((String)"1:"));
        Assertions.assertEquals(null, (Object)FilenameUtils.getPathNoEndSeparator((String)"1:a"));
        Assertions.assertEquals(null, (Object)FilenameUtils.getPathNoEndSeparator((String)"///a/b/c.txt"));
        Assertions.assertEquals(null, (Object)FilenameUtils.getPathNoEndSeparator((String)"//a"));
        Assertions.assertEquals((Object)"", (Object)FilenameUtils.getPathNoEndSeparator((String)""));
        Assertions.assertEquals((Object)"", (Object)FilenameUtils.getPathNoEndSeparator((String)"C:"));
        Assertions.assertEquals((Object)"", (Object)FilenameUtils.getPathNoEndSeparator((String)"C:/"));
        Assertions.assertEquals((Object)"", (Object)FilenameUtils.getPathNoEndSeparator((String)"//server/"));
        Assertions.assertEquals((Object)"", (Object)FilenameUtils.getPathNoEndSeparator((String)"~"));
        Assertions.assertEquals((Object)"", (Object)FilenameUtils.getPathNoEndSeparator((String)"~/"));
        Assertions.assertEquals((Object)"", (Object)FilenameUtils.getPathNoEndSeparator((String)"~user"));
        Assertions.assertEquals((Object)"", (Object)FilenameUtils.getPathNoEndSeparator((String)"~user/"));
        Assertions.assertEquals((Object)"a/b", (Object)FilenameUtils.getPathNoEndSeparator((String)"a/b/c.txt"));
        Assertions.assertEquals((Object)"a/b", (Object)FilenameUtils.getPathNoEndSeparator((String)"/a/b/c.txt"));
        Assertions.assertEquals((Object)"", (Object)FilenameUtils.getPathNoEndSeparator((String)"C:a"));
        Assertions.assertEquals((Object)"a/b", (Object)FilenameUtils.getPathNoEndSeparator((String)"C:a/b/c.txt"));
        Assertions.assertEquals((Object)"a/b", (Object)FilenameUtils.getPathNoEndSeparator((String)"C:/a/b/c.txt"));
        Assertions.assertEquals((Object)"a/b", (Object)FilenameUtils.getPathNoEndSeparator((String)"//server/a/b/c.txt"));
        Assertions.assertEquals((Object)"a/b", (Object)FilenameUtils.getPathNoEndSeparator((String)"~/a/b/c.txt"));
        Assertions.assertEquals((Object)"a/b", (Object)FilenameUtils.getPathNoEndSeparator((String)"~user/a/b/c.txt"));
    }

    @Test
    public void testGetPathNoEndSeparator_with_null_byte() {
        try {
            Assertions.assertEquals((Object)"a/b", (Object)FilenameUtils.getPathNoEndSeparator((String)"~user/a\u0000/b/c.txt"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testGetFullPath() {
        Assertions.assertEquals(null, (Object)FilenameUtils.getFullPath(null));
        Assertions.assertEquals((Object)"", (Object)FilenameUtils.getFullPath((String)"noseperator.inthispath"));
        Assertions.assertEquals((Object)"a/b/", (Object)FilenameUtils.getFullPath((String)"a/b/c.txt"));
        Assertions.assertEquals((Object)"a/b/", (Object)FilenameUtils.getFullPath((String)"a/b/c"));
        Assertions.assertEquals((Object)"a/b/c/", (Object)FilenameUtils.getFullPath((String)"a/b/c/"));
        Assertions.assertEquals((Object)"a\\b\\", (Object)FilenameUtils.getFullPath((String)"a\\b\\c"));
        Assertions.assertEquals(null, (Object)FilenameUtils.getFullPath((String)":"));
        Assertions.assertEquals(null, (Object)FilenameUtils.getFullPath((String)"1:/a/b/c.txt"));
        Assertions.assertEquals(null, (Object)FilenameUtils.getFullPath((String)"1:"));
        Assertions.assertEquals(null, (Object)FilenameUtils.getFullPath((String)"1:a"));
        Assertions.assertEquals(null, (Object)FilenameUtils.getFullPath((String)"///a/b/c.txt"));
        Assertions.assertEquals(null, (Object)FilenameUtils.getFullPath((String)"//a"));
        Assertions.assertEquals((Object)"", (Object)FilenameUtils.getFullPath((String)""));
        Assertions.assertEquals((Object)"C:", (Object)FilenameUtils.getFullPath((String)"C:"));
        Assertions.assertEquals((Object)"C:/", (Object)FilenameUtils.getFullPath((String)"C:/"));
        Assertions.assertEquals((Object)"//server/", (Object)FilenameUtils.getFullPath((String)"//server/"));
        Assertions.assertEquals((Object)"~/", (Object)FilenameUtils.getFullPath((String)"~"));
        Assertions.assertEquals((Object)"~/", (Object)FilenameUtils.getFullPath((String)"~/"));
        Assertions.assertEquals((Object)"~user/", (Object)FilenameUtils.getFullPath((String)"~user"));
        Assertions.assertEquals((Object)"~user/", (Object)FilenameUtils.getFullPath((String)"~user/"));
        Assertions.assertEquals((Object)"a/b/", (Object)FilenameUtils.getFullPath((String)"a/b/c.txt"));
        Assertions.assertEquals((Object)"/a/b/", (Object)FilenameUtils.getFullPath((String)"/a/b/c.txt"));
        Assertions.assertEquals((Object)"C:", (Object)FilenameUtils.getFullPath((String)"C:a"));
        Assertions.assertEquals((Object)"C:a/b/", (Object)FilenameUtils.getFullPath((String)"C:a/b/c.txt"));
        Assertions.assertEquals((Object)"C:/a/b/", (Object)FilenameUtils.getFullPath((String)"C:/a/b/c.txt"));
        Assertions.assertEquals((Object)"//server/a/b/", (Object)FilenameUtils.getFullPath((String)"//server/a/b/c.txt"));
        Assertions.assertEquals((Object)"~/a/b/", (Object)FilenameUtils.getFullPath((String)"~/a/b/c.txt"));
        Assertions.assertEquals((Object)"~user/a/b/", (Object)FilenameUtils.getFullPath((String)"~user/a/b/c.txt"));
    }

    @Test
    public void testGetFullPathNoEndSeparator() {
        Assertions.assertEquals(null, (Object)FilenameUtils.getFullPathNoEndSeparator(null));
        Assertions.assertEquals((Object)"", (Object)FilenameUtils.getFullPathNoEndSeparator((String)"noseperator.inthispath"));
        Assertions.assertEquals((Object)"a/b", (Object)FilenameUtils.getFullPathNoEndSeparator((String)"a/b/c.txt"));
        Assertions.assertEquals((Object)"a/b", (Object)FilenameUtils.getFullPathNoEndSeparator((String)"a/b/c"));
        Assertions.assertEquals((Object)"a/b/c", (Object)FilenameUtils.getFullPathNoEndSeparator((String)"a/b/c/"));
        Assertions.assertEquals((Object)"a\\b", (Object)FilenameUtils.getFullPathNoEndSeparator((String)"a\\b\\c"));
        Assertions.assertEquals(null, (Object)FilenameUtils.getFullPathNoEndSeparator((String)":"));
        Assertions.assertEquals(null, (Object)FilenameUtils.getFullPathNoEndSeparator((String)"1:/a/b/c.txt"));
        Assertions.assertEquals(null, (Object)FilenameUtils.getFullPathNoEndSeparator((String)"1:"));
        Assertions.assertEquals(null, (Object)FilenameUtils.getFullPathNoEndSeparator((String)"1:a"));
        Assertions.assertEquals(null, (Object)FilenameUtils.getFullPathNoEndSeparator((String)"///a/b/c.txt"));
        Assertions.assertEquals(null, (Object)FilenameUtils.getFullPathNoEndSeparator((String)"//a"));
        Assertions.assertEquals((Object)"", (Object)FilenameUtils.getFullPathNoEndSeparator((String)""));
        Assertions.assertEquals((Object)"C:", (Object)FilenameUtils.getFullPathNoEndSeparator((String)"C:"));
        Assertions.assertEquals((Object)"C:/", (Object)FilenameUtils.getFullPathNoEndSeparator((String)"C:/"));
        Assertions.assertEquals((Object)"//server/", (Object)FilenameUtils.getFullPathNoEndSeparator((String)"//server/"));
        Assertions.assertEquals((Object)"~", (Object)FilenameUtils.getFullPathNoEndSeparator((String)"~"));
        Assertions.assertEquals((Object)"~/", (Object)FilenameUtils.getFullPathNoEndSeparator((String)"~/"));
        Assertions.assertEquals((Object)"~user", (Object)FilenameUtils.getFullPathNoEndSeparator((String)"~user"));
        Assertions.assertEquals((Object)"~user/", (Object)FilenameUtils.getFullPathNoEndSeparator((String)"~user/"));
        Assertions.assertEquals((Object)"a/b", (Object)FilenameUtils.getFullPathNoEndSeparator((String)"a/b/c.txt"));
        Assertions.assertEquals((Object)"/a/b", (Object)FilenameUtils.getFullPathNoEndSeparator((String)"/a/b/c.txt"));
        Assertions.assertEquals((Object)"C:", (Object)FilenameUtils.getFullPathNoEndSeparator((String)"C:a"));
        Assertions.assertEquals((Object)"C:a/b", (Object)FilenameUtils.getFullPathNoEndSeparator((String)"C:a/b/c.txt"));
        Assertions.assertEquals((Object)"C:/a/b", (Object)FilenameUtils.getFullPathNoEndSeparator((String)"C:/a/b/c.txt"));
        Assertions.assertEquals((Object)"//server/a/b", (Object)FilenameUtils.getFullPathNoEndSeparator((String)"//server/a/b/c.txt"));
        Assertions.assertEquals((Object)"~/a/b", (Object)FilenameUtils.getFullPathNoEndSeparator((String)"~/a/b/c.txt"));
        Assertions.assertEquals((Object)"~user/a/b", (Object)FilenameUtils.getFullPathNoEndSeparator((String)"~user/a/b/c.txt"));
    }

    @Test
    public void testGetFullPathNoEndSeparator_IO_248() {
        Assertions.assertEquals((Object)"/", (Object)FilenameUtils.getFullPathNoEndSeparator((String)"/"));
        Assertions.assertEquals((Object)"\\", (Object)FilenameUtils.getFullPathNoEndSeparator((String)"\\"));
        Assertions.assertEquals((Object)"/", (Object)FilenameUtils.getFullPathNoEndSeparator((String)"/abc"));
        Assertions.assertEquals((Object)"\\", (Object)FilenameUtils.getFullPathNoEndSeparator((String)"\\abc"));
        Assertions.assertEquals((Object)"/abc", (Object)FilenameUtils.getFullPathNoEndSeparator((String)"/abc/xyz"));
        Assertions.assertEquals((Object)"\\abc", (Object)FilenameUtils.getFullPathNoEndSeparator((String)"\\abc\\xyz"));
    }

    @Test
    public void testGetName() {
        Assertions.assertEquals(null, (Object)FilenameUtils.getName(null));
        Assertions.assertEquals((Object)"noseperator.inthispath", (Object)FilenameUtils.getName((String)"noseperator.inthispath"));
        Assertions.assertEquals((Object)"c.txt", (Object)FilenameUtils.getName((String)"a/b/c.txt"));
        Assertions.assertEquals((Object)"c", (Object)FilenameUtils.getName((String)"a/b/c"));
        Assertions.assertEquals((Object)"", (Object)FilenameUtils.getName((String)"a/b/c/"));
        Assertions.assertEquals((Object)"c", (Object)FilenameUtils.getName((String)"a\\b\\c"));
    }

    @Test
    public void testInjectionFailure() {
        try {
            Assertions.assertEquals((Object)"c", (Object)FilenameUtils.getName((String)"a\\b\\\u0000c"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testGetBaseName() {
        Assertions.assertEquals(null, (Object)FilenameUtils.getBaseName(null));
        Assertions.assertEquals((Object)"noseperator", (Object)FilenameUtils.getBaseName((String)"noseperator.inthispath"));
        Assertions.assertEquals((Object)"c", (Object)FilenameUtils.getBaseName((String)"a/b/c.txt"));
        Assertions.assertEquals((Object)"c", (Object)FilenameUtils.getBaseName((String)"a/b/c"));
        Assertions.assertEquals((Object)"", (Object)FilenameUtils.getBaseName((String)"a/b/c/"));
        Assertions.assertEquals((Object)"c", (Object)FilenameUtils.getBaseName((String)"a\\b\\c"));
        Assertions.assertEquals((Object)"file.txt", (Object)FilenameUtils.getBaseName((String)"file.txt.bak"));
    }

    @Test
    public void testGetBaseName_with_nullByte() {
        try {
            Assertions.assertEquals((Object)"file.txt", (Object)FilenameUtils.getBaseName((String)"fil\u0000e.txt.bak"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testGetExtension() {
        Assertions.assertEquals(null, (Object)FilenameUtils.getExtension(null));
        Assertions.assertEquals((Object)"ext", (Object)FilenameUtils.getExtension((String)"file.ext"));
        Assertions.assertEquals((Object)"", (Object)FilenameUtils.getExtension((String)"README"));
        Assertions.assertEquals((Object)"com", (Object)FilenameUtils.getExtension((String)"domain.dot.com"));
        Assertions.assertEquals((Object)"jpeg", (Object)FilenameUtils.getExtension((String)"image.jpeg"));
        Assertions.assertEquals((Object)"", (Object)FilenameUtils.getExtension((String)"a.b/c"));
        Assertions.assertEquals((Object)"txt", (Object)FilenameUtils.getExtension((String)"a.b/c.txt"));
        Assertions.assertEquals((Object)"", (Object)FilenameUtils.getExtension((String)"a/b/c"));
        Assertions.assertEquals((Object)"", (Object)FilenameUtils.getExtension((String)"a.b\\c"));
        Assertions.assertEquals((Object)"txt", (Object)FilenameUtils.getExtension((String)"a.b\\c.txt"));
        Assertions.assertEquals((Object)"", (Object)FilenameUtils.getExtension((String)"a\\b\\c"));
        Assertions.assertEquals((Object)"", (Object)FilenameUtils.getExtension((String)"C:\\temp\\foo.bar\\README"));
        Assertions.assertEquals((Object)"ext", (Object)FilenameUtils.getExtension((String)"../filename.ext"));
        if (FilenameUtils.isSystemWindows()) {
            try {
                FilenameUtils.getExtension((String)"foo.exe:bar.txt");
                throw new AssertionError((Object)"Expected Exception");
            }
            catch (IllegalArgumentException e) {
                Assertions.assertEquals((Object)"NTFS ADS separator (':') in file name is forbidden.", (Object)e.getMessage());
            }
        } else {
            Assertions.assertEquals((Object)"txt", (Object)FilenameUtils.getExtension((String)"foo.exe:bar.txt"));
        }
    }

    @Test
    public void testRemoveExtension() {
        Assertions.assertEquals(null, (Object)FilenameUtils.removeExtension(null));
        Assertions.assertEquals((Object)"file", (Object)FilenameUtils.removeExtension((String)"file.ext"));
        Assertions.assertEquals((Object)"README", (Object)FilenameUtils.removeExtension((String)"README"));
        Assertions.assertEquals((Object)"domain.dot", (Object)FilenameUtils.removeExtension((String)"domain.dot.com"));
        Assertions.assertEquals((Object)"image", (Object)FilenameUtils.removeExtension((String)"image.jpeg"));
        Assertions.assertEquals((Object)"a.b/c", (Object)FilenameUtils.removeExtension((String)"a.b/c"));
        Assertions.assertEquals((Object)"a.b/c", (Object)FilenameUtils.removeExtension((String)"a.b/c.txt"));
        Assertions.assertEquals((Object)"a/b/c", (Object)FilenameUtils.removeExtension((String)"a/b/c"));
        Assertions.assertEquals((Object)"a.b\\c", (Object)FilenameUtils.removeExtension((String)"a.b\\c"));
        Assertions.assertEquals((Object)"a.b\\c", (Object)FilenameUtils.removeExtension((String)"a.b\\c.txt"));
        Assertions.assertEquals((Object)"a\\b\\c", (Object)FilenameUtils.removeExtension((String)"a\\b\\c"));
        Assertions.assertEquals((Object)"C:\\temp\\foo.bar\\README", (Object)FilenameUtils.removeExtension((String)"C:\\temp\\foo.bar\\README"));
        Assertions.assertEquals((Object)"../filename", (Object)FilenameUtils.removeExtension((String)"../filename.ext"));
    }

    @Test
    public void testEquals() {
        Assertions.assertTrue((boolean)FilenameUtils.equals(null, null));
        Assertions.assertFalse((boolean)FilenameUtils.equals(null, (String)""));
        Assertions.assertFalse((boolean)FilenameUtils.equals((String)"", null));
        Assertions.assertTrue((boolean)FilenameUtils.equals((String)"", (String)""));
        Assertions.assertTrue((boolean)FilenameUtils.equals((String)"file.txt", (String)"file.txt"));
        Assertions.assertFalse((boolean)FilenameUtils.equals((String)"file.txt", (String)"FILE.TXT"));
        Assertions.assertFalse((boolean)FilenameUtils.equals((String)"a\\b\\file.txt", (String)"a/b/file.txt"));
    }

    @Test
    public void testEqualsOnSystem() {
        Assertions.assertTrue((boolean)FilenameUtils.equalsOnSystem(null, null));
        Assertions.assertFalse((boolean)FilenameUtils.equalsOnSystem(null, (String)""));
        Assertions.assertFalse((boolean)FilenameUtils.equalsOnSystem((String)"", null));
        Assertions.assertTrue((boolean)FilenameUtils.equalsOnSystem((String)"", (String)""));
        Assertions.assertTrue((boolean)FilenameUtils.equalsOnSystem((String)"file.txt", (String)"file.txt"));
        Assertions.assertEquals((Object)WINDOWS, (Object)FilenameUtils.equalsOnSystem((String)"file.txt", (String)"FILE.TXT"));
        Assertions.assertFalse((boolean)FilenameUtils.equalsOnSystem((String)"a\\b\\file.txt", (String)"a/b/file.txt"));
    }

    @Test
    public void testEqualsNormalized() {
        Assertions.assertTrue((boolean)FilenameUtils.equalsNormalized(null, null));
        Assertions.assertFalse((boolean)FilenameUtils.equalsNormalized(null, (String)""));
        Assertions.assertFalse((boolean)FilenameUtils.equalsNormalized((String)"", null));
        Assertions.assertTrue((boolean)FilenameUtils.equalsNormalized((String)"", (String)""));
        Assertions.assertTrue((boolean)FilenameUtils.equalsNormalized((String)"file.txt", (String)"file.txt"));
        Assertions.assertFalse((boolean)FilenameUtils.equalsNormalized((String)"file.txt", (String)"FILE.TXT"));
        Assertions.assertTrue((boolean)FilenameUtils.equalsNormalized((String)"a\\b\\file.txt", (String)"a/b/file.txt"));
        Assertions.assertFalse((boolean)FilenameUtils.equalsNormalized((String)"a/b/", (String)"a/b"));
    }

    @Test
    public void testEqualsNormalizedOnSystem() {
        Assertions.assertTrue((boolean)FilenameUtils.equalsNormalizedOnSystem(null, null));
        Assertions.assertFalse((boolean)FilenameUtils.equalsNormalizedOnSystem(null, (String)""));
        Assertions.assertFalse((boolean)FilenameUtils.equalsNormalizedOnSystem((String)"", null));
        Assertions.assertTrue((boolean)FilenameUtils.equalsNormalizedOnSystem((String)"", (String)""));
        Assertions.assertTrue((boolean)FilenameUtils.equalsNormalizedOnSystem((String)"file.txt", (String)"file.txt"));
        Assertions.assertEquals((Object)WINDOWS, (Object)FilenameUtils.equalsNormalizedOnSystem((String)"file.txt", (String)"FILE.TXT"));
        Assertions.assertTrue((boolean)FilenameUtils.equalsNormalizedOnSystem((String)"a\\b\\file.txt", (String)"a/b/file.txt"));
        Assertions.assertFalse((boolean)FilenameUtils.equalsNormalizedOnSystem((String)"a/b/", (String)"a/b"));
    }

    @Test
    public void testEqualsNormalizedError_IO_128() {
        try {
            FilenameUtils.equalsNormalizedOnSystem((String)"//file.txt", (String)"file.txt");
            Assertions.fail((String)"Invalid normalized first file");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            FilenameUtils.equalsNormalizedOnSystem((String)"file.txt", (String)"//file.txt");
            Assertions.fail((String)"Invalid normalized second file");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            FilenameUtils.equalsNormalizedOnSystem((String)"//file.txt", (String)"//file.txt");
            Assertions.fail((String)"Invalid normalized both filse");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testEquals_fullControl() {
        Assertions.assertFalse((boolean)FilenameUtils.equals((String)"file.txt", (String)"FILE.TXT", (boolean)true, (IOCase)IOCase.SENSITIVE));
        Assertions.assertTrue((boolean)FilenameUtils.equals((String)"file.txt", (String)"FILE.TXT", (boolean)true, (IOCase)IOCase.INSENSITIVE));
        Assertions.assertEquals((Object)WINDOWS, (Object)FilenameUtils.equals((String)"file.txt", (String)"FILE.TXT", (boolean)true, (IOCase)IOCase.SYSTEM));
        Assertions.assertFalse((boolean)FilenameUtils.equals((String)"file.txt", (String)"FILE.TXT", (boolean)true, null));
    }

    @Test
    public void testIsExtension() {
        Assertions.assertFalse((boolean)FilenameUtils.isExtension(null, (String)null));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension((String)"file.txt", (String)null));
        Assertions.assertTrue((boolean)FilenameUtils.isExtension((String)"file", (String)null));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension((String)"file.txt", (String)""));
        Assertions.assertTrue((boolean)FilenameUtils.isExtension((String)"file", (String)""));
        Assertions.assertTrue((boolean)FilenameUtils.isExtension((String)"file.txt", (String)"txt"));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension((String)"file.txt", (String)"rtf"));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension((String)"a/b/file.txt", (String)null));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension((String)"a/b/file.txt", (String)""));
        Assertions.assertTrue((boolean)FilenameUtils.isExtension((String)"a/b/file.txt", (String)"txt"));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension((String)"a/b/file.txt", (String)"rtf"));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension((String)"a.b/file.txt", (String)null));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension((String)"a.b/file.txt", (String)""));
        Assertions.assertTrue((boolean)FilenameUtils.isExtension((String)"a.b/file.txt", (String)"txt"));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension((String)"a.b/file.txt", (String)"rtf"));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension((String)"a\\b\\file.txt", (String)null));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension((String)"a\\b\\file.txt", (String)""));
        Assertions.assertTrue((boolean)FilenameUtils.isExtension((String)"a\\b\\file.txt", (String)"txt"));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension((String)"a\\b\\file.txt", (String)"rtf"));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension((String)"a.b\\file.txt", (String)null));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension((String)"a.b\\file.txt", (String)""));
        Assertions.assertTrue((boolean)FilenameUtils.isExtension((String)"a.b\\file.txt", (String)"txt"));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension((String)"a.b\\file.txt", (String)"rtf"));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension((String)"a.b\\file.txt", (String)"TXT"));
    }

    @Test
    public void testIsExtension_injection() {
        try {
            FilenameUtils.isExtension((String)"a.b\\fi\u0000le.txt", (String)"TXT");
            Assertions.fail((String)"Should throw IAE");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testIsExtensionArray() {
        Assertions.assertFalse((boolean)FilenameUtils.isExtension(null, (String[])null));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension((String)"file.txt", (String[])null));
        Assertions.assertTrue((boolean)FilenameUtils.isExtension((String)"file", (String[])null));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension((String)"file.txt", (String[])new String[0]));
        Assertions.assertTrue((boolean)FilenameUtils.isExtension((String)"file.txt", (String[])new String[]{"txt"}));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension((String)"file.txt", (String[])new String[]{"rtf"}));
        Assertions.assertTrue((boolean)FilenameUtils.isExtension((String)"file", (String[])new String[]{"rtf", ""}));
        Assertions.assertTrue((boolean)FilenameUtils.isExtension((String)"file.txt", (String[])new String[]{"rtf", "txt"}));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension((String)"a/b/file.txt", (String[])null));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension((String)"a/b/file.txt", (String[])new String[0]));
        Assertions.assertTrue((boolean)FilenameUtils.isExtension((String)"a/b/file.txt", (String[])new String[]{"txt"}));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension((String)"a/b/file.txt", (String[])new String[]{"rtf"}));
        Assertions.assertTrue((boolean)FilenameUtils.isExtension((String)"a/b/file.txt", (String[])new String[]{"rtf", "txt"}));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension((String)"a.b/file.txt", (String[])null));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension((String)"a.b/file.txt", (String[])new String[0]));
        Assertions.assertTrue((boolean)FilenameUtils.isExtension((String)"a.b/file.txt", (String[])new String[]{"txt"}));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension((String)"a.b/file.txt", (String[])new String[]{"rtf"}));
        Assertions.assertTrue((boolean)FilenameUtils.isExtension((String)"a.b/file.txt", (String[])new String[]{"rtf", "txt"}));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension((String)"a\\b\\file.txt", (String[])null));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension((String)"a\\b\\file.txt", (String[])new String[0]));
        Assertions.assertTrue((boolean)FilenameUtils.isExtension((String)"a\\b\\file.txt", (String[])new String[]{"txt"}));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension((String)"a\\b\\file.txt", (String[])new String[]{"rtf"}));
        Assertions.assertTrue((boolean)FilenameUtils.isExtension((String)"a\\b\\file.txt", (String[])new String[]{"rtf", "txt"}));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension((String)"a.b\\file.txt", (String[])null));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension((String)"a.b\\file.txt", (String[])new String[0]));
        Assertions.assertTrue((boolean)FilenameUtils.isExtension((String)"a.b\\file.txt", (String[])new String[]{"txt"}));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension((String)"a.b\\file.txt", (String[])new String[]{"rtf"}));
        Assertions.assertTrue((boolean)FilenameUtils.isExtension((String)"a.b\\file.txt", (String[])new String[]{"rtf", "txt"}));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension((String)"a.b\\file.txt", (String[])new String[]{"TXT"}));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension((String)"a.b\\file.txt", (String[])new String[]{"TXT", "RTF"}));
    }

    @Test
    public void testIsExtensionVarArgs() {
        Assertions.assertTrue((boolean)FilenameUtils.isExtension((String)"file.txt", (String)"txt"));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension((String)"file.txt", (String)"rtf"));
        Assertions.assertTrue((boolean)FilenameUtils.isExtension((String)"file", (String[])new String[]{"rtf", ""}));
        Assertions.assertTrue((boolean)FilenameUtils.isExtension((String)"file.txt", (String[])new String[]{"rtf", "txt"}));
        Assertions.assertTrue((boolean)FilenameUtils.isExtension((String)"a/b/file.txt", (String)"txt"));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension((String)"a/b/file.txt", (String)"rtf"));
        Assertions.assertTrue((boolean)FilenameUtils.isExtension((String)"a/b/file.txt", (String[])new String[]{"rtf", "txt"}));
        Assertions.assertTrue((boolean)FilenameUtils.isExtension((String)"a.b/file.txt", (String)"txt"));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension((String)"a.b/file.txt", (String)"rtf"));
        Assertions.assertTrue((boolean)FilenameUtils.isExtension((String)"a.b/file.txt", (String[])new String[]{"rtf", "txt"}));
        Assertions.assertTrue((boolean)FilenameUtils.isExtension((String)"a\\b\\file.txt", (String)"txt"));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension((String)"a\\b\\file.txt", (String)"rtf"));
        Assertions.assertTrue((boolean)FilenameUtils.isExtension((String)"a\\b\\file.txt", (String[])new String[]{"rtf", "txt"}));
        Assertions.assertTrue((boolean)FilenameUtils.isExtension((String)"a.b\\file.txt", (String)"txt"));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension((String)"a.b\\file.txt", (String)"rtf"));
        Assertions.assertTrue((boolean)FilenameUtils.isExtension((String)"a.b\\file.txt", (String[])new String[]{"rtf", "txt"}));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension((String)"a.b\\file.txt", (String)"TXT"));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension((String)"a.b\\file.txt", (String[])new String[]{"TXT", "RTF"}));
    }

    @Test
    public void testIsExtensionCollection() {
        Assertions.assertFalse((boolean)FilenameUtils.isExtension(null, (Collection)null));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension((String)"file.txt", (Collection)null));
        Assertions.assertTrue((boolean)FilenameUtils.isExtension((String)"file", (Collection)null));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension((String)"file.txt", new ArrayList()));
        Assertions.assertTrue((boolean)FilenameUtils.isExtension((String)"file.txt", new ArrayList<String>(Arrays.asList("txt"))));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension((String)"file.txt", new ArrayList<String>(Arrays.asList("rtf"))));
        Assertions.assertTrue((boolean)FilenameUtils.isExtension((String)"file", new ArrayList<String>(Arrays.asList("rtf", ""))));
        Assertions.assertTrue((boolean)FilenameUtils.isExtension((String)"file.txt", new ArrayList<String>(Arrays.asList("rtf", "txt"))));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension((String)"a/b/file.txt", (Collection)null));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension((String)"a/b/file.txt", new ArrayList()));
        Assertions.assertTrue((boolean)FilenameUtils.isExtension((String)"a/b/file.txt", new ArrayList<String>(Arrays.asList("txt"))));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension((String)"a/b/file.txt", new ArrayList<String>(Arrays.asList("rtf"))));
        Assertions.assertTrue((boolean)FilenameUtils.isExtension((String)"a/b/file.txt", new ArrayList<String>(Arrays.asList("rtf", "txt"))));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension((String)"a.b/file.txt", (Collection)null));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension((String)"a.b/file.txt", new ArrayList()));
        Assertions.assertTrue((boolean)FilenameUtils.isExtension((String)"a.b/file.txt", new ArrayList<String>(Arrays.asList("txt"))));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension((String)"a.b/file.txt", new ArrayList<String>(Arrays.asList("rtf"))));
        Assertions.assertTrue((boolean)FilenameUtils.isExtension((String)"a.b/file.txt", new ArrayList<String>(Arrays.asList("rtf", "txt"))));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension((String)"a\\b\\file.txt", (Collection)null));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension((String)"a\\b\\file.txt", new ArrayList()));
        Assertions.assertTrue((boolean)FilenameUtils.isExtension((String)"a\\b\\file.txt", new ArrayList<String>(Arrays.asList("txt"))));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension((String)"a\\b\\file.txt", new ArrayList<String>(Arrays.asList("rtf"))));
        Assertions.assertTrue((boolean)FilenameUtils.isExtension((String)"a\\b\\file.txt", new ArrayList<String>(Arrays.asList("rtf", "txt"))));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension((String)"a.b\\file.txt", (Collection)null));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension((String)"a.b\\file.txt", new ArrayList()));
        Assertions.assertTrue((boolean)FilenameUtils.isExtension((String)"a.b\\file.txt", new ArrayList<String>(Arrays.asList("txt"))));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension((String)"a.b\\file.txt", new ArrayList<String>(Arrays.asList("rtf"))));
        Assertions.assertTrue((boolean)FilenameUtils.isExtension((String)"a.b\\file.txt", new ArrayList<String>(Arrays.asList("rtf", "txt"))));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension((String)"a.b\\file.txt", new ArrayList<String>(Arrays.asList("TXT"))));
        Assertions.assertFalse((boolean)FilenameUtils.isExtension((String)"a.b\\file.txt", new ArrayList<String>(Arrays.asList("TXT", "RTF"))));
    }
}

