/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.comparator;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import org.apache.commons.io.comparator.AbstractFileComparator;
import org.apache.commons.io.comparator.ComparatorAbstractTestCase;
import org.apache.commons.io.comparator.CompositeFileComparator;
import org.apache.commons.io.comparator.ExtensionFileComparator;
import org.apache.commons.io.comparator.ReverseFileComparator;
import org.apache.commons.io.comparator.SizeFileComparator;
import org.apache.commons.io.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class CompositeFileComparatorTest
extends ComparatorAbstractTestCase {
    @BeforeEach
    public void setUp() throws Exception {
        this.comparator = new CompositeFileComparator((Comparator[])new AbstractFileComparator[]{(AbstractFileComparator)SizeFileComparator.SIZE_COMPARATOR, (AbstractFileComparator)ExtensionFileComparator.EXTENSION_COMPARATOR});
        this.reverse = new ReverseFileComparator((Comparator)this.comparator);
        this.lessFile = new File(this.dir, "xyz.txt");
        this.equalFile1 = new File(this.dir, "foo.txt");
        this.equalFile2 = new File(this.dir, "bar.txt");
        this.moreFile = new File(this.dir, "foo.xyz");
        if (!this.lessFile.getParentFile().exists()) {
            throw new IOException("Cannot create file " + this.lessFile + " as the parent directory does not exist");
        }
        try (BufferedOutputStream output3 = new BufferedOutputStream(new FileOutputStream(this.lessFile));){
            TestUtils.generateTestData(output3, 32L);
        }
        if (!this.equalFile1.getParentFile().exists()) {
            throw new IOException("Cannot create file " + this.equalFile1 + " as the parent directory does not exist");
        }
        var2_2 = null;
        try (BufferedOutputStream output2 = new BufferedOutputStream(new FileOutputStream(this.equalFile1));){
            TestUtils.generateTestData(output2, 48L);
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        if (!this.equalFile2.getParentFile().exists()) {
            throw new IOException("Cannot create file " + this.equalFile2 + " as the parent directory does not exist");
        }
        var2_2 = null;
        try (BufferedOutputStream output1 = new BufferedOutputStream(new FileOutputStream(this.equalFile2));){
            TestUtils.generateTestData(output1, 48L);
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        if (!this.moreFile.getParentFile().exists()) {
            throw new IOException("Cannot create file " + this.moreFile + " as the parent directory does not exist");
        }
        var2_2 = null;
        try (BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(this.moreFile));){
            TestUtils.generateTestData(output, 48L);
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
    }

    @Test
    public void constructorIterable_order() {
        ArrayList<Comparator> list = new ArrayList<Comparator>();
        list.add(SizeFileComparator.SIZE_COMPARATOR);
        list.add(ExtensionFileComparator.EXTENSION_COMPARATOR);
        CompositeFileComparator c = new CompositeFileComparator(list);
        Assertions.assertEquals((int)0, (int)c.compare(this.equalFile1, this.equalFile2), (String)"equal");
        Assertions.assertTrue((c.compare(this.lessFile, this.moreFile) < 0 ? 1 : 0) != 0, (String)"less");
        Assertions.assertTrue((c.compare(this.moreFile, this.lessFile) > 0 ? 1 : 0) != 0, (String)"more");
    }

    @Test
    public void constructorIterable_Null() {
        CompositeFileComparator c = new CompositeFileComparator((Iterable)null);
        Assertions.assertEquals((int)0, (int)c.compare(this.lessFile, this.moreFile), (String)"less,more");
        Assertions.assertEquals((int)0, (int)c.compare(this.moreFile, this.lessFile), (String)"more,less");
        Assertions.assertEquals((Object)"CompositeFileComparator{}", (Object)c.toString(), (String)"toString");
    }

    @Test
    public void constructorArray_Null() {
        CompositeFileComparator c = new CompositeFileComparator((Comparator[])null);
        Assertions.assertEquals((int)0, (int)c.compare(this.lessFile, this.moreFile), (String)"less,more");
        Assertions.assertEquals((int)0, (int)c.compare(this.moreFile, this.lessFile), (String)"more,less");
        Assertions.assertEquals((Object)"CompositeFileComparator{}", (Object)c.toString(), (String)"toString");
    }
}

