/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.comparator;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.commons.io.comparator.AbstractFileComparator;
import org.apache.commons.io.comparator.ComparatorAbstractTestCase;
import org.apache.commons.io.comparator.LastModifiedFileComparator;
import org.apache.commons.io.test.TestUtils;
import org.junit.jupiter.api.BeforeEach;

public class LastModifiedFileComparatorTest
extends ComparatorAbstractTestCase {
    @BeforeEach
    public void setUp() throws Exception {
        this.comparator = (AbstractFileComparator)LastModifiedFileComparator.LASTMODIFIED_COMPARATOR;
        this.reverse = LastModifiedFileComparator.LASTMODIFIED_REVERSE;
        File olderFile = new File(this.dir, "older.txt");
        if (!olderFile.getParentFile().exists()) {
            throw new IOException("Cannot create file " + olderFile + " as the parent directory does not exist");
        }
        try (BufferedOutputStream output2 = new BufferedOutputStream(new FileOutputStream(olderFile));){
            TestUtils.generateTestData(output2, 0L);
        }
        File equalFile = new File(this.dir, "equal.txt");
        if (!equalFile.getParentFile().exists()) {
            throw new IOException("Cannot create file " + equalFile + " as the parent directory does not exist");
        }
        try (BufferedOutputStream output1 = new BufferedOutputStream(new FileOutputStream(equalFile));){
            TestUtils.generateTestData(output1, 0L);
        }
        do {
            TestUtils.sleepQuietly(300L);
            equalFile.setLastModified(System.currentTimeMillis());
        } while (olderFile.lastModified() == equalFile.lastModified());
        File newerFile = new File(this.dir, "newer.txt");
        if (!newerFile.getParentFile().exists()) {
            throw new IOException("Cannot create file " + newerFile + " as the parent directory does not exist");
        }
        try (BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(newerFile));){
            TestUtils.generateTestData(output, 0L);
        }
        do {
            TestUtils.sleepQuietly(300L);
            newerFile.setLastModified(System.currentTimeMillis());
        } while (equalFile.lastModified() == newerFile.lastModified());
        this.equalFile1 = equalFile;
        this.equalFile2 = equalFile;
        this.lessFile = olderFile;
        this.moreFile = newerFile;
    }
}

