/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.file;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.file.CounterAssertions;
import org.apache.commons.io.file.Counters;
import org.apache.commons.io.file.DeleteOption;
import org.apache.commons.io.file.PathUtils;
import org.apache.commons.io.file.StandardDeleteOption;
import org.apache.commons.lang3.SystemUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class PathUtilsDeleteFileTest {
    private Path tempDir;

    @AfterEach
    public void afterEach() throws IOException {
        if (Files.exists(this.tempDir, new LinkOption[0]) && PathUtils.isEmptyDirectory((Path)this.tempDir)) {
            Files.deleteIfExists(this.tempDir);
        }
    }

    @BeforeEach
    public void beforeEach() throws IOException {
        this.tempDir = Files.createTempDirectory(this.getClass().getCanonicalName(), new FileAttribute[0]);
    }

    @Test
    public void testDeleteFileDirectory1FileSize0() throws IOException {
        String fileName = "file-size-0.bin";
        PathUtils.copyFileToDirectory((Path)Paths.get("src/test/resources/org/apache/commons/io/dirs-1-file-size-0/file-size-0.bin", new String[0]), (Path)this.tempDir, (CopyOption[])new CopyOption[0]);
        CounterAssertions.assertCounts(0L, 1L, 0L, PathUtils.deleteFile((Path)this.tempDir.resolve("file-size-0.bin")));
        Files.deleteIfExists(this.tempDir);
    }

    @Test
    public void testDeleteFileDirectory1FileSize1() throws IOException {
        String fileName = "file-size-1.bin";
        PathUtils.copyFileToDirectory((Path)Paths.get("src/test/resources/org/apache/commons/io/dirs-1-file-size-1/file-size-1.bin", new String[0]), (Path)this.tempDir, (CopyOption[])new CopyOption[0]);
        CounterAssertions.assertCounts(0L, 1L, 1L, PathUtils.deleteFile((Path)this.tempDir.resolve("file-size-1.bin")));
        Files.deleteIfExists(this.tempDir);
    }

    @Test
    public void testDeleteFileDoesNotExist() throws IOException {
        this.testDeleteFileEmpty(PathUtils.deleteFile((Path)this.tempDir.resolve("file-does-not-exist.bin")));
        Files.deleteIfExists(this.tempDir);
    }

    private void testDeleteFileEmpty(Counters.PathCounters pathCounts) {
        CounterAssertions.assertCounts(0L, 0L, 0L, pathCounts);
    }

    @Test
    public void testDeleteFileEmptyDirectory() throws IOException {
        Assertions.assertThrows(NoSuchFileException.class, () -> this.testDeleteFileEmpty(PathUtils.deleteFile((Path)this.tempDir)));
        Files.deleteIfExists(this.tempDir);
    }

    @Test
    public void testDeleteReadOnlyFileDirectory1FileSize1() throws IOException {
        String fileName = "file-size-1.bin";
        PathUtils.copyFileToDirectory((Path)Paths.get("src/test/resources/org/apache/commons/io/dirs-1-file-size-1/file-size-1.bin", new String[0]), (Path)this.tempDir, (CopyOption[])new CopyOption[0]);
        Path resolved = this.tempDir.resolve("file-size-1.bin");
        PathUtils.setReadOnly((Path)resolved, (boolean)true, (LinkOption[])new LinkOption[0]);
        if (SystemUtils.IS_OS_WINDOWS) {
            Assertions.assertFalse((boolean)Files.isWritable(resolved));
            Assertions.assertThrows(IOException.class, () -> PathUtils.deleteFile((Path)resolved));
        }
        CounterAssertions.assertCounts(0L, 1L, 1L, PathUtils.deleteFile((Path)resolved, (DeleteOption[])new DeleteOption[]{StandardDeleteOption.OVERRIDE_READ_ONLY}));
        Files.deleteIfExists(this.tempDir);
    }

    @Test
    public void testSetReadOnlyFileDirectory1FileSize1() throws IOException {
        String fileName = "file-size-1.bin";
        PathUtils.copyFileToDirectory((Path)Paths.get("src/test/resources/org/apache/commons/io/dirs-1-file-size-1/file-size-1.bin", new String[0]), (Path)this.tempDir, (CopyOption[])new CopyOption[0]);
        Path resolved = this.tempDir.resolve("file-size-1.bin");
        PathUtils.setReadOnly((Path)resolved, (boolean)true, (LinkOption[])new LinkOption[0]);
        if (SystemUtils.IS_OS_WINDOWS) {
            Assertions.assertFalse((boolean)Files.isWritable(resolved));
            Assertions.assertThrows(IOException.class, () -> PathUtils.deleteFile((Path)resolved));
        }
        PathUtils.setReadOnly((Path)resolved, (boolean)false, (LinkOption[])new LinkOption[0]);
        PathUtils.deleteFile((Path)resolved);
        Files.deleteIfExists(this.tempDir);
    }
}

