/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.BoundedInputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BoundedInputStreamTest {
    @Test
    public void testReadSingle() throws Exception {
        int i;
        byte[] helloWorld = "Hello World".getBytes();
        byte[] hello = "Hello".getBytes();
        BoundedInputStream bounded = new BoundedInputStream((InputStream)new ByteArrayInputStream(helloWorld), (long)helloWorld.length);
        for (i = 0; i < helloWorld.length; ++i) {
            Assertions.assertEquals((int)helloWorld[i], (int)bounded.read(), (String)("limit = length byte[" + i + "]"));
        }
        Assertions.assertEquals((int)-1, (int)bounded.read(), (String)"limit = length end");
        bounded = new BoundedInputStream((InputStream)new ByteArrayInputStream(helloWorld), (long)(helloWorld.length + 1));
        for (i = 0; i < helloWorld.length; ++i) {
            Assertions.assertEquals((int)helloWorld[i], (int)bounded.read(), (String)("limit > length byte[" + i + "]"));
        }
        Assertions.assertEquals((int)-1, (int)bounded.read(), (String)"limit > length end");
        bounded = new BoundedInputStream((InputStream)new ByteArrayInputStream(helloWorld), (long)hello.length);
        for (i = 0; i < hello.length; ++i) {
            Assertions.assertEquals((int)hello[i], (int)bounded.read(), (String)("limit < length byte[" + i + "]"));
        }
        Assertions.assertEquals((int)-1, (int)bounded.read(), (String)"limit < length end");
    }

    @Test
    public void testReadArray() throws Exception {
        byte[] helloWorld = "Hello World".getBytes();
        byte[] hello = "Hello".getBytes();
        BoundedInputStream bounded = new BoundedInputStream((InputStream)new ByteArrayInputStream(helloWorld));
        this.compare("limit = -1", helloWorld, IOUtils.toByteArray((InputStream)bounded));
        bounded = new BoundedInputStream((InputStream)new ByteArrayInputStream(helloWorld), 0L);
        this.compare("limit = 0", new byte[0], IOUtils.toByteArray((InputStream)bounded));
        bounded = new BoundedInputStream((InputStream)new ByteArrayInputStream(helloWorld), (long)helloWorld.length);
        this.compare("limit = length", helloWorld, IOUtils.toByteArray((InputStream)bounded));
        bounded = new BoundedInputStream((InputStream)new ByteArrayInputStream(helloWorld), (long)(helloWorld.length + 1));
        this.compare("limit > length", helloWorld, IOUtils.toByteArray((InputStream)bounded));
        bounded = new BoundedInputStream((InputStream)new ByteArrayInputStream(helloWorld), (long)(helloWorld.length - 6));
        this.compare("limit < length", hello, IOUtils.toByteArray((InputStream)bounded));
    }

    private void compare(String msg, byte[] expected, byte[] actual) {
        Assertions.assertEquals((int)expected.length, (int)actual.length, (String)(msg + " length"));
        for (int i = 0; i < expected.length; ++i) {
            Assertions.assertEquals((byte)expected[i], (byte)actual[i], (String)(msg + " byte[" + i + "]"));
        }
    }
}

