/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.IOException;
import java.io.Reader;
import org.apache.commons.io.input.BrokenReader;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class BrokenReaderTest {
    private IOException exception;
    private Reader reader;

    @BeforeEach
    public void setUp() {
        this.exception = new IOException("test exception");
        this.reader = new BrokenReader(this.exception);
    }

    @Test
    public void testRead() {
        try {
            this.reader.read();
            Assertions.fail((String)"Expected exception not thrown.");
        }
        catch (IOException e) {
            Assertions.assertEquals((Object)this.exception, (Object)e);
        }
        try {
            this.reader.read(new char[1]);
            Assertions.fail((String)"Expected exception not thrown.");
        }
        catch (IOException e) {
            Assertions.assertEquals((Object)this.exception, (Object)e);
        }
        try {
            this.reader.read(new char[1], 0, 1);
            Assertions.fail((String)"Expected exception not thrown.");
        }
        catch (IOException e) {
            Assertions.assertEquals((Object)this.exception, (Object)e);
        }
    }

    @Test
    public void testSkip() {
        try {
            this.reader.skip(1L);
            Assertions.fail((String)"Expected exception not thrown.");
        }
        catch (IOException e) {
            Assertions.assertEquals((Object)this.exception, (Object)e);
        }
    }

    @Test
    public void testReady() {
        try {
            this.reader.ready();
            Assertions.fail((String)"Expected exception not thrown.");
        }
        catch (IOException e) {
            Assertions.assertEquals((Object)this.exception, (Object)e);
        }
    }

    @Test
    public void testMark() {
        try {
            this.reader.mark(1);
            Assertions.fail((String)"Expected exception not thrown.");
        }
        catch (IOException e) {
            Assertions.assertEquals((Object)this.exception, (Object)e);
        }
    }

    @Test
    public void testReset() {
        try {
            this.reader.reset();
            Assertions.fail((String)"Expected exception not thrown.");
        }
        catch (IOException e) {
            Assertions.assertEquals((Object)this.exception, (Object)e);
        }
    }

    @Test
    public void testClose() {
        try {
            this.reader.close();
            Assertions.fail((String)"Expected exception not thrown.");
        }
        catch (IOException e) {
            Assertions.assertEquals((Object)this.exception, (Object)e);
        }
    }
}

