/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.HashSet;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.CharacterFilterReader;
import org.apache.commons.io.output.StringBuilderWriter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CharacterFilterReaderTest {
    @Test
    public void testInputSize0FilterSize1() throws IOException {
        StringReader input = new StringReader("");
        HashSet<Integer> codePoints = new HashSet<Integer>();
        codePoints.add(97);
        try (CharacterFilterReader reader = new CharacterFilterReader((Reader)input, 65);){
            Assertions.assertEquals((int)-1, (int)reader.read());
        }
    }

    @Test
    public void testInputSize1FilterSize1() throws IOException {
        try (StringReader input = new StringReader("a");
             CharacterFilterReader reader = new CharacterFilterReader((Reader)input, 97);){
            Assertions.assertEquals((int)-1, (int)reader.read());
        }
    }

    @Test
    public void testInputSize2FilterSize1FilterAll() throws IOException {
        StringReader input = new StringReader("aa");
        try (CharacterFilterReader reader = new CharacterFilterReader((Reader)input, 97);){
            Assertions.assertEquals((int)-1, (int)reader.read());
        }
    }

    @Test
    public void testInputSize2FilterSize1FilterFirst() throws IOException {
        StringReader input = new StringReader("ab");
        try (CharacterFilterReader reader = new CharacterFilterReader((Reader)input, 97);){
            Assertions.assertEquals((int)98, (int)reader.read());
            Assertions.assertEquals((int)-1, (int)reader.read());
        }
    }

    @Test
    public void testInputSize2FilterSize1FilterLast() throws IOException {
        StringReader input = new StringReader("ab");
        try (CharacterFilterReader reader = new CharacterFilterReader((Reader)input, 98);){
            Assertions.assertEquals((int)97, (int)reader.read());
            Assertions.assertEquals((int)-1, (int)reader.read());
        }
    }

    @Test
    public void testReadIntoBuffer() throws IOException {
        StringReader input = new StringReader("ababcabcd");
        try (CharacterFilterReader reader = new CharacterFilterReader((Reader)input, 98);){
            char[] buff = new char[9];
            int charCount = reader.read(buff);
            Assertions.assertEquals((int)6, (int)charCount);
            Assertions.assertEquals((Object)"aacacd", (Object)new String(buff, 0, charCount));
        }
    }

    @Test
    public void testReadUsingReader() throws IOException {
        StringReader input = new StringReader("ababcabcd");
        try (StringBuilderWriter output = new StringBuilderWriter();
             CharacterFilterReader reader = new CharacterFilterReader((Reader)input, 98);){
            IOUtils.copy((Reader)reader, (Writer)output);
            Assertions.assertEquals((Object)"aacacd", (Object)output.toString());
        }
    }
}

