/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.input.SwappedDataInputStream;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class SwappedDataInputStreamTest {
    private SwappedDataInputStream sdis;
    private byte[] bytes;

    @BeforeEach
    public void setUp() {
        this.bytes = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        ByteArrayInputStream bais = new ByteArrayInputStream(this.bytes);
        this.sdis = new SwappedDataInputStream((InputStream)bais);
    }

    @AfterEach
    public void tearDown() {
        this.sdis = null;
    }

    @Test
    public void testReadBoolean() throws IOException {
        this.bytes = new byte[]{0, 1, 2};
        try (ByteArrayInputStream bais = new ByteArrayInputStream(this.bytes);
             SwappedDataInputStream sdis = new SwappedDataInputStream((InputStream)bais);){
            Assertions.assertEquals((Object)false, (Object)sdis.readBoolean());
            Assertions.assertEquals((Object)true, (Object)sdis.readBoolean());
            Assertions.assertEquals((Object)true, (Object)sdis.readBoolean());
        }
    }

    @Test
    public void testReadByte() throws IOException {
        Assertions.assertEquals((int)1, (int)this.sdis.readByte());
    }

    @Test
    public void testReadChar() throws IOException {
        Assertions.assertEquals((char)'\u0201', (char)this.sdis.readChar());
    }

    @Test
    public void testReadDouble() throws IOException {
        Assertions.assertEquals((double)Double.longBitsToDouble(578437695752307201L), (double)this.sdis.readDouble(), (double)0.0);
    }

    @Test
    public void testReadFloat() throws IOException {
        Assertions.assertEquals((float)Float.intBitsToFloat(67305985), (float)this.sdis.readFloat(), (float)0.0f);
    }

    @Test
    public void testReadFully() throws IOException {
        byte[] bytesIn = new byte[8];
        this.sdis.readFully(bytesIn);
        for (int i = 0; i < 8; ++i) {
            Assertions.assertEquals((byte)this.bytes[i], (byte)bytesIn[i]);
        }
    }

    @Test
    public void testReadInt() throws IOException {
        Assertions.assertEquals((int)67305985, (int)this.sdis.readInt());
    }

    @Test
    public void testReadLine() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.sdis.readLine(), (String)"readLine should be unsupported. ");
    }

    @Test
    public void testReadLong() throws IOException {
        Assertions.assertEquals((long)578437695752307201L, (long)this.sdis.readLong());
    }

    @Test
    public void testReadShort() throws IOException {
        Assertions.assertEquals((short)513, (short)this.sdis.readShort());
    }

    @Test
    public void testReadUnsignedByte() throws IOException {
        Assertions.assertEquals((int)1, (int)this.sdis.readUnsignedByte());
    }

    @Test
    public void testReadUnsignedShort() throws IOException {
        Assertions.assertEquals((int)513, (int)this.sdis.readUnsignedShort());
    }

    @Test
    public void testReadUTF() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.sdis.readUTF(), (String)"readUTF should be unsupported. ");
    }

    @Test
    public void testSkipBytes() throws IOException {
        this.sdis.skipBytes(4);
        Assertions.assertEquals((int)134678021, (int)this.sdis.readInt());
    }
}

