/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import org.apache.commons.io.output.XmlStreamWriter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junitpioneer.jupiter.DefaultLocale;

public class XmlStreamWriterTest {
    private static final String TEXT_LATIN1 = "eacute: \u00e9";
    private static final String TEXT_LATIN7 = "alpha: \u03b1";
    private static final String TEXT_LATIN15 = "euro: \u20ac";
    private static final String TEXT_EUC_JP = "hiragana A: \u3042";
    private static final String TEXT_UNICODE = "eacute: \u00e9, alpha: \u03b1, euro: \u20ac, hiragana A: \u3042";

    private static String createXmlContent(String text, String encoding) {
        String xmlDecl = "<?xml version=\"1.0\"?>";
        if (encoding != null) {
            xmlDecl = "<?xml version=\"1.0\" encoding=\"" + encoding + "\"?>";
        }
        return xmlDecl + "\n<text>" + text + "</text>";
    }

    private static void checkXmlContent(String xml, String encoding, String defaultEncoding) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        XmlStreamWriter writer = new XmlStreamWriter((OutputStream)out, defaultEncoding);
        writer.write(xml);
        writer.close();
        byte[] xmlContent = out.toByteArray();
        Assertions.assertTrue((boolean)encoding.equalsIgnoreCase(writer.getEncoding()));
        Assertions.assertTrue((boolean)Arrays.equals(xml.getBytes(encoding), xmlContent));
    }

    private static void checkXmlWriter(String text, String encoding) throws IOException {
        XmlStreamWriterTest.checkXmlWriter(text, encoding, null);
    }

    private static void checkXmlWriter(String text, String encoding, String defaultEncoding) throws IOException {
        String xml = XmlStreamWriterTest.createXmlContent(text, encoding);
        String effectiveEncoding = encoding;
        if (effectiveEncoding == null) {
            effectiveEncoding = defaultEncoding == null ? "UTF-8" : defaultEncoding;
        }
        XmlStreamWriterTest.checkXmlContent(xml, effectiveEncoding, defaultEncoding);
    }

    @Test
    public void testNoXmlHeader() throws IOException {
        String xml = "<text>text with no XML header</text>";
        XmlStreamWriterTest.checkXmlContent("<text>text with no XML header</text>", "UTF-8", null);
    }

    @Test
    public void testEmpty() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (XmlStreamWriter writer = new XmlStreamWriter((OutputStream)out);){
            writer.flush();
            writer.write("");
            writer.flush();
            writer.write(".");
            writer.flush();
        }
    }

    @Test
    public void testDefaultEncoding() throws IOException {
        XmlStreamWriterTest.checkXmlWriter(TEXT_UNICODE, null, null);
        XmlStreamWriterTest.checkXmlWriter(TEXT_UNICODE, null, "UTF-8");
        XmlStreamWriterTest.checkXmlWriter(TEXT_UNICODE, null, "UTF-16");
        XmlStreamWriterTest.checkXmlWriter(TEXT_UNICODE, null, "UTF-16BE");
        XmlStreamWriterTest.checkXmlWriter(TEXT_UNICODE, null, "ISO-8859-1");
    }

    @Test
    @DefaultLocale(language="tr")
    public void testLowerCaseEncodingWithTurkishLocale_IO_557() throws IOException {
        XmlStreamWriterTest.checkXmlWriter(TEXT_UNICODE, "utf-8");
        XmlStreamWriterTest.checkXmlWriter(TEXT_LATIN1, "iso-8859-1");
        XmlStreamWriterTest.checkXmlWriter(TEXT_LATIN7, "iso-8859-7");
    }

    @Test
    public void testUTF8Encoding() throws IOException {
        XmlStreamWriterTest.checkXmlWriter(TEXT_UNICODE, "UTF-8");
    }

    @Test
    public void testUTF16Encoding() throws IOException {
        XmlStreamWriterTest.checkXmlWriter(TEXT_UNICODE, "UTF-16");
    }

    @Test
    public void testUTF16BEEncoding() throws IOException {
        XmlStreamWriterTest.checkXmlWriter(TEXT_UNICODE, "UTF-16BE");
    }

    @Test
    public void testUTF16LEEncoding() throws IOException {
        XmlStreamWriterTest.checkXmlWriter(TEXT_UNICODE, "UTF-16LE");
    }

    @Test
    public void testLatin1Encoding() throws IOException {
        XmlStreamWriterTest.checkXmlWriter(TEXT_LATIN1, "ISO-8859-1");
    }

    @Test
    public void testLatin7Encoding() throws IOException {
        XmlStreamWriterTest.checkXmlWriter(TEXT_LATIN7, "ISO-8859-7");
    }

    @Test
    public void testLatin15Encoding() throws IOException {
        XmlStreamWriterTest.checkXmlWriter(TEXT_LATIN15, "ISO-8859-15");
    }

    @Test
    public void testEUC_JPEncoding() throws IOException {
        XmlStreamWriterTest.checkXmlWriter(TEXT_EUC_JP, "EUC-JP");
    }

    @Test
    public void testEBCDICEncoding() throws IOException {
        XmlStreamWriterTest.checkXmlWriter("simple text in EBCDIC", "CP1047");
    }
}

