/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.file.PathUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class FileUtilsCopyDirectoryToDirectoryTestCase {
    @TempDir
    public File temporaryFolder;

    private static void assertExceptionTypeAndMessage(File srcDir, File destDir, Class<? extends Exception> expectedExceptionType, String expectedMessage) {
        try {
            FileUtils.copyDirectoryToDirectory((File)srcDir, (File)destDir);
        }
        catch (Exception e) {
            String msg = e.getMessage();
            Assertions.assertEquals(expectedExceptionType, e.getClass());
            Assertions.assertEquals((Object)expectedMessage, (Object)msg);
            return;
        }
        Assertions.fail();
    }

    private void assertAclEntryList(Path sourcePath, Path destPath) throws IOException {
        Assertions.assertEquals((Object)PathUtils.getAclEntryList((Path)sourcePath), (Object)PathUtils.getAclEntryList((Path)destPath));
    }

    @Test
    public void copyDirectoryToDirectoryThrowsIllegalArgumentExceptionWithCorrectMessageWhenDstDirIsNotDirectory() throws IOException {
        File srcDir = new File(this.temporaryFolder, "sourceDirectory");
        srcDir.mkdir();
        File destDir = new File(this.temporaryFolder, "notadirectory");
        destDir.createNewFile();
        String expectedMessage = String.format("Destination '%s' is not a directory", destDir);
        FileUtilsCopyDirectoryToDirectoryTestCase.assertExceptionTypeAndMessage(srcDir, destDir, IllegalArgumentException.class, expectedMessage);
    }

    @Test
    public void copyDirectoryToDirectoryThrowsIllegalExceptionWithCorrectMessageWhenSrcDirIsNotDirectory() throws IOException {
        File srcDir = File.createTempFile("notadireotry", null, this.temporaryFolder);
        File destDir = new File(this.temporaryFolder, "destinationDirectory");
        destDir.mkdirs();
        String expectedMessage = String.format("Source '%s' is not a directory", srcDir);
        FileUtilsCopyDirectoryToDirectoryTestCase.assertExceptionTypeAndMessage(srcDir, destDir, IllegalArgumentException.class, expectedMessage);
    }

    @Test
    public void copyDirectoryToDirectoryThrowsNullPointerExceptionWithCorrectMessageWhenDstDirIsNull() {
        File srcDir = new File(this.temporaryFolder, "sourceDirectory");
        srcDir.mkdir();
        File destDir = null;
        FileUtilsCopyDirectoryToDirectoryTestCase.assertExceptionTypeAndMessage(srcDir, destDir, NullPointerException.class, "destinationDir");
    }

    @Test
    public void copyDirectoryToDirectoryThrowsNullPointerExceptionWithCorrectMessageWhenSrcDirIsNull() {
        File srcDir = null;
        File destinationDirectory = new File(this.temporaryFolder, "destinationDirectory");
        destinationDirectory.mkdir();
        FileUtilsCopyDirectoryToDirectoryTestCase.assertExceptionTypeAndMessage(srcDir, destinationDirectory, NullPointerException.class, "sourceDir");
    }

    @Test
    public void copyFileAndCheckAcl() throws IOException {
        Path sourcePath = Files.createTempFile("TempOutput", ".bin", new FileAttribute[0]);
        Path destPath = Paths.get(this.temporaryFolder.getAbsolutePath(), "SomeFile.bin");
        FileUtils.copyFile((File)sourcePath.toFile(), (File)destPath.toFile(), (boolean)true, (CopyOption[])new CopyOption[]{StandardCopyOption.COPY_ATTRIBUTES});
        this.assertAclEntryList(sourcePath, destPath);
        FileUtils.copyFile((File)sourcePath.toFile(), (File)destPath.toFile());
        this.assertAclEntryList(sourcePath, destPath);
        FileUtils.copyFile((File)sourcePath.toFile(), (File)destPath.toFile(), (boolean)true, (CopyOption[])new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
        this.assertAclEntryList(sourcePath, destPath);
        FileUtils.copyFile((File)sourcePath.toFile(), (File)destPath.toFile(), (boolean)true, (CopyOption[])new CopyOption[]{StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES});
        this.assertAclEntryList(sourcePath, destPath);
    }
}

