/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;

public class TestResources {
    private static final String ROOT = "/org/apache/commons/io/";

    public static File getFile(String fileName) throws URISyntaxException {
        return new File(TestResources.getURI(fileName));
    }

    public static Path getPath(String fileName) throws URISyntaxException {
        return Paths.get(TestResources.getURI(fileName));
    }

    public static URI getURI(String fileName) throws URISyntaxException {
        return TestResources.getURL(fileName).toURI();
    }

    public static URL getURL(String fileName) {
        return TestResources.class.getResource(ROOT + fileName);
    }

    public static InputStream getInputStream(String fileName) {
        return TestResources.class.getResourceAsStream(ROOT + fileName);
    }
}

