/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.filefilter;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.filefilter.ConditionalFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.IOFileFilterAbstractTestCase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public abstract class ConditionalFileFilterAbstractTestCase
extends IOFileFilterAbstractTestCase {
    private static final String TEST_FILE_NAME_PREFIX = "TestFile";
    private static final String TEST_FILE_TYPE = ".tst";
    protected IOFileFilterAbstractTestCase.TesterTrueFileFilter[] trueFilters;
    protected IOFileFilterAbstractTestCase.TesterFalseFileFilter[] falseFilters;
    private File file;
    private File workingPath;

    @BeforeEach
    public void setUp() throws Exception {
        this.workingPath = ConditionalFileFilterAbstractTestCase.determineWorkingDirectoryPath(this.getWorkingPathNamePropertyKey(), this.getDefaultWorkingPath());
        this.file = new File(this.workingPath, "TestFile1.tst");
        this.trueFilters = new IOFileFilterAbstractTestCase.TesterTrueFileFilter[4];
        this.falseFilters = new IOFileFilterAbstractTestCase.TesterFalseFileFilter[4];
        this.trueFilters[1] = new IOFileFilterAbstractTestCase.TesterTrueFileFilter(this);
        this.trueFilters[2] = new IOFileFilterAbstractTestCase.TesterTrueFileFilter(this);
        this.trueFilters[3] = new IOFileFilterAbstractTestCase.TesterTrueFileFilter(this);
        this.falseFilters[1] = new IOFileFilterAbstractTestCase.TesterFalseFileFilter(this);
        this.falseFilters[2] = new IOFileFilterAbstractTestCase.TesterFalseFileFilter(this);
        this.falseFilters[3] = new IOFileFilterAbstractTestCase.TesterFalseFileFilter(this);
    }

    @Test
    public void testAdd() {
        ArrayList<IOFileFilterAbstractTestCase.TesterTrueFileFilter> filters = new ArrayList<IOFileFilterAbstractTestCase.TesterTrueFileFilter>();
        ConditionalFileFilter fileFilter = this.getConditionalFileFilter();
        filters.add(new IOFileFilterAbstractTestCase.TesterTrueFileFilter(this));
        filters.add(new IOFileFilterAbstractTestCase.TesterTrueFileFilter(this));
        filters.add(new IOFileFilterAbstractTestCase.TesterTrueFileFilter(this));
        filters.add(new IOFileFilterAbstractTestCase.TesterTrueFileFilter(this));
        for (int i = 0; i < filters.size(); ++i) {
            Assertions.assertEquals((int)i, (int)fileFilter.getFileFilters().size(), (String)"file filters count: ");
            fileFilter.addFileFilter((IOFileFilter)filters.get(i));
            Assertions.assertEquals((int)(i + 1), (int)fileFilter.getFileFilters().size(), (String)"file filters count: ");
        }
        for (IOFileFilter filter : fileFilter.getFileFilters()) {
            Assertions.assertTrue((boolean)filters.contains(filter), (String)"found file filter");
        }
        Assertions.assertEquals((int)filters.size(), (int)fileFilter.getFileFilters().size(), (String)"file filters count");
    }

    @Test
    public void testRemove() {
        ArrayList<IOFileFilterAbstractTestCase.TesterTrueFileFilter> filters = new ArrayList<IOFileFilterAbstractTestCase.TesterTrueFileFilter>();
        ConditionalFileFilter fileFilter = this.getConditionalFileFilter();
        filters.add(new IOFileFilterAbstractTestCase.TesterTrueFileFilter(this));
        filters.add(new IOFileFilterAbstractTestCase.TesterTrueFileFilter(this));
        filters.add(new IOFileFilterAbstractTestCase.TesterTrueFileFilter(this));
        filters.add(new IOFileFilterAbstractTestCase.TesterTrueFileFilter(this));
        for (IOFileFilterAbstractTestCase.TesterTrueFileFilter filter : filters) {
            fileFilter.removeFileFilter((IOFileFilter)filter);
            Assertions.assertTrue((!fileFilter.getFileFilters().contains((Object)filter) ? 1 : 0) != 0, (String)"file filter removed");
        }
        Assertions.assertEquals((int)0, (int)fileFilter.getFileFilters().size(), (String)"file filters count");
    }

    @Test
    public void testNoFilters() throws Exception {
        ConditionalFileFilter fileFilter = this.getConditionalFileFilter();
        File file = new File(this.workingPath, "TestFile1.tst");
        ConditionalFileFilterAbstractTestCase.assertFileFiltering(1, (IOFileFilter)fileFilter, file, false);
        ConditionalFileFilterAbstractTestCase.assertFilenameFiltering(1, (IOFileFilter)fileFilter, file, false);
    }

    @Test
    public void testFilterBuiltUsingConstructor() throws Exception {
        List<List<IOFileFilter>> testFilters = this.getTestFilters();
        List<boolean[]> testTrueResults = this.getTrueResults();
        List<boolean[]> testFalseResults = this.getFalseResults();
        List<Boolean> testFileResults = this.getFileResults();
        List<Boolean> testFilenameResults = this.getFilenameResults();
        for (int i = 1; i < testFilters.size(); ++i) {
            List<IOFileFilter> filters = testFilters.get(i);
            boolean[] trueResults = testTrueResults.get(i);
            boolean[] falseResults = testFalseResults.get(i);
            boolean fileResults = testFileResults.get(i);
            boolean filenameResults = testFilenameResults.get(i);
            IOFileFilter filter = this.buildFilterUsingConstructor(filters);
            ConditionalFileFilterAbstractTestCase.resetTrueFilters(this.trueFilters);
            ConditionalFileFilterAbstractTestCase.resetFalseFilters(this.falseFilters);
            ConditionalFileFilterAbstractTestCase.assertFileFiltering(i, filter, this.file, fileResults);
            ConditionalFileFilterAbstractTestCase.assertTrueFiltersInvoked(i, this.trueFilters, trueResults);
            ConditionalFileFilterAbstractTestCase.assertFalseFiltersInvoked(i, this.falseFilters, falseResults);
            ConditionalFileFilterAbstractTestCase.resetTrueFilters(this.trueFilters);
            ConditionalFileFilterAbstractTestCase.resetFalseFilters(this.falseFilters);
            ConditionalFileFilterAbstractTestCase.assertFilenameFiltering(i, filter, this.file, filenameResults);
            ConditionalFileFilterAbstractTestCase.assertTrueFiltersInvoked(i, this.trueFilters, trueResults);
            ConditionalFileFilterAbstractTestCase.assertFalseFiltersInvoked(i, this.falseFilters, falseResults);
        }
    }

    @Test
    public void testFilterBuiltUsingAdd() throws Exception {
        List<List<IOFileFilter>> testFilters = this.getTestFilters();
        List<boolean[]> testTrueResults = this.getTrueResults();
        List<boolean[]> testFalseResults = this.getFalseResults();
        List<Boolean> testFileResults = this.getFileResults();
        List<Boolean> testFilenameResults = this.getFilenameResults();
        for (int i = 1; i < testFilters.size(); ++i) {
            List<IOFileFilter> filters = testFilters.get(i);
            boolean[] trueResults = testTrueResults.get(i);
            boolean[] falseResults = testFalseResults.get(i);
            boolean fileResults = testFileResults.get(i);
            boolean filenameResults = testFilenameResults.get(i);
            IOFileFilter filter = this.buildFilterUsingAdd(filters);
            ConditionalFileFilterAbstractTestCase.resetTrueFilters(this.trueFilters);
            ConditionalFileFilterAbstractTestCase.resetFalseFilters(this.falseFilters);
            ConditionalFileFilterAbstractTestCase.assertFileFiltering(i, filter, this.file, fileResults);
            ConditionalFileFilterAbstractTestCase.assertTrueFiltersInvoked(i, this.trueFilters, trueResults);
            ConditionalFileFilterAbstractTestCase.assertFalseFiltersInvoked(i, this.falseFilters, falseResults);
            ConditionalFileFilterAbstractTestCase.resetTrueFilters(this.trueFilters);
            ConditionalFileFilterAbstractTestCase.resetFalseFilters(this.falseFilters);
            ConditionalFileFilterAbstractTestCase.assertFilenameFiltering(i, filter, this.file, filenameResults);
            ConditionalFileFilterAbstractTestCase.assertTrueFiltersInvoked(i, this.trueFilters, trueResults);
            ConditionalFileFilterAbstractTestCase.assertFalseFiltersInvoked(i, this.falseFilters, falseResults);
        }
    }

    protected abstract ConditionalFileFilter getConditionalFileFilter();

    protected abstract IOFileFilter buildFilterUsingAdd(List<IOFileFilter> var1);

    protected abstract IOFileFilter buildFilterUsingConstructor(List<IOFileFilter> var1);

    protected abstract List<List<IOFileFilter>> getTestFilters();

    protected abstract List<boolean[]> getTrueResults();

    protected abstract List<boolean[]> getFalseResults();

    protected abstract List<Boolean> getFileResults();

    protected abstract List<Boolean> getFilenameResults();

    protected abstract String getWorkingPathNamePropertyKey();

    protected abstract String getDefaultWorkingPath();
}

