/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.apache.commons.io.input.CircularInputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CircularInputStreamTest {
    private void assertStreamOutput(byte[] toCycle, byte[] expected) throws IOException {
        byte[] actual = new byte[expected.length];
        try (InputStream infStream = this.createInputStream(toCycle, -1L);){
            int actualReadBytes = infStream.read(actual);
            Assertions.assertArrayEquals((byte[])expected, (byte[])actual);
            Assertions.assertEquals((int)expected.length, (int)actualReadBytes);
        }
    }

    private InputStream createInputStream(byte[] repeatContent, long targetByteCount) {
        return new CircularInputStream(repeatContent, targetByteCount);
    }

    @Test
    public void testContainsEofInputSize0() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.createInputStream(new byte[]{-1}, 0L));
    }

    @Test
    public void testCount0() throws IOException {
        try (InputStream in = this.createInputStream(new byte[]{1, 2}, 0L);){
            Assertions.assertEquals((int)-1, (int)in.read());
        }
    }

    @Test
    public void testCount0InputSize0() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.createInputStream(new byte[0], 0L));
    }

    @Test
    public void testCount0InputSize1() throws IOException {
        try (InputStream in = this.createInputStream(new byte[]{1}, 0L);){
            Assertions.assertEquals((int)-1, (int)in.read());
        }
    }

    @Test
    public void testCount1InputSize1() throws IOException {
        try (InputStream in = this.createInputStream(new byte[]{1}, 1L);){
            Assertions.assertEquals((int)1, (int)in.read());
            Assertions.assertEquals((int)-1, (int)in.read());
        }
    }

    @Test
    public void testCycleBytes() throws IOException {
        byte[] input = new byte[]{1, 2};
        byte[] expected = new byte[]{1, 2, 1, 2, 1};
        this.assertStreamOutput(input, expected);
    }

    @Test
    public void testNullInputSize0() {
        Assertions.assertThrows(NullPointerException.class, () -> this.createInputStream(null, 0L));
    }

    @Test
    public void testWholeRangeOfBytes() throws IOException {
        int size = 256;
        byte[] contentToCycle = new byte[256];
        int value = -128;
        for (int i = 0; i < contentToCycle.length; ++i) {
            contentToCycle[i] = value == -1 ? 0 : value;
            value = (byte)(value + 1);
        }
        byte[] expectedOutput = Arrays.copyOf(contentToCycle, 256);
        this.assertStreamOutput(contentToCycle, expectedOutput);
    }
}

