/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.input.MessageDigestCalculatingInputStreamTest;
import org.apache.commons.io.input.ObservableInputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ObservableInputStreamTest {
    @Test
    public void testDataByteCalled() throws Exception {
        byte[] buffer = MessageDigestCalculatingInputStreamTest.generateRandomByteStream(8192);
        LastByteKeepingObserver lko = new LastByteKeepingObserver();
        try (ObservableInputStream ois = new ObservableInputStream((InputStream)new ByteArrayInputStream(buffer));){
            Assertions.assertEquals((int)-1, (int)lko.lastByteSeen);
            ois.read();
            Assertions.assertEquals((int)-1, (int)lko.lastByteSeen);
            Assertions.assertFalse((boolean)lko.finished);
            Assertions.assertFalse((boolean)lko.closed);
            ois.add((ObservableInputStream.Observer)lko);
            for (int i = 1; i < buffer.length; ++i) {
                int result = ois.read();
                Assertions.assertEquals((byte)((byte)result), (byte)buffer[i]);
                Assertions.assertEquals((int)result, (int)lko.lastByteSeen);
                Assertions.assertFalse((boolean)lko.finished);
                Assertions.assertFalse((boolean)lko.closed);
            }
            int result = ois.read();
            Assertions.assertEquals((int)-1, (int)result);
            Assertions.assertTrue((boolean)lko.finished);
            Assertions.assertFalse((boolean)lko.closed);
            ois.close();
            Assertions.assertTrue((boolean)lko.finished);
            Assertions.assertTrue((boolean)lko.closed);
        }
    }

    @Test
    public void testDataBytesCalled() throws Exception {
        byte[] buffer = MessageDigestCalculatingInputStreamTest.generateRandomByteStream(8192);
        ByteArrayInputStream bais = new ByteArrayInputStream(buffer);
        ObservableInputStream ois = new ObservableInputStream((InputStream)bais);
        LastBytesKeepingObserver lko = new LastBytesKeepingObserver();
        byte[] readBuffer = new byte[23];
        Assertions.assertEquals(null, (Object)lko.buffer);
        ois.read(readBuffer);
        Assertions.assertEquals(null, (Object)lko.buffer);
        ois.add((ObservableInputStream.Observer)lko);
        while (true) {
            if (bais.available() >= 2048) {
                int result = ois.read(readBuffer);
                if (result == -1) {
                    ois.close();
                    break;
                }
                Assertions.assertEquals((Object)readBuffer, (Object)lko.buffer);
                Assertions.assertEquals((int)0, (int)lko.offset);
                Assertions.assertEquals((int)readBuffer.length, (int)lko.length);
                continue;
            }
            int res = Math.min(11, bais.available());
            int result = ois.read(readBuffer, 1, 11);
            if (result == -1) {
                ois.close();
                break;
            }
            Assertions.assertEquals((Object)readBuffer, (Object)lko.buffer);
            Assertions.assertEquals((int)1, (int)lko.offset);
            Assertions.assertEquals((int)res, (int)lko.length);
        }
    }

    private static class LastBytesKeepingObserver
    extends ObservableInputStream.Observer {
        private byte[] buffer = null;
        private int offset = -1;
        private int length = -1;

        private LastBytesKeepingObserver() {
        }

        public void data(byte[] pBuffer, int pOffset, int pLength) throws IOException {
            super.data(pBuffer, pOffset, pLength);
            this.buffer = pBuffer;
            this.offset = pOffset;
            this.length = pLength;
        }
    }

    private static class LastByteKeepingObserver
    extends ObservableInputStream.Observer {
        private int lastByteSeen = -1;
        private boolean finished;
        private boolean closed;

        private LastByteKeepingObserver() {
        }

        public void data(int pByte) throws IOException {
            super.data(pByte);
            this.lastByteSeen = pByte;
        }

        public void finished() throws IOException {
            super.finished();
            this.finished = true;
        }

        public void closed() throws IOException {
            super.closed();
            this.closed = true;
        }
    }
}

