/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.input.RandomAccessFileInputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RandomAccessFileInputStreamTest {
    private static final String DATA_FILE = "src/test/resources/org/apache/commons/io/test-file-iso8859-1.bin";
    private static final int DATA_FILE_LEN = 1430;

    private RandomAccessFile createRandomAccessFile() throws FileNotFoundException {
        return new RandomAccessFile(DATA_FILE, "r");
    }

    @Test
    public void testAvailable() throws IOException {
        try (RandomAccessFileInputStream inputStream = new RandomAccessFileInputStream(this.createRandomAccessFile(), true);){
            Assertions.assertEquals((int)1430, (int)inputStream.available());
        }
    }

    @Test
    public void testAvailableLong() throws IOException {
        try (RandomAccessFileInputStream inputStream = new RandomAccessFileInputStream(this.createRandomAccessFile(), true);){
            Assertions.assertEquals((long)1430L, (long)inputStream.availableLong());
        }
    }

    @Test
    public void testCtorCloseOnCloseFalse() throws IOException {
        try (RandomAccessFile file = this.createRandomAccessFile();){
            try (RandomAccessFileInputStream inputStream = new RandomAccessFileInputStream(file, false);){
                Assertions.assertEquals((Object)false, (Object)inputStream.isCloseOnClose());
            }
            file.read();
        }
    }

    @Test
    public void testCtorCloseOnCloseTrue() throws IOException {
        try (RandomAccessFile file = this.createRandomAccessFile();){
            try (RandomAccessFileInputStream inputStream = new RandomAccessFileInputStream(file, true);){
                Assertions.assertEquals((Object)true, (Object)inputStream.isCloseOnClose());
            }
            Assertions.assertThrows(IOException.class, () -> file.read());
        }
    }

    @Test
    public void testCtorNullFile() throws FileNotFoundException {
        Assertions.assertThrows(NullPointerException.class, () -> new RandomAccessFileInputStream(null));
    }

    @Test
    public void testGetters() throws IOException {
        try (RandomAccessFile file = this.createRandomAccessFile();
             RandomAccessFileInputStream inputStream = new RandomAccessFileInputStream(file, true);){
            Assertions.assertEquals((Object)file, (Object)inputStream.getRandomAccessFile());
            Assertions.assertEquals((Object)true, (Object)inputStream.isCloseOnClose());
        }
    }

    @Test
    public void testRead() throws IOException {
        try (RandomAccessFileInputStream inputStream = new RandomAccessFileInputStream(this.createRandomAccessFile(), true);){
            Assertions.assertEquals((int)65, (int)inputStream.read());
            Assertions.assertEquals((int)32, (int)inputStream.read());
            Assertions.assertEquals((int)84, (int)inputStream.read());
            Assertions.assertEquals((int)101, (int)inputStream.read());
            Assertions.assertEquals((int)115, (int)inputStream.read());
            Assertions.assertEquals((int)116, (int)inputStream.read());
            Assertions.assertEquals((int)32, (int)inputStream.read());
            Assertions.assertEquals((int)76, (int)inputStream.read());
            Assertions.assertEquals((int)105, (int)inputStream.read());
            Assertions.assertEquals((int)110, (int)inputStream.read());
            Assertions.assertEquals((int)101, (int)inputStream.read());
            Assertions.assertEquals((int)46, (int)inputStream.read());
            Assertions.assertEquals((int)1418, (int)inputStream.available());
            Assertions.assertEquals((long)1418L, (long)inputStream.availableLong());
        }
    }

    @Test
    public void testSkip() throws IOException {
        try (RandomAccessFile file = this.createRandomAccessFile();
             RandomAccessFileInputStream inputStream = new RandomAccessFileInputStream(file, false);){
            Assertions.assertEquals((long)0L, (long)inputStream.skip(-1L));
            Assertions.assertEquals((long)0L, (long)inputStream.skip(Integer.MIN_VALUE));
            Assertions.assertEquals((long)0L, (long)inputStream.skip(0L));
            Assertions.assertEquals((int)65, (int)inputStream.read());
            Assertions.assertEquals((long)1L, (long)inputStream.skip(1L));
            Assertions.assertEquals((int)84, (int)inputStream.read());
            Assertions.assertEquals((long)1L, (long)inputStream.skip(1L));
            Assertions.assertEquals((int)115, (int)inputStream.read());
            Assertions.assertEquals((long)1L, (long)inputStream.skip(1L));
            Assertions.assertEquals((int)32, (int)inputStream.read());
            Assertions.assertEquals((long)1L, (long)inputStream.skip(1L));
            Assertions.assertEquals((int)105, (int)inputStream.read());
            Assertions.assertEquals((long)1L, (long)inputStream.skip(1L));
            Assertions.assertEquals((int)101, (int)inputStream.read());
            Assertions.assertEquals((long)1L, (long)inputStream.skip(1L));
            Assertions.assertEquals((int)1418, (int)inputStream.available());
            Assertions.assertEquals((long)1418L, (long)inputStream.availableLong());
            Assertions.assertEquals((long)10L, (long)inputStream.skip(10L));
            Assertions.assertEquals((long)1408L, (long)inputStream.availableLong());
            long avail = inputStream.availableLong();
            Assertions.assertEquals((long)avail, (long)inputStream.skip(inputStream.availableLong()));
            Assertions.assertEquals((long)1430L, (long)file.length());
            Assertions.assertEquals((long)1430L, (long)file.getFilePointer());
            Assertions.assertEquals((long)0L, (long)inputStream.skip(1L));
            Assertions.assertEquals((long)0L, (long)inputStream.skip(1000000000000L));
        }
    }

    @Test
    public void testReadByteArray() throws IOException {
        try (RandomAccessFileInputStream inputStream = new RandomAccessFileInputStream(this.createRandomAccessFile(), true);){
            int dataLen = 12;
            byte[] buffer = new byte[12];
            Assertions.assertEquals((int)12, (int)inputStream.read(buffer));
            Assertions.assertArrayEquals((byte[])"A Test Line.".getBytes(StandardCharsets.ISO_8859_1), (byte[])buffer);
            Assertions.assertEquals((int)1418, (int)inputStream.available());
            Assertions.assertEquals((long)1418L, (long)inputStream.availableLong());
        }
    }

    @Test
    public void testReadByteArrayBounds() throws IOException {
        try (RandomAccessFileInputStream inputStream = new RandomAccessFileInputStream(this.createRandomAccessFile(), true);){
            int dataLen = 12;
            byte[] buffer = new byte[12];
            Assertions.assertEquals((int)12, (int)inputStream.read(buffer, 0, 12));
            Assertions.assertArrayEquals((byte[])"A Test Line.".getBytes(StandardCharsets.ISO_8859_1), (byte[])buffer);
            Assertions.assertEquals((int)1418, (int)inputStream.available());
            Assertions.assertEquals((long)1418L, (long)inputStream.availableLong());
        }
    }
}

