/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.CharArrayReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.Random;
import org.apache.commons.io.input.ReaderInputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ReaderInputStreamTest {
    private static final String TEST_STRING = "\u00e0 peine arriv\u00e9s nous entr\u00e2mes dans sa chambre";
    private static final String LARGE_TEST_STRING;
    private final Random random = new Random();

    private void testWithSingleByteRead(String testString, String charsetName) throws IOException {
        byte[] bytes = testString.getBytes(charsetName);
        ReaderInputStream in = new ReaderInputStream((Reader)new StringReader(testString), charsetName);
        for (byte b : bytes) {
            int read = in.read();
            Assertions.assertTrue((read >= 0 ? 1 : 0) != 0);
            Assertions.assertTrue((read <= 255 ? 1 : 0) != 0);
            Assertions.assertEquals((byte)b, (byte)((byte)read));
        }
        Assertions.assertEquals((int)-1, (int)in.read());
        in.close();
    }

    private void testWithBufferedRead(String testString, String charsetName) throws IOException {
        byte[] expected = testString.getBytes(charsetName);
        ReaderInputStream in = new ReaderInputStream((Reader)new StringReader(testString), charsetName);
        byte[] buffer = new byte[128];
        int offset = 0;
        block0: while (true) {
            int bufferLength;
            int bufferOffset;
            int read;
            if ((read = in.read(buffer, bufferOffset = this.random.nextInt(64), bufferLength = this.random.nextInt(64))) == -1) {
                Assertions.assertEquals((int)offset, (int)expected.length);
                break;
            }
            Assertions.assertTrue((read <= bufferLength ? 1 : 0) != 0);
            while (true) {
                if (read <= 0) continue block0;
                Assertions.assertTrue((offset < expected.length ? 1 : 0) != 0);
                Assertions.assertEquals((byte)expected[offset], (byte)buffer[bufferOffset]);
                ++offset;
                ++bufferOffset;
                --read;
            }
            break;
        }
        in.close();
    }

    @Test
    public void testUTF8WithSingleByteRead() throws IOException {
        this.testWithSingleByteRead(TEST_STRING, "UTF-8");
    }

    @Test
    public void testLargeUTF8WithSingleByteRead() throws IOException {
        this.testWithSingleByteRead(LARGE_TEST_STRING, "UTF-8");
    }

    @Test
    public void testUTF8WithBufferedRead() throws IOException {
        this.testWithBufferedRead(TEST_STRING, "UTF-8");
    }

    @Test
    public void testLargeUTF8WithBufferedRead() throws IOException {
        this.testWithBufferedRead(LARGE_TEST_STRING, "UTF-8");
    }

    @Test
    public void testUTF16WithSingleByteRead() throws IOException {
        this.testWithSingleByteRead(TEST_STRING, "UTF-16");
    }

    @Test
    public void testReadZero() throws Exception {
        String inStr = "test";
        ReaderInputStream r = new ReaderInputStream((Reader)new StringReader("test"));
        byte[] bytes = new byte[30];
        Assertions.assertEquals((int)0, (int)r.read(bytes, 0, 0));
        Assertions.assertEquals((int)"test".length(), (int)r.read(bytes, 0, "test".length() + 1));
        Assertions.assertEquals((int)0, (int)r.read(bytes, 0, 0));
        r.close();
    }

    @Test
    public void testReadZeroEmptyString() throws Exception {
        ReaderInputStream r = new ReaderInputStream((Reader)new StringReader(""));
        byte[] bytes = new byte[30];
        Assertions.assertEquals((int)0, (int)r.read(bytes, 0, 0));
        Assertions.assertEquals((int)-1, (int)r.read(bytes, 0, 1));
        Assertions.assertEquals((int)0, (int)r.read(bytes, 0, 0));
        Assertions.assertEquals((int)-1, (int)r.read(bytes, 0, 1));
        r.close();
    }

    @Test
    public void testCharsetMismatchInfiniteLoop() throws IOException {
        char[] inputChars = new char[]{'\u00e0', '\u00b2', '\u00a0'};
        Charset charset = Charset.forName("ASCII");
        try (ReaderInputStream stream = new ReaderInputStream((Reader)new CharArrayReader(inputChars), charset);){
            while (stream.read() != -1) {
            }
        }
    }

    static {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < 100; ++i) {
            buffer.append(TEST_STRING);
        }
        LARGE_TEST_STRING = buffer.toString();
    }
}

