/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.IOException;
import org.apache.commons.io.input.UnsynchronizedByteArrayInputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class UnsynchronizedByteArrayInputStreamTest {
    @Test
    public void testConstructor1() throws IOException {
        byte[] empty = new byte[]{};
        byte[] one = new byte[1];
        byte[] some = new byte[25];
        UnsynchronizedByteArrayInputStream is = new UnsynchronizedByteArrayInputStream(empty);
        Assertions.assertEquals((int)empty.length, (int)is.available());
        is.close();
        is = new UnsynchronizedByteArrayInputStream(one);
        Assertions.assertEquals((int)one.length, (int)is.available());
        is.close();
        is = new UnsynchronizedByteArrayInputStream(some);
        Assertions.assertEquals((int)some.length, (int)is.available());
        is.close();
    }

    @Test
    public void testConstructor2() {
        byte[] empty = new byte[]{};
        byte[] one = new byte[1];
        byte[] some = new byte[25];
        UnsynchronizedByteArrayInputStream is = new UnsynchronizedByteArrayInputStream(empty, 0);
        Assertions.assertEquals((int)empty.length, (int)is.available());
        is = new UnsynchronizedByteArrayInputStream(empty, 1);
        Assertions.assertEquals((int)0, (int)is.available());
        is = new UnsynchronizedByteArrayInputStream(one, 0);
        Assertions.assertEquals((int)one.length, (int)is.available());
        is = new UnsynchronizedByteArrayInputStream(one, 1);
        Assertions.assertEquals((int)0, (int)is.available());
        is = new UnsynchronizedByteArrayInputStream(one, 2);
        Assertions.assertEquals((int)0, (int)is.available());
        is = new UnsynchronizedByteArrayInputStream(some, 0);
        Assertions.assertEquals((int)some.length, (int)is.available());
        is = new UnsynchronizedByteArrayInputStream(some, 1);
        Assertions.assertEquals((int)(some.length - 1), (int)is.available());
        is = new UnsynchronizedByteArrayInputStream(some, 10);
        Assertions.assertEquals((int)(some.length - 10), (int)is.available());
        is = new UnsynchronizedByteArrayInputStream(some, some.length);
        Assertions.assertEquals((int)0, (int)is.available());
    }

    @Test
    public void testConstructor3() {
        byte[] empty = new byte[]{};
        byte[] one = new byte[1];
        byte[] some = new byte[25];
        UnsynchronizedByteArrayInputStream is = new UnsynchronizedByteArrayInputStream(empty, 0);
        Assertions.assertEquals((int)empty.length, (int)is.available());
        is = new UnsynchronizedByteArrayInputStream(empty, 1);
        Assertions.assertEquals((int)0, (int)is.available());
        is = new UnsynchronizedByteArrayInputStream(empty, 0, 1);
        Assertions.assertEquals((int)0, (int)is.available());
        is = new UnsynchronizedByteArrayInputStream(empty, 1, 1);
        Assertions.assertEquals((int)0, (int)is.available());
        is = new UnsynchronizedByteArrayInputStream(one, 0);
        Assertions.assertEquals((int)one.length, (int)is.available());
        is = new UnsynchronizedByteArrayInputStream(one, 1);
        Assertions.assertEquals((int)(one.length - 1), (int)is.available());
        is = new UnsynchronizedByteArrayInputStream(one, 2);
        Assertions.assertEquals((int)0, (int)is.available());
        is = new UnsynchronizedByteArrayInputStream(one, 0, 1);
        Assertions.assertEquals((int)1, (int)is.available());
        is = new UnsynchronizedByteArrayInputStream(one, 1, 1);
        Assertions.assertEquals((int)0, (int)is.available());
        is = new UnsynchronizedByteArrayInputStream(one, 0, 2);
        Assertions.assertEquals((int)1, (int)is.available());
        is = new UnsynchronizedByteArrayInputStream(one, 2, 1);
        Assertions.assertEquals((int)0, (int)is.available());
        is = new UnsynchronizedByteArrayInputStream(one, 2, 2);
        Assertions.assertEquals((int)0, (int)is.available());
        is = new UnsynchronizedByteArrayInputStream(some, 0);
        Assertions.assertEquals((int)some.length, (int)is.available());
        is = new UnsynchronizedByteArrayInputStream(some, 1);
        Assertions.assertEquals((int)(some.length - 1), (int)is.available());
        is = new UnsynchronizedByteArrayInputStream(some, 10);
        Assertions.assertEquals((int)(some.length - 10), (int)is.available());
        is = new UnsynchronizedByteArrayInputStream(some, some.length);
        Assertions.assertEquals((int)0, (int)is.available());
        is = new UnsynchronizedByteArrayInputStream(some, some.length, some.length);
        Assertions.assertEquals((int)0, (int)is.available());
        is = new UnsynchronizedByteArrayInputStream(some, some.length - 1, some.length);
        Assertions.assertEquals((int)1, (int)is.available());
        is = new UnsynchronizedByteArrayInputStream(some, 0, 7);
        Assertions.assertEquals((int)7, (int)is.available());
        is = new UnsynchronizedByteArrayInputStream(some, 7, 7);
        Assertions.assertEquals((int)7, (int)is.available());
        is = new UnsynchronizedByteArrayInputStream(some, 0, some.length * 2);
        Assertions.assertEquals((int)some.length, (int)is.available());
        is = new UnsynchronizedByteArrayInputStream(some, some.length - 1, 7);
        Assertions.assertEquals((int)1, (int)is.available());
    }

    @Test
    public void testInvalidConstructor2OffsetUnder() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new UnsynchronizedByteArrayInputStream(new byte[0], -1));
    }

    @Test
    public void testInvalidConstructor3LengthUnder() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new UnsynchronizedByteArrayInputStream(new byte[0], 0, -1));
    }

    @Test
    public void testInvalidConstructor3OffsetUnder() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new UnsynchronizedByteArrayInputStream(new byte[0], -1, 1));
    }

    @Test
    public void testInvalidReadArrayExplicitLenUnder() {
        byte[] buf = new byte[]{};
        UnsynchronizedByteArrayInputStream is = new UnsynchronizedByteArrayInputStream(new byte[]{10, 11, 12});
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> is.read(buf, 0, -1));
    }

    @Test
    public void testInvalidReadArrayExplicitOffsetUnder() {
        byte[] buf = new byte[]{};
        UnsynchronizedByteArrayInputStream is = new UnsynchronizedByteArrayInputStream(new byte[]{10, 11, 12});
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> is.read(buf, -1, 1));
    }

    @Test
    public void testInvalidReadArrayExplicitRangeOver() {
        byte[] buf = new byte[]{};
        UnsynchronizedByteArrayInputStream is = new UnsynchronizedByteArrayInputStream(new byte[]{10, 11, 12});
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> is.read(buf, 0, 1));
    }

    @Test
    public void testInvalidReadArrayNull() {
        byte[] buf = null;
        UnsynchronizedByteArrayInputStream is = new UnsynchronizedByteArrayInputStream(new byte[]{10, 11, 12});
        Assertions.assertThrows(NullPointerException.class, () -> is.read(buf));
    }

    @Test
    public void testInvalidSkipNUnder() {
        UnsynchronizedByteArrayInputStream is = new UnsynchronizedByteArrayInputStream(new byte[]{10, 11, 12});
        Assertions.assertThrows(IllegalArgumentException.class, () -> is.skip(-1L));
    }

    @Test
    public void testMarkReset() {
        UnsynchronizedByteArrayInputStream is = new UnsynchronizedByteArrayInputStream(new byte[]{10, 11, 12});
        Assertions.assertTrue((boolean)is.markSupported());
        Assertions.assertEquals((int)10, (int)is.read());
        Assertions.assertTrue((boolean)is.markSupported());
        is.mark(10);
        Assertions.assertEquals((int)11, (int)is.read());
        Assertions.assertEquals((int)12, (int)is.read());
        is.reset();
        Assertions.assertEquals((int)11, (int)is.read());
        Assertions.assertEquals((int)12, (int)is.read());
        Assertions.assertEquals((int)-1, (int)is.read());
        is.reset();
        Assertions.assertEquals((int)11, (int)is.read());
        Assertions.assertEquals((int)12, (int)is.read());
        Assertions.assertEquals((int)-1, (int)is.read());
    }

    @Test
    public void testReadArray() {
        byte[] buf = new byte[10];
        UnsynchronizedByteArrayInputStream is = new UnsynchronizedByteArrayInputStream(new byte[0]);
        int read = is.read(buf);
        Assertions.assertEquals((int)-1, (int)read);
        Assertions.assertArrayEquals((byte[])new byte[10], (byte[])buf);
        buf = new byte[]{};
        is = new UnsynchronizedByteArrayInputStream(new byte[]{10, 11, 12});
        read = is.read(buf);
        Assertions.assertEquals((int)0, (int)read);
        buf = new byte[10];
        is = new UnsynchronizedByteArrayInputStream(new byte[]{10, 11, 12});
        read = is.read(buf);
        Assertions.assertEquals((int)3, (int)read);
        Assertions.assertEquals((int)10, (int)buf[0]);
        Assertions.assertEquals((int)11, (int)buf[1]);
        Assertions.assertEquals((int)12, (int)buf[2]);
        Assertions.assertEquals((int)0, (int)buf[3]);
        buf = new byte[2];
        is = new UnsynchronizedByteArrayInputStream(new byte[]{10, 11, 12});
        read = is.read(buf);
        Assertions.assertEquals((int)2, (int)read);
        Assertions.assertEquals((int)10, (int)buf[0]);
        Assertions.assertEquals((int)11, (int)buf[1]);
        read = is.read(buf);
        Assertions.assertEquals((int)1, (int)read);
        Assertions.assertEquals((int)12, (int)buf[0]);
    }

    @Test
    public void testReadArrayExplicit() {
        byte[] buf = new byte[10];
        UnsynchronizedByteArrayInputStream is = new UnsynchronizedByteArrayInputStream(new byte[0]);
        int read = is.read(buf, 0, 10);
        Assertions.assertEquals((int)-1, (int)read);
        Assertions.assertArrayEquals((byte[])new byte[10], (byte[])buf);
        buf = new byte[10];
        is = new UnsynchronizedByteArrayInputStream(new byte[0]);
        read = is.read(buf, 4, 2);
        Assertions.assertEquals((int)-1, (int)read);
        Assertions.assertArrayEquals((byte[])new byte[10], (byte[])buf);
        buf = new byte[10];
        is = new UnsynchronizedByteArrayInputStream(new byte[0]);
        read = is.read(buf, 4, 6);
        Assertions.assertEquals((int)-1, (int)read);
        Assertions.assertArrayEquals((byte[])new byte[10], (byte[])buf);
        buf = new byte[]{};
        is = new UnsynchronizedByteArrayInputStream(new byte[]{10, 11, 12});
        read = is.read(buf, 0, 0);
        Assertions.assertEquals((int)0, (int)read);
        buf = new byte[10];
        is = new UnsynchronizedByteArrayInputStream(new byte[]{10, 11, 12});
        read = is.read(buf, 0, 2);
        Assertions.assertEquals((int)2, (int)read);
        Assertions.assertEquals((int)10, (int)buf[0]);
        Assertions.assertEquals((int)11, (int)buf[1]);
        Assertions.assertEquals((int)0, (int)buf[2]);
        read = is.read(buf, 0, 10);
        Assertions.assertEquals((int)1, (int)read);
        Assertions.assertEquals((int)12, (int)buf[0]);
    }

    @Test
    public void testReadSingle() {
        UnsynchronizedByteArrayInputStream is = new UnsynchronizedByteArrayInputStream(new byte[0]);
        Assertions.assertEquals((int)-1, (int)is.read());
        is = new UnsynchronizedByteArrayInputStream(new byte[]{10, 11, 12});
        Assertions.assertEquals((int)10, (int)is.read());
        Assertions.assertEquals((int)11, (int)is.read());
        Assertions.assertEquals((int)12, (int)is.read());
        Assertions.assertEquals((int)-1, (int)is.read());
    }

    @Test
    public void testSkip() {
        UnsynchronizedByteArrayInputStream is = new UnsynchronizedByteArrayInputStream(new byte[]{10, 11, 12});
        Assertions.assertEquals((int)3, (int)is.available());
        is.skip(1L);
        Assertions.assertEquals((int)2, (int)is.available());
        Assertions.assertEquals((int)11, (int)is.read());
        is.skip(1L);
        Assertions.assertEquals((int)0, (int)is.available());
        Assertions.assertEquals((int)-1, (int)is.read());
        is = new UnsynchronizedByteArrayInputStream(new byte[]{10, 11, 12});
        Assertions.assertEquals((int)3, (int)is.available());
        is.skip(0L);
        Assertions.assertEquals((int)3, (int)is.available());
        Assertions.assertEquals((int)10, (int)is.read());
        is = new UnsynchronizedByteArrayInputStream(new byte[]{10, 11, 12});
        Assertions.assertEquals((int)3, (int)is.available());
        is.skip(2L);
        Assertions.assertEquals((int)1, (int)is.available());
        Assertions.assertEquals((int)12, (int)is.read());
        Assertions.assertEquals((int)-1, (int)is.read());
        is = new UnsynchronizedByteArrayInputStream(new byte[]{10, 11, 12});
        Assertions.assertEquals((int)3, (int)is.available());
        is.skip(3L);
        Assertions.assertEquals((int)0, (int)is.available());
        Assertions.assertEquals((int)-1, (int)is.read());
        is = new UnsynchronizedByteArrayInputStream(new byte[]{10, 11, 12});
        Assertions.assertEquals((int)3, (int)is.available());
        is.skip(999L);
        Assertions.assertEquals((int)0, (int)is.available());
        Assertions.assertEquals((int)-1, (int)is.read());
    }
}

