/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.input.WindowsLineEndingInputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class WindowsLineEndingInputStreamTest {
    @Test
    public void simpleString() throws Exception {
        Assertions.assertEquals((Object)"abc\r\n", (Object)this.roundtrip("abc"));
    }

    @Test
    public void inTheMiddleOfTheLine() throws Exception {
        Assertions.assertEquals((Object)"a\r\nbc\r\n", (Object)this.roundtrip("a\r\nbc"));
    }

    @Test
    public void multipleBlankLines() throws Exception {
        Assertions.assertEquals((Object)"a\r\n\r\nbc\r\n", (Object)this.roundtrip("a\r\n\r\nbc"));
    }

    @Test
    public void twoLinesAtEnd() throws Exception {
        Assertions.assertEquals((Object)"a\r\n\r\n", (Object)this.roundtrip("a\r\n\r\n"));
    }

    @Test
    public void linuxLinefeeds() throws Exception {
        String roundtrip = this.roundtrip("ab\nc", false);
        Assertions.assertEquals((Object)"ab\r\nc", (Object)roundtrip);
    }

    @Test
    public void malformed() throws Exception {
        Assertions.assertEquals((Object)"a\rbc", (Object)this.roundtrip("a\rbc", false));
    }

    @Test
    public void retainLineFeed() throws Exception {
        Assertions.assertEquals((Object)"a\r\n\r\n", (Object)this.roundtrip("a\r\n\r\n", false));
        Assertions.assertEquals((Object)"a", (Object)this.roundtrip("a", false));
    }

    private String roundtrip(String msg) throws IOException {
        return this.roundtrip(msg, true);
    }

    private String roundtrip(String msg, boolean ensure) throws IOException {
        ByteArrayInputStream baos = new ByteArrayInputStream(msg.getBytes("UTF-8"));
        WindowsLineEndingInputStream lf = new WindowsLineEndingInputStream((InputStream)baos, ensure);
        byte[] buf = new byte[100];
        int read = lf.read(buf);
        lf.close();
        return new String(buf, 0, read, "UTF-8");
    }
}

