/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.io.output.CloseShieldOutputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class CloseShieldOutputStreamTest {
    private ByteArrayOutputStream original;
    private OutputStream shielded;
    private boolean closed;

    @BeforeEach
    public void setUp() {
        this.original = new ByteArrayOutputStream(){

            public void close() {
                CloseShieldOutputStreamTest.this.closed = true;
            }
        };
        this.shielded = new CloseShieldOutputStream((OutputStream)this.original);
        this.closed = false;
    }

    @Test
    public void testClose() throws IOException {
        this.shielded.close();
        Assertions.assertFalse((boolean)this.closed, (String)"closed");
        try {
            this.shielded.write(120);
            Assertions.fail((String)"write(b)");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.original.write(121);
        Assertions.assertEquals((int)1, (int)this.original.size());
        Assertions.assertEquals((int)121, (int)this.original.toByteArray()[0]);
    }
}

