/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.serialization;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.UUID;
import java.util.regex.Pattern;
import org.apache.commons.io.serialization.ClassNameMatcher;
import org.apache.commons.io.serialization.ClosingBase;
import org.apache.commons.io.serialization.MockSerializedClass;
import org.apache.commons.io.serialization.ValidatingObjectInputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ValidatingObjectInputStreamTest
extends ClosingBase {
    private MockSerializedClass testObject;
    private InputStream testStream;
    private static final ClassNameMatcher ALWAYS_TRUE = className -> true;

    @Override
    @BeforeEach
    public void setup() throws IOException {
        this.testObject = new MockSerializedClass(UUID.randomUUID().toString());
        ByteArrayOutputStream bos = this.willClose(new ByteArrayOutputStream());
        ObjectOutputStream oos = this.willClose(new ObjectOutputStream(bos));
        oos.writeObject(this.testObject);
        this.testStream = this.willClose(new ByteArrayInputStream(bos.toByteArray()));
    }

    private void assertSerialization(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        MockSerializedClass result = (MockSerializedClass)ois.readObject();
        Assertions.assertEquals((Object)this.testObject, (Object)result);
    }

    @Test
    public void noAccept() {
        Assertions.assertThrows(InvalidClassException.class, () -> this.assertSerialization((ObjectInputStream)this.willClose(new ValidatingObjectInputStream(this.testStream))));
    }

    @Test
    public void exceptionIncludesClassName() throws Exception {
        try {
            this.assertSerialization((ObjectInputStream)this.willClose(new ValidatingObjectInputStream(this.testStream)));
            Assertions.fail((String)"Expected an InvalidClassException");
        }
        catch (InvalidClassException ice) {
            String name = MockSerializedClass.class.getName();
            Assertions.assertTrue((boolean)ice.getMessage().contains(name), (String)("Expecting message to contain " + name));
        }
    }

    @Test
    public void acceptCustomMatcher() throws Exception {
        this.assertSerialization((ObjectInputStream)this.willClose(new ValidatingObjectInputStream(this.testStream)).accept(ALWAYS_TRUE));
    }

    @Test
    public void rejectCustomMatcher() {
        Assertions.assertThrows(InvalidClassException.class, () -> this.assertSerialization((ObjectInputStream)this.willClose(new ValidatingObjectInputStream(this.testStream)).accept(new Class[]{MockSerializedClass.class}).reject(ALWAYS_TRUE)));
    }

    @Test
    public void acceptPattern() throws Exception {
        this.assertSerialization((ObjectInputStream)this.willClose(new ValidatingObjectInputStream(this.testStream)).accept(Pattern.compile(".*MockSerializedClass.*")));
    }

    @Test
    public void rejectPattern() {
        Assertions.assertThrows(InvalidClassException.class, () -> this.assertSerialization((ObjectInputStream)this.willClose(new ValidatingObjectInputStream(this.testStream)).accept(new Class[]{MockSerializedClass.class}).reject(Pattern.compile("org.*"))));
    }

    @Test
    public void acceptWildcard() throws Exception {
        this.assertSerialization((ObjectInputStream)this.willClose(new ValidatingObjectInputStream(this.testStream)).accept(new String[]{"org.apache.commons.io.*"}));
    }

    @Test
    public void rejectWildcard() {
        Assertions.assertThrows(InvalidClassException.class, () -> this.assertSerialization((ObjectInputStream)this.willClose(new ValidatingObjectInputStream(this.testStream)).accept(new Class[]{MockSerializedClass.class}).reject(new String[]{"org.*"})));
    }

    @Test
    public void ourTestClassNotAccepted() {
        Assertions.assertThrows(InvalidClassException.class, () -> this.assertSerialization((ObjectInputStream)this.willClose(new ValidatingObjectInputStream(this.testStream)).accept(new Class[]{Integer.class})));
    }

    @Test
    public void ourTestClassOnlyAccepted() throws Exception {
        this.assertSerialization((ObjectInputStream)this.willClose(new ValidatingObjectInputStream(this.testStream)).accept(new Class[]{MockSerializedClass.class}));
    }

    @Test
    public void ourTestClassAcceptedFirst() throws Exception {
        this.assertSerialization((ObjectInputStream)this.willClose(new ValidatingObjectInputStream(this.testStream)).accept(new Class[]{MockSerializedClass.class, Integer.class}));
    }

    @Test
    public void ourTestClassAcceptedSecond() throws Exception {
        this.assertSerialization((ObjectInputStream)this.willClose(new ValidatingObjectInputStream(this.testStream)).accept(new Class[]{Integer.class, MockSerializedClass.class}));
    }

    @Test
    public void ourTestClassAcceptedFirstWildcard() throws Exception {
        this.assertSerialization((ObjectInputStream)this.willClose(new ValidatingObjectInputStream(this.testStream)).accept(new String[]{"*MockSerializedClass", "*Integer"}));
    }

    @Test
    public void ourTestClassAcceptedSecondWildcard() throws Exception {
        this.assertSerialization((ObjectInputStream)this.willClose(new ValidatingObjectInputStream(this.testStream)).accept(new String[]{"*Integer", "*MockSerializedClass"}));
    }

    @Test
    public void reject() {
        Assertions.assertThrows(InvalidClassException.class, () -> this.assertSerialization((ObjectInputStream)this.willClose(new ValidatingObjectInputStream(this.testStream)).accept(new Class[]{Long.class}).reject(new Class[]{MockSerializedClass.class, Integer.class})));
    }

    @Test
    public void rejectPrecedence() {
        Assertions.assertThrows(InvalidClassException.class, () -> this.assertSerialization((ObjectInputStream)this.willClose(new ValidatingObjectInputStream(this.testStream)).accept(new Class[]{MockSerializedClass.class}).reject(new Class[]{MockSerializedClass.class, Integer.class})));
    }

    @Test
    public void rejectOnly() throws Exception {
        Assertions.assertThrows(InvalidClassException.class, () -> this.assertSerialization((ObjectInputStream)this.willClose(new ValidatingObjectInputStream(this.testStream)).reject(new Class[]{Integer.class})));
    }

    @Test
    public void customInvalidMethod() throws Exception {
        Assertions.assertThrows(RuntimeException.class, () -> {
            class CustomVOIS
            extends ValidatingObjectInputStream {
                CustomVOIS(InputStream is) throws IOException {
                    super(is);
                }

                protected void invalidClassNameFound(String className) throws InvalidClassException {
                    throw new RuntimeException("Custom exception");
                }
            }
            this.assertSerialization((ObjectInputStream)this.willClose(new CustomVOIS(this.testStream)).reject(new Class[]{Integer.class}));
        });
    }
}

