/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.XmlStreamReader;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junitpioneer.jupiter.DefaultLocale;

public class XmlStreamReaderTest {
    private static final String XML5 = "xml-prolog-encoding-spaced-single-quotes";
    private static final String XML4 = "xml-prolog-encoding-single-quotes";
    private static final String XML3 = "xml-prolog-encoding-double-quotes";
    private static final String XML2 = "xml-prolog";
    private static final String XML1 = "xml";
    private static final String ENCODING_ATTRIBUTE_XML = "<?xml version=\"1.0\" ?> \n<atom:feed xmlns:atom=\"http://www.w3.org/2005/Atom\">\n\n  <atom:entry>\n    <atom:title encoding='base64'><![CDATA\naW5nTGluZSIgLz4";
    private static final int[] NO_BOM_BYTES = new int[0];
    private static final int[] UTF_16BE_BOM_BYTES = new int[]{254, 255};
    private static final int[] UTF_16LE_BOM_BYTES = new int[]{255, 254};
    private static final int[] UTF_32BE_BOM_BYTES = new int[]{0, 0, 254, 255};
    private static final int[] UTF_32LE_BOM_BYTES = new int[]{255, 254, 0, 0};
    private static final int[] UTF_8_BOM_BYTES = new int[]{239, 187, 191};
    private static final Map<String, int[]> BOMs = new HashMap<String, int[]>();
    private static final MessageFormat XML;
    private static final MessageFormat XML_WITH_PROLOG;
    private static final MessageFormat XML_WITH_PROLOG_AND_ENCODING_DOUBLE_QUOTES;
    private static final MessageFormat XML_WITH_PROLOG_AND_ENCODING_SINGLE_QUOTES;
    private static final MessageFormat XML_WITH_PROLOG_AND_ENCODING_SPACED_SINGLE_QUOTES;
    private static final MessageFormat INFO;
    private static final Map<String, MessageFormat> XMLs;

    protected void _testRawNoBomValid(String encoding) throws Exception {
        InputStream is = this.getXmlStream("no-bom", XML1, encoding, encoding);
        XmlStreamReader xmlReader = new XmlStreamReader(is, false);
        Assertions.assertEquals((Object)xmlReader.getEncoding(), (Object)"UTF-8");
        xmlReader.close();
        is = this.getXmlStream("no-bom", XML2, encoding, encoding);
        xmlReader = new XmlStreamReader(is);
        Assertions.assertEquals((Object)xmlReader.getEncoding(), (Object)"UTF-8");
        xmlReader.close();
        is = this.getXmlStream("no-bom", XML3, encoding, encoding);
        xmlReader = new XmlStreamReader(is);
        Assertions.assertEquals((Object)xmlReader.getEncoding(), (Object)encoding);
        xmlReader.close();
        is = this.getXmlStream("no-bom", XML4, encoding, encoding);
        xmlReader = new XmlStreamReader(is);
        Assertions.assertEquals((Object)xmlReader.getEncoding(), (Object)encoding);
        xmlReader.close();
        is = this.getXmlStream("no-bom", XML5, encoding, encoding);
        xmlReader = new XmlStreamReader(is);
        Assertions.assertEquals((Object)xmlReader.getEncoding(), (Object)encoding);
        xmlReader.close();
    }

    protected void _testRawNoBomInvalid(String encoding) throws Exception {
        InputStream is = this.getXmlStream("no-bom", XML3, encoding, encoding);
        try {
            new XmlStreamReader(is, false).close();
            Assertions.fail((String)"It should have failed");
        }
        catch (IOException ex) {
            Assertions.assertTrue((boolean)ex.getMessage().contains("Invalid encoding,"));
        }
    }

    @Test
    protected void testNullFileInput() {
        Assertions.assertThrows(NullPointerException.class, () -> new XmlStreamReader((File)null));
    }

    @Test
    protected void testNullInputStreamInput() {
        Assertions.assertThrows(NullPointerException.class, () -> new XmlStreamReader((InputStream)null));
    }

    @Test
    protected void testNullURLInput() {
        Assertions.assertThrows(NullPointerException.class, () -> new XmlStreamReader((URL)null));
    }

    @Test
    protected void testNullURLConnectionInput() {
        Assertions.assertThrows(NullPointerException.class, () -> new XmlStreamReader((URLConnection)null, "US-ASCII"));
    }

    @Test
    public void testRawNoBomUsAscii() throws Exception {
        this._testRawNoBomValid("US-ASCII");
    }

    @Test
    public void testRawNoBomUtf8() throws Exception {
        this._testRawNoBomValid("UTF-8");
    }

    @Test
    public void testRawNoBomUtf16BE() throws Exception {
        this._testRawNoBomValid("UTF-16BE");
    }

    @Test
    public void testRawNoBomUtf16LE() throws Exception {
        this._testRawNoBomValid("UTF-16LE");
    }

    @Test
    public void testRawNoBomUtf32BE() throws Exception {
        this._testRawNoBomValid("UTF-32BE");
    }

    @Test
    public void testRawNoBomUtf32LE() throws Exception {
        this._testRawNoBomValid("UTF-32LE");
    }

    @Test
    public void testRawNoBomIso8859_1() throws Exception {
        this._testRawNoBomValid("ISO-8859-1");
    }

    @Test
    public void testRawNoBomCp1047() throws Exception {
        this._testRawNoBomValid("CP1047");
    }

    protected void _testRawBomValid(String encoding) throws Exception {
        InputStream is = this.getXmlStream(encoding + "-bom", XML3, encoding, encoding);
        XmlStreamReader xmlReader = new XmlStreamReader(is, false);
        if (!encoding.equals("UTF-16") && !encoding.equals("UTF-32")) {
            Assertions.assertEquals((Object)xmlReader.getEncoding(), (Object)encoding);
        } else {
            Assertions.assertEquals((Object)xmlReader.getEncoding().substring(0, encoding.length()), (Object)encoding);
        }
        xmlReader.close();
    }

    protected void _testRawBomInvalid(String bomEnc, String streamEnc, String prologEnc) throws Exception {
        InputStream is = this.getXmlStream(bomEnc, XML3, streamEnc, prologEnc);
        XmlStreamReader xmlReader = null;
        try {
            xmlReader = new XmlStreamReader(is, false);
            String foundEnc = xmlReader.getEncoding();
            Assertions.fail((String)("Expected IOException for BOM " + bomEnc + ", streamEnc " + streamEnc + " and prologEnc " + prologEnc + ": found " + foundEnc));
        }
        catch (IOException ex) {
            Assertions.assertTrue((boolean)ex.getMessage().contains("Invalid encoding,"));
        }
        if (xmlReader != null) {
            xmlReader.close();
        }
    }

    @Test
    public void testRawBomUtf8() throws Exception {
        this._testRawBomValid("UTF-8");
        this._testRawBomInvalid("UTF-8-bom", "US-ASCII", "US-ASCII");
        this._testRawBomInvalid("UTF-8-bom", "ISO-8859-1", "ISO-8859-1");
        this._testRawBomInvalid("UTF-8-bom", "UTF-8", "UTF-16");
        this._testRawBomInvalid("UTF-8-bom", "UTF-8", "UTF-16BE");
        this._testRawBomInvalid("UTF-8-bom", "UTF-8", "UTF-16LE");
        this._testRawBomInvalid("UTF-16BE-bom", "UTF-16BE", "UTF-16LE");
        this._testRawBomInvalid("UTF-16LE-bom", "UTF-16LE", "UTF-16BE");
        this._testRawBomInvalid("UTF-16LE-bom", "UTF-16LE", "UTF-8");
        this._testRawBomInvalid("UTF-32BE-bom", "UTF-32BE", "UTF-32LE");
        this._testRawBomInvalid("UTF-32LE-bom", "UTF-32LE", "UTF-32BE");
        this._testRawBomInvalid("UTF-32LE-bom", "UTF-32LE", "UTF-8");
    }

    @Test
    public void testRawBomUtf16() throws Exception {
        this._testRawBomValid("UTF-16BE");
        this._testRawBomValid("UTF-16LE");
        this._testRawBomValid("UTF-16");
        this._testRawBomInvalid("UTF-16BE-bom", "UTF-16BE", "UTF-16LE");
        this._testRawBomInvalid("UTF-16LE-bom", "UTF-16LE", "UTF-16BE");
        this._testRawBomInvalid("UTF-16LE-bom", "UTF-16LE", "UTF-8");
    }

    @Test
    public void testRawBomUtf32() throws Exception {
        this._testRawBomValid("UTF-32BE");
        this._testRawBomValid("UTF-32LE");
        this._testRawBomValid("UTF-32");
        this._testRawBomInvalid("UTF-32BE-bom", "UTF-32BE", "UTF-32LE");
        this._testRawBomInvalid("UTF-32LE-bom", "UTF-32LE", "UTF-32BE");
        this._testRawBomInvalid("UTF-32LE-bom", "UTF-32LE", "UTF-8");
    }

    @Test
    public void testHttp() throws Exception {
        this._testHttpValid("application/xml", "UTF-8-bom", "UTF-8", null);
        this._testHttpValid("application/xml", "UTF-8-bom", "UTF-8", "UTF-8");
        this._testHttpValid("application/xml;charset=UTF-8", "UTF-8-bom", "UTF-8", null);
        this._testHttpValid("application/xml;charset=\"UTF-8\"", "UTF-8-bom", "UTF-8", null);
        this._testHttpValid("application/xml;charset='UTF-8'", "UTF-8-bom", "UTF-8", null);
        this._testHttpValid("application/xml;charset=UTF-8", "UTF-8-bom", "UTF-8", "UTF-8");
        this._testHttpValid("application/xml;charset=UTF-16", "UTF-16BE-bom", "UTF-16BE", null);
        this._testHttpValid("application/xml;charset=UTF-16", "UTF-16BE-bom", "UTF-16BE", "UTF-16");
        this._testHttpValid("application/xml;charset=UTF-16", "UTF-16BE-bom", "UTF-16BE", "UTF-16BE");
        this._testHttpInvalid("application/xml;charset=UTF-16BE", "UTF-16BE-bom", "UTF-16BE", null);
        this._testHttpInvalid("application/xml;charset=UTF-16BE", "UTF-16BE-bom", "UTF-16BE", "UTF-16");
        this._testHttpInvalid("application/xml;charset=UTF-16BE", "UTF-16BE-bom", "UTF-16BE", "UTF-16BE");
        this._testHttpInvalid("application/xml;charset=UTF-32BE", "UTF-32BE-bom", "UTF-32BE", null);
        this._testHttpInvalid("application/xml;charset=UTF-32BE", "UTF-32BE-bom", "UTF-32BE", "UTF-32");
        this._testHttpInvalid("application/xml;charset=UTF-32BE", "UTF-32BE-bom", "UTF-32BE", "UTF-32BE");
        this._testHttpInvalid("application/xml", "UTF-8-bom", "US-ASCII", "US-ASCII");
        this._testHttpInvalid("application/xml;charset=UTF-16", "UTF-16LE", "UTF-8", "UTF-8");
        this._testHttpInvalid("application/xml;charset=UTF-16", "no-bom", "UTF-16BE", "UTF-16BE");
        this._testHttpInvalid("application/xml;charset=UTF-32", "UTF-32LE", "UTF-8", "UTF-8");
        this._testHttpInvalid("application/xml;charset=UTF-32", "no-bom", "UTF-32BE", "UTF-32BE");
        this._testHttpValid("text/xml", "no-bom", "US-ASCII", null);
        this._testHttpValid("text/xml;charset=UTF-8", "UTF-8-bom", "UTF-8", "UTF-8");
        this._testHttpValid("text/xml;charset=UTF-8", "UTF-8-bom", "UTF-8", null);
        this._testHttpValid("text/xml;charset=UTF-16", "UTF-16BE-bom", "UTF-16BE", null);
        this._testHttpValid("text/xml;charset=UTF-16", "UTF-16BE-bom", "UTF-16BE", "UTF-16");
        this._testHttpValid("text/xml;charset=UTF-16", "UTF-16BE-bom", "UTF-16BE", "UTF-16BE");
        this._testHttpValid("text/xml;charset=UTF-32", "UTF-32BE-bom", "UTF-32BE", null);
        this._testHttpValid("text/xml;charset=UTF-32", "UTF-32BE-bom", "UTF-32BE", "UTF-32");
        this._testHttpValid("text/xml;charset=UTF-32", "UTF-32BE-bom", "UTF-32BE", "UTF-32BE");
        this._testHttpValid("text/xml", "UTF-8-bom", "US-ASCII", null);
        this._testAlternateDefaultEncoding("application/xml", "UTF-8-bom", "UTF-8", null, null);
        this._testAlternateDefaultEncoding("application/xml", "no-bom", "US-ASCII", null, "US-ASCII");
        this._testAlternateDefaultEncoding("application/xml", "UTF-8-bom", "UTF-8", null, "UTF-8");
        this._testAlternateDefaultEncoding("text/xml", "no-bom", "US-ASCII", null, null);
        this._testAlternateDefaultEncoding("text/xml", "no-bom", "US-ASCII", null, "US-ASCII");
        this._testAlternateDefaultEncoding("text/xml", "no-bom", "US-ASCII", null, "UTF-8");
        this._testHttpInvalid("text/xml;charset=UTF-16BE", "UTF-16BE-bom", "UTF-16BE", null);
        this._testHttpInvalid("text/xml;charset=UTF-16BE", "UTF-16BE-bom", "UTF-16BE", "UTF-16");
        this._testHttpInvalid("text/xml;charset=UTF-16BE", "UTF-16BE-bom", "UTF-16BE", "UTF-16BE");
        this._testHttpInvalid("text/xml;charset=UTF-16", "no-bom", "UTF-16BE", "UTF-16BE");
        this._testHttpInvalid("text/xml;charset=UTF-16", "no-bom", "UTF-16BE", null);
        this._testHttpInvalid("text/xml;charset=UTF-32BE", "UTF-32BE-bom", "UTF-32BE", null);
        this._testHttpInvalid("text/xml;charset=UTF-32BE", "UTF-32BE-bom", "UTF-32BE", "UTF-32");
        this._testHttpInvalid("text/xml;charset=UTF-32BE", "UTF-32BE-bom", "UTF-32BE", "UTF-32BE");
        this._testHttpInvalid("text/xml;charset=UTF-32", "no-bom", "UTF-32BE", "UTF-32BE");
        this._testHttpInvalid("text/xml;charset=UTF-32", "no-bom", "UTF-32BE", null);
        this._testHttpLenient("text/xml", "no-bom", "US-ASCII", null, "US-ASCII");
        this._testHttpLenient("text/xml;charset=UTF-8", "UTF-8-bom", "UTF-8", "UTF-8", "UTF-8");
        this._testHttpLenient("text/xml;charset=UTF-8", "UTF-8-bom", "UTF-8", null, "UTF-8");
        this._testHttpLenient("text/xml;charset=UTF-16", "UTF-16BE-bom", "UTF-16BE", null, "UTF-16BE");
        this._testHttpLenient("text/xml;charset=UTF-16", "UTF-16BE-bom", "UTF-16BE", "UTF-16", "UTF-16");
        this._testHttpLenient("text/xml;charset=UTF-16", "UTF-16BE-bom", "UTF-16BE", "UTF-16BE", "UTF-16BE");
        this._testHttpLenient("text/xml;charset=UTF-32", "UTF-32BE-bom", "UTF-32BE", null, "UTF-32BE");
        this._testHttpLenient("text/xml;charset=UTF-32", "UTF-32BE-bom", "UTF-32BE", "UTF-32", "UTF-32");
        this._testHttpLenient("text/xml;charset=UTF-32", "UTF-32BE-bom", "UTF-32BE", "UTF-32BE", "UTF-32BE");
        this._testHttpLenient("text/xml", "UTF-8-bom", "US-ASCII", null, "US-ASCII");
        this._testHttpLenient("text/xml;charset=UTF-16BE", "UTF-16BE-bom", "UTF-16BE", null, "UTF-16BE");
        this._testHttpLenient("text/xml;charset=UTF-16BE", "UTF-16BE-bom", "UTF-16BE", "UTF-16", "UTF-16");
        this._testHttpLenient("text/xml;charset=UTF-16BE", "UTF-16BE-bom", "UTF-16BE", "UTF-16BE", "UTF-16BE");
        this._testHttpLenient("text/xml;charset=UTF-16", "no-bom", "UTF-16BE", "UTF-16BE", "UTF-16BE");
        this._testHttpLenient("text/xml;charset=UTF-16", "no-bom", "UTF-16BE", null, "UTF-16");
        this._testHttpLenient("text/xml;charset=UTF-32BE", "UTF-32BE-bom", "UTF-32BE", null, "UTF-32BE");
        this._testHttpLenient("text/xml;charset=UTF-32BE", "UTF-32BE-bom", "UTF-32BE", "UTF-32", "UTF-32");
        this._testHttpLenient("text/xml;charset=UTF-32BE", "UTF-32BE-bom", "UTF-32BE", "UTF-32BE", "UTF-32BE");
        this._testHttpLenient("text/xml;charset=UTF-32", "no-bom", "UTF-32BE", "UTF-32BE", "UTF-32BE");
        this._testHttpLenient("text/xml;charset=UTF-32", "no-bom", "UTF-32BE", null, "UTF-32");
        this._testHttpLenient("text/html", "no-bom", "US-ASCII", "US-ASCII", "US-ASCII");
        this._testHttpLenient("text/html", "no-bom", "US-ASCII", null, "US-ASCII");
        this._testHttpLenient("text/html;charset=UTF-8", "no-bom", "US-ASCII", "UTF-8", "UTF-8");
        this._testHttpLenient("text/html;charset=UTF-16BE", "no-bom", "US-ASCII", "UTF-8", "UTF-8");
        this._testHttpLenient("text/html;charset=UTF-32BE", "no-bom", "US-ASCII", "UTF-8", "UTF-8");
    }

    @Test
    @DefaultLocale(language="tr")
    public void testLowerCaseEncodingWithTurkishLocale_IO_557() throws Exception {
        String[] encodings;
        for (String encoding : encodings = new String[]{"iso8859-1", "us-ascii", "utf-8"}) {
            String xml = this.getXML("no-bom", XML3, encoding, encoding);
            try (ByteArrayInputStream is = new ByteArrayInputStream(xml.getBytes(encoding));
                 XmlStreamReader xmlReader = new XmlStreamReader((InputStream)is);){
                Assertions.assertTrue((boolean)encoding.equalsIgnoreCase(xmlReader.getEncoding()), (String)("Check encoding : " + encoding));
                Assertions.assertEquals((Object)xml, (Object)IOUtils.toString((Reader)xmlReader), (String)"Check content");
            }
        }
    }

    @Test
    public void testRawContent() throws Exception {
        String encoding = "UTF-8";
        String xml = this.getXML("no-bom", XML3, "UTF-8", "UTF-8");
        ByteArrayInputStream is = new ByteArrayInputStream(xml.getBytes("UTF-8"));
        XmlStreamReader xmlReader = new XmlStreamReader((InputStream)is);
        Assertions.assertEquals((Object)xmlReader.getEncoding(), (Object)"UTF-8", (String)"Check encoding");
        Assertions.assertEquals((Object)xml, (Object)IOUtils.toString((Reader)xmlReader), (String)"Check content");
    }

    @Test
    public void testHttpContent() throws Exception {
        String encoding = "UTF-8";
        String xml = this.getXML("no-bom", XML3, "UTF-8", "UTF-8");
        ByteArrayInputStream is = new ByteArrayInputStream(xml.getBytes("UTF-8"));
        XmlStreamReader xmlReader = new XmlStreamReader((InputStream)is, "UTF-8");
        Assertions.assertEquals((Object)xmlReader.getEncoding(), (Object)"UTF-8", (String)"Check encoding");
        Assertions.assertEquals((Object)xml, (Object)IOUtils.toString((Reader)xmlReader), (String)"Check content");
    }

    public void _testAlternateDefaultEncoding(String cT, String bomEnc, String streamEnc, String prologEnc, String alternateEnc) throws Exception {
        InputStream is = this.getXmlStream(bomEnc, prologEnc == null ? XML1 : XML3, streamEnc, prologEnc);
        XmlStreamReader xmlReader = new XmlStreamReader(is, cT, false, alternateEnc);
        if (!streamEnc.equals("UTF-16")) {
            String enc = alternateEnc != null ? alternateEnc : streamEnc;
            Assertions.assertEquals((Object)xmlReader.getEncoding(), (Object)enc);
        } else {
            Assertions.assertEquals((Object)xmlReader.getEncoding().substring(0, streamEnc.length()), (Object)streamEnc);
        }
        xmlReader.close();
    }

    public void _testHttpValid(String cT, String bomEnc, String streamEnc, String prologEnc) throws Exception {
        InputStream is = this.getXmlStream(bomEnc, prologEnc == null ? XML1 : XML3, streamEnc, prologEnc);
        XmlStreamReader xmlReader = new XmlStreamReader(is, cT, false);
        if (!streamEnc.equals("UTF-16")) {
            Assertions.assertEquals((Object)xmlReader.getEncoding(), (Object)streamEnc);
        } else {
            Assertions.assertEquals((Object)xmlReader.getEncoding().substring(0, streamEnc.length()), (Object)streamEnc);
        }
        xmlReader.close();
    }

    protected void _testHttpInvalid(String cT, String bomEnc, String streamEnc, String prologEnc) throws Exception {
        InputStream is = this.getXmlStream(bomEnc, prologEnc == null ? XML2 : XML3, streamEnc, prologEnc);
        try {
            new XmlStreamReader(is, cT, false).close();
            Assertions.fail((String)("It should have failed for HTTP Content-type " + cT + ", BOM " + bomEnc + ", streamEnc " + streamEnc + " and prologEnc " + prologEnc));
        }
        catch (IOException ex) {
            Assertions.assertTrue((boolean)ex.getMessage().contains("Invalid encoding,"));
        }
    }

    protected void _testHttpLenient(String cT, String bomEnc, String streamEnc, String prologEnc, String shouldbe) throws Exception {
        InputStream is = this.getXmlStream(bomEnc, prologEnc == null ? XML2 : XML3, streamEnc, prologEnc);
        XmlStreamReader xmlReader = new XmlStreamReader(is, cT, true);
        Assertions.assertEquals((Object)xmlReader.getEncoding(), (Object)shouldbe);
        xmlReader.close();
    }

    @Test
    public void testEncodingAttributeXML() throws Exception {
        ByteArrayInputStream is = new ByteArrayInputStream(ENCODING_ATTRIBUTE_XML.getBytes(StandardCharsets.UTF_8));
        XmlStreamReader xmlReader = new XmlStreamReader((InputStream)is, "", true);
        Assertions.assertEquals((Object)xmlReader.getEncoding(), (Object)"UTF-8");
        xmlReader.close();
    }

    protected InputStream getXmlStream(String bomType, String xmlType, String streamEnc, String prologEnc) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        int[] bom = BOMs.get(bomType);
        if (bom == null) {
            bom = new int[]{};
        }
        for (int element : bom) {
            baos.write(element);
        }
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)baos, streamEnc);
        String xmlDoc = this.getXML(bomType, xmlType, streamEnc, prologEnc);
        writer.write(xmlDoc);
        writer.write("<da>\n");
        for (int i = 0; i < 10000; ++i) {
            writer.write("<do/>\n");
        }
        writer.write("</da>\n");
        ((Writer)writer).close();
        return new ByteArrayInputStream(baos.toByteArray());
    }

    private String getXML(String bomType, String xmlType, String streamEnc, String prologEnc) {
        MessageFormat xml = XMLs.get(xmlType);
        String info = INFO.format(new Object[]{bomType, xmlType, prologEnc});
        String xmlDoc = xml.format(new Object[]{streamEnc, prologEnc, info});
        return xmlDoc;
    }

    static {
        BOMs.put("no-bom", NO_BOM_BYTES);
        BOMs.put("UTF-16BE-bom", UTF_16BE_BOM_BYTES);
        BOMs.put("UTF-16LE-bom", UTF_16LE_BOM_BYTES);
        BOMs.put("UTF-32BE-bom", UTF_32BE_BOM_BYTES);
        BOMs.put("UTF-32LE-bom", UTF_32LE_BOM_BYTES);
        BOMs.put("UTF-16-bom", NO_BOM_BYTES);
        BOMs.put("UTF-8-bom", UTF_8_BOM_BYTES);
        XML = new MessageFormat("<root>{2}</root>");
        XML_WITH_PROLOG = new MessageFormat("<?xml version=\"1.0\"?>\n<root>{2}</root>");
        XML_WITH_PROLOG_AND_ENCODING_DOUBLE_QUOTES = new MessageFormat("<?xml version=\"1.0\" encoding=\"{1}\"?>\n<root>{2}</root>");
        XML_WITH_PROLOG_AND_ENCODING_SINGLE_QUOTES = new MessageFormat("<?xml version=\"1.0\" encoding=''{1}''?>\n<root>{2}</root>");
        XML_WITH_PROLOG_AND_ENCODING_SPACED_SINGLE_QUOTES = new MessageFormat("<?xml version=\"1.0\" encoding =  \t \n \r''{1}''?>\n<root>{2}</root>");
        INFO = new MessageFormat("\nBOM : {0}\nDoc : {1}\nStream Enc : {2}\nProlog Enc : {3}\n");
        XMLs = new HashMap<String, MessageFormat>();
        XMLs.put(XML1, XML);
        XMLs.put(XML2, XML_WITH_PROLOG);
        XMLs.put(XML3, XML_WITH_PROLOG_AND_ENCODING_DOUBLE_QUOTES);
        XMLs.put(XML4, XML_WITH_PROLOG_AND_ENCODING_SINGLE_QUOTES);
        XMLs.put(XML5, XML_WITH_PROLOG_AND_ENCODING_SPACED_SINGLE_QUOTES);
    }
}

