/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import org.apache.commons.io.output.FileWriterWithEncoding;
import org.apache.commons.io.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class FileWriterWithEncodingTest {
    @TempDir
    public File temporaryFolder;
    private String defaultEncoding;
    private File file1;
    private File file2;
    private String textContent;
    private final char[] anotherTestContent = new char[]{'f', 'z', 'x'};

    @BeforeEach
    public void setUp() throws Exception {
        File encodingFinder = new File(this.temporaryFolder, "finder.txt");
        try (OutputStreamWriter out = new OutputStreamWriter(new FileOutputStream(encodingFinder));){
            this.defaultEncoding = out.getEncoding();
        }
        this.file1 = new File(this.temporaryFolder, "testfile1.txt");
        this.file2 = new File(this.temporaryFolder, "testfile2.txt");
        char[] arr = new char[1024];
        char[] chars = "ABCDEFGHIJKLMNOPQabcdefgihklmnopq".toCharArray();
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = chars[i % chars.length];
        }
        this.textContent = new String(arr);
    }

    @Test
    public void sameEncoding_string_constructor() throws Exception {
        this.successfulRun(new FileWriterWithEncoding(this.file2, this.defaultEncoding));
    }

    @Test
    public void sameEncoding_string_string_constructor() throws Exception {
        this.successfulRun(new FileWriterWithEncoding(this.file2.getPath(), this.defaultEncoding));
    }

    @Test
    public void sameEncoding_Charset_constructor() throws Exception {
        this.successfulRun(new FileWriterWithEncoding(this.file2, Charset.defaultCharset()));
    }

    @Test
    public void sameEncoding_string_Charset_constructor() throws Exception {
        this.successfulRun(new FileWriterWithEncoding(this.file2.getPath(), Charset.defaultCharset()));
    }

    @Test
    public void sameEncoding_CharsetEncoder_constructor() throws Exception {
        CharsetEncoder enc = Charset.defaultCharset().newEncoder();
        this.successfulRun(new FileWriterWithEncoding(this.file2, enc));
    }

    @Test
    public void sameEncoding_string_CharsetEncoder_constructor() throws Exception {
        CharsetEncoder enc = Charset.defaultCharset().newEncoder();
        this.successfulRun(new FileWriterWithEncoding(this.file2.getPath(), enc));
    }

    private void successfulRun(FileWriterWithEncoding fw21) throws Exception {
        try (FileWriter fw1 = new FileWriter(this.file1);
             FileWriterWithEncoding fw2 = fw21;){
            this.writeTestPayload(fw1, fw2);
            TestUtils.checkFile(this.file1, this.file2);
        }
        Assertions.assertTrue((boolean)this.file1.exists());
        Assertions.assertTrue((boolean)this.file2.exists());
    }

    @Test
    public void testDifferentEncoding() throws Exception {
        Throwable throwable;
        FileWriterWithEncoding fw22;
        Throwable throwable2;
        FileWriter fw1;
        if (Charset.isSupported("UTF-16BE")) {
            fw1 = new FileWriter(this.file1);
            throwable2 = null;
            try {
                fw22 = new FileWriterWithEncoding(this.file2, this.defaultEncoding);
                throwable = null;
                try {
                    this.writeTestPayload(fw1, fw22);
                    try {
                        TestUtils.checkFile(this.file1, this.file2);
                        Assertions.fail();
                    }
                    catch (AssertionError assertionError) {
                        // empty catch block
                    }
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                finally {
                    if (fw22 != null) {
                        if (throwable != null) {
                            try {
                                fw22.close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                        } else {
                            fw22.close();
                        }
                    }
                }
            }
            catch (Throwable fw22) {
                throwable2 = fw22;
                throw fw22;
            }
            finally {
                if (fw1 != null) {
                    if (throwable2 != null) {
                        try {
                            fw1.close();
                        }
                        catch (Throwable fw22) {
                            throwable2.addSuppressed(fw22);
                        }
                    } else {
                        fw1.close();
                    }
                }
            }
            Assertions.assertTrue((boolean)this.file1.exists());
            Assertions.assertTrue((boolean)this.file2.exists());
        }
        if (Charset.isSupported("UTF-16LE")) {
            fw1 = new FileWriter(this.file1);
            throwable2 = null;
            try {
                fw22 = new FileWriterWithEncoding(this.file2, this.defaultEncoding);
                throwable = null;
                try {
                    this.writeTestPayload(fw1, fw22);
                    try {
                        TestUtils.checkFile(this.file1, this.file2);
                        Assertions.fail();
                    }
                    catch (AssertionError assertionError) {
                        // empty catch block
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (fw22 != null) {
                        if (throwable != null) {
                            try {
                                fw22.close();
                            }
                            catch (Throwable throwable6) {
                                throwable.addSuppressed(throwable6);
                            }
                        } else {
                            fw22.close();
                        }
                    }
                }
            }
            catch (Throwable throwable7) {
                throwable2 = throwable7;
                throw throwable7;
            }
            finally {
                if (fw1 != null) {
                    if (throwable2 != null) {
                        try {
                            fw1.close();
                        }
                        catch (Throwable throwable8) {
                            throwable2.addSuppressed(throwable8);
                        }
                    } else {
                        fw1.close();
                    }
                }
            }
            Assertions.assertTrue((boolean)this.file1.exists());
            Assertions.assertTrue((boolean)this.file2.exists());
        }
    }

    private void writeTestPayload(FileWriter fw1, FileWriterWithEncoding fw2) throws IOException {
        Assertions.assertTrue((boolean)this.file1.exists());
        Assertions.assertTrue((boolean)this.file2.exists());
        fw1.write(this.textContent);
        fw2.write(this.textContent);
        fw1.write(65);
        fw2.write(65);
        fw1.write(this.anotherTestContent);
        fw2.write(this.anotherTestContent);
        fw1.write(this.anotherTestContent, 1, 2);
        fw2.write(this.anotherTestContent, 1, 2);
        fw1.write("CAFE", 1, 2);
        fw2.write("CAFE", 1, 2);
        fw1.flush();
        fw2.flush();
    }

    @Test
    public void constructor_File_encoding_badEncoding() {
        Assertions.assertThrows(IOException.class, () -> {
            FileWriterWithEncoding writer = new FileWriterWithEncoding(this.file1, "BAD-ENCODE");
            Throwable throwable = null;
            if (writer != null) {
                if (throwable != null) {
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    writer.close();
                }
            }
        });
        Assertions.assertFalse((boolean)this.file1.exists());
    }

    @Test
    public void constructor_File_directory() {
        Assertions.assertThrows(IOException.class, () -> {
            FileWriterWithEncoding writer = new FileWriterWithEncoding(this.temporaryFolder, this.defaultEncoding);
            Throwable throwable = null;
            if (writer != null) {
                if (throwable != null) {
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    writer.close();
                }
            }
        });
        Assertions.assertFalse((boolean)this.file1.exists());
    }

    @Test
    public void constructor_File_nullFile() {
        Assertions.assertThrows(NullPointerException.class, () -> {
            FileWriterWithEncoding writer = new FileWriterWithEncoding((File)null, this.defaultEncoding);
            Throwable throwable = null;
            if (writer != null) {
                if (throwable != null) {
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    writer.close();
                }
            }
        });
        Assertions.assertFalse((boolean)this.file1.exists());
    }

    @Test
    public void constructor_fileName_nullFile() {
        Assertions.assertThrows(NullPointerException.class, () -> {
            FileWriterWithEncoding writer = new FileWriterWithEncoding((String)null, this.defaultEncoding);
            Throwable throwable = null;
            if (writer != null) {
                if (throwable != null) {
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    writer.close();
                }
            }
        });
        Assertions.assertFalse((boolean)this.file1.exists());
    }

    @Test
    public void sameEncoding_null_Charset_constructor() throws Exception {
        try {
            this.successfulRun(new FileWriterWithEncoding(this.file2, (Charset)null));
            Assertions.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }
}

