/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Random;
import org.apache.commons.io.input.DemuxInputStream;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.io.output.DemuxOutputStream;
import org.apache.commons.io.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DemuxTestCase {
    private static final String T1 = "Thread1";
    private static final String T2 = "Thread2";
    private static final String T3 = "Thread3";
    private static final String T4 = "Thread4";
    private static final String DATA1 = "Data for thread1";
    private static final String DATA2 = "Data for thread2";
    private static final String DATA3 = "Data for thread3";
    private static final String DATA4 = "Data for thread4";
    private static final Random c_random = new Random();
    private final HashMap<String, ByteArrayOutputStream> outputMap = new HashMap();
    private final HashMap<String, Thread> threadMap = new HashMap();

    private String getOutput(String threadName) {
        ByteArrayOutputStream output = this.outputMap.get(threadName);
        Assertions.assertNotNull((Object)output, (String)"getOutput()");
        return output.toString(StandardCharsets.UTF_8);
    }

    private String getInput(String threadName) {
        ReaderThread thread = (ReaderThread)this.threadMap.get(threadName);
        Assertions.assertNotNull((Object)thread, (String)"getInput()");
        return thread.getData();
    }

    private void doStart() {
        for (String name : this.threadMap.keySet()) {
            Thread thread = this.threadMap.get(name);
            thread.start();
        }
    }

    private void doJoin() throws Exception {
        for (String name : this.threadMap.keySet()) {
            Thread thread = this.threadMap.get(name);
            thread.join();
        }
    }

    private void startWriter(String name, String data, DemuxOutputStream demux) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        this.outputMap.put(name, output);
        WriterThread thread = new WriterThread(name, data, (OutputStream)output, demux);
        this.threadMap.put(name, thread);
    }

    private void startReader(String name, String data, DemuxInputStream demux) {
        ByteArrayInputStream input = new ByteArrayInputStream(data.getBytes());
        ReaderThread thread = new ReaderThread(name, input, demux);
        this.threadMap.put(name, thread);
    }

    @Test
    public void testOutputStream() throws Exception {
        DemuxOutputStream output = new DemuxOutputStream();
        this.startWriter(T1, DATA1, output);
        this.startWriter(T2, DATA2, output);
        this.startWriter(T3, DATA3, output);
        this.startWriter(T4, DATA4, output);
        this.doStart();
        this.doJoin();
        Assertions.assertEquals((Object)DATA1, (Object)this.getOutput(T1), (String)"Data1");
        Assertions.assertEquals((Object)DATA2, (Object)this.getOutput(T2), (String)"Data2");
        Assertions.assertEquals((Object)DATA3, (Object)this.getOutput(T3), (String)"Data3");
        Assertions.assertEquals((Object)DATA4, (Object)this.getOutput(T4), (String)"Data4");
    }

    @Test
    public void testInputStream() throws Exception {
        DemuxInputStream input = new DemuxInputStream();
        this.startReader(T1, DATA1, input);
        this.startReader(T2, DATA2, input);
        this.startReader(T3, DATA3, input);
        this.startReader(T4, DATA4, input);
        this.doStart();
        this.doJoin();
        Assertions.assertEquals((Object)DATA1, (Object)this.getInput(T1), (String)"Data1");
        Assertions.assertEquals((Object)DATA2, (Object)this.getInput(T2), (String)"Data2");
        Assertions.assertEquals((Object)DATA3, (Object)this.getInput(T3), (String)"Data3");
        Assertions.assertEquals((Object)DATA4, (Object)this.getInput(T4), (String)"Data4");
    }

    private static class WriterThread
    extends Thread {
        private final byte[] byteArray;
        private final OutputStream outputStream;
        private final DemuxOutputStream demuxOutputStream;

        WriterThread(String name, String data, OutputStream output, DemuxOutputStream demux) {
            super(name);
            this.outputStream = output;
            this.demuxOutputStream = demux;
            this.byteArray = data.getBytes();
        }

        @Override
        public void run() {
            this.demuxOutputStream.bindStream(this.outputStream);
            for (byte element : this.byteArray) {
                try {
                    this.demuxOutputStream.write((int)element);
                    int sleepTime = Math.abs(c_random.nextInt() % 10);
                    TestUtils.sleep(sleepTime);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static class ReaderThread
    extends Thread {
        private final StringBuffer stringBuffer = new StringBuffer();
        private final InputStream inputStream;
        private final DemuxInputStream demuxInputStream;

        ReaderThread(String name, InputStream input, DemuxInputStream demux) {
            super(name);
            this.inputStream = input;
            this.demuxInputStream = demux;
        }

        public String getData() {
            return this.stringBuffer.toString();
        }

        @Override
        public void run() {
            this.demuxInputStream.bindStream(this.inputStream);
            try {
                int ch = this.demuxInputStream.read();
                while (-1 != ch) {
                    this.stringBuffer.append((char)ch);
                    int sleepTime = Math.abs(c_random.nextInt() % 10);
                    TestUtils.sleep(sleepTime);
                    ch = this.demuxInputStream.read();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

