/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FileUtilsDeleteDirectoryBaseTestCase;
import org.apache.commons.io.IOExceptionList;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

@DisabledOnOs(value={OS.WINDOWS, OS.MAC})
public class FileUtilsDeleteDirectoryLinuxTestCase
extends FileUtilsDeleteDirectoryBaseTestCase {
    private boolean chmod(File file, int mode, boolean recurse) throws InterruptedException {
        Process proc;
        ArrayList<String> args = new ArrayList<String>();
        args.add("chmod");
        if (recurse) {
            args.add("-R");
        }
        args.add(Integer.toString(mode));
        args.add(file.getAbsolutePath());
        try {
            proc = Runtime.getRuntime().exec(args.toArray(new String[args.size()]));
        }
        catch (IOException e) {
            return false;
        }
        return proc.waitFor() == 0;
    }

    @Override
    protected boolean setupSymlink(File res, File link) throws Exception {
        ArrayList<String> args = new ArrayList<String>();
        args.add("ln");
        args.add("-s");
        args.add(res.getAbsolutePath());
        args.add(link.getAbsolutePath());
        Process proc = Runtime.getRuntime().exec(args.toArray(new String[args.size()]));
        return proc.waitFor() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testThrowsOnCannotDeleteFile() throws Exception {
        File nested = new File(this.top, "nested");
        Assertions.assertTrue((boolean)nested.mkdirs());
        File file = new File(nested, "restricted");
        FileUtils.touch((File)file);
        Assumptions.assumeTrue((boolean)this.chmod(nested, 500, false));
        try {
            FileUtils.deleteDirectory((File)nested);
            Assertions.fail((String)"expected IOException");
        }
        catch (IOException e) {
            IOExceptionList list = (IOExceptionList)e;
            Assertions.assertEquals((Object)("Cannot delete file: " + file.getAbsolutePath()), (Object)list.getCause(0).getMessage());
        }
        finally {
            this.chmod(nested, 755, false);
            FileUtils.deleteDirectory((File)nested);
        }
        Assertions.assertEquals((int)0, (int)this.top.list().length);
    }

    @Test
    public void testThrowsOnNullList() throws Exception {
        File nested = new File(this.top, "nested");
        Assertions.assertTrue((boolean)nested.mkdirs());
        Assumptions.assumeTrue((boolean)this.chmod(nested, 0, false));
        try {
            FileUtils.deleteDirectory((File)nested);
            Assertions.fail((String)"expected IOException");
        }
        catch (IOException e) {
            Assertions.assertEquals((Object)("Unknown I/O error listing contents of directory: " + nested.getAbsolutePath()), (Object)e.getMessage());
        }
        finally {
            this.chmod(nested, 755, false);
            FileUtils.deleteDirectory((File)nested);
        }
        Assertions.assertEquals((int)0, (int)this.top.list().length);
    }
}

