/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.ChronoLocalDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import org.apache.commons.io.DirectoryWalker;
import org.apache.commons.io.FileExistsException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.file.PathUtils;
import org.apache.commons.io.file.PathUtilsIsEmptyTest;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.NameFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.commons.io.test.TestUtils;
import org.apache.commons.lang3.SystemUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class FileUtilsTestCase {
    private static final long DATE3 = 1000000002000L;
    private static final long DATE2 = 1000000001000L;
    private static final long DATE1 = 1000000000000L;
    private static final int TEST_DIRECTORY_SIZE = 0;
    private static final BigInteger TEST_DIRECTORY_SIZE_BI = BigInteger.ZERO;
    private static final BigInteger TEST_DIRECTORY_SIZE_GT_ZERO_BI = BigInteger.valueOf(100L);
    private static final ListDirectoryWalker LIST_WALKER = new ListDirectoryWalker();
    @TempDir
    public File temporaryFolder;
    private File testFile1;
    private File testFile2;
    private long testFile1Size;
    private long testFile2Size;

    private void backDateFile10Minutes(File testFile) throws IOException {
        long mins10 = 600000L;
        long lastModified1 = this.getLastModifiedMillis(testFile);
        Assertions.assertTrue((boolean)this.setLastModifiedMillis(testFile, lastModified1 - 600000L));
        Assertions.assertNotEquals((long)this.getLastModifiedMillis(testFile), (long)lastModified1, (String)"Should have changed source date");
    }

    private void consumeRemaining(Iterator<File> iterator) {
        if (iterator != null) {
            iterator.forEachRemaining(e -> {});
        }
    }

    private void createCircularSymLink(File file) throws IOException {
        if (!FilenameUtils.isSystemWindows()) {
            Runtime.getRuntime().exec("ln -s " + file + "/.. " + file + "/cycle");
        } else {
            try {
                Runtime.getRuntime().exec("mklink /D " + file + "/cycle" + file + "/.. ");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void createFilesForTestCopyDirectory(File grandParentDir, File parentDir, File childDir) throws Exception {
        File childDir2 = new File(parentDir, "child2");
        File grandChildDir = new File(childDir, "grandChild");
        File grandChild2Dir = new File(childDir2, "grandChild2");
        File file1 = new File(grandParentDir, "file1.txt");
        File file2 = new File(parentDir, "file2.txt");
        File file3 = new File(childDir, "file3.txt");
        File file4 = new File(childDir2, "file4.txt");
        File file5 = new File(grandChildDir, "file5.txt");
        File file6 = new File(grandChild2Dir, "file6.txt");
        FileUtils.deleteDirectory((File)grandParentDir);
        grandChildDir.mkdirs();
        grandChild2Dir.mkdirs();
        FileUtils.writeStringToFile((File)file1, (String)"File 1 in grandparent", (String)"UTF8");
        FileUtils.writeStringToFile((File)file2, (String)"File 2 in parent", (String)"UTF8");
        FileUtils.writeStringToFile((File)file3, (String)"File 3 in child", (String)"UTF8");
        FileUtils.writeStringToFile((File)file4, (String)"File 4 in child2", (String)"UTF8");
        FileUtils.writeStringToFile((File)file5, (String)"File 5 in grandChild", (String)"UTF8");
        FileUtils.writeStringToFile((File)file6, (String)"File 6 in grandChild2", (String)"UTF8");
    }

    private long getLastModifiedMillis(File file) throws IOException {
        return FileUtils.lastModified((File)file);
    }

    private String getName() {
        return this.getClass().getSimpleName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void iterateFilesAndDirs(File dir, IOFileFilter fileFilter, IOFileFilter dirFilter, Collection<File> expectedFilesAndDirs) {
        int filesCount = 0;
        Iterator iterator = FileUtils.iterateFilesAndDirs((File)dir, (IOFileFilter)fileFilter, (IOFileFilter)dirFilter);
        try {
            ArrayList<File> actualFiles = new ArrayList<File>();
            while (iterator.hasNext()) {
                ++filesCount;
                File file = (File)iterator.next();
                actualFiles.add(file);
                Assertions.assertTrue((boolean)expectedFilesAndDirs.contains(file), () -> "Unexpected directory/file " + file + ", expected one of " + expectedFilesAndDirs);
            }
            Assertions.assertEquals((int)expectedFilesAndDirs.size(), (int)filesCount, () -> actualFiles.toString());
        }
        finally {
            this.consumeRemaining(iterator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void openOutputStream_noParent(boolean createFile) throws Exception {
        File file = new File("test.txt");
        Assertions.assertNull((Object)file.getParentFile());
        try {
            if (createFile) {
                TestUtils.createLineBasedFile(file, new String[]{"Hello"});
            }
            try (FileOutputStream out = FileUtils.openOutputStream((File)file);){
                out.write(0);
            }
            Assertions.assertTrue((boolean)file.exists());
        }
        finally {
            if (!file.delete()) {
                file.deleteOnExit();
            }
        }
    }

    private boolean setLastModifiedMillis(File testFile, long millis) {
        return testFile.setLastModified(millis);
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.testFile1 = new File(this.temporaryFolder, "file1-test.txt");
        this.testFile2 = new File(this.temporaryFolder, "file1a-test.txt");
        this.testFile1Size = this.testFile1.length();
        this.testFile2Size = this.testFile2.length();
        if (!this.testFile1.getParentFile().exists()) {
            throw new IOException("Cannot create file " + this.testFile1 + " as the parent directory does not exist");
        }
        try (BufferedOutputStream output3 = new BufferedOutputStream(new FileOutputStream(this.testFile1));){
            TestUtils.generateTestData(output3, this.testFile1Size);
        }
        if (!this.testFile2.getParentFile().exists()) {
            throw new IOException("Cannot create file " + this.testFile2 + " as the parent directory does not exist");
        }
        var2_2 = null;
        try (BufferedOutputStream output2 = new BufferedOutputStream(new FileOutputStream(this.testFile2));){
            TestUtils.generateTestData(output2, this.testFile2Size);
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        FileUtils.deleteDirectory((File)this.temporaryFolder);
        this.temporaryFolder.mkdirs();
        if (!this.testFile1.getParentFile().exists()) {
            throw new IOException("Cannot create file " + this.testFile1 + " as the parent directory does not exist");
        }
        var2_2 = null;
        try (BufferedOutputStream output1 = new BufferedOutputStream(new FileOutputStream(this.testFile1));){
            TestUtils.generateTestData(output1, this.testFile1Size);
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        if (!this.testFile2.getParentFile().exists()) {
            throw new IOException("Cannot create file " + this.testFile2 + " as the parent directory does not exist");
        }
        var2_2 = null;
        try (BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(this.testFile2));){
            TestUtils.generateTestData(output, this.testFile2Size);
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
    }

    @Test
    public void test_openInputStream_exists() throws Exception {
        File file = new File(this.temporaryFolder, "test.txt");
        TestUtils.createLineBasedFile(file, new String[]{"Hello"});
        try (FileInputStream in = FileUtils.openInputStream((File)file);){
            Assertions.assertEquals((int)72, (int)in.read());
        }
    }

    @Test
    public void test_openInputStream_existsButIsDirectory() {
        File directory = new File(this.temporaryFolder, "subdir");
        directory.mkdirs();
        Assertions.assertThrows(IOException.class, () -> FileUtils.openInputStream((File)directory));
    }

    @Test
    public void test_openInputStream_notExists() {
        File directory = new File(this.temporaryFolder, "test.txt");
        try (FileInputStream in = FileUtils.openInputStream((File)directory);){
            Assertions.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void test_openOutputStream_exists() throws Exception {
        File file = new File(this.temporaryFolder, "test.txt");
        TestUtils.createLineBasedFile(file, new String[]{"Hello"});
        try (FileOutputStream out = FileUtils.openOutputStream((File)file);){
            out.write(0);
        }
        Assertions.assertTrue((boolean)file.exists());
    }

    @Test
    public void test_openOutputStream_existsButIsDirectory() {
        File directory = new File(this.temporaryFolder, "subdir");
        directory.mkdirs();
        Assertions.assertThrows(IllegalArgumentException.class, () -> FileUtils.openOutputStream((File)directory));
    }

    @Test
    public void test_openOutputStream_noParentCreateFile() throws Exception {
        this.openOutputStream_noParent(true);
    }

    @Test
    public void test_openOutputStream_noParentNoFile() throws Exception {
        this.openOutputStream_noParent(false);
    }

    @Test
    public void test_openOutputStream_notExists() throws Exception {
        File file = new File(this.temporaryFolder, "a/test.txt");
        try (FileOutputStream out = FileUtils.openOutputStream((File)file);){
            out.write(0);
        }
        Assertions.assertTrue((boolean)file.exists());
    }

    @Test
    public void test_openOutputStream_notExistsCannotCreate() {
        String longStr = "abcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyz";
        File file = new File(this.temporaryFolder, "a/abcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyz/test.txt");
        try (FileOutputStream out = FileUtils.openOutputStream((File)file);){
            Assertions.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testByteCountToDisplaySizeBigInteger() {
        BigInteger b1023 = BigInteger.valueOf(1023L);
        BigInteger b1025 = BigInteger.valueOf(1025L);
        BigInteger KB1 = BigInteger.valueOf(1024L);
        BigInteger MB1 = KB1.multiply(KB1);
        BigInteger GB1 = MB1.multiply(KB1);
        BigInteger GB2 = GB1.add(GB1);
        BigInteger TB1 = GB1.multiply(KB1);
        BigInteger PB1 = TB1.multiply(KB1);
        BigInteger EB1 = PB1.multiply(KB1);
        Assertions.assertEquals((Object)"0 bytes", (Object)FileUtils.byteCountToDisplaySize((BigInteger)BigInteger.ZERO));
        Assertions.assertEquals((Object)"1 bytes", (Object)FileUtils.byteCountToDisplaySize((BigInteger)BigInteger.ONE));
        Assertions.assertEquals((Object)"1023 bytes", (Object)FileUtils.byteCountToDisplaySize((BigInteger)b1023));
        Assertions.assertEquals((Object)"1 KB", (Object)FileUtils.byteCountToDisplaySize((BigInteger)KB1));
        Assertions.assertEquals((Object)"1 KB", (Object)FileUtils.byteCountToDisplaySize((BigInteger)b1025));
        Assertions.assertEquals((Object)"1023 KB", (Object)FileUtils.byteCountToDisplaySize((BigInteger)MB1.subtract(BigInteger.ONE)));
        Assertions.assertEquals((Object)"1 MB", (Object)FileUtils.byteCountToDisplaySize((BigInteger)MB1));
        Assertions.assertEquals((Object)"1 MB", (Object)FileUtils.byteCountToDisplaySize((BigInteger)MB1.add(BigInteger.ONE)));
        Assertions.assertEquals((Object)"1023 MB", (Object)FileUtils.byteCountToDisplaySize((BigInteger)GB1.subtract(BigInteger.ONE)));
        Assertions.assertEquals((Object)"1 GB", (Object)FileUtils.byteCountToDisplaySize((BigInteger)GB1));
        Assertions.assertEquals((Object)"1 GB", (Object)FileUtils.byteCountToDisplaySize((BigInteger)GB1.add(BigInteger.ONE)));
        Assertions.assertEquals((Object)"2 GB", (Object)FileUtils.byteCountToDisplaySize((BigInteger)GB2));
        Assertions.assertEquals((Object)"1 GB", (Object)FileUtils.byteCountToDisplaySize((BigInteger)GB2.subtract(BigInteger.ONE)));
        Assertions.assertEquals((Object)"1 TB", (Object)FileUtils.byteCountToDisplaySize((BigInteger)TB1));
        Assertions.assertEquals((Object)"1 PB", (Object)FileUtils.byteCountToDisplaySize((BigInteger)PB1));
        Assertions.assertEquals((Object)"1 EB", (Object)FileUtils.byteCountToDisplaySize((BigInteger)EB1));
        Assertions.assertEquals((Object)"7 EB", (Object)FileUtils.byteCountToDisplaySize((long)Long.MAX_VALUE));
        Assertions.assertEquals((Object)"63 KB", (Object)FileUtils.byteCountToDisplaySize((BigInteger)BigInteger.valueOf(65535L)));
        Assertions.assertEquals((Object)"31 KB", (Object)FileUtils.byteCountToDisplaySize((BigInteger)BigInteger.valueOf(32767L)));
        Assertions.assertEquals((Object)"1 GB", (Object)FileUtils.byteCountToDisplaySize((BigInteger)BigInteger.valueOf(Integer.MAX_VALUE)));
    }

    @Test
    public void testByteCountToDisplaySizeLong() {
        Assertions.assertEquals((Object)"0 bytes", (Object)FileUtils.byteCountToDisplaySize((long)0L));
        Assertions.assertEquals((Object)"1 bytes", (Object)FileUtils.byteCountToDisplaySize((long)1L));
        Assertions.assertEquals((Object)"1023 bytes", (Object)FileUtils.byteCountToDisplaySize((long)1023L));
        Assertions.assertEquals((Object)"1 KB", (Object)FileUtils.byteCountToDisplaySize((long)1024L));
        Assertions.assertEquals((Object)"1 KB", (Object)FileUtils.byteCountToDisplaySize((long)1025L));
        Assertions.assertEquals((Object)"1023 KB", (Object)FileUtils.byteCountToDisplaySize((long)1047552L));
        Assertions.assertEquals((Object)"1 MB", (Object)FileUtils.byteCountToDisplaySize((long)0x100000L));
        Assertions.assertEquals((Object)"1 MB", (Object)FileUtils.byteCountToDisplaySize((long)0x100400L));
        Assertions.assertEquals((Object)"1023 MB", (Object)FileUtils.byteCountToDisplaySize((long)0x3FF00000L));
        Assertions.assertEquals((Object)"1 GB", (Object)FileUtils.byteCountToDisplaySize((long)0x40000000L));
        Assertions.assertEquals((Object)"1 GB", (Object)FileUtils.byteCountToDisplaySize((long)0x40100000L));
        Assertions.assertEquals((Object)"2 GB", (Object)FileUtils.byteCountToDisplaySize((long)0x80000000L));
        Assertions.assertEquals((Object)"1 GB", (Object)FileUtils.byteCountToDisplaySize((long)Integer.MAX_VALUE));
        Assertions.assertEquals((Object)"1 TB", (Object)FileUtils.byteCountToDisplaySize((long)0x10000000000L));
        Assertions.assertEquals((Object)"1 PB", (Object)FileUtils.byteCountToDisplaySize((long)0x4000000000000L));
        Assertions.assertEquals((Object)"1 EB", (Object)FileUtils.byteCountToDisplaySize((long)0x1000000000000000L));
        Assertions.assertEquals((Object)"7 EB", (Object)FileUtils.byteCountToDisplaySize((long)Long.MAX_VALUE));
        Assertions.assertEquals((Object)"63 KB", (Object)FileUtils.byteCountToDisplaySize((long)65535L));
        Assertions.assertEquals((Object)"31 KB", (Object)FileUtils.byteCountToDisplaySize((long)32767L));
        Assertions.assertEquals((Object)"1 GB", (Object)FileUtils.byteCountToDisplaySize((long)Integer.MAX_VALUE));
    }

    @Test
    public void testChecksum() throws Exception {
        String text = "Imagination is more important than knowledge - Einstein";
        File file = new File(this.temporaryFolder, "checksum-test.txt");
        FileUtils.writeStringToFile((File)file, (String)"Imagination is more important than knowledge - Einstein", (String)"US-ASCII");
        CRC32 expectedChecksum = new CRC32();
        expectedChecksum.update("Imagination is more important than knowledge - Einstein".getBytes(StandardCharsets.US_ASCII), 0, "Imagination is more important than knowledge - Einstein".length());
        long expectedValue = expectedChecksum.getValue();
        CRC32 testChecksum = new CRC32();
        Checksum resultChecksum = FileUtils.checksum((File)file, (Checksum)testChecksum);
        long resultValue = resultChecksum.getValue();
        Assertions.assertSame((Object)testChecksum, (Object)resultChecksum);
        Assertions.assertEquals((long)expectedValue, (long)resultValue);
    }

    @Test
    public void testChecksumCRC32() throws Exception {
        String text = "Imagination is more important than knowledge - Einstein";
        File file = new File(this.temporaryFolder, "checksum-test.txt");
        FileUtils.writeStringToFile((File)file, (String)"Imagination is more important than knowledge - Einstein", (String)"US-ASCII");
        CRC32 expectedChecksum = new CRC32();
        expectedChecksum.update("Imagination is more important than knowledge - Einstein".getBytes(StandardCharsets.US_ASCII), 0, "Imagination is more important than knowledge - Einstein".length());
        long expectedValue = expectedChecksum.getValue();
        long resultValue = FileUtils.checksumCRC32((File)file);
        Assertions.assertEquals((long)expectedValue, (long)resultValue);
    }

    @Test
    public void testChecksumDouble() throws Exception {
        String text1 = "Imagination is more important than knowledge - Einstein";
        File file1 = new File(this.temporaryFolder, "checksum-test.txt");
        FileUtils.writeStringToFile((File)file1, (String)"Imagination is more important than knowledge - Einstein", (String)"US-ASCII");
        String text2 = "To be or not to be - Shakespeare";
        File file2 = new File(this.temporaryFolder, "checksum-test2.txt");
        FileUtils.writeStringToFile((File)file2, (String)"To be or not to be - Shakespeare", (String)"US-ASCII");
        CRC32 expectedChecksum = new CRC32();
        expectedChecksum.update("Imagination is more important than knowledge - Einstein".getBytes(StandardCharsets.US_ASCII), 0, "Imagination is more important than knowledge - Einstein".length());
        expectedChecksum.update("To be or not to be - Shakespeare".getBytes(StandardCharsets.US_ASCII), 0, "To be or not to be - Shakespeare".length());
        long expectedValue = expectedChecksum.getValue();
        CRC32 testChecksum = new CRC32();
        FileUtils.checksum((File)file1, (Checksum)testChecksum);
        FileUtils.checksum((File)file2, (Checksum)testChecksum);
        long resultValue = testChecksum.getValue();
        Assertions.assertEquals((long)expectedValue, (long)resultValue);
    }

    @Test
    public void testChecksumOnDirectory() throws Exception {
        try {
            FileUtils.checksum((File)new File("."), (Checksum)new CRC32());
            Assertions.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testChecksumOnNullChecksum() throws Exception {
        String text = "Imagination is more important than knowledge - Einstein";
        File file = new File(this.temporaryFolder, "checksum-test.txt");
        FileUtils.writeStringToFile((File)file, (String)"Imagination is more important than knowledge - Einstein", (String)"US-ASCII");
        try {
            FileUtils.checksum((File)file, null);
            Assertions.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testChecksumOnNullFile() throws Exception {
        try {
            FileUtils.checksum(null, (Checksum)new CRC32());
            Assertions.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testCompareSizeOf() {
        File start = new File("src/test/java");
        long sizeLong1 = FileUtils.sizeOf((File)start);
        BigInteger sizeBig = FileUtils.sizeOfAsBigInteger((File)start);
        long sizeLong2 = FileUtils.sizeOf((File)start);
        Assertions.assertEquals((long)sizeLong1, (long)sizeLong2, (String)"Size should not change");
        Assertions.assertEquals((long)sizeLong1, (long)sizeBig.longValue(), (String)"longSize should equal BigSize");
    }

    @Test
    public void testContentEquals() throws Exception {
        File file = new File(this.temporaryFolder, this.getName());
        File file2 = new File(this.temporaryFolder, this.getName() + "2");
        Assertions.assertTrue((boolean)FileUtils.contentEquals(null, null));
        Assertions.assertFalse((boolean)FileUtils.contentEquals(null, (File)file));
        Assertions.assertFalse((boolean)FileUtils.contentEquals((File)file, null));
        Assertions.assertTrue((boolean)FileUtils.contentEquals((File)file, (File)file));
        Assertions.assertTrue((boolean)FileUtils.contentEquals((File)file, (File)file2));
        Assertions.assertTrue((boolean)FileUtils.contentEquals((File)file2, (File)file2));
        Assertions.assertTrue((boolean)FileUtils.contentEquals((File)file2, (File)file));
        Assertions.assertThrows(IllegalArgumentException.class, () -> FileUtils.contentEquals((File)this.temporaryFolder, (File)this.temporaryFolder));
        File objFile1 = new File(this.temporaryFolder, this.getName() + ".object");
        objFile1.deleteOnExit();
        FileUtils.copyURLToFile((URL)this.getClass().getResource("/java/lang/Object.class"), (File)objFile1);
        File objFile1b = new File(this.temporaryFolder, this.getName() + ".object2");
        objFile1.deleteOnExit();
        FileUtils.copyURLToFile((URL)this.getClass().getResource("/java/lang/Object.class"), (File)objFile1b);
        File objFile2 = new File(this.temporaryFolder, this.getName() + ".collection");
        objFile2.deleteOnExit();
        FileUtils.copyURLToFile((URL)this.getClass().getResource("/java/util/Collection.class"), (File)objFile2);
        Assertions.assertFalse((boolean)FileUtils.contentEquals((File)objFile1, (File)objFile2));
        Assertions.assertFalse((boolean)FileUtils.contentEquals((File)objFile1b, (File)objFile2));
        Assertions.assertTrue((boolean)FileUtils.contentEquals((File)objFile1, (File)objFile1b));
        Assertions.assertTrue((boolean)FileUtils.contentEquals((File)objFile1, (File)objFile1));
        Assertions.assertTrue((boolean)FileUtils.contentEquals((File)objFile1b, (File)objFile1b));
        Assertions.assertTrue((boolean)FileUtils.contentEquals((File)objFile2, (File)objFile2));
        file.createNewFile();
        file2.createNewFile();
        Assertions.assertTrue((boolean)FileUtils.contentEquals((File)file, (File)file));
        Assertions.assertTrue((boolean)FileUtils.contentEquals((File)file, (File)file2));
    }

    @Test
    public void testContentEqualsIgnoreEOL() throws Exception {
        File file1 = new File(this.temporaryFolder, this.getName());
        File file2 = new File(this.temporaryFolder, this.getName() + "2");
        Assertions.assertTrue((boolean)FileUtils.contentEqualsIgnoreEOL(null, null, null));
        Assertions.assertFalse((boolean)FileUtils.contentEqualsIgnoreEOL(null, (File)file1, null));
        Assertions.assertFalse((boolean)FileUtils.contentEqualsIgnoreEOL((File)file1, null, null));
        Assertions.assertTrue((boolean)FileUtils.contentEqualsIgnoreEOL((File)file1, (File)file1, null));
        Assertions.assertTrue((boolean)FileUtils.contentEqualsIgnoreEOL((File)file1, (File)file2, null));
        Assertions.assertTrue((boolean)FileUtils.contentEqualsIgnoreEOL((File)file2, (File)file2, null));
        Assertions.assertTrue((boolean)FileUtils.contentEqualsIgnoreEOL((File)file2, (File)file1, null));
        Assertions.assertThrows(IllegalArgumentException.class, () -> FileUtils.contentEqualsIgnoreEOL((File)this.temporaryFolder, (File)this.temporaryFolder, null));
        File tfile1 = new File(this.temporaryFolder, this.getName() + ".txt1");
        tfile1.deleteOnExit();
        FileUtils.write((File)tfile1, (CharSequence)"123\r");
        File tfile2 = new File(this.temporaryFolder, this.getName() + ".txt2");
        tfile1.deleteOnExit();
        FileUtils.write((File)tfile2, (CharSequence)"123\n");
        File tfile3 = new File(this.temporaryFolder, this.getName() + ".collection");
        tfile3.deleteOnExit();
        FileUtils.write((File)tfile3, (CharSequence)"123\r\n2");
        Assertions.assertTrue((boolean)FileUtils.contentEqualsIgnoreEOL((File)tfile1, (File)tfile1, null));
        Assertions.assertTrue((boolean)FileUtils.contentEqualsIgnoreEOL((File)tfile2, (File)tfile2, null));
        Assertions.assertTrue((boolean)FileUtils.contentEqualsIgnoreEOL((File)tfile3, (File)tfile3, null));
        Assertions.assertTrue((boolean)FileUtils.contentEqualsIgnoreEOL((File)tfile1, (File)tfile2, null));
        Assertions.assertFalse((boolean)FileUtils.contentEqualsIgnoreEOL((File)tfile1, (File)tfile3, null));
        Assertions.assertFalse((boolean)FileUtils.contentEqualsIgnoreEOL((File)tfile2, (File)tfile3, null));
        URL urlCR = this.getClass().getResource("FileUtilsTestDataCR.dat");
        Assertions.assertNotNull((Object)urlCR);
        File cr = new File(urlCR.toURI());
        Assertions.assertTrue((boolean)cr.exists());
        URL urlCRLF = this.getClass().getResource("FileUtilsTestDataCRLF.dat");
        Assertions.assertNotNull((Object)urlCRLF);
        File crlf = new File(urlCRLF.toURI());
        Assertions.assertTrue((boolean)crlf.exists());
        URL urlLF = this.getClass().getResource("FileUtilsTestDataLF.dat");
        Assertions.assertNotNull((Object)urlLF);
        File lf = new File(urlLF.toURI());
        Assertions.assertTrue((boolean)lf.exists());
        Assertions.assertTrue((boolean)FileUtils.contentEqualsIgnoreEOL((File)cr, (File)cr, null));
        Assertions.assertTrue((boolean)FileUtils.contentEqualsIgnoreEOL((File)crlf, (File)crlf, null));
        Assertions.assertTrue((boolean)FileUtils.contentEqualsIgnoreEOL((File)lf, (File)lf, null));
        Assertions.assertTrue((boolean)FileUtils.contentEqualsIgnoreEOL((File)cr, (File)crlf, null));
        Assertions.assertTrue((boolean)FileUtils.contentEqualsIgnoreEOL((File)cr, (File)lf, null));
        Assertions.assertTrue((boolean)FileUtils.contentEqualsIgnoreEOL((File)crlf, (File)lf, null));
        Assertions.assertTrue((boolean)FileUtils.contentEquals((File)cr, (File)cr));
        Assertions.assertTrue((boolean)FileUtils.contentEquals((File)crlf, (File)crlf));
        Assertions.assertTrue((boolean)FileUtils.contentEquals((File)lf, (File)lf));
        Assertions.assertFalse((boolean)FileUtils.contentEquals((File)cr, (File)crlf));
        Assertions.assertFalse((boolean)FileUtils.contentEquals((File)cr, (File)lf));
        Assertions.assertFalse((boolean)FileUtils.contentEquals((File)crlf, (File)lf));
        file1.createNewFile();
        file2.createNewFile();
        Assertions.assertTrue((boolean)FileUtils.contentEqualsIgnoreEOL((File)file1, (File)file1, null));
        Assertions.assertTrue((boolean)FileUtils.contentEqualsIgnoreEOL((File)file1, (File)file2, null));
    }

    @Test
    public void testCopyDirectoryExceptions() {
        Assertions.assertThrows(NullPointerException.class, () -> FileUtils.copyDirectory(null, null));
        Assertions.assertThrows(NullPointerException.class, () -> FileUtils.copyDirectory(null, (File)this.testFile1));
        Assertions.assertThrows(NullPointerException.class, () -> FileUtils.copyDirectory((File)this.testFile1, null));
        Assertions.assertThrows(NullPointerException.class, () -> FileUtils.copyDirectory(null, (File)new File("a")));
        Assertions.assertThrows(IllegalArgumentException.class, () -> FileUtils.copyDirectory((File)this.testFile1, (File)new File("a")));
        Assertions.assertThrows(IllegalArgumentException.class, () -> FileUtils.copyDirectory((File)this.testFile1, (File)new File("a")));
        Assertions.assertThrows(IllegalArgumentException.class, () -> FileUtils.copyDirectory((File)this.temporaryFolder, (File)this.temporaryFolder));
        Assertions.assertThrows(IOException.class, () -> FileUtils.copyDirectory((File)new File("doesnt-exist"), (File)new File("a")));
        Assertions.assertThrows(IllegalArgumentException.class, () -> FileUtils.copyDirectory((File)this.temporaryFolder, (File)this.testFile1));
    }

    @Test
    public void testCopyDirectoryFiltered() throws Exception {
        File grandParentDir = new File(this.temporaryFolder, "grandparent");
        File parentDir = new File(grandParentDir, "parent");
        File childDir = new File(parentDir, "child");
        this.createFilesForTestCopyDirectory(grandParentDir, parentDir, childDir);
        NameFileFilter filter = new NameFileFilter(new String[]{"parent", "child", "file3.txt"});
        File destDir = new File(this.temporaryFolder, "copydest");
        FileUtils.copyDirectory((File)grandParentDir, (File)destDir, (FileFilter)filter);
        List<File> files = LIST_WALKER.list(destDir);
        Assertions.assertEquals((int)3, (int)files.size());
        Assertions.assertEquals((Object)"parent", (Object)files.get(0).getName());
        Assertions.assertEquals((Object)"child", (Object)files.get(1).getName());
        Assertions.assertEquals((Object)"file3.txt", (Object)files.get(2).getName());
    }

    @Test
    public void testCopyDirectoryPreserveDates() throws Exception {
        File source = new File(this.temporaryFolder, "source");
        File sourceDirectory = new File(source, "directory");
        File sourceFile = new File(sourceDirectory, "hello.txt");
        source.mkdirs();
        sourceDirectory.mkdir();
        FileUtils.writeStringToFile((File)sourceFile, (String)"HELLO WORLD", (String)"UTF8");
        Assertions.assertTrue((boolean)this.setLastModifiedMillis(sourceFile, 1000000002000L));
        Assertions.assertTrue((boolean)this.setLastModifiedMillis(sourceDirectory, 1000000001000L));
        Assertions.assertTrue((boolean)this.setLastModifiedMillis(source, 1000000000000L));
        File target = new File(this.temporaryFolder, "target");
        File targetDirectory = new File(target, "directory");
        File targetFile = new File(targetDirectory, "hello.txt");
        FileUtils.copyDirectory((File)source, (File)target, (boolean)false);
        Assertions.assertNotEquals((long)1000000000000L, (long)this.getLastModifiedMillis(target));
        Assertions.assertNotEquals((long)1000000001000L, (long)this.getLastModifiedMillis(targetDirectory));
        if (!SystemUtils.IS_OS_WINDOWS) {
            Assertions.assertNotEquals((long)1000000002000L, (long)this.getLastModifiedMillis(targetFile));
        }
        FileUtils.deleteDirectory((File)target);
        FileUtils.copyDirectory((File)source, (File)target, (boolean)true);
        Assertions.assertEquals((long)1000000000000L, (long)this.getLastModifiedMillis(target));
        Assertions.assertEquals((long)1000000001000L, (long)this.getLastModifiedMillis(targetDirectory));
        Assertions.assertEquals((long)1000000002000L, (long)this.getLastModifiedMillis(targetFile));
        FileUtils.deleteDirectory((File)target);
        target.mkdirs();
        FileUtils.copyDirectory((File)source, (File)target, (boolean)true);
        Assertions.assertEquals((long)1000000000000L, (long)this.getLastModifiedMillis(target));
        Assertions.assertEquals((long)1000000001000L, (long)this.getLastModifiedMillis(targetDirectory));
        Assertions.assertEquals((long)1000000002000L, (long)this.getLastModifiedMillis(targetFile));
        FileUtils.deleteDirectory((File)target);
        targetDirectory.mkdirs();
        FileUtils.copyDirectory((File)source, (File)target, (boolean)true);
        Assertions.assertEquals((long)1000000000000L, (long)this.getLastModifiedMillis(target));
        Assertions.assertEquals((long)1000000001000L, (long)this.getLastModifiedMillis(targetDirectory));
        Assertions.assertEquals((long)1000000002000L, (long)this.getLastModifiedMillis(targetFile));
        FileUtils.deleteDirectory((File)target);
    }

    @Test
    public void testCopyDirectoryToChild() throws Exception {
        File grandParentDir = new File(this.temporaryFolder, "grandparent");
        File parentDir = new File(grandParentDir, "parent");
        File childDir = new File(parentDir, "child");
        this.createFilesForTestCopyDirectory(grandParentDir, parentDir, childDir);
        long expectedCount = LIST_WALKER.list(grandParentDir).size() + LIST_WALKER.list(parentDir).size();
        long expectedSize = FileUtils.sizeOfDirectory((File)grandParentDir) + FileUtils.sizeOfDirectory((File)parentDir);
        FileUtils.copyDirectory((File)parentDir, (File)childDir);
        Assertions.assertEquals((long)expectedCount, (long)LIST_WALKER.list(grandParentDir).size());
        Assertions.assertEquals((long)expectedSize, (long)FileUtils.sizeOfDirectory((File)grandParentDir));
        Assertions.assertTrue((expectedCount > 0L ? 1 : 0) != 0, (String)"Count > 0");
        Assertions.assertTrue((expectedSize > 0L ? 1 : 0) != 0, (String)"Size > 0");
    }

    @Test
    public void testCopyDirectoryToDirectory_NonExistingDest() throws Exception {
        if (!this.testFile1.getParentFile().exists()) {
            throw new IOException("Cannot create file " + this.testFile1 + " as the parent directory does not exist");
        }
        BufferedOutputStream output1 = new BufferedOutputStream(new FileOutputStream(this.testFile1));
        try {
            TestUtils.generateTestData(output1, 1234L);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)output1);
        }
        if (!this.testFile2.getParentFile().exists()) {
            throw new IOException("Cannot create file " + this.testFile2 + " as the parent directory does not exist");
        }
        BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(this.testFile2));
        try {
            TestUtils.generateTestData(output, 4321L);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)output);
        }
        File srcDir = this.temporaryFolder;
        File subDir = new File(srcDir, "sub");
        subDir.mkdir();
        File subFile = new File(subDir, "A.txt");
        FileUtils.writeStringToFile((File)subFile, (String)"HELLO WORLD", (String)"UTF8");
        File destDir = new File(System.getProperty("java.io.tmpdir"), "tmp-FileUtilsTestCase");
        FileUtils.deleteDirectory((File)destDir);
        File actualDestDir = new File(destDir, srcDir.getName());
        FileUtils.copyDirectoryToDirectory((File)srcDir, (File)destDir);
        Assertions.assertTrue((boolean)destDir.exists(), (String)"Check exists");
        Assertions.assertTrue((boolean)actualDestDir.exists(), (String)"Check exists");
        long srcSize = FileUtils.sizeOfDirectory((File)srcDir);
        Assertions.assertTrue((srcSize > 0L ? 1 : 0) != 0, (String)"Size > 0");
        Assertions.assertEquals((long)srcSize, (long)FileUtils.sizeOfDirectory((File)actualDestDir), (String)"Check size");
        Assertions.assertTrue((boolean)new File(actualDestDir, "sub/A.txt").exists());
        FileUtils.deleteDirectory((File)destDir);
    }

    @Test
    public void testCopyDirectoryToExistingDest() throws Exception {
        if (!this.testFile1.getParentFile().exists()) {
            throw new IOException("Cannot create file " + this.testFile1 + " as the parent directory does not exist");
        }
        BufferedOutputStream output1 = new BufferedOutputStream(new FileOutputStream(this.testFile1));
        try {
            TestUtils.generateTestData(output1, 1234L);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)output1);
        }
        if (!this.testFile2.getParentFile().exists()) {
            throw new IOException("Cannot create file " + this.testFile2 + " as the parent directory does not exist");
        }
        BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(this.testFile2));
        try {
            TestUtils.generateTestData(output, 4321L);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)output);
        }
        File srcDir = this.temporaryFolder;
        File subDir = new File(srcDir, "sub");
        subDir.mkdir();
        File subFile = new File(subDir, "A.txt");
        FileUtils.writeStringToFile((File)subFile, (String)"HELLO WORLD", (String)"UTF8");
        File destDir = new File(System.getProperty("java.io.tmpdir"), "tmp-FileUtilsTestCase");
        FileUtils.deleteDirectory((File)destDir);
        destDir.mkdirs();
        FileUtils.copyDirectory((File)srcDir, (File)destDir);
        long srcSize = FileUtils.sizeOfDirectory((File)srcDir);
        Assertions.assertTrue((srcSize > 0L ? 1 : 0) != 0, (String)"Size > 0");
        Assertions.assertEquals((long)srcSize, (long)FileUtils.sizeOfDirectory((File)destDir));
        Assertions.assertTrue((boolean)new File(destDir, "sub/A.txt").exists());
    }

    @Test
    public void testCopyDirectoryToGrandChild() throws Exception {
        File grandParentDir = new File(this.temporaryFolder, "grandparent");
        File parentDir = new File(grandParentDir, "parent");
        File childDir = new File(parentDir, "child");
        this.createFilesForTestCopyDirectory(grandParentDir, parentDir, childDir);
        long expectedCount = LIST_WALKER.list(grandParentDir).size() * 2;
        long expectedSize = FileUtils.sizeOfDirectory((File)grandParentDir) * 2L;
        FileUtils.copyDirectory((File)grandParentDir, (File)childDir);
        Assertions.assertEquals((long)expectedCount, (long)LIST_WALKER.list(grandParentDir).size());
        Assertions.assertEquals((long)expectedSize, (long)FileUtils.sizeOfDirectory((File)grandParentDir));
        Assertions.assertTrue((expectedSize > 0L ? 1 : 0) != 0, (String)"Size > 0");
    }

    @Test
    public void testCopyDirectoryToItself() throws Exception {
        File dir = new File(this.temporaryFolder, "itself");
        dir.mkdirs();
        FileUtils.copyDirectoryToDirectory((File)dir, (File)dir);
        Assertions.assertEquals((int)1, (int)LIST_WALKER.list(dir).size());
    }

    @Test
    public void testCopyDirectoryToNonExistingDest() throws Exception {
        if (!this.testFile1.getParentFile().exists()) {
            throw new IOException("Cannot create file " + this.testFile1 + " as the parent directory does not exist");
        }
        BufferedOutputStream output1 = new BufferedOutputStream(new FileOutputStream(this.testFile1));
        try {
            TestUtils.generateTestData(output1, 1234L);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)output1);
        }
        if (!this.testFile2.getParentFile().exists()) {
            throw new IOException("Cannot create file " + this.testFile2 + " as the parent directory does not exist");
        }
        BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(this.testFile2));
        try {
            TestUtils.generateTestData(output, 4321L);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)output);
        }
        File srcDir = this.temporaryFolder;
        File subDir = new File(srcDir, "sub");
        subDir.mkdir();
        File subFile = new File(subDir, "A.txt");
        FileUtils.writeStringToFile((File)subFile, (String)"HELLO WORLD", (String)"UTF8");
        File destDir = new File(System.getProperty("java.io.tmpdir"), "tmp-FileUtilsTestCase");
        FileUtils.deleteDirectory((File)destDir);
        FileUtils.copyDirectory((File)srcDir, (File)destDir);
        Assertions.assertTrue((boolean)destDir.exists(), (String)"Check exists");
        long sizeOfSrcDirectory = FileUtils.sizeOfDirectory((File)srcDir);
        Assertions.assertTrue((sizeOfSrcDirectory > 0L ? 1 : 0) != 0, (String)"Size > 0");
        Assertions.assertEquals((long)sizeOfSrcDirectory, (long)FileUtils.sizeOfDirectory((File)destDir), (String)"Check size");
        Assertions.assertTrue((boolean)new File(destDir, "sub/A.txt").exists());
        FileUtils.deleteDirectory((File)destDir);
    }

    @Test
    public void testCopyFile1() throws Exception {
        File destination = new File(this.temporaryFolder, "copy1.txt");
        this.backDateFile10Minutes(this.testFile1);
        FileUtils.copyFile((File)this.testFile1, (File)destination);
        Assertions.assertTrue((boolean)destination.exists(), (String)"Check Exist");
        Assertions.assertEquals((long)this.testFile1Size, (long)destination.length(), (String)"Check Full copy");
        Assertions.assertEquals((long)this.getLastModifiedMillis(this.testFile1), (long)this.getLastModifiedMillis(destination), (String)"Check last modified date preserved");
    }

    @Test
    public void testCopyFile1ToDir() throws Exception {
        File directory = new File(this.temporaryFolder, "subdir");
        if (!directory.exists()) {
            directory.mkdirs();
        }
        File destination = new File(directory, this.testFile1.getName());
        this.backDateFile10Minutes(this.testFile1);
        FileUtils.copyFileToDirectory((File)this.testFile1, (File)directory);
        Assertions.assertTrue((boolean)destination.exists(), (String)"Check Exist");
        Assertions.assertEquals((long)this.testFile1Size, (long)destination.length(), (String)"Check Full copy");
        Assertions.assertEquals((long)FileUtils.lastModified((File)this.testFile1), (long)FileUtils.lastModified((File)destination), (String)"Check last modified date preserved");
        Assertions.assertThrows(IllegalArgumentException.class, () -> FileUtils.copyFileToDirectory((File)destination, (File)directory), (String)"Should not be able to copy a file into the same directory as itself");
    }

    @Test
    public void testCopyFile2() throws Exception {
        File destination = new File(this.temporaryFolder, "copy2.txt");
        this.backDateFile10Minutes(this.testFile1);
        FileUtils.copyFile((File)this.testFile1, (File)destination);
        Assertions.assertTrue((boolean)destination.exists(), (String)"Check Exist");
        Assertions.assertEquals((long)this.testFile2Size, (long)destination.length(), (String)"Check Full copy");
        Assertions.assertEquals((long)this.getLastModifiedMillis(this.testFile1), (long)this.getLastModifiedMillis(destination), (String)"Check last modified date preserved");
    }

    @Test
    public void testCopyFile2ToDir() throws Exception {
        File directory = new File(this.temporaryFolder, "subdir");
        if (!directory.exists()) {
            directory.mkdirs();
        }
        File destination = new File(directory, this.testFile1.getName());
        this.backDateFile10Minutes(this.testFile1);
        FileUtils.copyFileToDirectory((File)this.testFile1, (File)directory);
        Assertions.assertTrue((boolean)destination.exists(), (String)"Check Exist");
        Assertions.assertEquals((long)this.testFile2Size, (long)destination.length(), (String)"Check Full copy");
        Assertions.assertEquals((long)FileUtils.lastModified((File)this.testFile1), (long)FileUtils.lastModified((File)destination), (String)"Check last modified date preserved");
    }

    @Test
    public void testCopyFile2WithoutFileDatePreservation() throws Exception {
        File destFile = new File(this.temporaryFolder, "copy2.txt");
        this.backDateFile10Minutes(this.testFile1);
        long nowMillis = System.currentTimeMillis() - 1000L;
        FileUtils.copyFile((File)this.testFile1, (File)destFile, (boolean)false);
        Assertions.assertTrue((boolean)destFile.exists(), (String)"Check Exist");
        Assertions.assertEquals((long)this.testFile1Size, (long)destFile.length(), (String)"Check Full copy");
        long destLastModMillis = this.getLastModifiedMillis(destFile);
        long unexpectedMillis = this.getLastModifiedMillis(this.testFile1);
        if (!SystemUtils.IS_OS_WINDOWS) {
            long deltaMillis = destLastModMillis - unexpectedMillis;
            Assertions.assertNotEquals((long)unexpectedMillis, (long)destLastModMillis, (String)("Check last modified date not same as input, delta " + deltaMillis));
            Assertions.assertTrue((destLastModMillis > nowMillis ? 1 : 0) != 0, (String)(destLastModMillis + " > " + nowMillis + " (delta " + deltaMillis + ")"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Disabled
    public void testCopyFileLarge() throws Exception {
        File largeFile = new File(this.temporaryFolder, "large.txt");
        File destination = new File(this.temporaryFolder, "copylarge.txt");
        System.out.println("START:   " + new Date());
        if (!largeFile.getParentFile().exists()) {
            throw new IOException("Cannot create file " + largeFile + " as the parent directory does not exist");
        }
        BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(largeFile));
        try {
            TestUtils.generateTestData(output, 0x40000000L);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)output);
        }
        System.out.println("CREATED: " + new Date());
        FileUtils.copyFile((File)largeFile, (File)destination);
        System.out.println("COPIED:  " + new Date());
        Assertions.assertTrue((boolean)destination.exists(), (String)"Check Exist");
        Assertions.assertEquals((long)largeFile.length(), (long)destination.length(), (String)"Check Full copy");
    }

    @Test
    public void testCopyFileToOutputStream() throws Exception {
        ByteArrayOutputStream destination = new ByteArrayOutputStream();
        FileUtils.copyFile((File)this.testFile1, (OutputStream)destination);
        Assertions.assertEquals((long)this.testFile1Size, (long)destination.size(), (String)"Check Full copy size");
        byte[] expected = FileUtils.readFileToByteArray((File)this.testFile1);
        Assertions.assertArrayEquals((byte[])expected, (byte[])destination.toByteArray(), (String)"Check Full copy");
    }

    @Test
    public void testCopyToDirectoryWithDirectory() throws IOException {
        File inputDirectory;
        File destDirectory = new File(this.temporaryFolder, "destination");
        if (!destDirectory.exists()) {
            destDirectory.mkdirs();
        }
        if (!(inputDirectory = new File(this.temporaryFolder, "input")).exists()) {
            inputDirectory.mkdirs();
        }
        File outputDirDestination = new File(destDirectory, inputDirectory.getName());
        FileUtils.copyToDirectory((File)this.testFile1, (File)inputDirectory);
        File destFile1 = new File(outputDirDestination, this.testFile1.getName());
        FileUtils.copyToDirectory((File)this.testFile2, (File)inputDirectory);
        File destFile2 = new File(outputDirDestination, this.testFile2.getName());
        FileUtils.copyToDirectory((File)inputDirectory, (File)destDirectory);
        Assertions.assertTrue((boolean)outputDirDestination.exists(), (String)"Check Exists");
        Assertions.assertTrue((boolean)outputDirDestination.isDirectory(), (String)"Check Directory");
        Assertions.assertTrue((boolean)destFile1.exists(), (String)"Check Exists");
        Assertions.assertEquals((long)this.testFile1Size, (long)destFile1.length(), (String)"Check Full Copy");
        Assertions.assertTrue((boolean)destFile2.exists(), (String)"Check Exists");
        Assertions.assertEquals((long)this.testFile2Size, (long)destFile2.length(), (String)"Check Full Copy");
    }

    @Test
    public void testCopyToDirectoryWithFile() throws IOException {
        File directory = new File(this.temporaryFolder, "subdir");
        if (!directory.exists()) {
            directory.mkdirs();
        }
        File destination = new File(directory, this.testFile1.getName());
        FileUtils.copyToDirectory((File)this.testFile1, (File)directory);
        Assertions.assertTrue((boolean)destination.exists(), (String)"Check Exists");
        Assertions.assertEquals((long)this.testFile1Size, (long)destination.length(), (String)"Check Full Copy");
    }

    @Test
    public void testCopyToDirectoryWithFileSourceDoesNotExist() {
        Assertions.assertThrows(IOException.class, () -> FileUtils.copyToDirectory((File)new File(this.temporaryFolder, "doesNotExists"), (File)this.temporaryFolder));
    }

    @Test
    public void testCopyToDirectoryWithFileSourceIsNull() {
        Assertions.assertThrows(NullPointerException.class, () -> FileUtils.copyToDirectory((File)null, (File)this.temporaryFolder));
    }

    @Test
    public void testCopyToDirectoryWithIterable() throws IOException {
        File directory = new File(this.temporaryFolder, "subdir");
        if (!directory.exists()) {
            directory.mkdirs();
        }
        ArrayList<File> input = new ArrayList<File>();
        input.add(this.testFile1);
        input.add(this.testFile2);
        File destFile1 = new File(directory, this.testFile1.getName());
        File destFile2 = new File(directory, this.testFile2.getName());
        FileUtils.copyToDirectory(input, (File)directory);
        Assertions.assertTrue((boolean)destFile1.exists(), (String)"Check Exists");
        Assertions.assertEquals((long)this.testFile1Size, (long)destFile1.length(), (String)"Check Full Copy");
        Assertions.assertTrue((boolean)destFile2.exists(), (String)"Check Exists");
        Assertions.assertEquals((long)this.testFile2Size, (long)destFile2.length(), (String)"Check Full Copy");
    }

    @Test
    public void testCopyToDirectoryWithIterableSourceDoesNotExist() {
        Assertions.assertThrows(IOException.class, () -> FileUtils.copyToDirectory(Collections.singleton(new File(this.temporaryFolder, "doesNotExists")), (File)this.temporaryFolder));
    }

    @Test
    public void testCopyToDirectoryWithIterableSourceIsNull() {
        Assertions.assertThrows(NullPointerException.class, () -> FileUtils.copyToDirectory((Iterable)null, (File)this.temporaryFolder));
    }

    @Test
    public void testCopyToSelf() throws Exception {
        File destination = new File(this.temporaryFolder, "copy3.txt");
        FileUtils.copyFile((File)this.testFile1, (File)destination);
        Assertions.assertThrows(IllegalArgumentException.class, () -> FileUtils.copyFile((File)destination, (File)destination));
    }

    @Test
    public void testCopyURLToFile() throws Exception {
        File file = new File(this.temporaryFolder, this.getName());
        file.deleteOnExit();
        String resourceName = "/java/lang/Object.class";
        FileUtils.copyURLToFile((URL)this.getClass().getResource("/java/lang/Object.class"), (File)file);
        try (FileInputStream fis = new FileInputStream(file);){
            Assertions.assertTrue((boolean)IOUtils.contentEquals((InputStream)this.getClass().getResourceAsStream("/java/lang/Object.class"), (InputStream)fis), (String)"Content is not equal.");
        }
    }

    @Test
    public void testCopyURLToFileWithTimeout() throws Exception {
        File file = new File(this.temporaryFolder, "testCopyURLToFileWithTimeout");
        file.deleteOnExit();
        String resourceName = "/java/lang/Object.class";
        FileUtils.copyURLToFile((URL)this.getClass().getResource("/java/lang/Object.class"), (File)file, (int)500, (int)500);
        try (FileInputStream fis = new FileInputStream(file);){
            Assertions.assertTrue((boolean)IOUtils.contentEquals((InputStream)this.getClass().getResourceAsStream("/java/lang/Object.class"), (InputStream)fis), (String)"Content is not equal.");
        }
    }

    @Test
    public void testDecodeUrl() {
        Assertions.assertEquals((Object)"", (Object)FileUtils.decodeUrl((String)""));
        Assertions.assertEquals((Object)"foo", (Object)FileUtils.decodeUrl((String)"foo"));
        Assertions.assertEquals((Object)"+", (Object)FileUtils.decodeUrl((String)"+"));
        Assertions.assertEquals((Object)"% ", (Object)FileUtils.decodeUrl((String)"%25%20"));
        Assertions.assertEquals((Object)"%20", (Object)FileUtils.decodeUrl((String)"%2520"));
        Assertions.assertEquals((Object)"jar:file:/C:/dir/sub dir/1.0/foo-1.0.jar!/org/Bar.class", (Object)FileUtils.decodeUrl((String)"jar:file:/C:/dir/sub%20dir/1.0/foo-1.0.jar!/org/Bar.class"));
    }

    @Test
    public void testDecodeUrlEncodingUtf8() {
        Assertions.assertEquals((Object)"\u00e4\u00f6\u00fc\u00df", (Object)FileUtils.decodeUrl((String)"%C3%A4%C3%B6%C3%BC%C3%9F"));
    }

    @Test
    public void testDecodeUrlLenient() {
        Assertions.assertEquals((Object)" ", (Object)FileUtils.decodeUrl((String)" "));
        Assertions.assertEquals((Object)"\u00e4\u00f6\u00fc\u00df", (Object)FileUtils.decodeUrl((String)"\u00e4\u00f6\u00fc\u00df"));
        Assertions.assertEquals((Object)"%", (Object)FileUtils.decodeUrl((String)"%"));
        Assertions.assertEquals((Object)"% ", (Object)FileUtils.decodeUrl((String)"%%20"));
        Assertions.assertEquals((Object)"%2", (Object)FileUtils.decodeUrl((String)"%2"));
        Assertions.assertEquals((Object)"%2G", (Object)FileUtils.decodeUrl((String)"%2G"));
    }

    @Test
    public void testDecodeUrlNullSafe() {
        Assertions.assertNull((Object)FileUtils.decodeUrl(null));
    }

    @Test
    public void testDelete() throws Exception {
        Assertions.assertEquals((Object)this.testFile1, (Object)FileUtils.delete((File)this.testFile1));
        Assertions.assertThrows(IOException.class, () -> FileUtils.delete((File)new File("does not exist.nope")));
    }

    @Test
    public void testDeleteDirectoryWithNonDirectory() throws Exception {
        try {
            FileUtils.deleteDirectory((File)this.testFile1);
            Assertions.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteQuietlyDir() throws IOException {
        File testDirectory = new File(this.temporaryFolder, "testDeleteQuietlyDir");
        File testFile = new File(testDirectory, "testDeleteQuietlyFile");
        testDirectory.mkdirs();
        if (!testFile.getParentFile().exists()) {
            throw new IOException("Cannot create file " + testFile + " as the parent directory does not exist");
        }
        BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(testFile));
        try {
            TestUtils.generateTestData(output, 0L);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)output);
        }
        Assertions.assertTrue((boolean)testDirectory.exists());
        Assertions.assertTrue((boolean)testFile.exists());
        FileUtils.deleteQuietly((File)testDirectory);
        Assertions.assertFalse((boolean)testDirectory.exists(), (String)"Check No Exist");
        Assertions.assertFalse((boolean)testFile.exists(), (String)"Check No Exist");
    }

    @Test
    public void testDeleteQuietlyFile() throws IOException {
        File testFile = new File(this.temporaryFolder, "testDeleteQuietlyFile");
        if (!testFile.getParentFile().exists()) {
            throw new IOException("Cannot create file " + testFile + " as the parent directory does not exist");
        }
        BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(testFile));
        try {
            TestUtils.generateTestData(output, 0L);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)output);
        }
        Assertions.assertTrue((boolean)testFile.exists());
        FileUtils.deleteQuietly((File)testFile);
        Assertions.assertFalse((boolean)testFile.exists(), (String)"Check No Exist");
    }

    @Test
    public void testDeleteQuietlyForNull() {
        try {
            FileUtils.deleteQuietly(null);
        }
        catch (Exception ex) {
            Assertions.fail((String)ex.getMessage());
        }
    }

    @Test
    public void testDeleteQuietlyNonExistent() {
        File testFile = new File("testDeleteQuietlyNonExistent");
        Assertions.assertFalse((boolean)testFile.exists());
        try {
            FileUtils.deleteQuietly((File)testFile);
        }
        catch (Exception ex) {
            Assertions.fail((String)ex.getMessage());
        }
    }

    @Test
    public void testFileUtils() throws Exception {
        File file1 = new File(this.temporaryFolder, "test.txt");
        String filename = file1.getAbsolutePath();
        try (FileOutputStream out = new FileOutputStream(file1);){
            ((OutputStream)out).write("This is a test".getBytes(StandardCharsets.UTF_8));
        }
        File file2 = new File(this.temporaryFolder, "test2.txt");
        FileUtils.writeStringToFile((File)file2, (String)filename, (String)"UTF-8");
        Assertions.assertTrue((boolean)file2.exists());
        Assertions.assertTrue((file2.length() > 0L ? 1 : 0) != 0);
        String file2contents = FileUtils.readFileToString((File)file2, (String)"UTF-8");
        Assertions.assertEquals((Object)filename, (Object)file2contents, (String)"Second file's contents correct");
        Assertions.assertTrue((boolean)file2.delete());
        String contents = FileUtils.readFileToString((File)new File(filename), (String)"UTF-8");
        Assertions.assertEquals((Object)"This is a test", (Object)contents, (String)"FileUtils.fileRead()");
    }

    @Test
    public void testForceDeleteAFile1() throws Exception {
        File destination = new File(this.temporaryFolder, "copy1.txt");
        destination.createNewFile();
        Assertions.assertTrue((boolean)destination.exists(), (String)"Copy1.txt doesn't exist to delete");
        FileUtils.forceDelete((File)destination);
        Assertions.assertFalse((boolean)destination.exists(), (String)"Check No Exist");
    }

    @Test
    public void testForceDeleteAFile2() throws Exception {
        File destination = new File(this.temporaryFolder, "copy2.txt");
        destination.createNewFile();
        Assertions.assertTrue((boolean)destination.exists(), (String)"Copy2.txt doesn't exist to delete");
        FileUtils.forceDelete((File)destination);
        Assertions.assertFalse((boolean)destination.exists(), (String)"Check No Exist");
    }

    @Test
    public void testForceDeleteAFile3() throws Exception {
        File destination = new File(this.temporaryFolder, "no_such_file");
        Assertions.assertFalse((boolean)destination.exists(), (String)"Check No Exist");
        try {
            FileUtils.forceDelete((File)destination);
            Assertions.fail((String)"Should generate FileNotFoundException");
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testForceDeleteDir() throws Exception {
        File testDirectory = this.temporaryFolder;
        Assertions.assertTrue((boolean)testDirectory.exists(), (String)"TestDirectory must exist");
        FileUtils.forceDelete((File)testDirectory);
        Assertions.assertFalse((boolean)testDirectory.exists(), (String)"TestDirectory must not exist");
    }

    @Test
    public void testForceDeleteReadOnlyFile() throws Exception {
        File destination = File.createTempFile("test-", ".txt");
        Assertions.assertTrue((boolean)destination.setReadOnly());
        Assertions.assertTrue((boolean)destination.canRead());
        Assertions.assertFalse((boolean)destination.canWrite());
        Assertions.assertTrue((boolean)destination.delete());
        destination = File.createTempFile("test-", ".txt");
        Assertions.assertTrue((boolean)destination.setReadOnly());
        Assertions.assertTrue((boolean)destination.canRead());
        Assertions.assertFalse((boolean)destination.canWrite());
        Assertions.assertTrue((boolean)destination.exists(), (String)"File doesn't exist to delete");
        FileUtils.forceDelete((File)destination);
        Assertions.assertFalse((boolean)destination.exists(), (String)"Check deletion");
    }

    @Test
    public void testForceMkdir() throws Exception {
        FileUtils.forceMkdir((File)this.temporaryFolder);
        File testFile = new File(this.temporaryFolder, this.getName());
        testFile.deleteOnExit();
        testFile.createNewFile();
        Assertions.assertTrue((boolean)testFile.exists(), (String)"Test file does not exist.");
        Assertions.assertThrows(IOException.class, () -> FileUtils.forceMkdir((File)testFile));
        testFile.delete();
        FileUtils.forceMkdir((File)testFile);
        Assertions.assertTrue((boolean)testFile.exists(), (String)"Directory was not created.");
    }

    @Test
    public void testForceMkdirParent() throws Exception {
        Assertions.assertTrue((boolean)this.temporaryFolder.exists());
        File testParentDir = new File(this.temporaryFolder, "testForceMkdirParent");
        testParentDir.delete();
        Assertions.assertFalse((boolean)testParentDir.exists());
        File testFile = new File(testParentDir, "test.txt");
        Assertions.assertFalse((boolean)testParentDir.exists());
        Assertions.assertFalse((boolean)testFile.exists());
        FileUtils.forceMkdirParent((File)testFile);
        Assertions.assertTrue((boolean)testParentDir.exists());
        Assertions.assertFalse((boolean)testFile.exists());
        FileUtils.forceMkdirParent((File)testFile);
        Assertions.assertTrue((boolean)testParentDir.exists());
        Assertions.assertFalse((boolean)testFile.exists());
    }

    @Test
    public void testGetFile() {
        File expected_A = new File("src");
        File expected_B = new File(expected_A, "main");
        File expected_C = new File(expected_B, "java");
        Assertions.assertEquals((Object)expected_A, (Object)FileUtils.getFile((String[])new String[]{"src"}), (String)"A");
        Assertions.assertEquals((Object)expected_B, (Object)FileUtils.getFile((String[])new String[]{"src", "main"}), (String)"B");
        Assertions.assertEquals((Object)expected_C, (Object)FileUtils.getFile((String[])new String[]{"src", "main", "java"}), (String)"C");
        try {
            FileUtils.getFile((String[])null);
            Assertions.fail((String)"Expected NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testGetFile_Parent() {
        File parent = new File("parent");
        File expected_A = new File(parent, "src");
        File expected_B = new File(expected_A, "main");
        File expected_C = new File(expected_B, "java");
        Assertions.assertEquals((Object)expected_A, (Object)FileUtils.getFile((File)parent, (String[])new String[]{"src"}), (String)"A");
        Assertions.assertEquals((Object)expected_B, (Object)FileUtils.getFile((File)parent, (String[])new String[]{"src", "main"}), (String)"B");
        Assertions.assertEquals((Object)expected_C, (Object)FileUtils.getFile((File)parent, (String[])new String[]{"src", "main", "java"}), (String)"C");
        try {
            FileUtils.getFile((File)parent, (String[])null);
            Assertions.fail((String)"Expected NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            FileUtils.getFile((File)null, (String[])new String[]{"src"});
            Assertions.fail((String)"Expected NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testGetTempDirectory() {
        File tempDirectory = new File(System.getProperty("java.io.tmpdir"));
        Assertions.assertEquals((Object)tempDirectory, (Object)FileUtils.getTempDirectory());
    }

    @Test
    public void testGetTempDirectoryPath() {
        Assertions.assertEquals((Object)System.getProperty("java.io.tmpdir"), (Object)FileUtils.getTempDirectoryPath());
    }

    @Test
    public void testGetUserDirectory() {
        File userDirectory = new File(System.getProperty("user.home"));
        Assertions.assertEquals((Object)userDirectory, (Object)FileUtils.getUserDirectory());
    }

    @Test
    public void testGetUserDirectoryPath() {
        Assertions.assertEquals((Object)System.getProperty("user.home"), (Object)FileUtils.getUserDirectoryPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIncorrectOutputSize() {
        File inFile = new File("pom.xml");
        ShorterFile outFile = new ShorterFile("target/pom.tmp");
        try {
            FileUtils.copyFile((File)inFile, (File)outFile);
            Assertions.fail((String)"Expected IOException");
        }
        catch (Exception e) {
            String msg = e.toString();
            Assertions.assertTrue((boolean)msg.contains("Failed to copy full contents"), (String)msg);
        }
        finally {
            outFile.delete();
        }
    }

    @Test
    public void testIO276() throws Exception {
        File dir = new File("target", "IO276");
        Assertions.assertTrue((boolean)dir.mkdirs(), (String)(dir + " should not be present"));
        File file = new File(dir, "IO276.txt");
        Assertions.assertTrue((boolean)file.createNewFile(), (String)(file + " should not be present"));
        FileUtils.forceDeleteOnExit((File)dir);
    }

    @Test
    public void testIO300() {
        File testDirectory = this.temporaryFolder;
        File src = new File(testDirectory, "dir1");
        File dest = new File(src, "dir2");
        Assertions.assertTrue((boolean)dest.mkdirs());
        Assertions.assertTrue((boolean)src.exists());
        try {
            FileUtils.moveDirectoryToDirectory((File)src, (File)dest, (boolean)false);
            Assertions.fail((String)"expected IOException");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Assertions.assertTrue((boolean)src.exists());
    }

    @Test
    public void testIsEmptyDirectory() throws IOException {
        Path tempDir = Files.createTempDirectory(this.getClass().getCanonicalName(), new FileAttribute[0]);
        File tempDirAsFile = tempDir.toFile();
        try {
            Assertions.assertTrue((boolean)FileUtils.isEmptyDirectory((File)tempDirAsFile));
        }
        finally {
            Files.delete(tempDir);
        }
        Assertions.assertFalse((boolean)FileUtils.isEmptyDirectory((File)PathUtilsIsEmptyTest.DIR_SIZE_1.toFile()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIsFileNewerOlder() throws Exception {
        String message;
        File reference = new File(this.temporaryFolder, "FileUtils-reference.txt");
        File oldFile = new File(this.temporaryFolder, "FileUtils-old.txt");
        File newFile = new File(this.temporaryFolder, "FileUtils-new.txt");
        File invalidFile = new File(this.temporaryFolder, "FileUtils-invalid-file.txt");
        if (!oldFile.getParentFile().exists()) {
            throw new IOException("Cannot create file " + oldFile + " as the parent directory does not exist");
        }
        BufferedOutputStream output1 = new BufferedOutputStream(new FileOutputStream(oldFile));
        try {
            TestUtils.generateTestData(output1, 0L);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)output1);
        }
        do {
            try {
                TestUtils.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!reference.getParentFile().exists()) {
                throw new IOException("Cannot create file " + reference + " as the parent directory does not exist");
            }
            BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(reference));
            try {
                TestUtils.generateTestData(output, 0L);
            }
            finally {
                IOUtils.closeQuietly((OutputStream)output);
            }
        } while (this.getLastModifiedMillis(oldFile) == this.getLastModifiedMillis(reference));
        Date date = new Date();
        long now = date.getTime();
        Instant instant = date.toInstant();
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(instant, ZoneId.systemDefault());
        LocalDateTime localDateTime = zonedDateTime.toLocalDateTime();
        LocalDate localDate = zonedDateTime.toLocalDate();
        LocalDate localDatePlusDay = localDate.plusDays(1L);
        LocalTime localTime = LocalTime.ofSecondOfDay(0L);
        do {
            try {
                TestUtils.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!newFile.getParentFile().exists()) {
                throw new IOException("Cannot create file " + newFile + " as the parent directory does not exist");
            }
            BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(newFile));
            try {
                TestUtils.generateTestData(output, 0L);
            }
            finally {
                IOUtils.closeQuietly((OutputStream)output);
            }
        } while (this.getLastModifiedMillis(reference) == this.getLastModifiedMillis(newFile));
        Assertions.assertFalse((boolean)FileUtils.isFileNewer((File)oldFile, (File)reference), (String)"Old File - Newer - File");
        Assertions.assertFalse((boolean)FileUtils.isFileNewer((File)oldFile, (Date)date), (String)"Old File - Newer - Date");
        Assertions.assertFalse((boolean)FileUtils.isFileNewer((File)oldFile, (long)now), (String)"Old File - Newer - Mili");
        Assertions.assertFalse((boolean)FileUtils.isFileNewer((File)oldFile, (Instant)instant), (String)"Old File - Newer - Instant");
        Assertions.assertFalse((boolean)FileUtils.isFileNewer((File)oldFile, (ChronoZonedDateTime)zonedDateTime), (String)"Old File - Newer - ZonedDateTime");
        Assertions.assertFalse((boolean)FileUtils.isFileNewer((File)oldFile, (ChronoLocalDateTime)localDateTime), (String)"Old File - Newer - LocalDateTime");
        Assertions.assertFalse((boolean)FileUtils.isFileNewer((File)oldFile, (ChronoLocalDateTime)localDateTime, (ZoneId)ZoneId.systemDefault()), (String)"Old File - Newer - LocalDateTime,ZoneId");
        Assertions.assertFalse((boolean)FileUtils.isFileNewer((File)oldFile, (ChronoLocalDate)localDate), (String)"Old File - Newer - LocalDate");
        Assertions.assertTrue((boolean)FileUtils.isFileNewer((File)oldFile, (ChronoLocalDate)localDate, (LocalTime)localTime), (String)"Old File - Newer - LocalDate,ZoneId");
        Assertions.assertFalse((boolean)FileUtils.isFileNewer((File)oldFile, (ChronoLocalDate)localDatePlusDay), (String)"Old File - Newer - LocalDate plus one day");
        Assertions.assertFalse((boolean)FileUtils.isFileNewer((File)oldFile, (ChronoLocalDate)localDatePlusDay, (LocalTime)localTime), (String)"Old File - Newer - LocalDate plus one day,ZoneId");
        Assertions.assertTrue((boolean)FileUtils.isFileNewer((File)newFile, (File)reference), (String)"New File - Newer - File");
        Assertions.assertTrue((boolean)FileUtils.isFileNewer((File)newFile, (Date)date), (String)"New File - Newer - Date");
        Assertions.assertTrue((boolean)FileUtils.isFileNewer((File)newFile, (long)now), (String)"New File - Newer - Mili");
        Assertions.assertTrue((boolean)FileUtils.isFileNewer((File)newFile, (Instant)instant), (String)"New File - Newer - Instant");
        Assertions.assertTrue((boolean)FileUtils.isFileNewer((File)newFile, (ChronoZonedDateTime)zonedDateTime), (String)"New File - Newer - ZonedDateTime");
        Assertions.assertTrue((boolean)FileUtils.isFileNewer((File)newFile, (ChronoLocalDateTime)localDateTime), (String)"New File - Newer - LocalDateTime");
        Assertions.assertTrue((boolean)FileUtils.isFileNewer((File)newFile, (ChronoLocalDateTime)localDateTime, (ZoneId)ZoneId.systemDefault()), (String)"New File - Newer - LocalDateTime,ZoneId");
        Assertions.assertFalse((boolean)FileUtils.isFileNewer((File)newFile, (ChronoLocalDate)localDate), (String)"New File - Newer - LocalDate");
        Assertions.assertTrue((boolean)FileUtils.isFileNewer((File)newFile, (ChronoLocalDate)localDate, (LocalTime)localTime), (String)"New File - Newer - LocalDate,ZoneId");
        Assertions.assertFalse((boolean)FileUtils.isFileNewer((File)newFile, (ChronoLocalDate)localDatePlusDay), (String)"New File - Newer - LocalDate plus one day");
        Assertions.assertFalse((boolean)FileUtils.isFileNewer((File)newFile, (ChronoLocalDate)localDatePlusDay, (LocalTime)localTime), (String)"New File - Newer - LocalDate plus one day,ZoneId");
        Assertions.assertFalse((boolean)FileUtils.isFileNewer((File)invalidFile, (File)reference), (String)"Invalid - Newer - File");
        String invalidFileName = invalidFile.getName();
        try {
            FileUtils.isFileNewer((File)newFile, (File)invalidFile);
            Assertions.fail((String)"Should have cause IllegalArgumentException");
        }
        catch (IllegalArgumentException iae) {
            message = iae.getMessage();
            Assertions.assertTrue((boolean)message.contains(invalidFileName), (String)("Message should contain: " + invalidFileName + " but was: " + message));
        }
        Assertions.assertTrue((boolean)FileUtils.isFileOlder((File)oldFile, (File)reference), (String)"Old File - Older - File");
        Assertions.assertTrue((boolean)FileUtils.isFileOlder((File)oldFile, (Date)date), (String)"Old File - Older - Date");
        Assertions.assertTrue((boolean)FileUtils.isFileOlder((File)oldFile, (long)now), (String)"Old File - Older - Mili");
        Assertions.assertTrue((boolean)FileUtils.isFileOlder((File)oldFile, (Instant)instant), (String)"Old File - Older - Instant");
        Assertions.assertTrue((boolean)FileUtils.isFileOlder((File)oldFile, (ChronoZonedDateTime)zonedDateTime), (String)"Old File - Older - ZonedDateTime");
        Assertions.assertTrue((boolean)FileUtils.isFileOlder((File)oldFile, (ChronoLocalDateTime)localDateTime), (String)"Old File - Older - LocalDateTime");
        Assertions.assertTrue((boolean)FileUtils.isFileOlder((File)oldFile, (ChronoLocalDateTime)localDateTime, (ZoneId)ZoneId.systemDefault()), (String)"Old File - Older - LocalDateTime,LocalTime");
        Assertions.assertTrue((boolean)FileUtils.isFileOlder((File)oldFile, (ChronoLocalDate)localDate), (String)"Old File - Older - LocalDate");
        Assertions.assertFalse((boolean)FileUtils.isFileOlder((File)oldFile, (ChronoLocalDate)localDate, (LocalTime)localTime), (String)"Old File - Older - LocalDate,ZoneId");
        Assertions.assertTrue((boolean)FileUtils.isFileOlder((File)oldFile, (ChronoLocalDate)localDatePlusDay), (String)"Old File - Older - LocalDate plus one day");
        Assertions.assertTrue((boolean)FileUtils.isFileOlder((File)oldFile, (ChronoLocalDate)localDatePlusDay, (LocalTime)localTime), (String)"Old File - Older - LocalDate plus one day,LocalTime");
        Assertions.assertFalse((boolean)FileUtils.isFileOlder((File)newFile, (File)reference), (String)"New File - Older - File");
        Assertions.assertFalse((boolean)FileUtils.isFileOlder((File)newFile, (Date)date), (String)"New File - Older - Date");
        Assertions.assertFalse((boolean)FileUtils.isFileOlder((File)newFile, (long)now), (String)"New File - Older - Mili");
        Assertions.assertFalse((boolean)FileUtils.isFileOlder((File)newFile, (Instant)instant), (String)"New File - Older - Instant");
        Assertions.assertFalse((boolean)FileUtils.isFileOlder((File)newFile, (ChronoZonedDateTime)zonedDateTime), (String)"New File - Older - ZonedDateTime");
        Assertions.assertFalse((boolean)FileUtils.isFileOlder((File)newFile, (ChronoLocalDateTime)localDateTime), (String)"New File - Older - LocalDateTime");
        Assertions.assertFalse((boolean)FileUtils.isFileOlder((File)newFile, (ChronoLocalDateTime)localDateTime, (ZoneId)ZoneId.systemDefault()), (String)"New File - Older - LocalDateTime,ZoneId");
        Assertions.assertTrue((boolean)FileUtils.isFileOlder((File)newFile, (ChronoLocalDate)localDate), (String)"New File - Older - LocalDate");
        Assertions.assertFalse((boolean)FileUtils.isFileOlder((File)newFile, (ChronoLocalDate)localDate, (LocalTime)localTime), (String)"New File - Older - LocalDate,LocalTime");
        Assertions.assertTrue((boolean)FileUtils.isFileOlder((File)newFile, (ChronoLocalDate)localDatePlusDay), (String)"New File - Older - LocalDate plus one day");
        Assertions.assertTrue((boolean)FileUtils.isFileOlder((File)newFile, (ChronoLocalDate)localDatePlusDay, (LocalTime)localTime), (String)"New File - Older - LocalDate plus one day,LocalTime");
        Assertions.assertFalse((boolean)FileUtils.isFileOlder((File)invalidFile, (File)reference), (String)"Invalid - Older - File");
        Assertions.assertThrows(IllegalArgumentException.class, () -> FileUtils.isFileOlder((File)newFile, (File)invalidFile));
        try {
            FileUtils.isFileOlder((File)newFile, (File)invalidFile);
            Assertions.fail((String)"Should have cause IllegalArgumentException");
        }
        catch (IllegalArgumentException iae) {
            message = iae.getMessage();
            Assertions.assertTrue((boolean)message.contains(invalidFileName), (String)("Message should contain: " + invalidFileName + " but was: " + message));
        }
        Assertions.assertThrows(NullPointerException.class, () -> FileUtils.isFileNewer(null, (long)now));
        Assertions.assertThrows(NullPointerException.class, () -> FileUtils.isFileNewer((File)oldFile, (File)null));
        Assertions.assertThrows(IllegalArgumentException.class, () -> FileUtils.isFileNewer((File)oldFile, (File)invalidFile));
        Assertions.assertThrows(NullPointerException.class, () -> FileUtils.isFileNewer((File)oldFile, (Date)null));
        Assertions.assertThrows(NullPointerException.class, () -> FileUtils.isFileOlder(null, (long)now));
        Assertions.assertThrows(NullPointerException.class, () -> FileUtils.isFileOlder((File)oldFile, (File)null));
        Assertions.assertThrows(NullPointerException.class, () -> FileUtils.isFileOlder((File)oldFile, (Date)null));
        Assertions.assertThrows(IllegalArgumentException.class, () -> FileUtils.isFileOlder((File)oldFile, (File)invalidFile));
    }

    @Test
    public void testIsDirectory() throws IOException {
        Assertions.assertFalse((boolean)FileUtils.isDirectory(null, (LinkOption[])new LinkOption[0]));
        Assertions.assertTrue((boolean)FileUtils.isDirectory((File)this.temporaryFolder, (LinkOption[])new LinkOption[0]));
        Assertions.assertFalse((boolean)FileUtils.isDirectory((File)this.testFile1, (LinkOption[])new LinkOption[0]));
        Path tempDir = Files.createTempDirectory(this.getClass().getCanonicalName(), new FileAttribute[0]);
        File tempDirAsFile = tempDir.toFile();
        Files.delete(tempDir);
        Assertions.assertFalse((boolean)FileUtils.isDirectory((File)tempDirAsFile, (LinkOption[])new LinkOption[0]));
    }

    @Test
    public void testIsRegularFile() throws IOException {
        Assertions.assertFalse((boolean)FileUtils.isRegularFile(null, (LinkOption[])new LinkOption[0]));
        Assertions.assertFalse((boolean)FileUtils.isRegularFile((File)this.temporaryFolder, (LinkOption[])new LinkOption[0]));
        Assertions.assertTrue((boolean)FileUtils.isRegularFile((File)this.testFile1, (LinkOption[])new LinkOption[0]));
        Files.delete(this.testFile1.toPath());
        Assertions.assertFalse((boolean)FileUtils.isRegularFile((File)this.testFile1, (LinkOption[])new LinkOption[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIterateFiles() throws Exception {
        File srcDir = this.temporaryFolder;
        File subDir = new File(srcDir, "list_test");
        File subSubDir = new File(subDir, "subSubDir");
        File notSubSubDir = new File(subDir, "notSubSubDir");
        Assertions.assertTrue((boolean)subDir.mkdir());
        Assertions.assertTrue((boolean)subSubDir.mkdir());
        Assertions.assertTrue((boolean)notSubSubDir.mkdir());
        Iterator iterator = null;
        try {
            ArrayList<String> expectedFileNames = new ArrayList<String>(Arrays.asList("a.txt", "b.txt", "c.txt", "d.txt", "e.txt", "f.txt"));
            int[] fileSizes = new int[]{123, 234, 345, 456, 678, 789};
            Assertions.assertEquals((int)expectedFileNames.size(), (int)fileSizes.length);
            Collections.sort(expectedFileNames);
            Arrays.sort(fileSizes);
            for (int i = 0; i < fileSizes.length; ++i) {
                TestUtils.generateTestData(new File(subDir, (String)expectedFileNames.get(i)), (long)fileSizes[i]);
            }
            String subSubFileName = "z.txt";
            TestUtils.generateTestData(new File(subSubDir, "z.txt"), 1L);
            expectedFileNames.add("z.txt");
            String notSubSubFileName = "not.txt";
            TestUtils.generateTestData(new File(notSubSubDir, "not.txt"), 1L);
            WildcardFileFilter allFilesFileFilter = new WildcardFileFilter("*.*");
            NameFileFilter dirFilter = new NameFileFilter("subSubDir");
            iterator = FileUtils.iterateFiles((File)subDir, (IOFileFilter)allFilesFileFilter, (IOFileFilter)dirFilter);
            HashMap<String, String> matchedFileNames = new HashMap<String, String>();
            ArrayList<String> actualFileNames = new ArrayList<String>();
            while (iterator.hasNext()) {
                boolean found = false;
                String fileName = ((File)iterator.next()).getName();
                actualFileNames.add(fileName);
                for (int j = 0; !found && j < expectedFileNames.size(); ++j) {
                    String expectedFileName = (String)expectedFileNames.get(j);
                    if (!expectedFileName.equals(fileName)) continue;
                    matchedFileNames.put(expectedFileName, expectedFileName);
                    found = true;
                }
            }
            Assertions.assertEquals((int)expectedFileNames.size(), (int)matchedFileNames.size());
            Collections.sort(actualFileNames);
            Assertions.assertEquals(expectedFileNames, actualFileNames);
            this.consumeRemaining(iterator);
            notSubSubDir.delete();
        }
        catch (Throwable throwable) {
            this.consumeRemaining(iterator);
            notSubSubDir.delete();
            subSubDir.delete();
            subDir.delete();
            throw throwable;
        }
        subSubDir.delete();
        subDir.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIterateFilesAndDirs() throws IOException {
        File srcDir = this.temporaryFolder;
        File subDir1 = new File(srcDir, "subdir1");
        File subDir2 = new File(subDir1, "subdir2");
        File subDir3 = new File(subDir2, "subdir3");
        File subDir4 = new File(subDir2, "subdir4");
        Assertions.assertTrue((boolean)subDir1.mkdir());
        Assertions.assertTrue((boolean)subDir2.mkdir());
        Assertions.assertTrue((boolean)subDir3.mkdir());
        Assertions.assertTrue((boolean)subDir4.mkdir());
        File someFile = new File(subDir2, "a.txt");
        WildcardFileFilter fileFilterAllFiles = new WildcardFileFilter("*.*");
        WildcardFileFilter fileFilterAllDirs = new WildcardFileFilter("*");
        WildcardFileFilter fileFilterExtTxt = new WildcardFileFilter("*.txt");
        try {
            try (BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(someFile));){
                TestUtils.generateTestData(output, 100L);
            }
            List<File> expectedFilesAndDirs = Arrays.asList(subDir1, subDir2, someFile, subDir3, subDir4);
            this.iterateFilesAndDirs(subDir1, (IOFileFilter)fileFilterAllFiles, (IOFileFilter)fileFilterAllDirs, expectedFilesAndDirs);
            expectedFilesAndDirs = Arrays.asList(subDir1, subDir2, someFile, subDir3, subDir4);
            this.iterateFilesAndDirs(subDir1, (IOFileFilter)fileFilterExtTxt, (IOFileFilter)fileFilterAllDirs, expectedFilesAndDirs);
            expectedFilesAndDirs = Arrays.asList(subDir1, subDir2, someFile);
            this.iterateFilesAndDirs(subDir1, (IOFileFilter)fileFilterAllFiles, (IOFileFilter)new NameFileFilter("subdir2"), expectedFilesAndDirs);
            expectedFilesAndDirs = Arrays.asList(subDir1, subDir2, someFile);
            this.iterateFilesAndDirs(subDir1, (IOFileFilter)fileFilterExtTxt, (IOFileFilter)new NameFileFilter("subdir2"), expectedFilesAndDirs);
        }
        finally {
            someFile.delete();
            subDir4.delete();
            subDir3.delete();
            subDir2.delete();
            subDir1.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testListFiles() throws Exception {
        File srcDir = this.temporaryFolder;
        File subDir = new File(srcDir, "list_test");
        File subDir2 = new File(subDir, "subdir");
        subDir.mkdir();
        subDir2.mkdir();
        try {
            String[] expectedFileNames = new String[]{"a.txt", "b.txt", "c.txt", "d.txt", "e.txt", "f.txt"};
            int[] fileSizes = new int[]{123, 234, 345, 456, 678, 789};
            for (int i = 0; i < expectedFileNames.length; ++i) {
                File theFile = new File(subDir, expectedFileNames[i]);
                if (!theFile.getParentFile().exists()) {
                    throw new IOException("Cannot create file " + theFile + " as the parent directory does not exist");
                }
                BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(theFile));
                try {
                    TestUtils.generateTestData(output, (long)fileSizes[i]);
                    continue;
                }
                finally {
                    IOUtils.closeQuietly((OutputStream)output);
                }
            }
            Collection actualFiles = FileUtils.listFiles((File)subDir, (IOFileFilter)new WildcardFileFilter("*.*"), (IOFileFilter)new WildcardFileFilter("*"));
            int count = actualFiles.size();
            Object[] fileObjs = actualFiles.toArray();
            Assertions.assertEquals((int)expectedFileNames.length, (int)actualFiles.size(), () -> actualFiles.toString());
            HashMap<String, String> foundFileNames = new HashMap<String, String>();
            for (int i = 0; i < count; ++i) {
                boolean found = false;
                for (int j = 0; !found && j < expectedFileNames.length; ++j) {
                    if (!expectedFileNames[j].equals(((File)fileObjs[i]).getName())) continue;
                    foundFileNames.put(expectedFileNames[j], expectedFileNames[j]);
                    found = true;
                }
            }
            Assertions.assertEquals((int)foundFileNames.size(), (int)expectedFileNames.length, () -> foundFileNames.toString());
        }
        finally {
            subDir.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testListFilesWithDirs() throws IOException {
        File srcDir = this.temporaryFolder;
        File subDir1 = new File(srcDir, "subdir");
        File subDir2 = new File(subDir1, "subdir2");
        subDir1.mkdir();
        subDir2.mkdir();
        try {
            File someFile = new File(subDir2, "a.txt");
            if (!someFile.getParentFile().exists()) {
                throw new IOException("Cannot create file " + someFile + " as the parent directory does not exist");
            }
            BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(someFile));
            try {
                TestUtils.generateTestData(output, 100L);
            }
            finally {
                IOUtils.closeQuietly((OutputStream)output);
            }
            File subDir3 = new File(subDir2, "subdir3");
            subDir3.mkdir();
            Collection files = FileUtils.listFilesAndDirs((File)subDir1, (IOFileFilter)new WildcardFileFilter("*.*"), (IOFileFilter)new WildcardFileFilter("*"));
            Assertions.assertEquals((int)4, (int)files.size());
            Assertions.assertTrue((boolean)files.contains(subDir1), (String)"Should contain the directory.");
            Assertions.assertTrue((boolean)files.contains(subDir2), (String)"Should contain the directory.");
            Assertions.assertTrue((boolean)files.contains(someFile), (String)"Should contain the file.");
            Assertions.assertTrue((boolean)files.contains(subDir3), (String)"Should contain the directory.");
        }
        finally {
            subDir1.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMoveDirectory_CopyDelete() throws Exception {
        File dir = this.temporaryFolder;
        File src = new File(dir, "testMoveDirectory2Source"){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean renameTo(File dest) {
                return false;
            }
        };
        File testDir = new File(src, "foo");
        File testFile = new File(testDir, "bar");
        testDir.mkdirs();
        if (!testFile.getParentFile().exists()) {
            throw new IOException("Cannot create file " + testFile + " as the parent directory does not exist");
        }
        BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(testFile));
        try {
            TestUtils.generateTestData(output, 0L);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)output);
        }
        File destination = new File(dir, "testMoveDirectory1Dest");
        FileUtils.deleteDirectory((File)destination);
        FileUtils.moveDirectory((File)src, (File)destination);
        Assertions.assertTrue((boolean)destination.exists(), (String)"Check Exist");
        Assertions.assertFalse((boolean)src.exists(), (String)"Original deleted");
        File movedDir = new File(destination, testDir.getName());
        File movedFile = new File(movedDir, testFile.getName());
        Assertions.assertTrue((boolean)movedDir.exists(), (String)"Check dir moved");
        Assertions.assertTrue((boolean)movedFile.exists(), (String)"Check file moved");
    }

    @Test
    public void testMoveDirectory_Errors() throws Exception {
        Assertions.assertThrows(NullPointerException.class, () -> FileUtils.moveDirectory(null, (File)new File("foo")));
        Assertions.assertThrows(NullPointerException.class, () -> FileUtils.moveDirectory((File)new File("foo"), null));
        try {
            FileUtils.moveDirectory((File)new File("nonexistant"), (File)new File("foo"));
            Assertions.fail((String)"Expected FileNotFoundException for source");
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        File testFile = new File(this.temporaryFolder, "testMoveDirectoryFile");
        if (!testFile.getParentFile().exists()) {
            throw new IOException("Cannot create file " + testFile + " as the parent directory does not exist");
        }
        BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(testFile));
        try {
            TestUtils.generateTestData(output, 0L);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)output);
        }
        Assertions.assertThrows(IllegalArgumentException.class, () -> FileUtils.moveDirectory((File)testFile, (File)new File("foo")));
        File testSrcFile = new File(this.temporaryFolder, "testMoveDirectorySource");
        File testDestFile = new File(this.temporaryFolder, "testMoveDirectoryDest");
        testSrcFile.mkdir();
        testDestFile.mkdir();
        try {
            FileUtils.moveDirectory((File)testSrcFile, (File)testDestFile);
            Assertions.fail((String)"Expected FileExistsException when dest already exists");
        }
        catch (FileExistsException fileExistsException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMoveDirectory_Rename() throws Exception {
        File dir = this.temporaryFolder;
        File src = new File(dir, "testMoveDirectory1Source");
        File testDir = new File(src, "foo");
        File testFile = new File(testDir, "bar");
        testDir.mkdirs();
        if (!testFile.getParentFile().exists()) {
            throw new IOException("Cannot create file " + testFile + " as the parent directory does not exist");
        }
        BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(testFile));
        try {
            TestUtils.generateTestData(output, 0L);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)output);
        }
        File destination = new File(dir, "testMoveDirectory1Dest");
        FileUtils.deleteDirectory((File)destination);
        FileUtils.moveDirectory((File)src, (File)destination);
        Assertions.assertTrue((boolean)destination.exists(), (String)"Check Exist");
        Assertions.assertFalse((boolean)src.exists(), (String)"Original deleted");
        File movedDir = new File(destination, testDir.getName());
        File movedFile = new File(movedDir, testFile.getName());
        Assertions.assertTrue((boolean)movedDir.exists(), (String)"Check dir moved");
        Assertions.assertTrue((boolean)movedFile.exists(), (String)"Check file moved");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMoveDirectoryToDirectory() throws Exception {
        File dir = this.temporaryFolder;
        File src = new File(dir, "testMoveDirectory1Source");
        File testChildDir = new File(src, "foo");
        File testFile = new File(testChildDir, "bar");
        testChildDir.mkdirs();
        if (!testFile.getParentFile().exists()) {
            throw new IOException("Cannot create file " + testFile + " as the parent directory does not exist");
        }
        BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(testFile));
        try {
            TestUtils.generateTestData(output, 0L);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)output);
        }
        File destDir = new File(dir, "testMoveDirectory1Dest");
        FileUtils.deleteDirectory((File)destDir);
        Assertions.assertFalse((boolean)destDir.exists(), (String)"Check Exist before");
        FileUtils.moveDirectoryToDirectory((File)src, (File)destDir, (boolean)true);
        Assertions.assertTrue((boolean)destDir.exists(), (String)"Check Exist after");
        Assertions.assertFalse((boolean)src.exists(), (String)"Original deleted");
        File movedDir = new File(destDir, src.getName());
        File movedChildDir = new File(movedDir, testChildDir.getName());
        File movedFile = new File(movedChildDir, testFile.getName());
        Assertions.assertTrue((boolean)movedDir.exists(), (String)"Check dir moved");
        Assertions.assertTrue((boolean)movedChildDir.exists(), (String)"Check child dir moved");
        Assertions.assertTrue((boolean)movedFile.exists(), (String)"Check file moved");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMoveDirectoryToDirectory_Errors() throws Exception {
        Assertions.assertThrows(NullPointerException.class, () -> FileUtils.moveDirectoryToDirectory(null, (File)new File("foo"), (boolean)true));
        Assertions.assertThrows(NullPointerException.class, () -> FileUtils.moveDirectoryToDirectory((File)new File("foo"), null, (boolean)true));
        File testFile1 = new File(this.temporaryFolder, "testMoveFileFile1");
        File testFile2 = new File(this.temporaryFolder, "testMoveFileFile2");
        if (!testFile1.getParentFile().exists()) {
            throw new IOException("Cannot create file " + testFile1 + " as the parent directory does not exist");
        }
        BufferedOutputStream output1 = new BufferedOutputStream(new FileOutputStream(testFile1));
        try {
            TestUtils.generateTestData(output1, 0L);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)output1);
        }
        if (!testFile2.getParentFile().exists()) {
            throw new IOException("Cannot create file " + testFile2 + " as the parent directory does not exist");
        }
        BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(testFile2));
        try {
            TestUtils.generateTestData(output, 0L);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)output);
        }
        try {
            FileUtils.moveDirectoryToDirectory((File)testFile1, (File)testFile2, (boolean)true);
            Assertions.fail((String)"Expected IOException when dest not a directory");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        File nonexistant = new File(this.temporaryFolder, "testMoveFileNonExistant");
        try {
            FileUtils.moveDirectoryToDirectory((File)testFile1, (File)nonexistant, (boolean)false);
            Assertions.fail((String)"Expected IOException when dest does not exist and create=false");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testMoveFile_CopyDelete() throws Exception {
        File destination = new File(this.temporaryFolder, "move2.txt");
        File src = new File(this.testFile1.getAbsolutePath()){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean renameTo(File f) {
                return false;
            }
        };
        FileUtils.moveFile((File)src, (File)destination);
        Assertions.assertTrue((boolean)destination.exists(), (String)"Check Exist");
        Assertions.assertFalse((boolean)src.exists(), (String)"Original deleted");
    }

    @Test
    public void testMoveFile_CopyDelete_Failed() throws Exception {
        File destination = new File(this.temporaryFolder, "move3.txt");
        File src = new File(this.testFile1.getAbsolutePath()){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean delete() {
                return false;
            }

            @Override
            public boolean renameTo(File f) {
                return false;
            }
        };
        Assertions.assertThrows(IOException.class, () -> FileUtils.moveFile((File)src, (File)destination));
        Assertions.assertFalse((boolean)destination.exists(), (String)"Check Rollback");
        Assertions.assertTrue((boolean)src.exists(), (String)"Original exists");
    }

    @Test
    public void testMoveFile_CopyDelete_WithFileDatePreservation() throws Exception {
        File destination = new File(this.temporaryFolder, "move2.txt");
        this.backDateFile10Minutes(this.testFile1);
        File src = new File(this.testFile1.getAbsolutePath()){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean renameTo(File f) {
                return false;
            }
        };
        long expected = this.getLastModifiedMillis(this.testFile1);
        FileUtils.moveFile((File)src, (File)destination, (CopyOption[])new CopyOption[]{StandardCopyOption.COPY_ATTRIBUTES});
        Assertions.assertTrue((boolean)destination.exists(), (String)"Check Exist");
        Assertions.assertFalse((boolean)src.exists(), (String)"Original deleted");
        long destLastMod = this.getLastModifiedMillis(destination);
        long delta = destLastMod - expected;
        Assertions.assertEquals((long)expected, (long)destLastMod, (String)("Check last modified date same as input, delta " + delta));
    }

    @Test
    public void testMoveFile_CopyDelete_WithoutFileDatePreservation() throws Exception {
        File destination = new File(this.temporaryFolder, "move2.txt");
        this.backDateFile10Minutes(this.testFile1);
        long nowMillis = System.currentTimeMillis() - 1000L;
        File src = new File(this.testFile1.getAbsolutePath()){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean renameTo(File f) {
                return false;
            }
        };
        long unexpectedMillis = this.getLastModifiedMillis(this.testFile1);
        FileUtils.moveFile((File)src, (File)destination, (CopyOption[])PathUtils.EMPTY_COPY_OPTIONS);
        Assertions.assertTrue((boolean)destination.exists(), (String)"Check Exist");
        Assertions.assertFalse((boolean)src.exists(), (String)"Original deleted");
        if (!SystemUtils.IS_OS_WINDOWS) {
            long destLastModMillis = this.getLastModifiedMillis(destination);
            long deltaMillis = destLastModMillis - unexpectedMillis;
            Assertions.assertNotEquals((long)unexpectedMillis, (long)destLastModMillis, (String)("Check last modified date not same as input, delta " + deltaMillis));
            Assertions.assertTrue((destLastModMillis > nowMillis ? 1 : 0) != 0, (String)(destLastModMillis + " > " + nowMillis + " (delta " + deltaMillis + ")"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMoveFile_Errors() throws Exception {
        Assertions.assertThrows(NullPointerException.class, () -> FileUtils.moveFile(null, (File)new File("foo")));
        Assertions.assertThrows(NullPointerException.class, () -> FileUtils.moveFile((File)new File("foo"), null));
        try {
            FileUtils.moveFile((File)new File("nonexistant"), (File)new File("foo"));
            Assertions.fail((String)"Expected FileNotFoundException for source");
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        Assertions.assertThrows(IllegalArgumentException.class, () -> FileUtils.moveFile((File)this.temporaryFolder, (File)new File("foo")));
        File testSourceFile = new File(this.temporaryFolder, "testMoveFileSource");
        File testDestFile = new File(this.temporaryFolder, "testMoveFileSource");
        if (!testSourceFile.getParentFile().exists()) {
            throw new IOException("Cannot create file " + testSourceFile + " as the parent directory does not exist");
        }
        BufferedOutputStream output1 = new BufferedOutputStream(new FileOutputStream(testSourceFile));
        try {
            TestUtils.generateTestData(output1, 0L);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)output1);
        }
        if (!testDestFile.getParentFile().exists()) {
            throw new IOException("Cannot create file " + testDestFile + " as the parent directory does not exist");
        }
        BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(testDestFile));
        try {
            TestUtils.generateTestData(output, 0L);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)output);
        }
        try {
            FileUtils.moveFile((File)testSourceFile, (File)testDestFile);
            Assertions.fail((String)"Expected FileExistsException when dest already exists");
        }
        catch (FileExistsException fileExistsException) {
            // empty catch block
        }
    }

    @Test
    public void testMoveFile_Rename() throws Exception {
        File destination = new File(this.temporaryFolder, "move1.txt");
        FileUtils.moveFile((File)this.testFile1, (File)destination);
        Assertions.assertTrue((boolean)destination.exists(), (String)"Check Exist");
        Assertions.assertFalse((boolean)this.testFile1.exists(), (String)"Original deleted");
    }

    @Test
    public void testMoveFileToDirectory() throws Exception {
        File destDir = new File(this.temporaryFolder, "moveFileDestDir");
        File movedFile = new File(destDir, this.testFile1.getName());
        Assertions.assertFalse((boolean)destDir.exists(), (String)"Check Exist before");
        Assertions.assertFalse((boolean)movedFile.exists(), (String)"Check Exist before");
        FileUtils.moveFileToDirectory((File)this.testFile1, (File)destDir, (boolean)true);
        Assertions.assertTrue((boolean)movedFile.exists(), (String)"Check Exist after");
        Assertions.assertFalse((boolean)this.testFile1.exists(), (String)"Original deleted");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMoveFileToDirectory_Errors() throws Exception {
        Assertions.assertThrows(NullPointerException.class, () -> FileUtils.moveFileToDirectory(null, (File)new File("foo"), (boolean)true));
        Assertions.assertThrows(NullPointerException.class, () -> FileUtils.moveFileToDirectory((File)new File("foo"), null, (boolean)true));
        File testFile1 = new File(this.temporaryFolder, "testMoveFileFile1");
        File testFile2 = new File(this.temporaryFolder, "testMoveFileFile2");
        if (!testFile1.getParentFile().exists()) {
            throw new IOException("Cannot create file " + testFile1 + " as the parent directory does not exist");
        }
        BufferedOutputStream output1 = new BufferedOutputStream(new FileOutputStream(testFile1));
        try {
            TestUtils.generateTestData(output1, 0L);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)output1);
        }
        if (!testFile2.getParentFile().exists()) {
            throw new IOException("Cannot create file " + testFile2 + " as the parent directory does not exist");
        }
        BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(testFile2));
        try {
            TestUtils.generateTestData(output, 0L);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)output);
        }
        Assertions.assertThrows(IllegalArgumentException.class, () -> FileUtils.moveFileToDirectory((File)testFile1, (File)testFile2, (boolean)true));
        File nonexistant = new File(this.temporaryFolder, "testMoveFileNonExistant");
        try {
            FileUtils.moveFileToDirectory((File)testFile1, (File)nonexistant, (boolean)false);
            Assertions.fail((String)"Expected IOException when dest does not exist and create=false");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMoveToDirectory() throws Exception {
        File destDir = new File(this.temporaryFolder, "testMoveToDirectoryDestDir");
        File testDir = new File(this.temporaryFolder, "testMoveToDirectoryTestDir");
        File testFile = new File(this.temporaryFolder, "testMoveToDirectoryTestFile");
        testDir.mkdirs();
        if (!testFile.getParentFile().exists()) {
            throw new IOException("Cannot create file " + testFile + " as the parent directory does not exist");
        }
        BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(testFile));
        try {
            TestUtils.generateTestData(output, 0L);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)output);
        }
        File movedFile = new File(destDir, testFile.getName());
        File movedDir = new File(destDir, testFile.getName());
        Assertions.assertFalse((boolean)movedFile.exists(), (String)"Check File Doesnt exist");
        Assertions.assertFalse((boolean)movedDir.exists(), (String)"Check Dir Doesnt exist");
        FileUtils.moveToDirectory((File)testFile, (File)destDir, (boolean)true);
        Assertions.assertTrue((boolean)movedFile.exists(), (String)"Check File exists");
        Assertions.assertFalse((boolean)testFile.exists(), (String)"Check Original File doesn't exist");
        FileUtils.moveToDirectory((File)testDir, (File)destDir, (boolean)true);
        Assertions.assertTrue((boolean)movedDir.exists(), (String)"Check Dir exists");
        Assertions.assertFalse((boolean)testDir.exists(), (String)"Check Original Dir doesn't exist");
    }

    @Test
    public void testMoveToDirectory_Errors() throws Exception {
        try {
            FileUtils.moveDirectoryToDirectory(null, (File)new File("foo"), (boolean)true);
            Assertions.fail((String)"Expected NullPointerException when source is null");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            FileUtils.moveDirectoryToDirectory((File)new File("foo"), null, (boolean)true);
            Assertions.fail((String)"Expected NullPointerException when destination is null");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        File nonexistant = new File(this.temporaryFolder, "nonexistant");
        File destDir = new File(this.temporaryFolder, "MoveToDirectoryDestDir");
        try {
            FileUtils.moveToDirectory((File)nonexistant, (File)destDir, (boolean)true);
            Assertions.fail((String)"Expected IOException when source does not exist");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testReadFileToByteArray() throws Exception {
        File file = new File(this.temporaryFolder, "read.txt");
        FileOutputStream out = new FileOutputStream(file);
        out.write(11);
        out.write(21);
        out.write(31);
        out.close();
        byte[] data = FileUtils.readFileToByteArray((File)file);
        Assertions.assertEquals((int)3, (int)data.length);
        Assertions.assertEquals((int)11, (int)data[0]);
        Assertions.assertEquals((int)21, (int)data[1]);
        Assertions.assertEquals((int)31, (int)data[2]);
    }

    @Test
    public void testReadFileToStringWithDefaultEncoding() throws Exception {
        File file = new File(this.temporaryFolder, "read.obj");
        FileOutputStream out = new FileOutputStream(file);
        byte[] text = "Hello /u1234".getBytes();
        out.write(text);
        out.close();
        String data = FileUtils.readFileToString((File)file);
        Assertions.assertEquals((Object)"Hello /u1234", (Object)data);
    }

    @Test
    public void testReadFileToStringWithEncoding() throws Exception {
        File file = new File(this.temporaryFolder, "read.obj");
        FileOutputStream out = new FileOutputStream(file);
        byte[] text = "Hello /u1234".getBytes(StandardCharsets.UTF_8);
        out.write(text);
        out.close();
        String data = FileUtils.readFileToString((File)file, (String)"UTF8");
        Assertions.assertEquals((Object)"Hello /u1234", (Object)data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadLines() throws Exception {
        File file = TestUtils.newFile(this.temporaryFolder, "lines.txt");
        try {
            String[] data = new String[]{"hello", "/u1234", "", "this is", "some text"};
            TestUtils.createLineBasedFile(file, data);
            List lines = FileUtils.readLines((File)file, (String)"UTF-8");
            Assertions.assertEquals(Arrays.asList(data), (Object)lines);
        }
        finally {
            TestUtils.deleteFile(file);
        }
    }

    @Test
    public void testSizeOf() throws Exception {
        File file = new File(this.temporaryFolder, this.getName());
        try {
            FileUtils.sizeOf(null);
            Assertions.fail((String)"Exception expected.");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            FileUtils.sizeOf((File)file);
            Assertions.fail((String)"Exception expected.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        file.createNewFile();
        file.deleteOnExit();
        Assertions.assertEquals((long)0L, (long)FileUtils.sizeOf((File)file));
        file.delete();
        Assertions.assertEquals((long)this.testFile1Size, (long)FileUtils.sizeOf((File)this.testFile1), (String)"Unexpected files size");
        Assertions.assertEquals((long)0L, (long)FileUtils.sizeOf((File)this.temporaryFolder), (String)"Unexpected directory size");
    }

    @Test
    public void testSizeOfAsBigInteger() throws Exception {
        File file = new File(this.temporaryFolder, this.getName());
        try {
            FileUtils.sizeOfAsBigInteger(null);
            Assertions.fail((String)"Exception expected.");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            FileUtils.sizeOfAsBigInteger((File)file);
            Assertions.fail((String)"Exception expected.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        file.createNewFile();
        file.deleteOnExit();
        Assertions.assertEquals((Object)BigInteger.ZERO, (Object)FileUtils.sizeOfAsBigInteger((File)file));
        file.delete();
        Assertions.assertEquals((Object)BigInteger.valueOf(this.testFile1Size), (Object)FileUtils.sizeOfAsBigInteger((File)this.testFile1), (String)"Unexpected files size");
        Assertions.assertEquals((Object)TEST_DIRECTORY_SIZE_BI, (Object)FileUtils.sizeOfAsBigInteger((File)this.temporaryFolder), (String)"Unexpected directory size");
    }

    @Test
    public void testSizeOfDirectory() throws Exception {
        File file = new File(this.temporaryFolder, this.getName());
        try {
            FileUtils.sizeOfDirectory((File)file);
            Assertions.fail((String)"Exception expected.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        file.createNewFile();
        try {
            FileUtils.sizeOfDirectory((File)file);
            Assertions.fail((String)"Exception expected.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        file.delete();
        file.mkdir();
        this.createCircularSymLink(file);
        Assertions.assertEquals((long)0L, (long)FileUtils.sizeOfDirectory((File)file), (String)"Unexpected directory size");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSizeOfDirectoryAsBigInteger() throws Exception {
        File file = new File(this.temporaryFolder, this.getName());
        try {
            FileUtils.sizeOfDirectoryAsBigInteger((File)file);
            Assertions.fail((String)"Exception expected.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        file.createNewFile();
        file.deleteOnExit();
        try {
            FileUtils.sizeOfDirectoryAsBigInteger((File)file);
            Assertions.fail((String)"Exception expected.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        file.delete();
        file.mkdir();
        this.createCircularSymLink(file);
        Assertions.assertEquals((Object)TEST_DIRECTORY_SIZE_BI, (Object)FileUtils.sizeOfDirectoryAsBigInteger((File)file), (String)"Unexpected directory size");
        file.delete();
        file.mkdir();
        File nonEmptyFile = new File(file, "nonEmptyFile" + System.nanoTime());
        if (!nonEmptyFile.getParentFile().exists()) {
            throw new IOException("Cannot create file " + nonEmptyFile + " as the parent directory does not exist");
        }
        BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(nonEmptyFile));
        try {
            TestUtils.generateTestData(output, TEST_DIRECTORY_SIZE_GT_ZERO_BI.longValue());
        }
        finally {
            IOUtils.closeQuietly((OutputStream)output);
        }
        nonEmptyFile.deleteOnExit();
        Assertions.assertEquals((Object)TEST_DIRECTORY_SIZE_GT_ZERO_BI, (Object)FileUtils.sizeOfDirectoryAsBigInteger((File)file), (String)"Unexpected directory size");
        nonEmptyFile.delete();
        file.delete();
    }

    @Test
    public void testToFile1() throws Exception {
        URL url = new URL("file", null, "a/b/c/file.txt");
        File file = FileUtils.toFile((URL)url);
        Assertions.assertTrue((boolean)file.toString().contains("file.txt"));
    }

    @Test
    public void testToFile2() throws Exception {
        URL url = new URL("file", null, "a/b/c/file%20n%61me%2520.tx%74");
        File file = FileUtils.toFile((URL)url);
        Assertions.assertTrue((boolean)file.toString().contains("file name%20.txt"));
    }

    @Test
    public void testToFile3() throws Exception {
        Assertions.assertNull((Object)FileUtils.toFile(null));
        Assertions.assertNull((Object)FileUtils.toFile((URL)new URL("http://jakarta.apache.org")));
    }

    @Test
    public void testToFile4() throws Exception {
        URL url = new URL("file", null, "a/b/c/file%%20%me.txt%");
        File file = FileUtils.toFile((URL)url);
        Assertions.assertTrue((boolean)file.toString().contains("file% %me.txt%"));
    }

    @Test
    public void testToFile5() throws Exception {
        URL url = new URL("file", null, "both%20are%20100%20%25%20true");
        File file = FileUtils.toFile((URL)url);
        Assertions.assertEquals((Object)"both are 100 % true", (Object)file.toString());
    }

    @Test
    public void testToFiles1() throws Exception {
        URL[] urls = new URL[]{new URL("file", null, "file1.txt"), new URL("file", null, "file2.txt")};
        File[] files = FileUtils.toFiles((URL[])urls);
        Assertions.assertEquals((int)urls.length, (int)files.length);
        Assertions.assertTrue((boolean)files[0].toString().contains("file1.txt"), (String)("File: " + files[0]));
        Assertions.assertTrue((boolean)files[1].toString().contains("file2.txt"), (String)("File: " + files[1]));
    }

    @Test
    public void testToFiles2() throws Exception {
        URL[] urls = new URL[]{new URL("file", null, "file1.txt"), null};
        File[] files = FileUtils.toFiles((URL[])urls);
        Assertions.assertEquals((int)urls.length, (int)files.length);
        Assertions.assertTrue((boolean)files[0].toString().contains("file1.txt"), (String)("File: " + files[0]));
        Assertions.assertNull((Object)files[1], (String)("File: " + files[1]));
    }

    @Test
    public void testToFiles3() throws Exception {
        URL[] urls = null;
        File[] files = FileUtils.toFiles(urls);
        Assertions.assertEquals((int)0, (int)files.length);
    }

    @Test
    public void testToFiles3a() throws Exception {
        URL[] urls = new URL[]{};
        File[] files = FileUtils.toFiles((URL[])urls);
        Assertions.assertEquals((int)0, (int)files.length);
    }

    @Test
    public void testToFiles4() throws Exception {
        URL[] urls = new URL[]{new URL("file", null, "file1.txt"), new URL("http", "jakarta.apache.org", "file1.txt")};
        try {
            FileUtils.toFiles((URL[])urls);
            Assertions.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testToFileUtf8() throws Exception {
        URL url = new URL("file", null, "/home/%C3%A4%C3%B6%C3%BC%C3%9F");
        File file = FileUtils.toFile((URL)url);
        Assertions.assertTrue((boolean)file.toString().contains("\u00e4\u00f6\u00fc\u00df"));
    }

    @Test
    public void testTouch() throws IOException {
        File file = new File(this.temporaryFolder, "touch.txt");
        if (file.exists()) {
            file.delete();
        }
        Assertions.assertFalse((boolean)file.exists(), (String)"Bad test: test file still exists");
        FileUtils.touch((File)file);
        Assertions.assertTrue((boolean)file.exists(), (String)"FileUtils.touch() created file");
        FileOutputStream out = new FileOutputStream(file);
        Assertions.assertEquals((long)0L, (long)file.length(), (String)"Created empty file.");
        out.write(0);
        out.close();
        Assertions.assertEquals((long)1L, (long)file.length(), (String)"Wrote one byte to file");
        long y2k = new GregorianCalendar(2000, 0, 1).getTime().getTime();
        boolean res = this.setLastModifiedMillis(file, y2k);
        Assertions.assertTrue((boolean)res, (String)"Bad test: set lastModified failed");
        Assertions.assertEquals((long)y2k, (long)this.getLastModifiedMillis(file), (String)"Bad test: set lastModified set incorrect value");
        long nowMillis = System.currentTimeMillis();
        FileUtils.touch((File)file);
        Assertions.assertEquals((long)1L, (long)file.length(), (String)"FileUtils.touch() didn't empty the file.");
        Assertions.assertFalse((y2k == this.getLastModifiedMillis(file) ? 1 : 0) != 0, (String)"FileUtils.touch() changed lastModified");
        int delta = 3000;
        Assertions.assertTrue((this.getLastModifiedMillis(file) >= nowMillis - 3000L ? 1 : 0) != 0, (String)"FileUtils.touch() changed lastModified to more than now-3s");
        Assertions.assertTrue((this.getLastModifiedMillis(file) <= nowMillis + 3000L ? 1 : 0) != 0, (String)"FileUtils.touch() changed lastModified to less than now+3s");
    }

    @Test
    public void testToURLs1() throws Exception {
        File[] files = new File[]{new File(this.temporaryFolder, "file1.txt"), new File(this.temporaryFolder, "file2.txt"), new File(this.temporaryFolder, "test file.txt")};
        URL[] urls = FileUtils.toURLs((File[])files);
        Assertions.assertEquals((int)files.length, (int)urls.length);
        Assertions.assertTrue((boolean)urls[0].toExternalForm().startsWith("file:"));
        Assertions.assertTrue((boolean)urls[0].toExternalForm().contains("file1.txt"));
        Assertions.assertTrue((boolean)urls[1].toExternalForm().startsWith("file:"));
        Assertions.assertTrue((boolean)urls[1].toExternalForm().contains("file2.txt"));
        Assertions.assertTrue((boolean)urls[2].toExternalForm().startsWith("file:"));
        Assertions.assertTrue((boolean)urls[2].toExternalForm().contains("test%20file.txt"));
    }

    @Test
    public void testToURLs3a() throws Exception {
        File[] files = new File[]{};
        URL[] urls = FileUtils.toURLs((File[])files);
        Assertions.assertEquals((int)0, (int)urls.length);
    }

    @Test
    public void testWrite_WithAppendOptionFalse_ShouldDeletePreviousFileLines() throws Exception {
        File file = TestUtils.newFile(this.temporaryFolder, "lines.txt");
        FileUtils.writeStringToFile((File)file, (String)"This line was there before you...");
        FileUtils.write((File)file, (CharSequence)"this is brand new data", (boolean)false);
        String expected = "this is brand new data";
        String actual = FileUtils.readFileToString((File)file);
        Assertions.assertEquals((Object)"this is brand new data", (Object)actual);
    }

    @Test
    public void testWrite_WithAppendOptionTrue_ShouldNotDeletePreviousFileLines() throws Exception {
        File file = TestUtils.newFile(this.temporaryFolder, "lines.txt");
        FileUtils.writeStringToFile((File)file, (String)"This line was there before you...");
        FileUtils.write((File)file, (CharSequence)"this is brand new data", (boolean)true);
        String expected = "This line was there before you...this is brand new data";
        String actual = FileUtils.readFileToString((File)file);
        Assertions.assertEquals((Object)"This line was there before you...this is brand new data", (Object)actual);
    }

    @Test
    public void testWriteByteArrayToFile() throws Exception {
        File file = new File(this.temporaryFolder, "write.obj");
        byte[] data = new byte[]{11, 21, 31};
        FileUtils.writeByteArrayToFile((File)file, (byte[])data);
        TestUtils.assertEqualContent(data, file);
    }

    @Test
    public void testWriteByteArrayToFile_WithAppendOptionFalse_ShouldDeletePreviousFileLines() throws Exception {
        File file = TestUtils.newFile(this.temporaryFolder, "lines.txt");
        FileUtils.writeStringToFile((File)file, (String)"This line was there before you...");
        FileUtils.writeByteArrayToFile((File)file, (byte[])"this is brand new data".getBytes(), (boolean)false);
        String expected = "this is brand new data";
        String actual = FileUtils.readFileToString((File)file);
        Assertions.assertEquals((Object)"this is brand new data", (Object)actual);
    }

    @Test
    public void testWriteByteArrayToFile_WithAppendOptionTrue_ShouldNotDeletePreviousFileLines() throws Exception {
        File file = TestUtils.newFile(this.temporaryFolder, "lines.txt");
        FileUtils.writeStringToFile((File)file, (String)"This line was there before you...");
        FileUtils.writeByteArrayToFile((File)file, (byte[])"this is brand new data".getBytes(), (boolean)true);
        String expected = "This line was there before you...this is brand new data";
        String actual = FileUtils.readFileToString((File)file);
        Assertions.assertEquals((Object)"This line was there before you...this is brand new data", (Object)actual);
    }

    @Test
    public void testWriteByteArrayToFile_WithOffsetAndLength() throws Exception {
        File file = new File(this.temporaryFolder, "write.obj");
        byte[] data = new byte[]{11, 21, 32, 41, 51};
        byte[] writtenData = new byte[3];
        System.arraycopy(data, 1, writtenData, 0, 3);
        FileUtils.writeByteArrayToFile((File)file, (byte[])data, (int)1, (int)3);
        TestUtils.assertEqualContent(writtenData, file);
    }

    @Test
    public void testWriteByteArrayToFile_WithOffsetAndLength_WithAppendOptionTrue_ShouldDeletePreviousFileLines() throws Exception {
        File file = TestUtils.newFile(this.temporaryFolder, "lines.txt");
        FileUtils.writeStringToFile((File)file, (String)"This line was there before you...");
        byte[] data = "SKIP_THIS_this is brand new data_AND_SKIP_THIS".getBytes(StandardCharsets.UTF_8);
        FileUtils.writeByteArrayToFile((File)file, (byte[])data, (int)10, (int)22, (boolean)false);
        String expected = "this is brand new data";
        String actual = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
        Assertions.assertEquals((Object)"this is brand new data", (Object)actual);
    }

    @Test
    public void testWriteByteArrayToFile_WithOffsetAndLength_WithAppendOptionTrue_ShouldNotDeletePreviousFileLines() throws Exception {
        File file = TestUtils.newFile(this.temporaryFolder, "lines.txt");
        FileUtils.writeStringToFile((File)file, (String)"This line was there before you...");
        byte[] data = "SKIP_THIS_this is brand new data_AND_SKIP_THIS".getBytes(StandardCharsets.UTF_8);
        FileUtils.writeByteArrayToFile((File)file, (byte[])data, (int)10, (int)22, (boolean)true);
        String expected = "This line was there before you...this is brand new data";
        String actual = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
        Assertions.assertEquals((Object)"This line was there before you...this is brand new data", (Object)actual);
    }

    @Test
    public void testWriteCharSequence1() throws Exception {
        File file = new File(this.temporaryFolder, "write.txt");
        FileUtils.write((File)file, (CharSequence)"Hello /u1234", (String)"UTF8");
        byte[] text = "Hello /u1234".getBytes(StandardCharsets.UTF_8);
        TestUtils.assertEqualContent(text, file);
    }

    @Test
    public void testWriteCharSequence2() throws Exception {
        File file = new File(this.temporaryFolder, "write.txt");
        FileUtils.write((File)file, (CharSequence)"Hello /u1234", (String)null);
        byte[] text = "Hello /u1234".getBytes();
        TestUtils.assertEqualContent(text, file);
    }

    @Test
    public void testWriteLines_3arg_nullSeparator() throws Exception {
        Object[] data = new Object[]{"hello", new StringBuffer("world"), "", "this is", null, "some text"};
        List<Object> list = Arrays.asList(data);
        File file = TestUtils.newFile(this.temporaryFolder, "lines.txt");
        FileUtils.writeLines((File)file, (String)"US-ASCII", list);
        String expected = "hello" + System.lineSeparator() + "world" + System.lineSeparator() + System.lineSeparator() + "this is" + System.lineSeparator() + System.lineSeparator() + "some text" + System.lineSeparator();
        String actual = FileUtils.readFileToString((File)file, (String)"US-ASCII");
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testWriteLines_3argsWithAppendOptionFalse_ShouldDeletePreviousFileLines() throws Exception {
        File file = TestUtils.newFile(this.temporaryFolder, "lines.txt");
        FileUtils.writeStringToFile((File)file, (String)"This line was there before you...");
        List<String> linesToAppend = Arrays.asList("my first line", "The second Line");
        FileUtils.writeLines((File)file, linesToAppend, (boolean)false);
        String expected = "my first line" + System.lineSeparator() + "The second Line" + System.lineSeparator();
        String actual = FileUtils.readFileToString((File)file);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testWriteLines_3argsWithAppendOptionTrue_ShouldNotDeletePreviousFileLines() throws Exception {
        File file = TestUtils.newFile(this.temporaryFolder, "lines.txt");
        FileUtils.writeStringToFile((File)file, (String)"This line was there before you...");
        List<String> linesToAppend = Arrays.asList("my first line", "The second Line");
        FileUtils.writeLines((File)file, linesToAppend, (boolean)true);
        String expected = "This line was there before you...my first line" + System.lineSeparator() + "The second Line" + System.lineSeparator();
        String actual = FileUtils.readFileToString((File)file);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testWriteLines_4arg() throws Exception {
        Object[] data = new Object[]{"hello", new StringBuffer("world"), "", "this is", null, "some text"};
        List<Object> list = Arrays.asList(data);
        File file = TestUtils.newFile(this.temporaryFolder, "lines.txt");
        FileUtils.writeLines((File)file, (String)"US-ASCII", list, (String)"*");
        String expected = "hello*world**this is**some text*";
        String actual = FileUtils.readFileToString((File)file, (String)"US-ASCII");
        Assertions.assertEquals((Object)"hello*world**this is**some text*", (Object)actual);
    }

    @Test
    public void testWriteLines_4arg_nullSeparator() throws Exception {
        Object[] data = new Object[]{"hello", new StringBuffer("world"), "", "this is", null, "some text"};
        List<Object> list = Arrays.asList(data);
        File file = TestUtils.newFile(this.temporaryFolder, "lines.txt");
        FileUtils.writeLines((File)file, (String)"US-ASCII", list, null);
        String expected = "hello" + System.lineSeparator() + "world" + System.lineSeparator() + System.lineSeparator() + "this is" + System.lineSeparator() + System.lineSeparator() + "some text" + System.lineSeparator();
        String actual = FileUtils.readFileToString((File)file, (String)"US-ASCII");
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testWriteLines_4arg_Writer_nullData() throws Exception {
        File file = TestUtils.newFile(this.temporaryFolder, "lines.txt");
        FileUtils.writeLines((File)file, (String)"US-ASCII", null, (String)"*");
        Assertions.assertEquals((long)0L, (long)file.length(), (String)"Sizes differ");
    }

    @Test
    public void testWriteLines_4argsWithAppendOptionFalse_ShouldDeletePreviousFileLines() throws Exception {
        File file = TestUtils.newFile(this.temporaryFolder, "lines.txt");
        FileUtils.writeStringToFile((File)file, (String)"This line was there before you...");
        List<String> linesToAppend = Arrays.asList("my first line", "The second Line");
        FileUtils.writeLines((File)file, linesToAppend, null, (boolean)false);
        String expected = "my first line" + System.lineSeparator() + "The second Line" + System.lineSeparator();
        String actual = FileUtils.readFileToString((File)file);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testWriteLines_4argsWithAppendOptionTrue_ShouldNotDeletePreviousFileLines() throws Exception {
        File file = TestUtils.newFile(this.temporaryFolder, "lines.txt");
        FileUtils.writeStringToFile((File)file, (String)"This line was there before you...");
        List<String> linesToAppend = Arrays.asList("my first line", "The second Line");
        FileUtils.writeLines((File)file, linesToAppend, null, (boolean)true);
        String expected = "This line was there before you...my first line" + System.lineSeparator() + "The second Line" + System.lineSeparator();
        String actual = FileUtils.readFileToString((File)file);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testWriteLines_5argsWithAppendOptionFalse_ShouldDeletePreviousFileLines() throws Exception {
        File file = TestUtils.newFile(this.temporaryFolder, "lines.txt");
        FileUtils.writeStringToFile((File)file, (String)"This line was there before you...");
        List<String> linesToAppend = Arrays.asList("my first line", "The second Line");
        FileUtils.writeLines((File)file, null, linesToAppend, null, (boolean)false);
        String expected = "my first line" + System.lineSeparator() + "The second Line" + System.lineSeparator();
        String actual = FileUtils.readFileToString((File)file);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testWriteLines_5argsWithAppendOptionTrue_ShouldNotDeletePreviousFileLines() throws Exception {
        File file = TestUtils.newFile(this.temporaryFolder, "lines.txt");
        FileUtils.writeStringToFile((File)file, (String)"This line was there before you...");
        List<String> linesToAppend = Arrays.asList("my first line", "The second Line");
        FileUtils.writeLines((File)file, null, linesToAppend, null, (boolean)true);
        String expected = "This line was there before you...my first line" + System.lineSeparator() + "The second Line" + System.lineSeparator();
        String actual = FileUtils.readFileToString((File)file);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testWriteLinesEncoding_WithAppendOptionFalse_ShouldDeletePreviousFileLines() throws Exception {
        File file = TestUtils.newFile(this.temporaryFolder, "lines.txt");
        FileUtils.writeStringToFile((File)file, (String)"This line was there before you...");
        List<String> linesToAppend = Arrays.asList("my first line", "The second Line");
        FileUtils.writeLines((File)file, null, linesToAppend, (boolean)false);
        String expected = "my first line" + System.lineSeparator() + "The second Line" + System.lineSeparator();
        String actual = FileUtils.readFileToString((File)file);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testWriteLinesEncoding_WithAppendOptionTrue_ShouldNotDeletePreviousFileLines() throws Exception {
        File file = TestUtils.newFile(this.temporaryFolder, "lines.txt");
        FileUtils.writeStringToFile((File)file, (String)"This line was there before you...");
        List<String> linesToAppend = Arrays.asList("my first line", "The second Line");
        FileUtils.writeLines((File)file, null, linesToAppend, (boolean)true);
        String expected = "This line was there before you...my first line" + System.lineSeparator() + "The second Line" + System.lineSeparator();
        String actual = FileUtils.readFileToString((File)file);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testWriteStringToFile_WithAppendOptionFalse_ShouldDeletePreviousFileLines() throws Exception {
        File file = TestUtils.newFile(this.temporaryFolder, "lines.txt");
        FileUtils.writeStringToFile((File)file, (String)"This line was there before you...");
        FileUtils.writeStringToFile((File)file, (String)"this is brand new data", (boolean)false);
        String expected = "this is brand new data";
        String actual = FileUtils.readFileToString((File)file);
        Assertions.assertEquals((Object)"this is brand new data", (Object)actual);
    }

    @Test
    public void testWriteStringToFile_WithAppendOptionTrue_ShouldNotDeletePreviousFileLines() throws Exception {
        File file = TestUtils.newFile(this.temporaryFolder, "lines.txt");
        FileUtils.writeStringToFile((File)file, (String)"This line was there before you...");
        FileUtils.writeStringToFile((File)file, (String)"this is brand new data", (boolean)true);
        String expected = "This line was there before you...this is brand new data";
        String actual = FileUtils.readFileToString((File)file);
        Assertions.assertEquals((Object)"This line was there before you...this is brand new data", (Object)actual);
    }

    @Test
    public void testWriteStringToFile1() throws Exception {
        File file = new File(this.temporaryFolder, "write.txt");
        FileUtils.writeStringToFile((File)file, (String)"Hello /u1234", (String)"UTF8");
        byte[] text = "Hello /u1234".getBytes(StandardCharsets.UTF_8);
        TestUtils.assertEqualContent(text, file);
    }

    @Test
    public void testWriteStringToFile2() throws Exception {
        File file = new File(this.temporaryFolder, "write.txt");
        FileUtils.writeStringToFile((File)file, (String)"Hello /u1234", (String)null);
        byte[] text = "Hello /u1234".getBytes();
        TestUtils.assertEqualContent(text, file);
    }

    @Test
    public void testWriteStringToFile3() throws Exception {
        File file = new File(this.temporaryFolder, "write.txt");
        FileUtils.writeStringToFile((File)file, (String)"Hello /u1234", (Charset)null);
        byte[] text = "Hello /u1234".getBytes();
        TestUtils.assertEqualContent(text, file);
    }

    @Test
    public void testWriteStringToFileWithEncoding_WithAppendOptionFalse_ShouldDeletePreviousFileLines() throws Exception {
        File file = TestUtils.newFile(this.temporaryFolder, "lines.txt");
        FileUtils.writeStringToFile((File)file, (String)"This line was there before you...");
        FileUtils.writeStringToFile((File)file, (String)"this is brand new data", (String)null, (boolean)false);
        String expected = "this is brand new data";
        String actual = FileUtils.readFileToString((File)file);
        Assertions.assertEquals((Object)"this is brand new data", (Object)actual);
    }

    @Test
    public void testWriteStringToFileWithEncoding_WithAppendOptionTrue_ShouldNotDeletePreviousFileLines() throws Exception {
        File file = TestUtils.newFile(this.temporaryFolder, "lines.txt");
        FileUtils.writeStringToFile((File)file, (String)"This line was there before you...");
        FileUtils.writeStringToFile((File)file, (String)"this is brand new data", (String)null, (boolean)true);
        String expected = "This line was there before you...this is brand new data";
        String actual = FileUtils.readFileToString((File)file);
        Assertions.assertEquals((Object)"This line was there before you...this is brand new data", (Object)actual);
    }

    @Test
    public void testWriteWithEncoding_WithAppendOptionFalse_ShouldDeletePreviousFileLines() throws Exception {
        File file = TestUtils.newFile(this.temporaryFolder, "lines.txt");
        FileUtils.writeStringToFile((File)file, (String)"This line was there before you...");
        FileUtils.write((File)file, (CharSequence)"this is brand new data", (String)null, (boolean)false);
        String expected = "this is brand new data";
        String actual = FileUtils.readFileToString((File)file);
        Assertions.assertEquals((Object)"this is brand new data", (Object)actual);
    }

    @Test
    public void testWriteWithEncoding_WithAppendOptionTrue_ShouldNotDeletePreviousFileLines() throws Exception {
        File file = TestUtils.newFile(this.temporaryFolder, "lines.txt");
        FileUtils.writeStringToFile((File)file, (String)"This line was there before you...");
        FileUtils.write((File)file, (CharSequence)"this is brand new data", (String)null, (boolean)true);
        String expected = "This line was there before you...this is brand new data";
        String actual = FileUtils.readFileToString((File)file);
        Assertions.assertEquals((Object)"This line was there before you...this is brand new data", (Object)actual);
    }

    private static class ShorterFile
    extends File {
        private static final long serialVersionUID = 1L;

        public ShorterFile(String pathname) {
            super(pathname);
        }

        @Override
        public long length() {
            return super.length() - 1L;
        }
    }

    static class ListDirectoryWalker
    extends DirectoryWalker<File> {
        ListDirectoryWalker() {
        }

        protected void handleDirectoryStart(File directory, int depth, Collection<File> results) throws IOException {
            if (depth > 0) {
                results.add(directory);
            }
        }

        protected void handleFile(File file, int depth, Collection<File> results) throws IOException {
            results.add(file);
        }

        List<File> list(File startDirectory) throws IOException {
            ArrayList<File> files = new ArrayList<File>();
            this.walk(startDirectory, files);
            return files;
        }
    }
}

