/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.file;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.file.CleaningPathVisitor;
import org.apache.commons.io.file.CounterAssertions;
import org.apache.commons.io.file.Counters;
import org.apache.commons.io.file.CountingPathVisitor;
import org.apache.commons.io.file.PathUtils;
import org.apache.commons.io.file.TestArguments;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class CleaningPathVisitorTest
extends TestArguments {
    private Path tempDir;

    @AfterEach
    public void afterEach() throws IOException {
        Assertions.assertTrue((boolean)Files.exists(this.tempDir, new LinkOption[0]));
        if (Files.exists(this.tempDir, new LinkOption[0]) && PathUtils.isEmptyDirectory((Path)this.tempDir)) {
            Files.deleteIfExists(this.tempDir);
        }
    }

    private void applyCleanEmptyDirectory(CleaningPathVisitor visitor) throws IOException {
        Files.walkFileTree(this.tempDir, (FileVisitor<? super Path>)visitor);
        CounterAssertions.assertCounts(1L, 0L, 0L, (CountingPathVisitor)visitor);
    }

    @BeforeEach
    public void beforeEach() throws IOException {
        this.tempDir = Files.createTempDirectory(this.getClass().getCanonicalName(), new FileAttribute[0]);
    }

    @ParameterizedTest
    @MethodSource(value={"cleaningPathVisitors"})
    public void testCleanEmptyDirectory(CleaningPathVisitor visitor) throws IOException {
        this.applyCleanEmptyDirectory(visitor);
    }

    @ParameterizedTest
    @MethodSource(value={"pathCounters"})
    public void testCleanEmptyDirectoryNullCtorArg(Counters.PathCounters pathCounters) throws IOException {
        this.applyCleanEmptyDirectory(new CleaningPathVisitor(pathCounters, (String[])null));
    }

    @ParameterizedTest
    @MethodSource(value={"cleaningPathVisitors"})
    public void testCleanFolders1FileSize0(CleaningPathVisitor visitor) throws IOException {
        PathUtils.copyDirectory((Path)Paths.get("src/test/resources/org/apache/commons/io/dirs-1-file-size-0", new String[0]), (Path)this.tempDir, (CopyOption[])new CopyOption[0]);
        CounterAssertions.assertCounts(1L, 1L, 0L, (CountingPathVisitor)PathUtils.visitFileTree((FileVisitor)visitor, (Path)this.tempDir));
    }

    @ParameterizedTest
    @MethodSource(value={"cleaningPathVisitors"})
    public void testCleanFolders1FileSize1(CleaningPathVisitor visitor) throws IOException {
        PathUtils.copyDirectory((Path)Paths.get("src/test/resources/org/apache/commons/io/dirs-1-file-size-1", new String[0]), (Path)this.tempDir, (CopyOption[])new CopyOption[0]);
        CounterAssertions.assertCounts(1L, 1L, 1L, (CountingPathVisitor)PathUtils.visitFileTree((FileVisitor)visitor, (Path)this.tempDir));
    }

    @ParameterizedTest
    @MethodSource(value={"pathCounters"})
    public void testCleanFolders1FileSize1Skip(Counters.PathCounters pathCounters) throws IOException {
        PathUtils.copyDirectory((Path)Paths.get("src/test/resources/org/apache/commons/io/dirs-1-file-size-1", new String[0]), (Path)this.tempDir, (CopyOption[])new CopyOption[0]);
        String skipFileName = "file-size-1.bin";
        CleaningPathVisitor visitor = new CleaningPathVisitor(pathCounters, new String[]{"file-size-1.bin"});
        CounterAssertions.assertCounts(1L, 1L, 1L, (CountingPathVisitor)PathUtils.visitFileTree((FileVisitor)visitor, (Path)this.tempDir));
        Path skippedFile = this.tempDir.resolve("file-size-1.bin");
        Assertions.assertTrue((boolean)Files.exists(skippedFile, new LinkOption[0]));
        Files.delete(skippedFile);
    }

    @ParameterizedTest
    @MethodSource(value={"cleaningPathVisitors"})
    public void testCleanFolders2FileSize2(CleaningPathVisitor visitor) throws IOException {
        PathUtils.copyDirectory((Path)Paths.get("src/test/resources/org/apache/commons/io/dirs-2-file-size-2", new String[0]), (Path)this.tempDir, (CopyOption[])new CopyOption[0]);
        CounterAssertions.assertCounts(3L, 2L, 2L, (CountingPathVisitor)PathUtils.visitFileTree((FileVisitor)visitor, (Path)this.tempDir));
    }
}

