/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.filefilter;

import java.io.File;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.util.regex.Pattern;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.AbstractFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.RegexFileFilter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RegexFileFilterTestCase {
    public void assertFiltering(IOFileFilter filter, File file, boolean expected) {
        Assertions.assertEquals((Object)expected, (Object)filter.accept(file), (String)("Filter(File) " + filter.getClass().getName() + " not " + expected + " for " + file));
        if (file != null && file.getParentFile() != null) {
            Assertions.assertEquals((Object)expected, (Object)filter.accept(file.getParentFile(), file.getName()), (String)("Filter(File, String) " + filter.getClass().getName() + " not " + expected + " for " + file));
        } else if (file == null) {
            Assertions.assertEquals((Object)expected, (Object)filter.accept(file), (String)("Filter(File, String) " + filter.getClass().getName() + " not " + expected + " for null"));
        }
    }

    public void assertFiltering(IOFileFilter filter, Path path, boolean expected) {
        FileVisitResult expectedFileVisitResult = AbstractFileFilter.toFileVisitResult((boolean)expected, (Path)path);
        Assertions.assertEquals((Object)((Object)expectedFileVisitResult), (Object)((Object)filter.accept(path, null)), (String)("Filter(Path) " + filter.getClass().getName() + " not " + (Object)((Object)expectedFileVisitResult) + " for " + path));
        if (path != null && path.getParent() != null) {
            Assertions.assertEquals((Object)((Object)expectedFileVisitResult), (Object)((Object)filter.accept(path, null)), (String)("Filter(Path, Path) " + filter.getClass().getName() + " not " + (Object)((Object)expectedFileVisitResult) + " for " + path));
        } else if (path == null) {
            Assertions.assertEquals((Object)((Object)expectedFileVisitResult), (Object)((Object)filter.accept(path, null)), (String)("Filter(Path, Path) " + filter.getClass().getName() + " not " + (Object)((Object)expectedFileVisitResult) + " for null"));
        }
    }

    @Test
    public void testRegex() {
        RegexFileFilter filter = new RegexFileFilter("^.*[tT]est(-\\d+)?\\.java$");
        this.assertFiltering((IOFileFilter)filter, new File("Test.java"), true);
        this.assertFiltering((IOFileFilter)filter, new File("test-10.java"), true);
        this.assertFiltering((IOFileFilter)filter, new File("test-.java"), false);
        this.assertFiltering((IOFileFilter)filter, new File("Test.java").toPath(), true);
        this.assertFiltering((IOFileFilter)filter, new File("test-10.java").toPath(), true);
        this.assertFiltering((IOFileFilter)filter, new File("test-.java").toPath(), false);
        filter = new RegexFileFilter("^[Tt]est.java$");
        this.assertFiltering((IOFileFilter)filter, new File("Test.java"), true);
        this.assertFiltering((IOFileFilter)filter, new File("test.java"), true);
        this.assertFiltering((IOFileFilter)filter, new File("tEST.java"), false);
        this.assertFiltering((IOFileFilter)filter, new File("Test.java").toPath(), true);
        this.assertFiltering((IOFileFilter)filter, new File("test.java").toPath(), true);
        this.assertFiltering((IOFileFilter)filter, new File("tEST.java").toPath(), false);
        filter = new RegexFileFilter(Pattern.compile("^test.java$", 2));
        this.assertFiltering((IOFileFilter)filter, new File("Test.java"), true);
        this.assertFiltering((IOFileFilter)filter, new File("test.java"), true);
        this.assertFiltering((IOFileFilter)filter, new File("tEST.java"), true);
        this.assertFiltering((IOFileFilter)filter, new File("Test.java").toPath(), true);
        this.assertFiltering((IOFileFilter)filter, new File("test.java").toPath(), true);
        this.assertFiltering((IOFileFilter)filter, new File("tEST.java").toPath(), true);
        filter = new RegexFileFilter("^test.java$", 2);
        this.assertFiltering((IOFileFilter)filter, new File("Test.java"), true);
        this.assertFiltering((IOFileFilter)filter, new File("test.java"), true);
        this.assertFiltering((IOFileFilter)filter, new File("tEST.java"), true);
        this.assertFiltering((IOFileFilter)filter, new File("Test.java").toPath(), true);
        this.assertFiltering((IOFileFilter)filter, new File("test.java").toPath(), true);
        this.assertFiltering((IOFileFilter)filter, new File("tEST.java").toPath(), true);
        filter = new RegexFileFilter("^test.java$", IOCase.INSENSITIVE);
        this.assertFiltering((IOFileFilter)filter, new File("Test.java"), true);
        this.assertFiltering((IOFileFilter)filter, new File("test.java"), true);
        this.assertFiltering((IOFileFilter)filter, new File("tEST.java"), true);
        this.assertFiltering((IOFileFilter)filter, new File("Test.java").toPath(), true);
        this.assertFiltering((IOFileFilter)filter, new File("test.java").toPath(), true);
        this.assertFiltering((IOFileFilter)filter, new File("tEST.java").toPath(), true);
        try {
            new RegexFileFilter((String)null);
            Assertions.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new RegexFileFilter(null, 2);
            Assertions.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new RegexFileFilter(null, IOCase.INSENSITIVE);
            Assertions.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new RegexFileFilter((Pattern)null);
            Assertions.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

