/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.TestResources;
import org.apache.commons.io.input.Tailer;
import org.apache.commons.io.input.TailerListener;
import org.apache.commons.io.input.TailerListenerAdapter;
import org.apache.commons.io.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class TailerTest {
    @TempDir
    public static File temporaryFolder;
    private Tailer tailer;

    @AfterEach
    public void tearDown() {
        if (this.tailer != null) {
            this.tailer.stop();
        }
    }

    @Test
    public void testLongFile() throws Exception {
        long delay = 50L;
        File file = new File(temporaryFolder, "testLongFile.txt");
        this.createFile(file, 0L);
        try (FileWriter writer = new FileWriter(file, true);){
            for (int i = 0; i < 100000; ++i) {
                writer.write("LineLineLineLineLineLineLineLineLineLine\n");
            }
            writer.write("SBTOURIST\n");
        }
        TestTailerListener listener = new TestTailerListener();
        this.tailer = new Tailer(file, (TailerListener)listener, 50L, false);
        Thread thread = new Thread((Runnable)this.tailer);
        thread.start();
        List<String> lines = listener.getLines();
        while (lines.isEmpty() || !lines.get(lines.size() - 1).equals("SBTOURIST")) {
            lines = listener.getLines();
        }
        listener.clear();
    }

    @Test
    public void testBufferBreak() throws Exception {
        long delay = 50L;
        File file = new File(temporaryFolder, "testBufferBreak.txt");
        this.createFile(file, 0L);
        this.writeString(file, "SBTOURIST\n");
        TestTailerListener listener = new TestTailerListener();
        this.tailer = new Tailer(file, (TailerListener)listener, 50L, false, 1);
        Thread thread = new Thread((Runnable)this.tailer);
        thread.start();
        List<String> lines = listener.getLines();
        while (lines.isEmpty() || !lines.get(lines.size() - 1).equals("SBTOURIST")) {
            lines = listener.getLines();
        }
        listener.clear();
    }

    @Test
    public void testMultiByteBreak() throws Exception {
        long delay = 50L;
        File origin = TestResources.getFile("test-file-utf8.bin");
        File file = new File(temporaryFolder, "testMultiByteBreak.txt");
        this.createFile(file, 0L);
        TestTailerListener listener = new TestTailerListener();
        String osname = System.getProperty("os.name");
        boolean isWindows = osname.startsWith("Windows");
        Charset charsetUTF8 = StandardCharsets.UTF_8;
        this.tailer = new Tailer(file, charsetUTF8, (TailerListener)listener, 50L, false, isWindows, 8192);
        Thread thread = new Thread((Runnable)this.tailer);
        thread.start();
        try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(file), charsetUTF8);
             BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(origin), charsetUTF8));){
            String line;
            ArrayList<String> lines = new ArrayList<String>();
            while ((line = reader.readLine()) != null) {
                out.write(line);
                out.write("\n");
                lines.add(line);
            }
            ((Writer)out).close();
            long testDelayMillis = 500L;
            TestUtils.sleep(500L);
            List<String> tailerlines = listener.getLines();
            Assertions.assertEquals((int)lines.size(), (int)tailerlines.size(), (String)"line count");
            int len = lines.size();
            for (int i = 0; i < len; ++i) {
                String actual;
                String expected = (String)lines.get(i);
                if (expected.equals(actual = tailerlines.get(i))) continue;
                Assertions.fail((String)("Line: " + i + "\nExp: (" + expected.length() + ") " + expected + "\nAct: (" + actual.length() + ") " + actual));
            }
        }
    }

    @Test
    public void testTailerEof() throws Exception {
        long delay = 50L;
        File file = new File(temporaryFolder, "tailer2-test.txt");
        this.createFile(file, 0L);
        TestTailerListener listener = new TestTailerListener();
        this.tailer = new Tailer(file, (TailerListener)listener, 50L, false);
        Thread thread = new Thread((Runnable)this.tailer);
        thread.start();
        this.writeString(file, "Line");
        TestUtils.sleep(100L);
        List<String> lines = listener.getLines();
        Assertions.assertEquals((int)0, (int)lines.size(), (String)"1 line count");
        this.writeString(file, " one\n");
        TestUtils.sleep(100L);
        lines = listener.getLines();
        Assertions.assertEquals((int)1, (int)lines.size(), (String)"1 line count");
        Assertions.assertEquals((Object)"Line one", (Object)lines.get(0), (String)"1 line 1");
        listener.clear();
    }

    @Test
    public void testTailer() throws Exception {
        long delayMillis = 50L;
        File file = new File(temporaryFolder, "tailer1-test.txt");
        this.createFile(file, 0L);
        TestTailerListener listener = new TestTailerListener();
        String osname = System.getProperty("os.name");
        boolean isWindows = osname.startsWith("Windows");
        this.tailer = new Tailer(file, (TailerListener)listener, 50L, false, isWindows);
        Thread thread = new Thread((Runnable)this.tailer);
        thread.start();
        this.write(file, "Line one", "Line two");
        long testDelayMillis = 500L;
        TestUtils.sleep(500L);
        List<String> lines = listener.getLines();
        Assertions.assertEquals((int)2, (int)lines.size(), (String)"1 line count");
        Assertions.assertEquals((Object)"Line one", (Object)lines.get(0), (String)"1 line 1");
        Assertions.assertEquals((Object)"Line two", (Object)lines.get(1), (String)"1 line 2");
        listener.clear();
        this.write(file, "Line three");
        TestUtils.sleep(500L);
        lines = listener.getLines();
        Assertions.assertEquals((int)1, (int)lines.size(), (String)"2 line count");
        Assertions.assertEquals((Object)"Line three", (Object)lines.get(0), (String)"2 line 3");
        listener.clear();
        lines = FileUtils.readLines((File)file, (String)"UTF-8");
        Assertions.assertEquals((int)3, (int)lines.size(), (String)"3 line count");
        Assertions.assertEquals((Object)"Line one", lines.get(0), (String)"3 line 1");
        Assertions.assertEquals((Object)"Line two", lines.get(1), (String)"3 line 2");
        Assertions.assertEquals((Object)"Line three", lines.get(2), (String)"3 line 3");
        file.delete();
        Assertions.assertFalse((boolean)file.exists(), (String)"File should not exist");
        this.createFile(file, 0L);
        Assertions.assertTrue((boolean)file.exists(), (String)"File should now exist");
        TestUtils.sleep(500L);
        this.write(file, "Line four");
        TestUtils.sleep(500L);
        lines = listener.getLines();
        Assertions.assertEquals((int)1, (int)lines.size(), (String)"4 line count");
        Assertions.assertEquals((Object)"Line four", (Object)lines.get(0), (String)"4 line 3");
        listener.clear();
        thread.interrupt();
        TestUtils.sleep(2000L);
        this.write(file, "Line five");
        Assertions.assertEquals((int)0, (int)listener.getLines().size(), (String)"4 line count");
        Assertions.assertNotNull((Object)listener.exception, (String)"Missing InterruptedException");
        Assertions.assertTrue((boolean)(listener.exception instanceof InterruptedException), (String)("Unexpected Exception: " + listener.exception));
        Assertions.assertEquals((int)1, (int)listener.initialized, (String)"Expected init to be called");
        Assertions.assertEquals((int)1, (int)listener.rotated, (String)"fileRotated should be be called");
    }

    @Test
    public void testTailerEndOfFileReached() throws Exception {
        long delayMillis = 50L;
        long testDelayMillis = 500L;
        File file = new File(temporaryFolder, "tailer-eof-test.txt");
        this.createFile(file, 0L);
        TestTailerListener listener = new TestTailerListener();
        String osname = System.getProperty("os.name");
        boolean isWindows = osname.startsWith("Windows");
        this.tailer = new Tailer(file, (TailerListener)listener, 50L, false, isWindows);
        Thread thread = new Thread((Runnable)this.tailer);
        thread.start();
        this.write(file, "line1", "line2", "line3");
        TestUtils.sleep(500L);
        this.write(file, "line4", "line5", "line6");
        TestUtils.sleep(500L);
        this.write(file, "line7", "line8", "line9");
        TestUtils.sleep(500L);
        Assertions.assertTrue((listener.reachedEndOfFile >= 3 ? 1 : 0) != 0, (String)"end of file reached at least 3 times");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createFile(File file, long size) throws IOException {
        if (!file.getParentFile().exists()) {
            throw new IOException("Cannot create file " + file + " as the parent directory does not exist");
        }
        try (BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(file));){
            TestUtils.generateTestData(output, size);
        }
        RandomAccessFile reader = null;
        try {
            while (reader == null) {
                try {
                    reader = new RandomAccessFile(file.getPath(), "r");
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
                try {
                    TestUtils.sleep(200L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        finally {
            try {
                IOUtils.close(reader);
            }
            catch (IOException iOException) {}
        }
    }

    private void write(File file, String ... lines) throws Exception {
        try (FileWriter writer = new FileWriter(file, true);){
            for (String line : lines) {
                writer.write(line + "\n");
            }
        }
    }

    private void writeString(File file, String ... strings) throws Exception {
        try (FileWriter writer = new FileWriter(file, true);){
            for (String string : strings) {
                writer.write(string);
            }
        }
    }

    @Test
    public void testStopWithNoFile() throws Exception {
        File file = new File(temporaryFolder, "nosuchfile");
        Assertions.assertFalse((boolean)file.exists(), (String)"nosuchfile should not exist");
        TestTailerListener listener = new TestTailerListener();
        int delay = 100;
        int idle = 50;
        this.tailer = Tailer.create((File)file, (TailerListener)listener, (long)100L, (boolean)false);
        TestUtils.sleep(50L);
        this.tailer.stop();
        TestUtils.sleep(150L);
        Assertions.assertNull((Object)listener.exception, (String)"Should not generate Exception");
        Assertions.assertEquals((int)1, (int)listener.initialized, (String)"Expected init to be called");
        Assertions.assertTrue((listener.notFound > 0 ? 1 : 0) != 0, (String)"fileNotFound should be called");
        Assertions.assertEquals((int)0, (int)listener.rotated, (String)"fileRotated should be not be called");
        Assertions.assertEquals((int)0, (int)listener.reachedEndOfFile, (String)"end of file never reached");
    }

    @Test
    public void testInterrupt() throws Exception {
        File file = new File(temporaryFolder, "nosuchfile");
        Assertions.assertFalse((boolean)file.exists(), (String)"nosuchfile should not exist");
        TestTailerListener listener = new TestTailerListener();
        int delay = 1000;
        int idle = 50;
        this.tailer = new Tailer(file, (TailerListener)listener, 1000L, false, 8192);
        Thread thread = new Thread((Runnable)this.tailer);
        thread.setDaemon(true);
        thread.start();
        TestUtils.sleep(50L);
        thread.interrupt();
        TestUtils.sleep(1050L);
        Assertions.assertNotNull((Object)listener.exception, (String)"Missing InterruptedException");
        Assertions.assertTrue((boolean)(listener.exception instanceof InterruptedException), (String)("Unexpected Exception: " + listener.exception));
        Assertions.assertEquals((int)1, (int)listener.initialized, (String)"Expected init to be called");
        Assertions.assertTrue((listener.notFound > 0 ? 1 : 0) != 0, (String)"fileNotFound should be called");
        Assertions.assertEquals((int)0, (int)listener.rotated, (String)"fileRotated should be not be called");
        Assertions.assertEquals((int)0, (int)listener.reachedEndOfFile, (String)"end of file never reached");
    }

    @Test
    public void testStopWithNoFileUsingExecutor() throws Exception {
        File file = new File(temporaryFolder, "nosuchfile");
        Assertions.assertFalse((boolean)file.exists(), (String)"nosuchfile should not exist");
        TestTailerListener listener = new TestTailerListener();
        int delay = 100;
        int idle = 50;
        this.tailer = new Tailer(file, (TailerListener)listener, 100L, false);
        ScheduledThreadPoolExecutor exec = new ScheduledThreadPoolExecutor(1);
        exec.execute((Runnable)this.tailer);
        TestUtils.sleep(50L);
        this.tailer.stop();
        TestUtils.sleep(150L);
        Assertions.assertNull((Object)listener.exception, (String)"Should not generate Exception");
        Assertions.assertEquals((int)1, (int)listener.initialized, (String)"Expected init to be called");
        Assertions.assertTrue((listener.notFound > 0 ? 1 : 0) != 0, (String)"fileNotFound should be called");
        Assertions.assertEquals((int)0, (int)listener.rotated, (String)"fileRotated should be not be called");
        Assertions.assertEquals((int)0, (int)listener.reachedEndOfFile, (String)"end of file never reached");
    }

    @Test
    public void testIO335() throws Exception {
        long delayMillis = 50L;
        File file = new File(temporaryFolder, "tailer-testio334.txt");
        this.createFile(file, 0L);
        TestTailerListener listener = new TestTailerListener();
        this.tailer = new Tailer(file, (TailerListener)listener, 50L, false);
        Thread thread = new Thread((Runnable)this.tailer);
        thread.start();
        this.writeString(file, "CRLF\r\n", "LF\n", "CR\r", "CRCR\r\r", "trail");
        long testDelayMillis = 500L;
        TestUtils.sleep(500L);
        List<String> lines = listener.getLines();
        Assertions.assertEquals((int)4, (int)lines.size(), (String)"line count");
        Assertions.assertEquals((Object)"CRLF", (Object)lines.get(0), (String)"line 1");
        Assertions.assertEquals((Object)"LF", (Object)lines.get(1), (String)"line 2");
        Assertions.assertEquals((Object)"CR", (Object)lines.get(2), (String)"line 3");
        Assertions.assertEquals((Object)"CRCR\r", (Object)lines.get(3), (String)"line 4");
    }

    private static class TestTailerListener
    extends TailerListenerAdapter {
        private final List<String> lines = Collections.synchronizedList(new ArrayList());
        volatile Exception exception;
        volatile int notFound;
        volatile int rotated;
        volatile int initialized;
        volatile int reachedEndOfFile;

        private TestTailerListener() {
        }

        public void handle(String line) {
            this.lines.add(line);
        }

        public List<String> getLines() {
            return this.lines;
        }

        public void clear() {
            this.lines.clear();
        }

        public void handle(Exception e) {
            this.exception = e;
        }

        public void init(Tailer tailer) {
            ++this.initialized;
        }

        public void fileNotFound() {
            ++this.notFound;
        }

        public void fileRotated() {
            ++this.rotated;
        }

        public void endOfFileReached() {
            ++this.reachedEndOfFile;
        }
    }
}

