/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.UUID;
import org.apache.commons.io.TaggedIOException;
import org.apache.commons.io.output.BrokenWriter;
import org.apache.commons.io.output.ClosedWriter;
import org.apache.commons.io.output.StringBuilderWriter;
import org.apache.commons.io.output.TaggedWriter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TaggedWriterTest {
    @Test
    public void testNormalWriter() {
        try (StringBuilderWriter buffer = new StringBuilderWriter();){
            try (TaggedWriter writer = new TaggedWriter((Writer)buffer);){
                writer.write(97);
                writer.write(new char[]{'b'});
                writer.write(new char[]{'c'}, 0, 1);
                writer.flush();
            }
            Assertions.assertEquals((int)3, (int)buffer.getBuilder().length());
            Assertions.assertEquals((char)'a', (char)buffer.getBuilder().charAt(0));
            Assertions.assertEquals((char)'b', (char)buffer.getBuilder().charAt(1));
            Assertions.assertEquals((char)'c', (char)buffer.getBuilder().charAt(2));
        }
        catch (IOException e) {
            Assertions.fail((String)"Unexpected exception thrown");
        }
    }

    @Test
    public void testBrokenWriter() {
        IOException exception = new IOException("test exception");
        TaggedWriter writer = new TaggedWriter((Writer)new BrokenWriter(exception));
        try {
            writer.write(new char[]{'x'}, 0, 1);
            Assertions.fail((String)"Expected exception not thrown.");
        }
        catch (IOException e) {
            Assertions.assertTrue((boolean)writer.isCauseOf((Exception)e));
            try {
                writer.throwIfCauseOf((Exception)e);
                Assertions.fail((String)"Expected exception not thrown.");
            }
            catch (IOException e2) {
                Assertions.assertEquals((Object)exception, (Object)e2);
            }
        }
        try {
            writer.flush();
            Assertions.fail((String)"Expected exception not thrown.");
        }
        catch (IOException e) {
            Assertions.assertTrue((boolean)writer.isCauseOf((Exception)e));
            try {
                writer.throwIfCauseOf((Exception)e);
                Assertions.fail((String)"Expected exception not thrown.");
            }
            catch (IOException e2) {
                Assertions.assertEquals((Object)exception, (Object)e2);
            }
        }
        try {
            writer.close();
            Assertions.fail((String)"Expected exception not thrown.");
        }
        catch (IOException e) {
            Assertions.assertTrue((boolean)writer.isCauseOf((Exception)e));
            try {
                writer.throwIfCauseOf((Exception)e);
                Assertions.fail((String)"Expected exception not thrown.");
            }
            catch (IOException e2) {
                Assertions.assertEquals((Object)exception, (Object)e2);
            }
        }
    }

    @Test
    public void testOtherException() throws Exception {
        IOException exception = new IOException("test exception");
        try (TaggedWriter writer = new TaggedWriter((Writer)ClosedWriter.CLOSED_WRITER);){
            Assertions.assertFalse((boolean)writer.isCauseOf((Exception)exception));
            Assertions.assertFalse((boolean)writer.isCauseOf((Exception)new TaggedIOException(exception, (Serializable)UUID.randomUUID())));
            try {
                writer.throwIfCauseOf((Exception)exception);
            }
            catch (IOException e) {
                Assertions.fail((String)"Unexpected exception thrown");
            }
            try {
                writer.throwIfCauseOf((Exception)new TaggedIOException(exception, (Serializable)UUID.randomUUID()));
            }
            catch (IOException e) {
                Assertions.fail((String)"Unexpected exception thrown");
            }
        }
    }
}

