/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jci.compilers;

import groovy.lang.GroovyClassLoader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.jci.compilers.AbstractJavaCompiler;
import org.apache.commons.jci.compilers.CompilationResult;
import org.apache.commons.jci.compilers.GroovyCompilationProblem;
import org.apache.commons.jci.compilers.GroovyJavaCompilerSettings;
import org.apache.commons.jci.compilers.JavaCompilerSettings;
import org.apache.commons.jci.problems.CompilationProblem;
import org.apache.commons.jci.readers.ResourceReader;
import org.apache.commons.jci.stores.ResourceStore;
import org.apache.commons.jci.utils.ConversionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.ErrorCollector;
import org.codehaus.groovy.control.MultipleCompilationErrorsException;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.messages.Message;
import org.codehaus.groovy.control.messages.WarningMessage;
import org.codehaus.groovy.tools.GroovyClass;

public final class GroovyJavaCompiler
extends AbstractJavaCompiler {
    private final Log log = LogFactory.getLog((Class)GroovyJavaCompiler.class);
    private final GroovyJavaCompilerSettings defaultSettings = new GroovyJavaCompilerSettings(new CompilerConfiguration());

    public CompilationResult compile(String[] pResourceNames, ResourceReader pReader, ResourceStore pStore, ClassLoader pClassLoader, JavaCompilerSettings pSettings) {
        CompilerConfiguration configuration = ((GroovyJavaCompilerSettings)pSettings).getCompilerConfiguration();
        ErrorCollector collector = new ErrorCollector(configuration);
        GroovyClassLoader groovyClassLoader = new GroovyClassLoader(pClassLoader);
        CompilationUnit unit = new CompilationUnit(configuration, null, (ClassLoader)groovyClassLoader);
        SourceUnit[] source = new SourceUnit[pResourceNames.length];
        for (int i = 0; i < source.length; ++i) {
            String resourceName = pResourceNames[i];
            source[i] = new SourceUnit(ConversionUtils.convertResourceToClassName((String)resourceName), new String(pReader.getBytes(resourceName)), configuration, (ClassLoader)groovyClassLoader, collector);
            unit.addSource(source[i]);
        }
        ArrayList<GroovyCompilationProblem> problems = new ArrayList<GroovyCompilationProblem>();
        try {
            this.log.debug((Object)"compiling");
            unit.compile(7);
            List classes = unit.getClasses();
            Iterator it = classes.iterator();
            while (it.hasNext()) {
                GroovyClass clazz = (GroovyClass)it.next();
                byte[] bytes = clazz.getBytes();
                pStore.write(ConversionUtils.convertClassToResourcePath((String)clazz.getName()), bytes);
            }
        }
        catch (MultipleCompilationErrorsException e) {
            List errors;
            ErrorCollector col = e.getErrorCollector();
            List warnings = col.getWarnings();
            if (warnings != null) {
                Iterator it = warnings.iterator();
                while (it.hasNext()) {
                    WarningMessage warning = (WarningMessage)it.next();
                    GroovyCompilationProblem problem = new GroovyCompilationProblem((Message)warning);
                    if (this.problemHandler != null) {
                        this.problemHandler.handle((CompilationProblem)problem);
                    }
                    problems.add(problem);
                }
            }
            if ((errors = col.getErrors()) != null) {
                Iterator it = errors.iterator();
                while (it.hasNext()) {
                    Message message = (Message)it.next();
                    GroovyCompilationProblem problem = new GroovyCompilationProblem(message);
                    if (this.problemHandler != null) {
                        this.problemHandler.handle((CompilationProblem)problem);
                    }
                    problems.add(problem);
                }
            }
        }
        catch (CompilationFailedException e) {
            throw new RuntimeException("no expected");
        }
        CompilationProblem[] result = new CompilationProblem[problems.size()];
        problems.toArray(result);
        return new CompilationResult(result);
    }

    public JavaCompilerSettings createDefaultSettings() {
        return this.defaultSettings;
    }
}

