/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jci.compilers;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.jci.readers.ResourceReader;
import org.apache.commons.jci.utils.ConversionUtils;

public final class FileInputStreamProxy
extends InputStream {
    private static final ThreadLocal readerThreadLocal = new ThreadLocal();
    private final InputStream in;
    private final String name;

    public static void setResourceReader(ResourceReader pReader) {
        readerThreadLocal.set(pReader);
    }

    public FileInputStreamProxy(File pFile) throws FileNotFoundException {
        this("" + pFile);
    }

    public FileInputStreamProxy(FileDescriptor fdObj) {
        throw new RuntimeException();
    }

    public FileInputStreamProxy(String pName) throws FileNotFoundException {
        this.name = ConversionUtils.getResourceNameFromFileName((String)pName);
        ResourceReader reader = (ResourceReader)readerThreadLocal.get();
        if (reader == null) {
            throw new RuntimeException("forgot to set the ResourceReader for this thread?");
        }
        byte[] bytes = reader.getBytes(this.name);
        if (bytes == null) {
            throw new FileNotFoundException(this.name);
        }
        this.in = new ByteArrayInputStream(bytes);
    }

    public int read() throws IOException {
        return this.in.read();
    }

    public int available() throws IOException {
        return this.in.available();
    }

    public void close() throws IOException {
        this.in.close();
    }

    public synchronized void mark(int readlimit) {
        this.in.mark(readlimit);
    }

    public boolean markSupported() {
        return this.in.markSupported();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this.in.read(b, off, len);
    }

    public int read(byte[] b) throws IOException {
        return this.in.read(b);
    }

    public synchronized void reset() throws IOException {
        this.in.reset();
    }

    public long skip(long n) throws IOException {
        return this.in.skip(n);
    }
}

