/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jci.examples.commandline;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Iterator;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.jci.compilers.CompilationResult;
import org.apache.commons.jci.compilers.JavaCompiler;
import org.apache.commons.jci.compilers.JavaCompilerFactory;
import org.apache.commons.jci.compilers.JavaCompilerSettings;
import org.apache.commons.jci.problems.CompilationProblem;
import org.apache.commons.jci.problems.CompilationProblemHandler;
import org.apache.commons.jci.readers.FileResourceReader;
import org.apache.commons.jci.readers.ResourceReader;
import org.apache.commons.jci.stores.FileResourceStore;
import org.apache.commons.jci.stores.ResourceStore;

public final class CommandlineCompiler {
    public static void main(String[] args) throws Exception {
        Options options = new Options();
        OptionBuilder.withArgName((String)"a.jar:b.jar");
        OptionBuilder.hasArg();
        OptionBuilder.withValueSeparator((char)':');
        OptionBuilder.withDescription((String)"Specify where to find user class files");
        options.addOption(OptionBuilder.create((String)"classpath"));
        OptionBuilder.withArgName((String)"release");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Provide source compatibility with specified release");
        options.addOption(OptionBuilder.create((String)"source"));
        OptionBuilder.withArgName((String)"release");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Generate class files for specific VM version");
        options.addOption(OptionBuilder.create((String)"target"));
        OptionBuilder.withArgName((String)"path");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Specify where to find input source files");
        options.addOption(OptionBuilder.create((String)"sourcepath"));
        OptionBuilder.withArgName((String)"directory");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Specify where to place generated class files");
        options.addOption(OptionBuilder.create((String)"d"));
        OptionBuilder.withArgName((String)"num");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Stop compilation after these number of errors");
        options.addOption(OptionBuilder.create((String)"Xmaxerrs"));
        OptionBuilder.withArgName((String)"num");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Stop compilation after these number of warning");
        options.addOption(OptionBuilder.create((String)"Xmaxwarns"));
        OptionBuilder.withDescription((String)"Generate no warnings");
        options.addOption(OptionBuilder.create((String)"nowarn"));
        GnuParser parser = new GnuParser();
        CommandLine cmd = parser.parse(options, args, true);
        ClassLoader classloader = CommandlineCompiler.class.getClassLoader();
        File sourcepath = new File(".");
        File targetpath = new File(".");
        int maxerrs = 10;
        int maxwarns = 10;
        final boolean nowarn = cmd.hasOption("nowarn");
        JavaCompiler compiler = new JavaCompilerFactory().createCompiler("eclipse");
        JavaCompilerSettings settings = compiler.createDefaultSettings();
        Iterator it = cmd.iterator();
        while (it.hasNext()) {
            Option option = (Option)it.next();
            if ("classpath".equals(option.getOpt())) {
                String[] values = option.getValues();
                URL[] urls = new URL[values.length];
                for (int i = 0; i < urls.length; ++i) {
                    urls[i] = new File(values[i]).toURL();
                }
                classloader = new URLClassLoader(urls);
                continue;
            }
            if ("source".equals(option.getOpt())) {
                settings.setSourceVersion(option.getValue());
                continue;
            }
            if ("target".equals(option.getOpt())) {
                settings.setTargetVersion(option.getValue());
                continue;
            }
            if ("sourcepath".equals(option.getOpt())) {
                sourcepath = new File(option.getValue());
                continue;
            }
            if ("d".equals(option.getOpt())) {
                targetpath = new File(option.getValue());
                continue;
            }
            if ("Xmaxerrs".equals(option.getOpt())) {
                maxerrs = Integer.parseInt(option.getValue());
                continue;
            }
            if (!"Xmaxwarns".equals(option.getOpt())) continue;
            maxwarns = Integer.parseInt(option.getValue());
        }
        FileResourceReader reader = new FileResourceReader(sourcepath);
        FileResourceStore store = new FileResourceStore(targetpath);
        final int maxErrors = maxerrs;
        final int maxWarnings = maxwarns;
        compiler.setCompilationProblemHandler(new CompilationProblemHandler(){
            int errors = 0;
            int warnings = 0;

            public boolean handle(CompilationProblem pProblem) {
                if (pProblem.isError()) {
                    System.err.println(pProblem);
                    ++this.errors;
                    if (this.errors >= maxErrors) {
                        return false;
                    }
                } else {
                    if (!nowarn) {
                        System.err.println(pProblem);
                    }
                    ++this.warnings;
                    if (this.warnings >= maxWarnings) {
                        return false;
                    }
                }
                return true;
            }
        });
        String[] resource = cmd.getArgs();
        for (int i = 0; i < resource.length; ++i) {
            System.out.println("compiling " + resource[i]);
        }
        CompilationResult result = compiler.compile(resource, (ResourceReader)reader, (ResourceStore)store, classloader);
        System.out.println(result.getErrors().length + " errors");
        System.out.println(result.getWarnings().length + " warnings");
    }
}

