/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jci.examples.configuration;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import org.apache.commons.jci.examples.configuration.Configurable;
import org.apache.commons.jci.examples.configuration.Something;
import org.apache.commons.jci.listeners.FileChangeListener;
import org.apache.commons.jci.monitor.FilesystemAlterationListener;
import org.apache.commons.jci.monitor.FilesystemAlterationMonitor;
import org.apache.commons.jci.monitor.FilesystemAlterationObserver;

public final class ConfigurationReloading {
    private final FilesystemAlterationMonitor fam = new FilesystemAlterationMonitor();

    private void run(String[] args) {
        final File configFile = new File("some.properties");
        System.out.println("Watching " + configFile.getAbsolutePath());
        final ArrayList<Something> configurables = new ArrayList<Something>();
        FileChangeListener listener = new FileChangeListener(){

            public void onStop(FilesystemAlterationObserver pObserver) {
                super.onStop(pObserver);
                if (this.hasChanged()) {
                    System.out.println("Configuration change detected " + configFile);
                    Properties props = new Properties();
                    try {
                        props.load(new FileInputStream(configFile));
                        System.out.println("Notifying about configuration change " + configFile);
                        Iterator it = configurables.iterator();
                        while (it.hasNext()) {
                            Configurable configurable = (Configurable)it.next();
                            configurable.configure(props);
                        }
                    }
                    catch (Exception e) {
                        System.err.println("Failed to load configuration " + configFile);
                    }
                }
            }
        };
        this.fam.addListener(configFile, (FilesystemAlterationListener)listener);
        this.fam.start();
        configurables.add(new Something());
        while (true) {
            try {
                while (true) {
                    Thread.sleep(1000L);
                }
            }
            catch (InterruptedException e) {
                continue;
            }
            break;
        }
    }

    public static void main(String[] args) {
        new ConfigurationReloading().run(args);
    }
}

