/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jci.examples.serverpages;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import org.apache.commons.jci.utils.ConversionUtils;

public final class JspGenerator {
    private String quote(String s) {
        StringBuffer sb = new StringBuffer();
        char[] input = s.toCharArray();
        for (int i = 0; i < input.length; ++i) {
            char c = input[i];
            if (c == '\"') {
                sb.append('\\');
            }
            if (c == '\\') {
                sb.append('\\');
            }
            if (c == '\n') {
                sb.append("\");\n").append("    out.write(\"");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private void wrap(StringBuffer pInput, Writer pOutput) throws IOException {
        pOutput.append("    out.write(\"");
        pOutput.append(this.quote(pInput.toString()));
        pOutput.append("\");").append('\n');
    }

    public byte[] generateJavaSource(String pResourceName, File pFile) {
        try {
            int c;
            String packageName;
            String className;
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            InputStreamReader input = new InputStreamReader(new FileInputStream(pFile));
            OutputStreamWriter output = new OutputStreamWriter(outputStream);
            int p = pResourceName.lastIndexOf(47);
            if (p < 0) {
                className = ConversionUtils.stripExtension((String)pResourceName);
                packageName = "";
            } else {
                className = ConversionUtils.stripExtension((String)pResourceName.substring(p + 1));
                packageName = pResourceName.substring(0, p).replace('/', '.');
                ((Writer)output).append("package ").append(packageName).append(";").append('\n');
            }
            ((Writer)output).append("import java.io.PrintWriter;").append('\n');
            ((Writer)output).append("import java.io.IOException;").append('\n');
            ((Writer)output).append("import javax.servlet.http.HttpServlet;").append('\n');
            ((Writer)output).append("import javax.servlet.http.HttpServletRequest;").append('\n');
            ((Writer)output).append("import javax.servlet.http.HttpServletResponse;").append('\n');
            ((Writer)output).append("import javax.servlet.ServletException;").append('\n');
            ((Writer)output).append("public class ").append(className).append(" extends HttpServlet {").append('\n');
            ((Writer)output).append("  protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {").append('\n');
            ((Writer)output).append("    final PrintWriter out = response.getWriter();").append('\n');
            char[] open = "<?".toCharArray();
            char[] close = "?>".toCharArray();
            StringBuffer sb = new StringBuffer();
            char[] watch = open;
            int w = 0;
            while ((c = ((Reader)input).read()) >= 0) {
                if (c == watch[w]) {
                    if (watch.length != ++w) continue;
                    if (watch == open) {
                        this.wrap(sb, output);
                        sb = new StringBuffer();
                        watch = close;
                    } else if (watch == close) {
                        ((Writer)output).append(sb.toString());
                        sb = new StringBuffer();
                        watch = open;
                    }
                    w = 0;
                    continue;
                }
                if (w > 0) {
                    sb.append(watch, 0, w);
                }
                sb.append((char)c);
                w = 0;
            }
            if (watch == open) {
                this.wrap(sb, output);
            }
            ((Writer)output).append("    out.close();").append('\n');
            ((Writer)output).append("    out.flush();").append('\n');
            ((Writer)output).append("  }").append('\n');
            ((Writer)output).append("}").append('\n');
            ((Writer)output).close();
            return outputStream.toByteArray();
        }
        catch (IOException e) {
            return null;
        }
    }
}

