/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jci.examples.serverpages;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.jci.ReloadingClassLoader;
import org.apache.commons.jci.compilers.CompilationResult;
import org.apache.commons.jci.compilers.JavaCompilerFactory;
import org.apache.commons.jci.examples.serverpages.JspGenerator;
import org.apache.commons.jci.examples.serverpages.JspReader;
import org.apache.commons.jci.listeners.CompilingListener;
import org.apache.commons.jci.listeners.ReloadNotificationListener;
import org.apache.commons.jci.monitor.FilesystemAlterationListener;
import org.apache.commons.jci.monitor.FilesystemAlterationMonitor;
import org.apache.commons.jci.monitor.FilesystemAlterationObserver;
import org.apache.commons.jci.problems.CompilationProblem;
import org.apache.commons.jci.readers.ResourceReader;
import org.apache.commons.jci.stores.MemoryResourceStore;
import org.apache.commons.jci.stores.ResourceStore;
import org.apache.commons.jci.stores.TransactionalResourceStore;
import org.apache.commons.jci.utils.ConversionUtils;

public final class ServerPageServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private final ReloadingClassLoader classloader = new ReloadingClassLoader(ServerPageServlet.class.getClassLoader());
    private FilesystemAlterationMonitor fam;
    private CompilingListener jspListener;
    private Map servletsByClassname = new HashMap();
    static /* synthetic */ Class class$javax$servlet$http$HttpServlet;

    public void init() throws ServletException {
        super.init();
        File serverpagesDir = new File(this.getServletContext().getRealPath("/") + this.getInitParameter("serverpagesDir"));
        this.log("Monitoring serverpages in " + serverpagesDir);
        TransactionalResourceStore store = new TransactionalResourceStore((ResourceStore)new MemoryResourceStore()){
            private Set newClasses;
            private Map newServletsByClassname;

            public void onStart() {
                super.onStart();
                this.newClasses = new HashSet();
                this.newServletsByClassname = new HashMap(ServerPageServlet.this.servletsByClassname);
            }

            public void onStop() {
                super.onStop();
                boolean reload = false;
                Iterator it = this.newClasses.iterator();
                while (it.hasNext()) {
                    String clazzName = (String)it.next();
                    try {
                        Class clazz = ServerPageServlet.this.classloader.loadClass(clazzName);
                        if (!(class$javax$servlet$http$HttpServlet == null ? ServerPageServlet.class$("javax.servlet.http.HttpServlet") : class$javax$servlet$http$HttpServlet).isAssignableFrom(clazz)) {
                            ServerPageServlet.this.log(clazzName + " is not a servlet");
                            continue;
                        }
                        HttpServlet servlet = (HttpServlet)clazz.newInstance();
                        this.newServletsByClassname.put(clazzName, servlet);
                        reload = true;
                    }
                    catch (Exception e) {
                        ServerPageServlet.this.log("", e);
                    }
                }
                if (reload) {
                    ServerPageServlet.this.log("Activating new map of servlets " + this.newServletsByClassname);
                    ServerPageServlet.this.servletsByClassname = this.newServletsByClassname;
                }
            }

            public void write(String pResourceName, byte[] pResourceData) {
                super.write(pResourceName, pResourceData);
                if (pResourceName.endsWith(".class")) {
                    this.newClasses.add(pResourceName.replace('/', '.').substring(0, pResourceName.length() - ".class".length()));
                }
            }
        };
        this.jspListener = new CompilingListener(new JavaCompilerFactory().createCompiler("eclipse"), store){
            private final JspGenerator transformer;
            private final Map sources;
            private final Set resourceToCompile;
            {
                this.transformer = new JspGenerator();
                this.sources = new HashMap();
                this.resourceToCompile = new HashSet();
            }

            public void onStart(FilesystemAlterationObserver pObserver) {
                super.onStart(pObserver);
                this.resourceToCompile.clear();
            }

            public void onFileChange(File pFile) {
                if (pFile.getName().endsWith(".jsp")) {
                    String resourceName = ConversionUtils.stripExtension((String)this.getSourceNameFromFile(this.observer, pFile)) + ".java";
                    ServerPageServlet.this.log("Updating " + resourceName);
                    this.sources.put(resourceName, this.transformer.generateJavaSource(resourceName, pFile));
                    this.resourceToCompile.add(resourceName);
                }
                super.onFileChange(pFile);
            }

            public void onFileCreate(File pFile) {
                if (pFile.getName().endsWith(".jsp")) {
                    String resourceName = ConversionUtils.stripExtension((String)this.getSourceNameFromFile(this.observer, pFile)) + ".java";
                    ServerPageServlet.this.log("Creating " + resourceName);
                    this.sources.put(resourceName, this.transformer.generateJavaSource(resourceName, pFile));
                    this.resourceToCompile.add(resourceName);
                }
                super.onFileCreate(pFile);
            }

            public String[] getResourcesToCompile(FilesystemAlterationObserver pObserver) {
                String[] resourceNames = new String[this.resourceToCompile.size()];
                this.resourceToCompile.toArray(resourceNames);
                return resourceNames;
            }

            public ResourceReader getReader(FilesystemAlterationObserver pObserver) {
                return new JspReader(this.sources, super.getReader(pObserver));
            }
        };
        this.jspListener.addReloadNotificationListener((ReloadNotificationListener)this.classloader);
        this.fam = new FilesystemAlterationMonitor();
        this.fam.addListener(serverpagesDir, (FilesystemAlterationListener)this.jspListener);
        this.fam.start();
    }

    private String convertRequestToServletClassname(HttpServletRequest request) {
        String path = request.getPathInfo().substring(1);
        String clazz = ConversionUtils.stripExtension((String)path).replace('/', '.');
        return clazz;
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.log("Request " + request.getRequestURI());
        CompilationResult result = this.jspListener.getCompilationResult();
        CompilationProblem[] errors = result.getErrors();
        if (errors.length > 0) {
            PrintWriter out = response.getWriter();
            out.append("<html><body>");
            for (int i = 0; i < errors.length; ++i) {
                CompilationProblem problem = errors[i];
                out.append(problem.toString()).append("<br/>").append('\n');
            }
            out.append("</body></html>");
            out.flush();
            out.close();
            return;
        }
        String servletClassname = this.convertRequestToServletClassname(request);
        this.log("Checking for serverpage " + servletClassname);
        HttpServlet servlet = (HttpServlet)this.servletsByClassname.get(servletClassname);
        if (servlet == null) {
            this.log("No servlet  for " + request.getRequestURI());
            response.sendError(404);
            return;
        }
        this.log("Delegating request to " + servletClassname);
        servlet.service((ServletRequest)request, (ServletResponse)response);
    }

    public void destroy() {
        this.fam.stop();
        super.destroy();
    }
}

