/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary.disk.block;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.jcs.auxiliary.disk.AbstractDiskCacheManager;
import org.apache.commons.jcs.auxiliary.disk.block.BlockDiskCache;
import org.apache.commons.jcs.auxiliary.disk.block.BlockDiskCacheAttributes;
import org.apache.commons.jcs.engine.behavior.IElementSerializer;
import org.apache.commons.jcs.engine.logging.behavior.ICacheEventLogger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BlockDiskCacheManager
extends AbstractDiskCacheManager {
    private static final Log log = LogFactory.getLog(BlockDiskCacheManager.class);
    private static BlockDiskCacheManager instance;
    private final Map<String, BlockDiskCache<?, ?>> caches = new ConcurrentHashMap();
    private final BlockDiskCacheAttributes defaultCacheAttributes;

    private BlockDiskCacheManager(BlockDiskCacheAttributes defaultCacheAttributes, ICacheEventLogger cacheEventLogger, IElementSerializer elementSerializer) {
        this.defaultCacheAttributes = defaultCacheAttributes;
        this.setElementSerializer(elementSerializer);
        this.setCacheEventLogger(cacheEventLogger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BlockDiskCacheManager getInstance(BlockDiskCacheAttributes defaultCacheAttributes, ICacheEventLogger cacheEventLogger, IElementSerializer elementSerializer) {
        Class<BlockDiskCacheManager> clazz = BlockDiskCacheManager.class;
        synchronized (BlockDiskCacheManager.class) {
            if (instance == null) {
                instance = new BlockDiskCacheManager(defaultCacheAttributes, cacheEventLogger, elementSerializer);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return instance;
        }
    }

    public <K, V> BlockDiskCache<K, V> getCache(String cacheName) {
        BlockDiskCacheAttributes cacheAttributes = (BlockDiskCacheAttributes)this.defaultCacheAttributes.copy();
        cacheAttributes.setCacheName(cacheName);
        return this.getCache(cacheAttributes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V> BlockDiskCache<K, V> getCache(BlockDiskCacheAttributes cacheAttributes) {
        BlockDiskCache<Object, Object> cache = null;
        String cacheName = cacheAttributes.getCacheName();
        log.debug((Object)("Getting cache named: " + cacheName));
        Map<String, BlockDiskCache<?, ?>> map = this.caches;
        synchronized (map) {
            BlockDiskCache<?, ?> blockDiskCache = this.caches.get(cacheName);
            cache = blockDiskCache;
            if (cache == null) {
                cache = new BlockDiskCache(cacheAttributes);
                cache.setCacheEventLogger(this.getCacheEventLogger());
                cache.setElementSerializer(this.getElementSerializer());
                this.caches.put(cacheName, cache);
            }
        }
        return cache;
    }
}

