/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary.disk.indexed;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.jcs.auxiliary.disk.AbstractDiskCacheManager;
import org.apache.commons.jcs.auxiliary.disk.indexed.IndexedDiskCache;
import org.apache.commons.jcs.auxiliary.disk.indexed.IndexedDiskCacheAttributes;
import org.apache.commons.jcs.engine.behavior.IElementSerializer;
import org.apache.commons.jcs.engine.logging.behavior.ICacheEventLogger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IndexedDiskCacheManager
extends AbstractDiskCacheManager {
    private static final Log log = LogFactory.getLog(IndexedDiskCacheManager.class);
    private static IndexedDiskCacheManager instance;
    private final Map<String, IndexedDiskCache<?, ?>> caches = new ConcurrentHashMap();
    private final IndexedDiskCacheAttributes defaultCacheAttributes;

    private IndexedDiskCacheManager(IndexedDiskCacheAttributes defaultCacheAttributes, ICacheEventLogger cacheEventLogger, IElementSerializer elementSerializer) {
        this.defaultCacheAttributes = defaultCacheAttributes;
        this.setElementSerializer(elementSerializer);
        this.setCacheEventLogger(cacheEventLogger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IndexedDiskCacheManager getInstance(IndexedDiskCacheAttributes defaultCacheAttributes, ICacheEventLogger cacheEventLogger, IElementSerializer elementSerializer) {
        Class<IndexedDiskCacheManager> clazz = IndexedDiskCacheManager.class;
        synchronized (IndexedDiskCacheManager.class) {
            if (instance == null) {
                instance = new IndexedDiskCacheManager(defaultCacheAttributes, cacheEventLogger, elementSerializer);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return instance;
        }
    }

    public <K, V> IndexedDiskCache<K, V> getCache(String cacheName) {
        IndexedDiskCacheAttributes cacheAttributes = (IndexedDiskCacheAttributes)this.defaultCacheAttributes.copy();
        cacheAttributes.setCacheName(cacheName);
        return this.getCache(cacheAttributes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V> IndexedDiskCache<K, V> getCache(IndexedDiskCacheAttributes cacheAttributes) {
        IndexedDiskCache<Object, Object> cache = null;
        String cacheName = cacheAttributes.getCacheName();
        log.debug((Object)("Getting cache named: " + cacheName));
        Map<String, IndexedDiskCache<?, ?>> map = this.caches;
        synchronized (map) {
            IndexedDiskCache<?, ?> indexedDiskCache = this.caches.get(cacheName);
            cache = indexedDiskCache;
            if (cache == null) {
                cache = new IndexedDiskCache(cacheAttributes, this.getElementSerializer());
                cache.setCacheEventLogger(this.getCacheEventLogger());
                this.caches.put(cacheName, cache);
            }
        }
        return cache;
    }
}

