/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary.disk.jdbc;

import java.sql.SQLException;
import org.apache.commons.jcs.auxiliary.disk.jdbc.JDBCDiskCache;
import org.apache.commons.jcs.auxiliary.disk.jdbc.JDBCDiskCacheAttributes;
import org.apache.commons.jcs.auxiliary.disk.jdbc.JDBCDiskCacheManagerAbstractTemplate;
import org.apache.commons.jcs.auxiliary.disk.jdbc.TableState;
import org.apache.commons.jcs.engine.behavior.ICompositeCacheManager;
import org.apache.commons.jcs.engine.behavior.IElementSerializer;
import org.apache.commons.jcs.engine.logging.behavior.ICacheEventLogger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JDBCDiskCacheManager
extends JDBCDiskCacheManagerAbstractTemplate {
    private static final Log log = LogFactory.getLog(JDBCDiskCacheManager.class);
    private static JDBCDiskCacheManager instance;
    private final JDBCDiskCacheAttributes defaultJDBCDiskCacheAttributes;
    private ICompositeCacheManager compositeCacheManager;

    private JDBCDiskCacheManager(JDBCDiskCacheAttributes cattr, ICompositeCacheManager compositeCacheManager, ICacheEventLogger cacheEventLogger, IElementSerializer elementSerializer) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Creating JDBCDiskCacheManager with " + cattr));
        }
        this.defaultJDBCDiskCacheAttributes = cattr;
        this.setElementSerializer(elementSerializer);
        this.setCacheEventLogger(cacheEventLogger);
        this.setCompositeCacheManager(compositeCacheManager);
    }

    public JDBCDiskCacheAttributes getDefaultJDBCDiskCacheAttributes() {
        return this.defaultJDBCDiskCacheAttributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JDBCDiskCacheManager getInstance(JDBCDiskCacheAttributes cattr, ICompositeCacheManager compositeCacheManager, ICacheEventLogger cacheEventLogger, IElementSerializer elementSerializer) {
        Class<JDBCDiskCacheManager> clazz = JDBCDiskCacheManager.class;
        synchronized (JDBCDiskCacheManager.class) {
            if (instance == null) {
                instance = new JDBCDiskCacheManager(cattr, compositeCacheManager, cacheEventLogger, elementSerializer);
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            ++clients;
            return instance;
        }
    }

    public <K, V> JDBCDiskCache<K, V> getCache(String cacheName) {
        JDBCDiskCacheAttributes cattr = (JDBCDiskCacheAttributes)this.defaultJDBCDiskCacheAttributes.copy();
        cattr.setCacheName(cacheName);
        return this.getCache(cattr);
    }

    @Override
    protected <K, V> JDBCDiskCache<K, V> createJDBCDiskCache(JDBCDiskCacheAttributes cattr, TableState tableState) throws SQLException {
        JDBCDiskCache raf = new JDBCDiskCache(cattr, tableState, this.getCompositeCacheManager());
        return raf;
    }

    protected void setCompositeCacheManager(ICompositeCacheManager compositeCacheManager) {
        this.compositeCacheManager = compositeCacheManager;
    }

    protected ICompositeCacheManager getCompositeCacheManager() {
        return this.compositeCacheManager;
    }
}

