/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary.disk.jdbc;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.jcs.auxiliary.AuxiliaryCache;
import org.apache.commons.jcs.auxiliary.disk.AbstractDiskCacheManager;
import org.apache.commons.jcs.auxiliary.disk.jdbc.JDBCDiskCache;
import org.apache.commons.jcs.auxiliary.disk.jdbc.JDBCDiskCacheAttributes;
import org.apache.commons.jcs.auxiliary.disk.jdbc.ShrinkerThread;
import org.apache.commons.jcs.auxiliary.disk.jdbc.TableState;
import org.apache.commons.jcs.utils.threadpool.DaemonThreadFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class JDBCDiskCacheManagerAbstractTemplate
extends AbstractDiskCacheManager {
    private static final Log log = LogFactory.getLog(JDBCDiskCacheManagerAbstractTemplate.class);
    protected static int clients;
    private static Map<String, JDBCDiskCache<?, ?>> caches;
    protected static Map<String, TableState> tableStates;
    private ScheduledExecutorService shrinkerDaemon;
    private final Map<String, ShrinkerThread> shrinkerThreadMap = new ConcurrentHashMap<String, ShrinkerThread>();

    protected abstract <K, V> JDBCDiskCache<K, V> createJDBCDiskCache(JDBCDiskCacheAttributes var1, TableState var2) throws SQLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V> JDBCDiskCache<K, V> getCache(JDBCDiskCacheAttributes cattr) {
        JDBCDiskCache<Object, Object> diskCache = null;
        log.debug((Object)("cacheName = " + cattr.getCacheName()));
        Map<String, JDBCDiskCache<?, ?>> map = caches;
        synchronized (map) {
            JDBCDiskCache<?, ?> jdbcDiskCache = caches.get(cattr.getCacheName());
            diskCache = jdbcDiskCache;
            if (diskCache == null) {
                TableState tableState = tableStates.get(cattr.getTableName());
                if (tableState == null) {
                    tableState = new TableState(cattr.getTableName());
                }
                try {
                    diskCache = this.createJDBCDiskCache(cattr, tableState);
                    diskCache.setCacheEventLogger(this.getCacheEventLogger());
                    diskCache.setElementSerializer(this.getElementSerializer());
                    caches.put(cattr.getCacheName(), diskCache);
                }
                catch (SQLException e) {
                    log.error((Object)("Failed to create cache " + cattr.getCacheName()), (Throwable)e);
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("JDBC cache = " + diskCache));
        }
        this.createShrinkerWhenNeeded(cattr, diskCache);
        return diskCache;
    }

    protected void createShrinkerWhenNeeded(JDBCDiskCacheAttributes cattr, AuxiliaryCache<?, ?> raf) {
        if (cattr.isUseDiskShrinker()) {
            ShrinkerThread shrinkerThread;
            if (this.shrinkerDaemon == null) {
                this.shrinkerDaemon = Executors.newScheduledThreadPool(2, new DaemonThreadFactory("JCS-JDBCDiskCacheManager-", 1));
            }
            if ((shrinkerThread = this.shrinkerThreadMap.get(cattr.getTableName())) == null) {
                shrinkerThread = new ShrinkerThread();
                this.shrinkerThreadMap.put(cattr.getTableName(), shrinkerThread);
                long intervalMillis = Math.max(999, cattr.getShrinkerIntervalSeconds() * 1000);
                if (log.isInfoEnabled()) {
                    log.info((Object)("Setting the shrinker to run every [" + intervalMillis + "] ms. for table [" + cattr.getTableName() + "]"));
                }
                this.shrinkerDaemon.scheduleAtFixedRate(shrinkerThread, 0L, intervalMillis, TimeUnit.MILLISECONDS);
            }
            shrinkerThread.addDiskCacheToShrinkList((JDBCDiskCache)raf);
        }
    }

    public void freeCache(String name) {
        JDBCDiskCache<?, ?> raf = caches.get(name);
        if (raf != null) {
            try {
                raf.dispose();
            }
            catch (IOException e) {
                log.error((Object)"Problem disposing of disk.", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        if (--clients != 0) {
            return;
        }
        Map<String, JDBCDiskCache<?, ?>> map = caches;
        synchronized (map) {
            for (JDBCDiskCache<?, ?> raf : caches.values()) {
                if (raf == null) continue;
                try {
                    raf.dispose();
                }
                catch (IOException e) {
                    log.error((Object)"Problem disposing of disk.", (Throwable)e);
                }
            }
        }
    }

    static {
        caches = new ConcurrentHashMap();
        tableStates = new ConcurrentHashMap<String, TableState>();
    }
}

