/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary.disk.jdbc.mysql;

import java.sql.SQLException;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.jcs.auxiliary.disk.jdbc.JDBCDiskCacheAttributes;
import org.apache.commons.jcs.auxiliary.disk.jdbc.JDBCDiskCacheManagerAbstractTemplate;
import org.apache.commons.jcs.auxiliary.disk.jdbc.JDBCDiskCachePoolAccess;
import org.apache.commons.jcs.auxiliary.disk.jdbc.TableState;
import org.apache.commons.jcs.auxiliary.disk.jdbc.mysql.MySQLDiskCache;
import org.apache.commons.jcs.auxiliary.disk.jdbc.mysql.MySQLDiskCacheAttributes;
import org.apache.commons.jcs.auxiliary.disk.jdbc.mysql.MySQLTableOptimizer;
import org.apache.commons.jcs.auxiliary.disk.jdbc.mysql.util.ScheduleFormatException;
import org.apache.commons.jcs.auxiliary.disk.jdbc.mysql.util.ScheduleParser;
import org.apache.commons.jcs.engine.behavior.ICompositeCacheManager;
import org.apache.commons.jcs.engine.behavior.IElementSerializer;
import org.apache.commons.jcs.engine.logging.behavior.ICacheEventLogger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MySQLDiskCacheManager
extends JDBCDiskCacheManagerAbstractTemplate {
    private static final Log log = LogFactory.getLog(MySQLDiskCacheManager.class);
    private static MySQLDiskCacheManager instance;
    private final MySQLDiskCacheAttributes defaultJDBCDiskCacheAttributes;
    private static final int DAILY_INTERVAL = 86400000;
    private Timer daemon = null;
    private ICompositeCacheManager compositeCacheManager;

    private MySQLDiskCacheManager(MySQLDiskCacheAttributes cattr, ICompositeCacheManager compositeCacheManager, ICacheEventLogger cacheEventLogger, IElementSerializer elementSerializer) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Creating MySQLDiskCacheManager with " + cattr));
        }
        this.defaultJDBCDiskCacheAttributes = cattr;
        this.setElementSerializer(elementSerializer);
        this.setCacheEventLogger(cacheEventLogger);
        this.setCompositeCacheManager(compositeCacheManager);
    }

    public MySQLDiskCacheAttributes getDefaultJDBCDiskCacheAttributes() {
        return this.defaultJDBCDiskCacheAttributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MySQLDiskCacheManager getInstance(MySQLDiskCacheAttributes cattr, ICompositeCacheManager compositeCacheManager, ICacheEventLogger cacheEventLogger, IElementSerializer elementSerializer) {
        Class<MySQLDiskCacheManager> clazz = MySQLDiskCacheManager.class;
        synchronized (MySQLDiskCacheManager.class) {
            if (instance == null) {
                instance = new MySQLDiskCacheManager(cattr, compositeCacheManager, cacheEventLogger, elementSerializer);
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            ++clients;
            return instance;
        }
    }

    public <K, V> MySQLDiskCache<K, V> getCache(String cacheName) {
        MySQLDiskCacheAttributes cattr = (MySQLDiskCacheAttributes)this.defaultJDBCDiskCacheAttributes.copy();
        cattr.setCacheName(cacheName);
        return (MySQLDiskCache)this.getCache(cattr);
    }

    protected <K, V> MySQLDiskCache<K, V> createJDBCDiskCache(JDBCDiskCacheAttributes cattr, TableState tableState) throws SQLException {
        MySQLDiskCache diskCache = new MySQLDiskCache((MySQLDiskCacheAttributes)cattr, tableState, this.getCompositeCacheManager());
        this.scheduleOptimizations((MySQLDiskCacheAttributes)cattr, tableState, diskCache.getPoolAccess());
        return diskCache;
    }

    protected void setCompositeCacheManager(ICompositeCacheManager compositeCacheManager) {
        this.compositeCacheManager = compositeCacheManager;
    }

    protected ICompositeCacheManager getCompositeCacheManager() {
        return this.compositeCacheManager;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void scheduleOptimizations(MySQLDiskCacheAttributes attributes, TableState tableState, JDBCDiskCachePoolAccess poolAccess) {
        if (attributes == null) return;
        if (attributes.getOptimizationSchedule() != null) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Will try to configure optimization for table [" + attributes.getTableName() + "] on schdule [" + attributes.getOptimizationSchedule() + "]"));
            }
            MySQLTableOptimizer optimizer = new MySQLTableOptimizer(attributes, tableState, poolAccess);
            try {
                Date[] dates = ScheduleParser.createDatesForSchedule(attributes.getOptimizationSchedule());
                if (dates == null) return;
                for (int i = 0; i < dates.length; ++i) {
                    this.scheduleOptimization(dates[i], optimizer);
                }
                return;
            }
            catch (ScheduleFormatException e) {
                log.warn((Object)("Problem creating optimization schedule for table [" + attributes.getTableName() + "]"));
                return;
            }
        } else {
            if (!log.isInfoEnabled()) return;
            log.info((Object)("Optimization is not configured for table [" + attributes.getTableName() + "]"));
        }
    }

    protected void scheduleOptimization(Date startTime, MySQLTableOptimizer optimizer) {
        if (log.isInfoEnabled()) {
            log.info((Object)("startTime [" + startTime + "] for optimizer " + optimizer));
        }
        if (this.daemon == null) {
            this.daemon = new Timer(true);
        }
        OptimizerTask runnable = new OptimizerTask(optimizer);
        this.daemon.scheduleAtFixedRate((TimerTask)runnable, startTime, 86400000L);
        if (log.isInfoEnabled()) {
            log.info((Object)("Scheduled optimization to begin at [" + startTime + "]"));
        }
    }

    private static class OptimizerTask
    extends TimerTask {
        private MySQLTableOptimizer optimizer = null;

        public OptimizerTask(MySQLTableOptimizer optimizer) {
            this.optimizer = optimizer;
        }

        @Override
        public void run() {
            if (this.optimizer != null) {
                boolean success = this.optimizer.optimizeTable();
                if (log.isInfoEnabled()) {
                    log.info((Object)("Optimization success status [" + success + "]"));
                }
            } else {
                log.warn((Object)"OptimizerRunner: The optimizer is null.  Could not optimize table.");
            }
        }
    }
}

