/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary.lateral;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.jcs.auxiliary.AuxiliaryCache;
import org.apache.commons.jcs.auxiliary.lateral.LateralCacheNoWait;
import org.apache.commons.jcs.auxiliary.lateral.LateralCacheWatchRepairable;
import org.apache.commons.jcs.auxiliary.lateral.behavior.ILateralCacheAttributes;
import org.apache.commons.jcs.auxiliary.lateral.behavior.ILateralCacheListener;
import org.apache.commons.jcs.auxiliary.lateral.behavior.ILateralCacheManager;
import org.apache.commons.jcs.auxiliary.lateral.behavior.ILateralCacheObserver;
import org.apache.commons.jcs.engine.behavior.ICacheServiceNonLocal;
import org.apache.commons.jcs.engine.behavior.IShutdownObserver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class LateralCacheAbstractManager
implements ILateralCacheManager,
IShutdownObserver {
    private static final Log log = LogFactory.getLog(LateralCacheAbstractManager.class);
    protected final Map<String, LateralCacheNoWait<?, ?>> caches = new HashMap();
    protected ILateralCacheAttributes lca;
    private LateralCacheWatchRepairable lateralWatch;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V> void addLateralCacheListener(String cacheName, ILateralCacheListener<K, V> listener) throws IOException {
        Map<String, LateralCacheNoWait<?, ?>> map = this.caches;
        synchronized (map) {
            this.lateralWatch.addCacheListener(cacheName, listener);
        }
    }

    @Override
    public abstract <K, V> AuxiliaryCache<K, V> getCache(String var1);

    public String getStats() {
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fixCaches(ICacheServiceNonLocal<Serializable, Serializable> lateralService, ILateralCacheObserver lateralWatch) {
        log.debug((Object)"Fixing lateral caches:");
        Map<String, LateralCacheNoWait<?, ?>> map = this.caches;
        synchronized (map) {
            for (LateralCacheNoWait<?, ?> cache : this.caches.values()) {
                cache.fixCache(lateralService);
            }
        }
    }

    @Override
    public Map<String, LateralCacheNoWait<?, ?>> getCaches() {
        return this.caches;
    }
}

