/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary.lateral.socket.tcp;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.commons.jcs.auxiliary.AuxiliaryCache;
import org.apache.commons.jcs.auxiliary.AuxiliaryCacheAttributes;
import org.apache.commons.jcs.auxiliary.lateral.LateralCacheAbstractFactory;
import org.apache.commons.jcs.auxiliary.lateral.LateralCacheNoWait;
import org.apache.commons.jcs.auxiliary.lateral.LateralCacheNoWaitFacade;
import org.apache.commons.jcs.auxiliary.lateral.behavior.ILateralCacheAttributes;
import org.apache.commons.jcs.auxiliary.lateral.behavior.ILateralCacheListener;
import org.apache.commons.jcs.auxiliary.lateral.socket.tcp.LateralTCPCacheManager;
import org.apache.commons.jcs.auxiliary.lateral.socket.tcp.LateralTCPDiscoveryListener;
import org.apache.commons.jcs.auxiliary.lateral.socket.tcp.LateralTCPDiscoveryListenerManager;
import org.apache.commons.jcs.auxiliary.lateral.socket.tcp.LateralTCPListener;
import org.apache.commons.jcs.auxiliary.lateral.socket.tcp.behavior.ITCPLateralCacheAttributes;
import org.apache.commons.jcs.engine.behavior.ICompositeCacheManager;
import org.apache.commons.jcs.engine.behavior.IElementSerializer;
import org.apache.commons.jcs.engine.logging.behavior.ICacheEventLogger;
import org.apache.commons.jcs.utils.discovery.UDPDiscoveryManager;
import org.apache.commons.jcs.utils.discovery.UDPDiscoveryService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LateralTCPCacheFactory
extends LateralCacheAbstractFactory {
    private static final Log log = LogFactory.getLog(LateralTCPCacheFactory.class);
    private LateralTCPDiscoveryListenerManager lateralTCPDiscoveryListenerManager;

    @Override
    public <K, V> AuxiliaryCache<K, V> createCache(AuxiliaryCacheAttributes iaca, ICompositeCacheManager cacheMgr, ICacheEventLogger cacheEventLogger, IElementSerializer elementSerializer) {
        ITCPLateralCacheAttributes lac = (ITCPLateralCacheAttributes)iaca;
        ArrayList<AuxiliaryCache> noWaits = new ArrayList<AuxiliaryCache>();
        if (lac.getTcpServers() != null) {
            StringTokenizer it = new StringTokenizer(lac.getTcpServers(), ",");
            if (log.isDebugEnabled()) {
                log.debug((Object)("Configured for [" + it.countTokens() + "]  servers."));
            }
            while (it.hasMoreElements()) {
                String server = (String)it.nextElement();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("tcp server = " + server));
                }
                ITCPLateralCacheAttributes lacC = (ITCPLateralCacheAttributes)lac.copy();
                lacC.setTcpServer(server);
                LateralTCPCacheManager lcm = LateralTCPCacheManager.getInstance(lacC, cacheMgr, cacheEventLogger, elementSerializer);
                cacheMgr.registerShutdownObserver(lcm);
                AuxiliaryCache ic = lcm.getCache(lacC.getCacheName());
                noWaits.add(ic);
            }
        }
        ILateralCacheListener<K, V> listener = this.createListener((ILateralCacheAttributes)iaca, cacheMgr);
        LateralCacheNoWait[] lcnwArray = noWaits.toArray(new LateralCacheNoWait[0]);
        LateralCacheNoWaitFacade<K, V> lcnwf = new LateralCacheNoWaitFacade<K, V>(listener, lcnwArray, (ILateralCacheAttributes)iaca);
        this.createDiscoveryService(lac, lcnwf, cacheMgr, cacheEventLogger, elementSerializer);
        return lcnwf;
    }

    @Override
    public <K, V> ILateralCacheListener<K, V> createListener(ILateralCacheAttributes lac, ICompositeCacheManager cacheMgr) {
        ITCPLateralCacheAttributes attr = (ITCPLateralCacheAttributes)lac;
        LateralTCPListener listener = null;
        if (attr.isReceive()) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Getting listener for " + lac));
            }
            try {
                listener = LateralTCPListener.getInstance(attr, cacheMgr);
                cacheMgr.registerShutdownObserver(listener);
            }
            catch (Exception e) {
                log.error((Object)"Problem creating lateral listener", (Throwable)e);
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Not creating a listener since we are not receiving.");
        }
        return listener;
    }

    private synchronized <K, V> UDPDiscoveryService createDiscoveryService(ITCPLateralCacheAttributes lac, LateralCacheNoWaitFacade<K, V> lcnwf, ICompositeCacheManager cacheMgr, ICacheEventLogger cacheEventLogger, IElementSerializer elementSerializer) {
        UDPDiscoveryService discovery = null;
        if (lac.isUdpDiscoveryEnabled()) {
            if (this.lateralTCPDiscoveryListenerManager == null) {
                this.lateralTCPDiscoveryListenerManager = new LateralTCPDiscoveryListenerManager();
            }
            LateralTCPDiscoveryListener discoveryListener = this.lateralTCPDiscoveryListenerManager.getDiscoveryListener(lac, cacheMgr, cacheEventLogger, elementSerializer);
            discoveryListener.addNoWaitFacade(lac.getCacheName(), lcnwf);
            discovery = UDPDiscoveryManager.getInstance().getService(lac.getUdpDiscoveryAddr(), lac.getUdpDiscoveryPort(), lac.getTcpListenerPort(), cacheMgr);
            discovery.addParticipatingCacheName(lac.getCacheName());
            discovery.addDiscoveryListener(discoveryListener);
            if (log.isInfoEnabled()) {
                log.info((Object)("Registered TCP lateral cache [" + lac.getCacheName() + "] with UDPDiscoveryService."));
            }
        }
        return discovery;
    }
}

