/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary.lateral.socket.tcp;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.jcs.auxiliary.lateral.LateralCache;
import org.apache.commons.jcs.auxiliary.lateral.LateralCacheAbstractManager;
import org.apache.commons.jcs.auxiliary.lateral.LateralCacheAttributes;
import org.apache.commons.jcs.auxiliary.lateral.LateralCacheMonitor;
import org.apache.commons.jcs.auxiliary.lateral.LateralCacheNoWait;
import org.apache.commons.jcs.auxiliary.lateral.LateralCacheWatchRepairable;
import org.apache.commons.jcs.auxiliary.lateral.ZombieLateralCacheWatch;
import org.apache.commons.jcs.auxiliary.lateral.behavior.ILateralCacheListener;
import org.apache.commons.jcs.auxiliary.lateral.behavior.ILateralCacheManager;
import org.apache.commons.jcs.auxiliary.lateral.socket.tcp.LateralTCPListener;
import org.apache.commons.jcs.auxiliary.lateral.socket.tcp.LateralTCPService;
import org.apache.commons.jcs.auxiliary.lateral.socket.tcp.behavior.ITCPLateralCacheAttributes;
import org.apache.commons.jcs.engine.ZombieCacheServiceNonLocal;
import org.apache.commons.jcs.engine.behavior.ICacheServiceNonLocal;
import org.apache.commons.jcs.engine.behavior.ICompositeCacheManager;
import org.apache.commons.jcs.engine.behavior.IElementSerializer;
import org.apache.commons.jcs.engine.logging.behavior.ICacheEventLogger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LateralTCPCacheManager
extends LateralCacheAbstractManager {
    private static final Log log = LogFactory.getLog(LateralTCPCacheManager.class);
    private static LateralCacheMonitor monitor;
    private static final Map<String, LateralTCPCacheManager> instances;
    private final ITCPLateralCacheAttributes lateralCacheAttributes;
    private ICacheServiceNonLocal<?, ?> lateralService;
    private final LateralCacheWatchRepairable lateralWatch;
    private final ICompositeCacheManager cacheMgr;
    private final ICacheEventLogger cacheEventLogger;
    private final IElementSerializer elementSerializer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LateralTCPCacheManager getInstance(ITCPLateralCacheAttributes lca, ICompositeCacheManager cacheMgr, ICacheEventLogger cacheEventLogger, IElementSerializer elementSerializer) {
        Map<String, LateralTCPCacheManager> map = instances;
        synchronized (map) {
            String key = lca.getTcpServer();
            LateralTCPCacheManager ins = instances.get(key);
            if (ins == null) {
                log.info((Object)("Instance for [" + key + "] is null, creating"));
                ins = instances.get(lca.getTcpServer());
                if (ins == null) {
                    ins = new LateralTCPCacheManager(lca, cacheMgr, cacheEventLogger, elementSerializer);
                    instances.put(key, ins);
                }
                LateralTCPCacheManager.createMonitor(ins);
            }
            return ins;
        }
    }

    private static synchronized void createMonitor(ILateralCacheManager instance) {
        if (monitor == null) {
            monitor = new LateralCacheMonitor(instance);
            Thread t = new Thread(monitor);
            t.setDaemon(true);
            t.start();
        }
    }

    private LateralTCPCacheManager(ITCPLateralCacheAttributes lcaA, ICompositeCacheManager cacheMgr, ICacheEventLogger cacheEventLogger, IElementSerializer elementSerializer) {
        this.lateralCacheAttributes = lcaA;
        this.cacheMgr = cacheMgr;
        this.cacheEventLogger = cacheEventLogger;
        this.elementSerializer = elementSerializer;
        this.lateralWatch = new LateralCacheWatchRepairable();
        this.lateralWatch.setCacheWatch(new ZombieLateralCacheWatch());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating lateral cache service, lca = " + this.lateralCacheAttributes));
        }
        try {
            if (log.isInfoEnabled()) {
                log.info((Object)("Creating TCP service, lca = " + this.lateralCacheAttributes));
            }
            this.lateralService = new LateralTCPService(this.lateralCacheAttributes);
        }
        catch (Exception ex) {
            log.error((Object)"Failure, lateral instance will use zombie service", (Throwable)ex);
            this.lateralService = new ZombieCacheServiceNonLocal(this.lateralCacheAttributes.getZombieQueueMaxSize());
            LateralTCPCacheManager.createMonitor(this);
            monitor.notifyError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <K, V> void addLateralCacheListener(String cacheName, ILateralCacheListener<K, V> listener) throws IOException {
        Map map = this.caches;
        synchronized (map) {
            this.lateralWatch.addCacheListener(cacheName, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V> LateralCacheNoWait<K, V> getCache(String cacheName) {
        LateralCacheNoWait lateralNoWait = null;
        Map map = this.caches;
        synchronized (map) {
            lateralNoWait = (LateralCacheNoWait)this.caches.get(cacheName);
            if (lateralNoWait == null) {
                LateralCacheAttributes attr = (LateralCacheAttributes)this.lateralCacheAttributes.copy();
                attr.setCacheName(cacheName);
                LateralCache cache = new LateralCache(attr, this.lateralService, monitor);
                cache.setCacheEventLogger(this.cacheEventLogger);
                cache.setElementSerializer(this.elementSerializer);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Created cache for noWait, cache [" + cache + "]"));
                }
                lateralNoWait = new LateralCacheNoWait(cache);
                lateralNoWait.setCacheEventLogger(this.cacheEventLogger);
                lateralNoWait.setElementSerializer(this.elementSerializer);
                this.caches.put(cacheName, lateralNoWait);
                if (log.isInfoEnabled()) {
                    log.info((Object)("Created LateralCacheNoWait for [" + this.lateralCacheAttributes + "] LateralCacheNoWait = [" + lateralNoWait + "]"));
                }
                this.addListenerIfNeeded(cacheName);
            }
        }
        return lateralNoWait;
    }

    private void addListenerIfNeeded(String cacheName) {
        if (this.lateralCacheAttributes.isReceive()) {
            try {
                this.addLateralCacheListener(cacheName, LateralTCPListener.getInstance(this.lateralCacheAttributes, this.cacheMgr));
            }
            catch (IOException ioe) {
                log.error((Object)"Problem creating lateral listener", (Throwable)ioe);
            }
            catch (Exception e) {
                log.error((Object)"Problem creating lateral listener", (Throwable)e);
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Not creating a listener since we are not receiving.");
        }
    }

    @Override
    public Map<String, ? extends ILateralCacheManager> getInstances() {
        return instances;
    }

    @Override
    public Object fixService() throws IOException {
        LateralTCPService service = null;
        try {
            service = new LateralTCPService(this.lateralCacheAttributes);
        }
        catch (Exception ex) {
            log.error((Object)("Can't fix " + ex.getMessage()));
            throw new IOException("Can't fix " + ex.getMessage());
        }
        return service;
    }

    @Override
    public void shutdown() {
        try {
            this.lateralService.dispose("ALL");
        }
        catch (IOException e) {
            log.error((Object)"Problem disposing of service", (Throwable)e);
        }
        if (monitor != null) {
            monitor.notifyShutdown();
        }
    }

    static {
        instances = new ConcurrentHashMap<String, LateralTCPCacheManager>();
    }
}

